/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.ctl.RptLetterOfGuaranteeDetailFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class RptLetterOfGuaranteeDetailBaseHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.ctl.client.RptLetterOfGuaranteeDetailResource";
    private static final String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static final String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private BigDecimal amtRate = null;
    private HashMap GuaranteeMap = new HashMap();

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    public RptLetterOfGuaranteeDetailBaseHandler(FilterInfo filterInfo, KDTable kdt, int amtRate) {
        super(filterInfo, kdt);
        this.amtRate = new BigDecimal(String.valueOf(amtRate));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RptLetterOfGuaranteeDetailBaseHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt, int amtRate) {
        super(filterInfo, sorter, kdt);
        this.amtRate = new BigDecimal(String.valueOf(amtRate));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.getColumn("issueDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.kdt.getColumn("expiredDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        while (rs.next()) {
            BigDecimal amt = Constants.ZERO;
            BigDecimal localBalance = Constants.ZERO;
            BigDecimal guanAmount = Constants.ZERO;
            BigDecimal fee = Constants.ZERO;
            BigDecimal aussCurrAm = Constants.ZERO;
            if (rs.getBigDecimal("Amount") != null) {
                amt = rs.getBigDecimal("Amount").divide(this.amtRate, 10, 4);
            }
            if (rs.getBigDecimal("LocalBalance") != null) {
                localBalance = rs.getBigDecimal("LocalBalance").divide(this.amtRate, 10, 4);
            }
            if (rs.getBigDecimal("guanAmount") != null) {
                guanAmount = rs.getBigDecimal("guanAmount").divide(this.amtRate, 10, 4);
            }
            if (rs.getBigDecimal("fee") != null) {
                fee = rs.getBigDecimal("fee").divide(this.amtRate, 10, 4);
            }
            if (rs.getBigDecimal("aussCurrAm") != null) {
                aussCurrAm = rs.getBigDecimal("aussCurrAm").divide(this.amtRate, 10, 4);
            }
            IRow row = this.kdt.addRow();
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("bank").setValue((Object)rs.getString("Institution.name"));
            row.getCell("currency").setValue((Object)rs.getString("Currency.name"));
            row.getCell("lgType").setValue((Object)rs.getString("LGType.name"));
            row.getCell("amount").setValue((Object)amt);
            row.getCell("exRate").setValue((Object)rs.getBigDecimal("LocalCurExRate"));
            row.getCell("balanceLocal").setValue((Object)localBalance);
            row.getCell("issueDate").setValue((Object)rs.getString("IssueDate"));
            if (!FMHelper.isEmpty((String)rs.getString("ExpiredDate"))) {
                row.getCell("expiredDate").setValue((Object)rs.getString("ExpiredDate"));
            } else {
                row.getCell("expiredDate").setValue((Object)rs.getString("guaranteeDate"));
            }
            row.getCell("receiver").setValue((Object)rs.getString("Receiver"));
            row.getCell("guanRate").setValue((Object)rs.getBigDecimal("guanRate"));
            row.getCell("guanAmount").setValue((Object)guanAmount);
            row.getCell("aussCurrAm").setValue((Object)aussCurrAm);
            row.getCell("bankAcct").setValue((Object)rs.getString("bankAcct.name"));
            row.getCell("fee").setValue((Object)fee);
            row.getCell("applyUnit").setValue((Object)rs.getString("applyUnit.name"));
            row.getCell("responseUnit").setValue((Object)rs.getString("responseUnit.name"));
            row.getCell("project").setValue((Object)rs.getString("project.name"));
            row.getCell("gt").setValue((Object)rs.getString("GaranteeType.name"));
            row.getCell("guarantee").setValue(this.GuaranteeMap.get(rs.getString("id")));
            row.getCell("isInCredit").setValue((Object)(rs.getBoolean("IsInCredit") ? yes : no));
            row.getCell("isDelay").setValue((Object)(rs.getBoolean("isDelay") ? yes : no));
            row.setUserObject((Object)rs.getString("id"));
        }
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.ctl.app.RptLetterOfGuaranteeDetailQuery";
    }

    protected abstract void formatHeadRow();

    protected abstract void insertHeadRow();

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    public String getGuranteeRowSet(String id, String GuType) throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ctl.RptLetterofGuanranteeDetailGuaranteeQuery");
        String GuranteeName = " ";
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("LetterofGuarantee.id", (Object)id));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        try {
            while (rs.next()) {
                GuranteeName = GuranteeName + rs.getString("guaranteeCompHand") + ",";
            }
        }
        catch (SQLException e) {
            throw FMHelper.toBOSException((Throwable)e);
        }
        GuranteeName = GuranteeName.substring(0, GuranteeName.length() - 1);
        return GuranteeName;
    }

    public HashMap getGurantee() throws BOSException {
        HashMap GuaranteeMap = RptLetterOfGuaranteeDetailFacadeFactory.getRemoteInstance().ReturnGuarantee(this.filterInfo, this.sorter, "T_CTL_LetterOfGuarantee", this.getQueryPath());
        return GuaranteeMap;
    }
}

