/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.client.AbstractSetAssureExpiredDateUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SetAssureExpiredDateUI
extends AbstractSetAssureExpiredDateUI {
    private static final Logger logger = CoreUIObject.getLogger(SetAssureExpiredDateUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        AssureBillInfo info = this.getInfo();
        if (info.getEndDate() != null) {
            this.txtExpiredDate.setValue((Object)info.getEndDate());
        }
        if (info.getDeferDay() > 0) {
            this.txtDeferDay.setValue((Object)new Integer(info.getDeferDay()), false);
        }
        this.txtClosedDate.setValue((Object)info.getAssureCloseDate());
    }

    protected int dateDeferDays(Date dt1, Date dt2) {
        Calendar c1 = Calendar.getInstance();
        Date dt = DateHelper.truncateDate((Date)dt1);
        c1.setTime(dt);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(dt2);
        int diff = Integer.parseInt(String.valueOf((c1.getTimeInMillis() - c2.getTimeInMillis()) / 1000L / 60L / 60L / 24L));
        return diff;
    }

    @Override
    protected void txtClosedDate_dataChanged(DataChangeEvent e) throws Exception {
        java.sql.Date dt1 = this.txtClosedDate.getSqlDate();
        java.sql.Date dt2 = this.txtExpiredDate.getSqlDate();
        int days = this.dateDeferDays(dt1, dt2);
        this.txtDeferDay.setValue((Object)new Integer(days));
    }

    public AssureBillInfo getInfo() throws EASBizException, BOSException {
        String assureBillID = this.getUIContext().get("ID").toString();
        AssureBillInfo info = AssureBillFactory.getRemoteInstance().getAssureBillInfo((IObjectPK)new ObjectUuidPK(assureBillID));
        return info;
    }

    @Override
    protected void txtDeferDay_stateChanged(ChangeEvent e) throws Exception {
        int days = Integer.parseInt(this.txtDeferDay.getValue().toString());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.txtExpiredDate.getSqlDate());
        calendar.set(5, calendar.get(5) + days);
        this.txtClosedDate.setValue((Object)calendar.getTime());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        AssureBillInfo info = this.getInfo();
        info.setDeferDay(Integer.parseInt(this.txtDeferDay.getValue().toString()));
        info.setAssureCloseDate(this.txtClosedDate.getSqlDate());
        AssureBillFactory.getRemoteInstance().submit((CoreBaseInfo)info);
        this.uiWindow.close();
    }
}

