/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.BizReceiveBillFactory;
import com.kingdee.eas.fm.ecore.BizReceiveBillInfo;
import com.kingdee.eas.fm.ecore.BizReplyBillFactory;
import com.kingdee.eas.fm.ecore.BizReplyBillInfo;
import com.kingdee.eas.fm.ecore.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ecore.MessageCommonSendFacadeFactory;
import com.kingdee.eas.fm.ecore.ProxySignatureEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SignUpEnum;
import com.kingdee.eas.fm.ecore.client.AbstractBizReplyBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizReplyBillEditUI
extends AbstractBizReplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BizReplyBillEditUI.class);

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("oriMessageTime");
        return sic;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (this.editData.getReplyType() == DraftReplyTypeEnum.CHENGDUI) {
            this.acceptPanel.setVisible(true);
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TISHIFUKUAN || this.editData.getReplyType() == DraftReplyTypeEnum.YUQITISHIFUKUAN) {
            this.presentPanel.setVisible(true);
            this.presentPanel.setBounds(350, 138, 290, 68);
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.BAOZHENG) {
            this.contGuarnteeAddress.setVisible(true);
            this.contGuarnteeAddress.setBounds(20, 481, 270, 19);
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TIEXIAN) {
            this.contDistAgreeNumber.setVisible(true);
            this.contDistAgreeNumber.setBounds(20, 481, 270, 19);
        }
        if (!FMHelper.isEmpty((Object)this.editData.getOriMessageTime())) {
            this.txtOriMessageTime.setText(this.editData.getOriMessageTime().toString());
        }
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        if (this.getOprtState() != OprtState.ADDNEW) {
            this.actionSendECDS.setEnabled(false);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSendECDS.setEnabled(true);
        this.btnSendECDS.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        String receiveBillID = (String)this.getUIContext().get("receivingBillId");
        if (!FMHelper.isEmpty((String)receiveBillID)) {
            BizReplyBillInfo info = (BizReplyBillInfo)dataObject;
            ObjectUuidPK pk = new ObjectUuidPK(receiveBillID);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("draftBill.*");
            try {
                BizReceiveBillInfo bizReceiveBillInfo = BizReceiveBillFactory.getRemoteInstance().getBizReceiveBillInfo((IObjectPK)pk, sic);
                info.setReplyType(bizReceiveBillInfo.getReplyType());
                info.setDraftNumber(bizReceiveBillInfo.getDraftBill().getDraftNumber());
                info.setDraftAmount(bizReceiveBillInfo.getDraftBill().getDraftAmount());
                info.setOriMessageID(bizReceiveBillInfo.getMessageID());
                info.setOriMessageTime(bizReceiveBillInfo.getMessageTime());
                info.setBizPromoterOrgCode(bizReceiveBillInfo.getReceiverOrgCode());
                info.setReplierOrgCode(bizReceiveBillInfo.getReceiverOrgCode());
            }
            catch (Exception e) {
                this.handleException(e);
                this.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getReplyType() == DraftReplyTypeEnum.TIEXIAN && !FMHelper.isEmpty((String)this.discAgreeNumber.getText())) {
            this.editData.setAgreementNumber(this.discAgreeNumber.getText());
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.CHENGDUI && !FMHelper.isEmpty((String)this.txtAgreementNumber.getText())) {
            this.editData.setAgreementNumber(this.txtAgreementNumber.getText());
        } else {
            this.editData.setAgreementNumber(null);
        }
    }

    protected IObjectValue createNewData() {
        BizReplyBillInfo info = new BizReplyBillInfo();
        info.setProxySignature(ProxySignatureEnum.PS01);
        info.setReplySignUp(SignUpEnum.SU00);
        info.setReplierRole(RoleEnum.RC00);
        info.setReplyDate(new Date());
        info.setIsSend(true);
        info.setIsCancelDraft(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BizReplyBillFactory.getRemoteInstance();
    }

    @Override
    public void actionSendECDS_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        this.storeFields();
        Map returnMap = MessageCommonSendFacadeFactory.getRemoteInstance().commonMessageSend("commonSendTest", this.editData.getBizPromoterOrgCode(), this.editData.getDraftNumber(), RequestTypeEnum.TYHF, (IObjectValue)this.editData);
        if (returnMap.get("result") != null && returnMap.get("result").toString().equals("0")) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{returnMap.get("eCause") + " " + returnMap.get("eMsg")});
        }
        if (returnMap.get("result") == null || !returnMap.get("result").toString().equals("1")) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u62a5\u6587\u53d1\u9001\u51fa\u9519\uff0c\u53d1\u9001\u5931\u8d25"});
        }
        MsgBox.showInfo((String)"\u62a5\u6587\u5df2\u6210\u529f\u53d1\u9001\u5230ECDS\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94\u7684\u884c\u4e3a\u8868\u4fe1\u606f\u8ddf\u8e2a\u540e\u7eed\u4e1a\u52a1\u60c5\u51b5");
    }
}

