/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.BaseDataDealFacadeFactory;
import com.kingdee.eas.fm.ecore.IBaseDataDealFacade;
import com.kingdee.eas.fm.ecore.client.AbstractDataImportWindowUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataImportWindowUI
extends AbstractDataImportWindowUI {
    private static final Logger logger = CoreUIObject.getLogger(DataImportWindowUI.class);
    String getTableName;
    String strFileType;
    String strTempFullPath;
    int AuthListDataSize = 3;
    int AssPSAPDataSize = 6;
    int BankDataSize = 32;
    int CommonDataSize = 9;
    int APDataSize = 14;
    int AssPSDataSize = 12;
    int AssBankDataSize = 19;
    String errMsgOne = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"11_BaseDataImportUI");

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCancel.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        Map ctx = this.getUIContext();
        this.getTableName = ctx.get("tableName").toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSourceName_actionPerformed(ActionEvent e) throws Exception {
        super.btnSourceName_actionPerformed(e);
        this.getSelectFile();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String msg = "";
        if (this.verifyInput()) {
            try {
                msg = this.readData(this.getTableName, this.strTempFullPath);
            }
            catch (IOException ie) {
                msg = this.errMsgOne;
                MsgBox.showInfo((String)msg);
            }
        }
        if (msg.equals("")) {
            this.destroyWindow();
        } else {
            MsgBox.showInfo((String)msg);
        }
    }

    private void getSelectFile() throws EASBizException {
        String tempPath = this.getDataImpPath();
        KDFileChooser chooser = new KDFileChooser(new File("c:\\"));
        chooser.setAcceptAllFileFilterUsed(false);
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            File tempfile = chooser.getSelectedFile();
            this.strTempFullPath = tempfile.getPath();
            String strTempPath = tempfile.getPath();
            String strTempName = tempfile.getName();
            this.txtSourceName.setText(this.strTempFullPath);
            this.strFileType = strTempName.substring(strTempName.lastIndexOf(46) + 1);
        }
    }

    private String getDataImpPath() {
        String tempPath = System.getProperty("easclient.root");
        tempPath = tempPath == null ? "c:\\" : tempPath + "/";
        tempPath = tempPath.replace('/', File.separatorChar);
        tempPath = tempPath.replace('\\', File.separatorChar);
        return tempPath;
    }

    protected boolean verifyInput() throws Exception {
        if (!"dat".equals(this.strFileType)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"10_BaseDataImportUI"));
            return false;
        }
        return !FMHelper.isEmpty((String)this.getTableName);
    }

    protected IBaseDataDealFacade getRemoteInstance() throws BOSException {
        return BaseDataDealFacadeFactory.getRemoteInstance();
    }

    private String readData(String tableName, String fileName) throws IOException, EASDBException, EASBizException, BOSException {
        ArrayList<String[]> importDateList = new ArrayList<String[]>();
        String msg = "";
        int arraylength = 0;
        if (tableName.equals("T_BE_BeBank")) {
            arraylength = this.BankDataSize;
        } else if (tableName.equals("T_ECR_AssBankData")) {
            arraylength = this.AssBankDataSize;
        } else if (tableName.equals("T_ECR_AuthListData")) {
            arraylength = this.AuthListDataSize;
        } else if (tableName.equals("T_ECR_CommonData")) {
            arraylength = this.CommonDataSize;
        } else if (tableName.equals("T_ECR_APData")) {
            arraylength = this.APDataSize;
        } else if (tableName.equals("T_ECR_AssPSData")) {
            arraylength = this.AssPSDataSize;
        } else if (tableName.equals("T_ECR_AssPSAPData")) {
            arraylength = this.AssPSAPDataSize;
        }
        File file = new File(fileName);
        DataInputStream input = new DataInputStream(new FileInputStream(file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
        String str = null;
        boolean readEnd = true;
        while (readEnd) {
            for (int i = 0; i < 5000; ++i) {
                String[] importData = null;
                str = in.readLine();
                if (str == null) {
                    readEnd = false;
                    break;
                }
                importData = this.getColumns(str, arraylength);
                if (importData == null) continue;
                importDateList.add(importData);
            }
            if (!(msg = this.getRemoteInstance().baseDataDeal(this.getTableName, importDateList)).equals("")) break;
            importDateList.clear();
            Runtime.getRuntime().freeMemory();
        }
        return msg;
    }

    private String[] getColumns(String s, int length) {
        String[] cols = new String[length];
        int lengthCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            lengthCount = s.charAt(i) == '\u2520' ? lengthCount + 1 : lengthCount;
        }
        if (length != lengthCount / 2) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < length; ++i) {
            int star = sb.indexOf("\u2520");
            int end = sb.indexOf("\u2520", star + 1);
            cols[i] = sb.substring(star + 1, end).trim();
            sb.delete(star, end + 1);
        }
        return cols;
    }
}

