/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.ecore.MessageTypeEnum;
import com.kingdee.eas.fm.ecore.client.DraftDaySummaryFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DraftDaySummaryHandler
implements IFMDetailRptHandler {
    protected KDTable kdt;
    protected DraftDaySummaryFilterParam filterParam;
    private static final Logger logger = CoreUIObject.getLogger(DraftDaySummaryHandler.class);

    protected DraftDaySummaryHandler(KDTable kdt, DraftDaySummaryFilterParam filterParam) {
        this.kdt = kdt;
        this.filterParam = filterParam;
    }

    private String[] getMergeColumn() {
        return new String[]{"msgType", "msgNumber", "ecoreNum", "ecdsNum"};
    }

    public void endDataFill() {
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.setUserObject((Object)rs.getString("FId"));
            row.getCell("checkDate").setValue((Object)rs.getDate("FCheckDate"));
            row.getCell("beBank").setValue((Object)rs.getString("FBeBank"));
            String msgType = rs.getString("FMsgType");
            String FmsgType = MessageTypeEnum.getEnum(msgType).getAlias();
            row.getCell("msgType").setValue((Object)FmsgType);
            row.getCell("msgNumber").setValue((Object)rs.getString("FMsgNumber"));
            row.getCell("ecoreNum").setValue((Object)new Integer(rs.getInt("FMsgNum")));
            row.getCell("ecdsNum").setValue((Object)new Integer(rs.getInt("FBakNum")));
        }
    }

    public IRowSet getRowSet() throws BOSException {
        String orderBy;
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        Date checkBeginDate = this.filterParam.getCheckBeginDate();
        Date checkEndDate = this.filterParam.getCheckEndDate();
        String messageType = null;
        if (this.filterParam.getMsgType() != null) {
            messageType = this.filterParam.getMsgType().getValue();
        }
        sb.append("Select FID,FCheckDate,FBeBank,FMsgType,FMsgNumber,FMsgNum,FBakNum ");
        sb.append("from T_ECR_DraftDaySummary draftSummary ");
        sb.append("left join (Select FBizDate,Count(1) FBakNum From T_ECR_Message Where FBizDate >= ? and FBizDate <= ? Group By FBizDate) message ");
        sb.append("on draftSummary.FCheckDate = message.FBizDate ");
        sb.append(" where 1=1");
        sb.append(" and FCheckDate >= ? and FCheckDate <= ?");
        paramList.add(checkBeginDate);
        paramList.add(checkEndDate);
        paramList.add(checkBeginDate);
        paramList.add(checkEndDate);
        if (messageType != null) {
            sb.append(" and FMsgType = ?");
            paramList.add(messageType);
        }
        if (!StringUtils.isEmpty((String)(orderBy = this.getOrderByClause()))) {
            sb.append("\n").append(orderBy);
        }
        logger.info((Object)"=====================================");
        logger.info((Object)sb);
        logger.info((Object)"=====================================");
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sb.toString(), paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    protected String getOrderByClause() {
        return "order by FCheckDate desc, FBeBank";
    }

    public void initHeader() {
    }

    public void setTableStateRow() {
    }
}

