/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client.massageCommonSend.impl;

import com.kingdee.bos.ctrl.swing.KDBusiMaskField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.client.MessageCommonSendUI;
import com.kingdee.eas.fm.ecore.client.massageCommonSend.IEditUIProcessor;
import com.kingdee.eas.fm.ecore.client.massageCommonSend.impl.DynComponentImpl;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class AbstractEditUIProcessor
implements IEditUIProcessor {
    static final int between = 5;
    protected CoreUI ui;
    protected Map comps = new HashMap();

    abstract Object[][] initTab();

    public JComponent getComp(String name) {
        if (this.comps == null) {
            return null;
        }
        return (JComponent)this.comps.get(name);
    }

    @Override
    public void setUI(CoreUI ui) {
        this.ui = ui;
    }

    protected KDLabelContainer getLabel() {
        KDLabelContainer ret = new KDLabelContainer();
        ret.setBoundLabelLength(150);
        ret.setBoundLabelUnderline(true);
        ret.setBoundLabelAlignment(7);
        return ret;
    }

    @Override
    public void initEnvironment() throws Exception {
        DynComponentImpl dynComp = new DynComponentImpl();
        ((MessageCommonSendUI)this.ui).getPanel().removeAll();
        this.comps.clear();
        Object[][] tab = this.initTab();
        for (int i = 0; i < tab.length; ++i) {
            Object[] entry = tab[i];
            KDLabelContainer label = this.getLabel();
            label.setName("label" + i);
            label.setBounds(new Rectangle(10, 10 + i * 25, 400, 20));
            if ("-".equals(entry[0])) continue;
            JComponent tmpComp = dynComp.getDynComponent((Integer)entry[2]);
            tmpComp.setName((String)entry[1]);
            if (tmpComp instanceof KDBusiMaskField) {
                ((KDBusiMaskField)tmpComp).setRequired(((Boolean)entry[3]).booleanValue());
            }
            if (tmpComp instanceof KDComboBox) {
                ((KDComboBox)tmpComp).setRequired(((Boolean)entry[3]).booleanValue());
            }
            if (tmpComp instanceof KDNumberTextField) {
                ((KDNumberTextField)tmpComp).setRequired(((Boolean)entry[3]).booleanValue());
            }
            if (tmpComp instanceof KDDatePicker) {
                ((KDDatePicker)tmpComp).setRequired(((Boolean)entry[3]).booleanValue());
            }
            label.setBoundLabelText((String)entry[0]);
            label.setBoundEditor(tmpComp);
            ((MessageCommonSendUI)this.ui).getPanel().add((Component)label, (Object)new KDLayout.Constraints(5, label.getBounds()));
            this.comps.put(tmpComp.getName(), tmpComp);
        }
        ((MessageCommonSendUI)this.ui).getPanel().repaint();
    }

    @Override
    public void setValueToComponent(BillBaseInfo info) {
        if (FMHelper.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        Object[][] tab = this.initTab();
        for (int i = 0; i < tab.length; ++i) {
            Object[] entry = tab[i];
            if ("-".equals(entry[0])) continue;
            JComponent comp = (JComponent)this.comps.get(entry[1]);
            Object compValue = info.get((String)entry[4]);
            if (comp != null && !FMHelper.isEmpty((Object)compValue)) {
                if (comp instanceof KDBusiMaskField) {
                    ((KDBusiMaskField)comp).setValue(compValue);
                } else if (comp instanceof KDComboBox) {
                    FMClientHelper.setSelectObject((KDComboBox)((KDComboBox)comp), (Object)compValue);
                } else if (comp instanceof KDDatePicker) {
                    ((KDDatePicker)comp).setValue(compValue);
                } else if (comp instanceof KDNumberTextField) {
                    FMClientHelper.setCutValue((KDNumberTextField)((KDNumberTextField)comp), (Number)((Number)compValue), (boolean)true);
                }
            }
            comp.setEnabled(false);
        }
    }

    @Override
    public void verify() throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this.ui, (KDPanel)((MessageCommonSendUI)this.ui).getPanel());
    }

    @Override
    public BillBaseInfo buildBillInfo() throws Exception {
        this.verify();
        BillBaseInfo info = this.getBillBaseInfo();
        String stringType = "java.lang.String";
        String dateType = "java.util.Date";
        String bigDecimalType = "java.math.BigDecimal";
        String enumType = "Enum";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Object[][] tab = this.initTab();
        for (int i = 0; i < tab.length; ++i) {
            if ("-".equals(tab[i][0])) continue;
            Object compValue = null;
            JComponent comp = this.getComp(tab[i][1].toString());
            if (comp instanceof KDBusiMaskField) {
                compValue = ((KDBusiMaskField)comp).getText();
            } else if (comp instanceof KDComboBox) {
                compValue = ((KDComboBox)comp).getSelectedItem();
            } else if (comp instanceof KDNumberTextField) {
                compValue = ((KDNumberTextField)comp).getNumberValue();
            } else if (comp instanceof KDDatePicker) {
                compValue = ((KDDatePicker)comp).getValue();
            }
            if (FMHelper.isEmpty((Object)compValue)) continue;
            String fieldName = tab[i][4].toString();
            StringBuffer fieldNameForMethod = new StringBuffer(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1));
            Class<?> fieldType = info.getClass().getMethod("get" + fieldNameForMethod.toString(), null).getReturnType();
            if (compValue == null) continue;
            if (fieldType.getName().endsWith(stringType)) {
                info.setString(tab[i][4].toString(), compValue.toString());
                continue;
            }
            if (fieldType.getName().endsWith(bigDecimalType)) {
                info.setBigDecimal(tab[i][4].toString(), new BigDecimal(compValue.toString()));
                continue;
            }
            if (fieldType.getName().endsWith(dateType)) {
                info.setDate(tab[i][4].toString(), (Date)compValue);
                continue;
            }
            if (!fieldType.getName().endsWith(enumType)) continue;
            Object[] arglist = new Object[]{new String(compValue.toString())};
            Class[] partype1 = new Class[]{String.class};
            Object o = fieldType.getMethod("getEnum", partype1).invoke((Object)info, arglist);
            arglist = new Object[]{o};
            partype1[0] = fieldType;
            info.getClass().getMethod("set" + fieldNameForMethod.toString(), partype1).invoke((Object)info, arglist);
        }
        return info;
    }
}

