/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowCollection;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.IForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;

public class CDForecastedBlockingFlowGenerator
implements IForecastedBlockingFlowGenerator {
    public ForecastedBlockingFlowCollection genForecastedBlockingFlowColl(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("company.id");
        selectors.add("company.name");
        selectors.add("Institution.id");
        selectors.add("Institution.name");
        selectors.add("BlockFlowType.*");
        selectors.add("BlockFlowType.id");
        PayableBillInfo srcInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        if (srcInfo.getBlockFlowType() == null || !FinUtils.dayAfterEquals(srcInfo.getExpiredDate(), DateUtil.getDayBegin())) {
            return new ForecastedBlockingFlowCollection();
        }
        ForecastedBlockingFlowCollection destColl = new ForecastedBlockingFlowCollection();
        String billTypeName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityAlias(srcInfo.getId().toString());
        ForecastedBlockingFlowInfo destInfo = new ForecastedBlockingFlowInfo();
        destInfo.setNumber(srcInfo.getNumber());
        destInfo.setAmount(srcInfo.getBalance());
        destInfo.setOriginalAmount(srcInfo.getAmount());
        destInfo.setBillId(srcInfo.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        BankInfo bank = srcInfo.getInstitution();
        if (bank != null) {
            destInfo.setCounterPart(bank.getName());
        } else {
            destInfo.setCounterPart(srcInfo.getCompany().getName());
        }
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setDescription(billTypeName + srcInfo.getNumber());
        destInfo.setExchangeRate(srcInfo.getLocalCurExRate());
        destInfo.setExpectedDate(srcInfo.getExpiredDate());
        destInfo.setBlockFlowType(srcInfo.getBlockFlowType());
        if (srcInfo.getBlockFlowType() != null) {
            destInfo.setIsInFlow(srcInfo.getBlockFlowType().isIsInFlow());
        }
        destInfo.setIsInsider(false);
        destInfo.setRegion(srcInfo.getRegion());
        destInfo.setSourceType(SourceTypeEnum.system);
        destColl.add(destInfo);
        return destColl;
    }
}

