/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class LoanInterestBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        LoanInterestInfo info = this.getLoanInterestInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        if (info.getInterestType() == IntCalTypeEnum.PAY_INT || info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            this.addIntAmtJournal(ctx, info, journalColl);
        }
        return journalColl;
    }

    private void addIntAmtJournal(Context ctx, LoanInterestInfo info, JournalCollection journalColl) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getAccount());
        journalInfo.setCurrency(info.getIntCurrency());
        journalInfo.setCreateDate(info.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setIsDebit(false);
        journalInfo.setCreditAmount(info.getIntCurrencyAmt());
        journalInfo.setBizDate(info.getBizDate());
        journalInfo.setOppAccountView(info.getIntFeeAcctView());
        journalInfo.setAccountView(info.getAccount().getAccount());
        journalInfo.setOppUnit(null);
        journalInfo.setBillType(BillTypeEnum.intBill);
        journalInfo.setBillNumber(info.getNumber());
        String des = "";
        if (info.getInterestType() == IntCalTypeEnum.PAY_INT) {
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"449_LoanInterestBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"449_LoanInterestBookNotifyBuilder");
        } else if (info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder");
        }
        journalInfo.setDescription(des);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalColl.add(journalInfo);
    }

    private LoanInterestInfo getLoanInterestInfo(Context ctx, String billId) throws EASBizException, BOSException {
        LoanInterestInfo info = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("account.*");
        return sic;
    }
}

