/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;
import java.util.Set;

public class RepaymentBook4PayableNotifyBuilder
implements IBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = this.getRepaymentInfo(ctx, billId);
        String sourceBillId = repaymentInfo.getSourceBillId();
        Object srcBillInfo = null;
        if (FinancingBillTypeEnum.CommercialDraft == repaymentInfo.getSourceType() && !EmptyUtil.isEmpty((String)sourceBillId)) {
            srcBillInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        } else if (FinancingBillTypeEnum.LetterOfCredit == repaymentInfo.getSourceType() && !EmptyUtil.isEmpty((String)sourceBillId)) {
            srcBillInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        }
        JournalCollection journalColl = new JournalCollection();
        this.addRepayAmtJournal(ctx, repaymentInfo, journalColl, 0, (CoreBillBaseInfo)srcBillInfo);
        if (repaymentInfo.getCautionAmt().compareTo(Constants.ZERO) != 0 && repaymentInfo.getAcutionAcctBank() != null) {
            this.addCautionAmtJournal(ctx, repaymentInfo, journalColl, (CoreBillBaseInfo)srcBillInfo);
        }
        return journalColl;
    }

    private void addRepayAmtJournal(Context ctx, RepaymentInfo repaymentInfo, JournalCollection journalColl, int type, CoreBillBaseInfo srcBillInfo) throws EASBizException, BOSException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(repaymentInfo.getBankAcct());
        journalInfo.setCurrency(repaymentInfo.getCurrency());
        journalInfo.setCreateDate(repaymentInfo.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(repaymentInfo.getBizDate());
        if (repaymentInfo.getBankAcct() == null) {
            return;
        }
        journalInfo.setAccountView(repaymentInfo.getBankAcct().getAccount());
        journalInfo.setBillId(repaymentInfo.getId().toString());
        journalInfo.setBillNumber(repaymentInfo.getNumber());
        journalInfo.setCompany(repaymentInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        if (type == 0) {
            journalInfo.setCreditAmount(repaymentInfo.getAmount());
            journalInfo.setBillType(BillTypeEnum.other);
            journalInfo.setAccountView(repaymentInfo.getBankAcct().getAccount());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LoanInfo) {
                journalInfo.setOppAccountView(repaymentInfo.getLoanAcct());
                String des = "";
                des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"450_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"450_RepaymentBook4PayableNotifyBuilder");
                journalInfo.setDescription(des);
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof PayableBillInfo) {
                PayableBillInfo payableBill = (PayableBillInfo)srcBillInfo;
                journalInfo.setOppAccountView(payableBill.getBillAccount());
                journalInfo.setSettlementNumber(payableBill.getNumber());
                journalInfo.setSettlementType(this.getSettlementType(ctx, "66666666-6666-6666-6666-6666666666661C9A9013"));
                if (repaymentInfo.getPayee() != null) {
                    journalInfo.setOppUnit(repaymentInfo.getPayee().getName());
                } else if (repaymentInfo.getPayeeCust() != null) {
                    journalInfo.setOppUnit(repaymentInfo.getPayeeCust().getName());
                }
                String des = "";
                des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"451_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"451_RepaymentBook4PayableNotifyBuilder");
                journalInfo.setDescription(des);
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LetterOfCreditInfo) {
                LetterOfCreditInfo letterOfCreditInfo = (LetterOfCreditInfo)srcBillInfo;
                journalInfo.setSettlementType(this.getSettlementType(ctx, "55555555-5555-5555-5555-5555555555551C9A9013"));
                journalInfo.setSettlementNumber(letterOfCreditInfo.getNumber());
                String des = "";
                des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder");
                journalInfo.setDescription(des);
            }
        } else {
            journalInfo.setCreditAmount(repaymentInfo.getInterest());
            journalInfo.setBillType(BillTypeEnum.intBill);
            journalInfo.setAccountView(repaymentInfo.getBankAcct().getAccount());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LoanInfo) {
                journalInfo.setOppAccountView(repaymentInfo.getInterestAcct());
                String des = "";
                des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder");
                journalInfo.setDescription(des);
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof PayableBillInfo) {
                PayableBillInfo payableBill = (PayableBillInfo)srcBillInfo;
                journalInfo.setOppAccountView(payableBill.getBillAccount());
                journalInfo.setSettlementNumber(payableBill.getNumber());
                journalInfo.setSettlementType(this.getSettlementType(ctx, "66666666-6666-6666-6666-6666666666661C9A9013"));
                journalInfo.setOppUnit(payableBill.getPayeeName());
                String des = "";
                des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"454_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"454_RepaymentBook4PayableNotifyBuilder");
                journalInfo.setDescription(des);
            } else if (EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) || srcBillInfo instanceof LetterOfCreditInfo) {
                // empty if block
            }
        }
        journalColl.add(journalInfo);
    }

    private RepaymentInfo getRepaymentInfo(Context ctx, String billId) throws EASBizException, BOSException {
        RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("InterestAcct.id");
        sic.add("InterestAcct.name");
        sic.add("InterestAcct.number");
        sic.add("LoanAcct.id");
        sic.add("LoanAcct.name");
        sic.add("LoanAcct.number");
        sic.add("BankAcct.id");
        sic.add("BankAcct.name");
        sic.add("BankAcct.number");
        sic.add("BankAcct.account.id");
        sic.add("BankAcct.account.name");
        sic.add("BankAcct.account.number");
        sic.add("acutionAcctBank.account.id");
        sic.add("acutionAcctBank.account.number");
        sic.add("acutionAcctBank.account.name");
        sic.add("payeeCust.name");
        sic.add("payee.name");
        return sic;
    }

    private SettlementTypeInfo getSettlementType(Context ctx, String ntTypeID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)ntTypeID));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }

    private void addCautionAmtJournal(Context ctx, RepaymentInfo repaymentInfo, JournalCollection journalColl, CoreBillBaseInfo srcBillInfo) throws BOSException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(repaymentInfo.getAcutionAcctBank());
        journalInfo.setCurrency(repaymentInfo.getCurrency());
        journalInfo.setCreateDate(repaymentInfo.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(repaymentInfo.getCautionAmt());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(repaymentInfo.getBizDate());
        journalInfo.setAccountView(repaymentInfo.getAcutionAcctBank().getAccount());
        journalInfo.setOppAccountView(repaymentInfo.getLoanAcct());
        journalInfo.setBillType(BillTypeEnum.repaymentbill);
        journalInfo.setBillId(repaymentInfo.getId().toString());
        journalInfo.setBillNumber(repaymentInfo.getNumber());
        String des = "";
        des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"455_RepaymentBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"455_RepaymentBookNotifyBuilder");
        journalInfo.setDescription(des);
        journalInfo.setCompany(repaymentInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LetterOfCreditInfo) {
            LetterOfCreditInfo letterOfCreditInfo = (LetterOfCreditInfo)srcBillInfo;
            journalInfo.setSettlementType(this.getSettlementType(ctx, "55555555-5555-5555-5555-5555555555551C9A9013"));
            journalInfo.setSettlementNumber(letterOfCreditInfo.getNumber());
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des);
        }
        journalColl.add(journalInfo);
    }

    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        return null;
    }
}

