/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.AbstractRepaymentInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.BondsRepaymentEditUI;
import com.kingdee.eas.fm.fin.client.BondsRepaymentListUI;
import com.kingdee.eas.fm.fin.client.RepaymentEditUI;
import com.kingdee.eas.fm.fin.client.RepaymentListUI;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class RepaymentInfo
extends AbstractRepaymentInfo
implements Serializable,
IFMBgUsed {
    private BOSUuid sourceBill;
    private boolean isBat4Payable = false;
    private LoanInfo loanInfo;
    private Date oldBizDate;
    private BigDecimal remAmt;
    private boolean isCreatePayment = false;
    public static final BOSObjectType BOSTYPE = new BOSObjectType("18180D81");

    public RepaymentInfo() {
    }

    protected RepaymentInfo(String pkField) {
        super(pkField);
    }

    public LoanInfo getLoanInfo() {
        return this.loanInfo;
    }

    public void setLoanInfo(LoanInfo loanInfo) {
        this.loanInfo = loanInfo;
    }

    public BigDecimal getRemAmt() {
        if (this.loanInfo != null) {
            return this.loanInfo.getBalance().subtract(this.getAmount());
        }
        return Constants.ZERO;
    }

    public void setRemAmt(BigDecimal remAmt) {
        this.remAmt = remAmt;
    }

    public boolean isCreatePayment() {
        return this.isCreatePayment;
    }

    public void setCreatePayment(boolean isCreatePayment) {
        this.isCreatePayment = isCreatePayment;
    }

    public void setOldBizDate(Date oldBizDate) {
        this.oldBizDate = oldBizDate;
    }

    public Date getOldBizDate() {
        return this.oldBizDate;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.sourceBill);
        marshaller.writeObject((Object)this.loanInfo);
        marshaller.writeObject((Object)this.remAmt);
        marshaller.writeObject((Object)this.oldBizDate);
        marshaller.writeObject((Object)new Boolean(this.isCreatePayment));
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.sourceBill = (BOSUuid)unmarshaller.readObject();
        this.loanInfo = (LoanInfo)unmarshaller.readObject();
        this.remAmt = (BigDecimal)unmarshaller.readObject();
        this.oldBizDate = (Date)unmarshaller.readObject();
        this.isCreatePayment = (Boolean)unmarshaller.readObject();
    }

    public boolean isBat4Payable() {
        return this.isBat4Payable;
    }

    public void setBat4Payable(boolean isBat4Payable) {
        this.isBat4Payable = isBat4Payable;
    }

    public FMBgItemProp[] getBgItemProps() {
        return new FMBgItemProp[]{new FMBgItemProp("outBgItemId", "outBgItemNumber", "outBgItemName")};
    }

    public String getBOTPEditUI() {
        if (this.isIsBondsRepayment()) {
            return BondsRepaymentEditUI.class.getName();
        }
        return RepaymentEditUI.class.getName();
    }

    public String getBOTPListUI() {
        if (this.isIsBondsRepayment()) {
            return BondsRepaymentListUI.class.getName();
        }
        return RepaymentListUI.class.getName();
    }
}

