/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractBondAdjustInterestEditUI;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BondAdjustInterestEditUI
extends AbstractBondAdjustInterestEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BondAdjustInterestEditUI.class);
    private boolean successFlag;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanAdjustInterestFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.txtAdjustAfterRate.setPrecision(8);
        this.txtAdjustAfterRate.setRemoveingZeroInDispaly(false);
        this.txtAdjustAfterRate.setRemoveingZeroInEdit(true);
        this.txtAdjustAfterRate.setHorizontalAlignment(4);
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.txtAdjustAfterRate.setNegatived(true);
        this.txtAdjustAfterRate.setSupportedEmpty(false);
        this.txtYearDays.setHorizontalAlignment(4);
        this.pkAdjustDate.setSupportedEmpty(false);
        this.txtNumber.setMaxLength(80);
        this.txtContractNum.setMaxLength(100);
        this.txtDescription.setMaxLength(150);
        this.comboIntRateTypeExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BondAdjustInterestEditUI.this.beforeActionPerformed(e);
                try {
                    BondAdjustInterestEditUI.this.comboIntRateTypeExpression_actionPerformed(e);
                }
                catch (Exception exc) {
                    BondAdjustInterestEditUI.this.handUIException(exc);
                }
                finally {
                    BondAdjustInterestEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
            this.txtYearDays.setEnabled(true);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.txtYearDays.setEnabled(true);
        } else {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.txtYearDays.setEnabled(false);
        }
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.initModifyRateType();
    }

    private void initModifyRateType() throws BOSException {
        this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR_Adjustment);
        this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR);
    }

    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkAdjustDate});
    }

    @Override
    public void loadFields() {
        Map listeners = null;
        try {
            listeners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        this.txtYearDays.setValue((Object)new Integer(this.editData.getYearDays()));
        this.txtAdjustAfterRate.setValue((Object)this.editData.getAdjustAfterRate());
        if (this.editData.getModifyRateType() != null) {
            this.combModifyRateType.setSelectedItem((Object)this.editData.getModifyRateType());
        } else if (this.getOprtState().equals(OprtState.ADDNEW) && this.getUIContext().get("LoanID") != null) {
            this.combModifyRateType.setSelectedItem((Object)IntRateModifyType.Agreement);
        }
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listeners);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"261_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
    }

    public static void show(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"LoanID", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BondAdjustInterestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((BondAdjustInterestEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return false;
    }

    public void checkDate() throws Exception {
        Date lastSettleDate = null;
        Date comDate = null;
        Date adjDate = (Date)this.pkAdjustDate.getValue();
        if (adjDate.before(this.editData.getLoan().getIssueDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"184_BondAdjustInterestEditUI"));
            SysUtil.abort();
        }
        Date lastPreDate = this.editData.getLoan().getLastPreIntDate();
        lastSettleDate = this.editData.getLoan().getLastIntDate();
        if (lastPreDate == null && lastSettleDate == null) {
            return;
        }
        comDate = lastSettleDate != null ? lastSettleDate : lastPreDate;
        if (lastSettleDate != null && lastPreDate != null) {
            comDate = lastSettleDate.getTime() > lastPreDate.getTime() ? lastSettleDate : lastPreDate;
        }
        if (adjDate.getTime() <= comDate.getTime()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"185_BondAdjustInterestEditUI") + this.editData.getLoan().getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"186_BondAdjustInterestEditUI");
            msg = MessageFormat.format(msg, this.editData.getLoan().getNumber());
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkDate();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkDate();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    protected IObjectValue createNewData() {
        LoanAdjustInterestInfo adjustInfo = new LoanAdjustInterestInfo();
        if (this.getUIContext().get("LoanID") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("LoanID");
            try {
                LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo(pk, this.getLoanInfoSelector());
                adjustInfo.setLoan(loanInfo);
                adjustInfo.setCreditorAsCompany(loanInfo.getGroupID());
                adjustInfo.setCreditorAsBank(loanInfo.getInstitution());
                adjustInfo.setAccount(loanInfo.getBankAcct());
                adjustInfo.setContractNum(loanInfo.getContractNum());
                adjustInfo.setAdjustSeq(LoanAdjustInterestFactory.getRemoteInstance().getMaxSeq(pk));
                adjustInfo.setAdjustDate(DateUtil.getDayBegin());
                adjustInfo.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
                adjustInfo.setYearDays(360);
                adjustInfo.setBasePoints(Constants.ZERO);
                adjustInfo.setAdjustAfterRate(Constants.ZERO);
                adjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
                adjustInfo.setPenAccrualRate(Constants.ZERO);
                adjustInfo.setIsUsed(IsOrNoEnum.NO);
                adjustInfo.setCreator(this.userinfo);
                adjustInfo.setIsBond(loanInfo.isIsBonds());
                adjustInfo.setCompany(loanInfo.getCompany());
                this.currentCompany = loanInfo.getCompany();
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"526_IntReceivePayDateChooseUI"), loanInfo.getNumber(), adjustInfo.getAdjustSeq());
                adjustInfo.setDescription(msgStr);
                this.baseCurrency = loanInfo.getCurrency();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            adjustInfo.setAdjustDate(DateUtil.getDayBegin());
            adjustInfo.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            adjustInfo.setYearDays(360);
            adjustInfo.setAdjustAfterRate(Constants.ZERO);
            adjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
            adjustInfo.setPenAccrualRate(Constants.ZERO);
            adjustInfo.setIsUsed(IsOrNoEnum.NO);
            adjustInfo.setCreator(this.userinfo);
            adjustInfo.setCompany(this.currentCompany);
        }
        return adjustInfo;
    }

    private SelectorItemCollection getLoanInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        sic.add(new SelectorItemInfo("GroupID.number"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("intRateType.isLPR"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("creditorAsCompany.id"));
        sic.add(new SelectorItemInfo("creditorAsCompany.name"));
        sic.add(new SelectorItemInfo("creditorAsCompany.number"));
        sic.add(new SelectorItemInfo("creditorAsBank.id"));
        sic.add(new SelectorItemInfo("creditorAsBank.name"));
        sic.add(new SelectorItemInfo("creditorAsBank.number"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("contractNum"));
        sic.add(new SelectorItemInfo("adjustSeq"));
        sic.add(new SelectorItemInfo("adjustDate"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("adjustAfterRate"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    protected String getClassAlise() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"187_BondAdjustInterestEditUI");
    }

    @Override
    protected void combModifyRateType_itemStateChanged(ItemEvent e) throws Exception {
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            this.comboIntRateTypeExpression.setEnabled(true);
            this.comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtAdjustAfterRate.setEnabled(true);
            this.txtAdjustAfterRate.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void comboIntRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpress = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            this.txtYearDays.setText("360");
            this.txtYearDays.setEnabled(true);
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
            this.txtYearDays.setText("30");
            this.txtYearDays.setEnabled(true);
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.DAY)) {
            this.txtYearDays.setText("1");
            this.txtYearDays.setEnabled(false);
        }
    }
}

