/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.client.AbstractBondApplyBillFilterUI;
import com.kingdee.eas.fm.fin.client.BondApplyBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondApplyBillFilterUI
extends AbstractBondApplyBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BondApplyBillFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.comboStatus.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.initLoanProperty();
        this.initCurrency();
        this.prmtTradeMarket.setData(null);
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initLoanProperty() {
        this.comboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Object getParam() {
        Set prmtTradeMarketSet;
        BondApplyBillFilterParam labfp = new BondApplyBillFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            labfp.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (null != this.dpStartDate.getValue()) {
            labfp.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            labfp.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (!(this.comboStatus.getSelectedItem() instanceof LoanApplyBillStatusEnum)) {
            labfp.setStatus((LoanApplyBillStatusEnum)null);
        } else {
            labfp.setStatus((LoanApplyBillStatusEnum)((Object)this.comboStatus.getShowSelectedItem()));
        }
        if (null != this.cboCurrency.getSelectedItem()) {
            Object obj = this.cboCurrency.getSelectedItem();
            if (obj instanceof CurrencyInfo) {
                labfp.setCurrencyInfo((CurrencyInfo)this.cboCurrency.getSelectedItem());
            } else {
                labfp.setCurrencyInfo(null);
            }
        }
        if ((prmtTradeMarketSet = this.getIdSetFromF7(this.prmtTradeMarket)) != null && prmtTradeMarketSet.size() > 0) {
            labfp.setTradeMarketId(prmtTradeMarketSet);
        }
        return labfp;
    }

    protected Class getParamClass() {
        return BondApplyBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        BondApplyBillFilterParam labfp = (BondApplyBillFilterParam)param;
        if (labfp == null) {
            return;
        }
        this.dpStartDate.setValue((Object)labfp.getStartDate());
        this.dpEndDate.setValue((Object)labfp.getEndDate());
        if (labfp.getStatus() == null) {
            this.comboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboStatus.setSelectedItem((Object)labfp.getStatus());
        }
        if (labfp.getCurrencyInfo() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)labfp.getCurrencyInfo());
        } else {
            this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        try {
            this.prmtTradeMarket.setData((Object)this.getBaseInfoFromIdSet(labfp.getTradeMarketId()));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public boolean verify() {
        if (((Date)this.dpStartDate.getValue()).after((Date)this.dpEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"273_LoanApplyBillFilterUI"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }
}

