/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillCollection;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillFilterParam;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.ICompDepositAccountBill;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.client.AbstractCompDepositAccountBillListUI;
import com.kingdee.eas.fm.fin.client.CompDepositAccountBillEditUI;
import com.kingdee.eas.fm.fin.client.CompDepositBillDataProvider;
import com.kingdee.eas.fm.fin.client.CompDepositBillFilterUI;
import com.kingdee.eas.fm.fin.client.CompUntimeDepositBillEditUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CompDepositAccountBillListUI
extends AbstractCompDepositAccountBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CompDepositAccountBillListUI.class);
    CompDepositBillFilterUI filterUI;
    FillListener fillListener = new FillListener();
    private Boolean effectiveCanBeModify = new Boolean(false);
    private static final String COMPDEPOSITBILL_FILENAME = "/FM/FIN/COMPDEPOSIT";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getBOTPViewStatus() != 1) {
            FSClientHelper.checkClearingHouseCompany();
        }
        this.btnModifyCertificateNo.setEnabled(false);
        super.onLoad();
        this.initTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionUnDeposit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionReDeposit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_repeatcheck"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionAntiAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.btnNavInnerEreceipt.setVisible(true);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1) {
            IRow row = this.tblMain.getRow(rowIndex);
            if (((Boolean)row.getCell("isUnDeposit").getValue()).booleanValue() && "3".equals(((BizEnumValueDTO)row.getCell("status").getValue()).getString())) {
                this.btnModifyCertificateNo.setEnabled(true);
            } else {
                this.btnModifyCertificateNo.setEnabled(false);
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CompDepositAccountBillInfo info = this.getSelectObject();
        if (info.getEffectedStatus() == CompDepositBillStatusEnum.ACCEPTED && !info.isIsHistory()) {
            throw new TDException(TDException.EXCEPTION61);
        }
        this.effectiveCanBeModify = new Boolean(this.hasBeenOperated(info.getId().toString()));
        Set downBillSet = BOTPUtil.getDestBillIdSet(null, (String)info.getId().toString());
        if (info.isIsreceived() || downBillSet.size() > 0) {
            throw new TDException(TDException.EXCEPTION78);
        }
        if (this.hasBeenOperated(info.getId().toString())) {
            throw new TDException(TDException.UNALLOW_EDIT);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        Boolean isHis = (Boolean)row.getCell("isHistory").getValue();
        if (this.getSelectObject().getEffectedStatus() == CompDepositBillStatusEnum.ACCEPTED && !isHis.booleanValue()) {
            throw new TDException(TDException.EXCEPTION62);
        }
        if (isHis.booleanValue()) {
            Boolean isRedepsited = (Boolean)row.getCell("isReDeposited").getValue();
            if (isRedepsited.booleanValue()) {
                throw new TDException(TDException.DELETE_EXC1);
            }
            Boolean isReceived = (Boolean)row.getCell("isreceived").getValue();
            if (isReceived.booleanValue()) {
                throw new TDException(TDException.DELETE_EXC3);
            }
        } else {
            Boolean isVouched = (Boolean)row.getCell("fiVouchered").getValue();
            if (isVouched.booleanValue()) {
                throw new TDException(TDException.DELETE_EXC2);
            }
            Boolean isReceived = (Boolean)row.getCell("isreceived").getValue();
            if (isReceived.booleanValue()) {
                throw new TDException(TDException.DELETE_EXC3);
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CompDepositAccountBillFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return CompDepositAccountBillEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CompDepositBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionAddNewHis_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals((Object)this.actionAddNewHis)) {
            uiContext.put((Object)"addType", (Object)Boolean.TRUE);
            uiContext.put((Object)"ISHIS", (Object)Boolean.TRUE);
        } else {
            uiContext.put((Object)"ISHIS", (Object)Boolean.FALSE);
            uiContext.put((Object)"addType", (Object)Boolean.FALSE);
        }
        if (action.equals(this.actionEdit)) {
            uiContext.put((Object)"editScope", (Object)"");
        }
        if (action.equals((Object)this.actionReDeposit)) {
            uiContext.put((Object)"RTD", (Object)Boolean.TRUE);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    @Override
    public void actionReDeposit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeRedeposit();
        try {
            this.setOprtState("userCustomerStatus");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
            CompDepositAccountBillEditUI.showReDeopsitWindow((CoreUIObject)this, this.getSelectedKeyValue(), 1);
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        this.refresh(e);
    }

    @Override
    public void actionUnDeposit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeUnDeposited();
        CompUntimeDepositBillEditUI.showUnDeopsitWindow((CoreUIObject)this, this.getSelectedKeyValue());
        this.refresh(e);
    }

    @Override
    public void actionUndoUnDeposit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUndoUnDeposit_actionPerformed(e);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        CompDepositAccountBillInfo info = this.getSelectObject();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.CompDepositAccountBill", null, (IObjectValue)info);
    }

    private void checkCanBeRedeposit() throws Exception {
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = this.getSelectObject();
        if (CompDepositAccountBillInfo2.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON1);
        }
        if (!CompDepositAccountBillInfo2.getDepositType().getValue().equals("timedeposit") && !CompDepositAccountBillInfo2.getDepositType().getValue().equals("timedeposit_outer")) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON4);
        }
        if (CompDepositAccountBillInfo2.getBalance().compareTo(Constants.ZERO) <= 0) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON3);
        }
    }

    private void checkCanBeUnDeposited() throws Exception {
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = this.getSelectObject();
        if (CompDepositAccountBillInfo2.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.NOT_UNDEPOSIT_REASON1);
        }
        if (CompDepositAccountBillInfo2.getBalance().compareTo(Constants.ZERO) <= 0) {
            throw new TDException(TDException.NOT_UNDEPOSIT_REASON2);
        }
    }

    private CompDepositAccountBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("depcompany.number");
        sic.add("depcompany.id");
        sic.add("depcompany.name");
        sic.add("currency.*");
        sic.add("fundFlowItem.*");
        CompDepositAccountBillInfo info = ((ICompDepositAccountBill)this.getBizInterface()).getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        return info;
    }

    private CompDepositAccountBillCollection getSelectCollection() throws Exception {
        this.checkSelected();
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("currency.*");
        sic.add("fundFlowItem.*");
        ev.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        CompDepositAccountBillCollection colls = ((ICompDepositAccountBill)this.getBizInterface()).getCompDepositAccountBillCollection(ev);
        return colls;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.getFilterItems().add(new FilterItemInfo("id", this.changeSet(ids), CompareType.INCLUDE));
            view.setFilter(filterinfo);
            CompDepositAccountBillCollection infos = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillCollection(view);
            for (int i = 0; i < infos.size(); ++i) {
                CompDepositAccountBillInfo info = infos.get(i);
                if (info.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
                    throw new TDException(TDException.CREATE_VOUCHER_EXC2);
                }
                if (info.isFiVouchered()) {
                    throw new TDException(TDException.CREATE_VOUCHER_EXC3);
                }
                if (!info.isIsHistory()) continue;
                throw new TDException(TDException.CREATE_VOUCHER_EXC4);
            }
        } else {
            return;
        }
        super.actionVoucher_actionPerformed(e);
    }

    private Object changeSet(ArrayList ids) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.size(); ++i) {
            set.add(ids.get(i).toString());
        }
        return set;
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    private boolean hasBeenOperated(String selectedValue) throws BOSException, SQLException {
        String sql = "select fid from t_fin_compintreceivedbill where FTimeDepositBillIDID = '" + selectedValue + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        return rs.next();
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CompDepositBillFilterParam param = (CompDepositBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.ComDep).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String[] billIds = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            CompDepositAccountBillInfo compDepositAccountBillInfo = (CompDepositAccountBillInfo)CompDepositAccountBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
            billIds[i] = compDepositAccountBillInfo.getSourceBillId();
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])billIds, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CompDepositBillDataProvider data = new CompDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(COMPDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrintPreview_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CompDepositBillDataProvider data = new CompDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(COMPDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        return sic;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        return this.getSelectors();
    }

    private void initTable() {
        this.tblMain.getColumn("bgItem").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("acceptedDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("maturityDay").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public FilterInfo getFilterInfo() {
        String TargetBillType;
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            return null;
        }
        FilterInfo defaultFilter = new FilterInfo();
        defaultFilter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(3), CompareType.EQUALS));
        Object fromeObj = ((HashMap)this.getUIContext().get("BTPEDITPARAMETER")).get("FROME");
        Object TargetBillTypeObj = ((HashMap)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType");
        String frome = fromeObj == null ? null : fromeObj.toString();
        String string = TargetBillType = TargetBillTypeObj == null ? null : TargetBillTypeObj.toString();
        if (frome != null) {
            defaultFilter.getFilterItems().add(new FilterItemInfo("DepCompany.id", ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("COMPANYID"), CompareType.EQUALS));
            if (frome.equals("TIMEDEPOSIT")) {
                defaultFilter.getFilterItems().add(new FilterItemInfo("isreceived", (Object)Boolean.FALSE, CompareType.EQUALS));
            } else if (frome.equals("UnTimeDepositApplyBill")) {
                defaultFilter.getFilterItems().add(new FilterItemInfo("isreceived", (Object)Boolean.TRUE, CompareType.EQUALS));
                defaultFilter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
            }
        }
        if (TargetBillType != null && TargetBillType.equals("CompDepositAccountBill")) {
            defaultFilter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
            defaultFilter.getFilterItems().add(new FilterItemInfo("depositBank.relatedCompany.id", ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("companyID"), CompareType.EQUALS));
        }
        return defaultFilter;
    }

    @Override
    public void actionAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompDepositAccountBillCollection colls = this.getSelectCollection();
        for (int i = 0; i < colls.size(); ++i) {
            CompDepositAccountBillInfo info = colls.get(i);
            if (info.getEffectedStatus() != CompDepositBillStatusEnum.SUBMIT) {
                throw new TDException(TDException.EXCEPTION81, new String[]{info.getNumber()});
            }
            ICompDepositAccountBill iComp = (ICompDepositAccountBill)this.getBizInterface();
            FinHelper.checkInnerAcctCtrl(info.getCorpCurAcct(), info.getCurrency(), info.getAmount());
            iComp.accepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        }
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionAntiAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompDepositAccountBillCollection colls = this.getSelectCollection();
        ICompDepositAccountBill iComp = (ICompDepositAccountBill)this.getBizInterface();
        for (int i = 0; i < colls.size(); ++i) {
            CompDepositAccountBillInfo info = colls.get(i);
            if (info.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
                throw new TDException(TDException.EXCEPTION82, new String[]{info.getNumber()});
            }
            if (info.isIsChangeByReDeposited()) {
                throw new TDException(TDException.EXCEPTION83, new String[]{info.getNumber()});
            }
            if (info.isIsUnDeposit()) {
                throw new TDException(TDException.EXCEPTION84, new String[]{info.getNumber()});
            }
            if (info.isFiVouchered()) {
                throw new TDException(TDException.EXCEPTION85, new String[]{info.getNumber()});
            }
            if (info.isIsreceived()) {
                throw new TDException(TDException.EXCEPTION86, new String[]{info.getNumber()});
            }
            if (FinHelper.isExistDownBill(info.getBOSType().toString(), info.getId().toString())) {
                throw new TDException(TDException.EXCEPTION87, new String[]{info.getNumber()});
            }
            Date settleDate = FSClientHelper.getClearingHouse().getSettleDate();
            if (null != info.getAcceptedDate() && info.getAcceptedDate().before(settleDate)) {
                throw new TDException(TDException.EXCEPTION88, new String[]{info.getNumber()});
            }
            if (info.isIsHistory()) {
                throw new TDException(TDException.EXCEPTION89, new String[]{info.getNumber()});
            }
            iComp.antiAccepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        }
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionModifyCertificateNo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompDepositAccountBillEditUI.showModifyCertificateNoWindow((CoreUIObject)this, this.getSelectedKeyValue());
        this.refresh(e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "effectiveDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAccepted"};
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(CompDepositAccountBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                String currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"naturalAmt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"balance", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"expireIn", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"intFreeAmt", (String)currencyId);
                }
                if (row.getCell("intRateTypeExpression").getValue() == null) continue;
                String rateExpression = row.getCell("intRateTypeExpression").getValue().toString();
                if (rateExpression != null) {
                    if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                        row.getCell("baseRate").getStyleAttributes().setNumberFormat("###,##0.0000\\%");
                        row.getCell("Rate").getStyleAttributes().setNumberFormat("###,##0.0000\\%");
                        row.getCell("curRate").getStyleAttributes().setNumberFormat("###,##0.0000\\%");
                        row.getCell("baseRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        row.getCell("Rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        row.getCell("curRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    } else {
                        row.getCell("baseRate").getStyleAttributes().setNumberFormat("###,##0.0000\\\u2030");
                        row.getCell("Rate").getStyleAttributes().setNumberFormat("###,##0.0000\\\u2030");
                        row.getCell("curRate").getStyleAttributes().setNumberFormat("###,##0.0000\\\u2030");
                        row.getCell("baseRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        row.getCell("Rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        row.getCell("curRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                }
                row.getCell("exchangeRate").getStyleAttributes().setNumberFormat("%r-[]0.5n");
                row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

