/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.AbstractCompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.client.AbstractCompUntimeDepositBillEditUI;
import com.kingdee.eas.fm.fin.client.CompUntimeDepositBillDataProvider;
import com.kingdee.eas.fm.fin.client.IntReceivedBillEditUI;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CompUntimeDepositBillEditUI
extends AbstractCompUntimeDepositBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CompUntimeDepositBillEditUI.class);
    private CompDepositAccountBillInfo timeDepositBillInfo;
    private Map successHm;
    private CompanyOrgUnitInfo companyInfo;
    private BigDecimal depositBalance = Constants.ZERO;
    public static final String COMPUNTIMEDEPOSITBILL_FILENAME = "/FM/FIN/COMPUNTIMEDEPOSIT";
    private BankInfo clearingHouse;
    private boolean isSubmit = false;

    public CompUntimeDepositBillEditUI() throws Exception {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("handler.name"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.*"));
        return sic;
    }

    @Override
    public void loadFields() {
        EventListener[] listeners = this.pkBillDate.getEditor().getListeners(DataChangeListener.class);
        DataChangeListener dateDcl = null;
        if (listeners != null && listeners.length > 0) {
            dateDcl = (DataChangeListener)listeners[0];
            this.pkBillDate.removeDataChangeListener(dateDcl);
        }
        listeners = this.depositType.getListeners(ItemListener.class);
        ItemListener depositTypeDcl = null;
        if (listeners != null && listeners.length > 0) {
            depositTypeDcl = (ItemListener)listeners[0];
            this.depositType.removeItemListener(depositTypeDcl);
        }
        super.loadFields();
        if (this.timeDepositBillInfo != null) {
            this.pkEndDate.setValue((Object)this.timeDepositBillInfo.getMaturityDay());
            this.txtDepositAmt.setValue((Object)this.timeDepositBillInfo.getAmount());
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.txtRemAmt.setValue((Object)this.timeDepositBillInfo.getBalance().subtract(this.editData.getUnDepositAmt()));
            }
            this.txtlocalAmt.setValue((Object)this.editData.getExchangeRate().multiply(this.editData.getUnDepositAmt()));
            this.depositType.setSelectedItem((Object)this.timeDepositBillInfo.getDepositType());
        }
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
        this.txtUnTimeDepositSeqNo.setValue((Object)new Integer(this.editData.getUnTimeDepositSeqNo()));
        this.txtUnDepositAmt.setMaximumValue((Comparable)this.editData.getUnDepositAmt());
        this.txtUnDepositAmt.setValue((Object)this.editData.getUnDepositAmt());
        this.chkIsYearRate.setSelected(this.editData.isIsAppointRate());
        this.txtYearRate.setPrecision(5);
        this.txtYearRate.setHorizontalAlignment(4);
        this.txtIntDeAmt.setHorizontalAlignment(4);
        this.txtIntCurAmt.setHorizontalAlignment(4);
        this.txtintSum.setHorizontalAlignment(4);
        this.txtYearRate.setValue((Object)this.editData.getYearRate());
        this.txtDescription.setMaxLength(80);
        this.calcUnDepositAmtTotal();
        TimeDepositTypeEnum timeDepositType = this.editData.getDepositType();
        if (timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.prmtCorpCurAcct.setValue(null);
            }
            this.prmtCorpCurAcct.setRequired(false);
        } else if (timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER) {
            this.prmtCorpCurAcct.setRequired(true);
        }
        this.pkBillDate.addDataChangeListener(dateDcl);
        this.depositType.addItemListener(depositTypeDcl);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setTimeDepositBill((CompDepositAccountBillInfo)this.prmtTimeDepositBill.getValue());
        this.editData.setBank((BankInfo)this.prmtBank.getValue());
        this.editData.setDepCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        this.editData.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        this.editData.setUnTimeDepositSeqNo(this.txtUnTimeDepositSeqNo.getIntegerValue());
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setAccumulativeUnTimeDepostAmt(this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue());
        }
        this.editData.setUnDepositAmt(this.txtUnDepositAmt.getBigDecimalValue());
        this.editData.setCorpCurAcct((InnerAccountInfo)this.prmtCorpCurAcct.getValue());
        this.editData.setCorpDepAcct((InnerAccountInfo)this.prmtCorpDepAcct.getValue());
        this.editData.setHandler(FMClientHelper.getUserByF7Person((CoreUI)this, (KDBizPromptBox)this.prmtHandler));
        this.editData.setIsreceived(false);
        this.editData.setIsAppointRate(this.chkIsYearRate.isSelected());
        this.editData.setIsCalInt(this.chkIsCalInt.isSelected());
        this.editData.setYearRate(this.txtYearRate.getBigDecimalValue());
        this.editData.setCertificateNo(this.txtCertificateNo.getText());
    }

    private void initNotCalIntDays() {
        this.txtNotCalIntDays.setHorizontalAlignment(4);
        UnDepositTypeEnum unDepType = (UnDepositTypeEnum)this.comboUnDepositType.getSelectedItem();
        TimeDepositTypeEnum timeDepositType = (TimeDepositTypeEnum)this.depositType.getSelectedItem();
        if (this.chkIsCalInt.isSelected() && unDepType == UnDepositTypeEnum.CONSULT_UNDEPOSIT && (timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            this.contNotCalIntDays.setVisible(true);
        } else {
            this.contNotCalIntDays.setVisible(false);
            if (this.getOprtState() != OprtState.VIEW) {
                this.txtNotCalIntDays.setValue((Object)Constants.ZERO);
            }
        }
    }

    public void onLoad() throws Exception {
        if (!this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.companyInfo);
            this.clearingHouse = FSClientHelper.getClearingHouse();
            if (this.clearingHouse.getSettleDate() == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"123_CompDepositAccountBillEditUI"));
                SysUtil.abort();
            }
        }
        this.initController();
        super.onLoad();
        if (this.timeDepositBillInfo != null) {
            if (this.timeDepositBillInfo.getDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositBillInfo.getDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
                this.comboUnDepositType.removeAllItems();
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
                this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            } else {
                this.comboUnDepositType.removeAllItems();
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
                this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            }
        }
        this.txtYearRate.setValue((Object)this.editData.getYearRate());
        if (this.editData.getUnDepositType() != null) {
            this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtHandler.setEnabled(true);
            this.prmtCorpCurAcct.setEnabled(true);
            if (this.editData.getCurrency() != null && !this.companyInfo.getBaseCurrency().getId().toString().equals(this.editData.getCurrency().getId().toString())) {
                this.txtExchangeRate.setEnabled(true);
            }
        }
        this.txtUnDepositAmt.setValue((Object)this.editData.getUnDepositAmt());
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.editData.getAccumulativeUnTimeDepostAmt());
            this.txtRemAmt.setValue((Object)FMHelper.subtract((BigDecimal)this.txtDepositAmt.getBigDecimalValue(), (BigDecimal)this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue()));
        }
        if (this.getUIContext().get("infoid") != null) {
            this.actionCreateFrom.setEnabled(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
        }
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAccountant);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtCreator);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtHandler);
        this.initOldData((IObjectValue)this.editData);
        this.txtDescription.setMaxLength(80);
        this.txtUnTimeDepositSeqNo.setHorizontalAlignment(4);
        this.txtlocalAmt.setHorizontalAlignment(4);
        this.txtUnDepositAmt.setHorizontalAlignment(4);
        this.txtUnDepositAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtRemAmt.setHorizontalAlignment(4);
        this.txtAccumulativeUnTimeDepostAmt.setHorizontalAlignment(4);
        this.txtDepositAmt.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtYearRate.setPrecision(5);
        this.txtYearRate.setHorizontalAlignment(4);
        this.txtRemAmt.setRemoveingZeroInDispaly(false);
        this.txtUnDepositAmt.setRemoveingZeroInDispaly(false);
        this.txtlocalAmt.setRemoveingZeroInDispaly(false);
        this.txtAccumulativeUnTimeDepostAmt.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtDepositAmt.setRemoveingZeroInDispaly(false);
        this.chkIsYearRate.setSelected(this.editData.isIsAppointRate());
        this.chkIsCalInt.setSelected(this.editData.isIsCalInt());
        this.txtYearRate.setValue((Object)this.editData.getYearRate());
        this.storeFields();
        this.actionAuditResult.setVisible(false);
        this.initNotCalIntDays();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    protected void initDataStatus() {
        BOSUuid sbid;
        super.initDataStatus();
        CompUnTimeDepositBillInfo unTimeInfo = (CompUnTimeDepositBillInfo)this.getDataObject();
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionAddNew.setEnabled(false);
            this.actionAddNew.setVisible(false);
            this.actionCreateFrom.setVisible(false);
            this.actionCreateFrom.setVisible(false);
        } else {
            if (this.getBOTPViewStatus() == 1) {
                this.actionAddNew.setEnabled(false);
                this.actionAddNew.setVisible(false);
            } else {
                this.actionAddNew.setEnabled(true);
                this.actionAddNew.setVisible(false);
            }
            this.actionCreateFrom.setVisible(true);
            this.actionCreateFrom.setVisible(true);
        }
        this.txtYearRate.setEnabled(unTimeInfo.isIsAppointRate());
        AbstractCompDepositAccountBillInfo compDepositAccountBillInfo = null;
        if (unTimeInfo.getTimeDepositBill() != null) {
            try {
                compDepositAccountBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(unTimeInfo.getTimeDepositBill().getId()), this.getTimedepositSelectors());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = compDepositAccountBillInfo.getIntRateTypeExpression();
            if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
                if (this.contYearRate.getBoundLabelText().indexOf("%") == -1) {
                    if (this.contYearRate.getBoundLabelText().indexOf("\u2030") == -1) {
                        this.contYearRate.setBoundLabelText(this.contYearRate.getBoundLabelText() + "(%)");
                    } else {
                        String strValue = "";
                        strValue = this.contYearRate.getBoundLabelText();
                        strValue = strValue.replaceAll("\u2030", "%");
                        this.contYearRate.setBoundLabelText(strValue);
                    }
                }
            } else if (this.contYearRate.getBoundLabelText().indexOf("\u2030") == -1) {
                if (this.contYearRate.getBoundLabelText().indexOf("%") == -1) {
                    this.contYearRate.setBoundLabelText(this.contYearRate.getBoundLabelText() + "(\u2030)");
                } else {
                    String strValue = "";
                    strValue = this.contYearRate.getBoundLabelText();
                    strValue = strValue.replaceAll("%", "\u2030");
                    this.contYearRate.setBoundLabelText(strValue);
                }
            }
        }
        this.chkIsYearRate.setVisible(unTimeInfo.isIsCalInt());
        this.contYearRate.setVisible(unTimeInfo.isIsCalInt());
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        if (!EmptyUtil.isEmpty((String)unTimeInfo.getSourceBillId()) && (sbid = BOSUuid.read((String)unTimeInfo.getSourceBillId())).getType().equals((Object)new UnTimeDepositApplyBillInfo().getBOSType())) {
            this.comboUnDepositType.setEnabled(false);
        }
    }

    private void initController() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString()));
        this.setPre2(baseCurrPre);
        this.prmtHandler.setEnabled(false);
        this.prmtCorpDepAcct.setEnabled(false);
        this.prmtCreator.setEnabled(false);
    }

    private void setPre2(int currencyPre) {
        this.txtDepositAmt.setPrecision(currencyPre);
        this.txtlocalAmt.setPrecision(currencyPre);
        this.txtUnDepositAmt.setPrecision(currencyPre);
        this.txtRemAmt.setPrecision(currencyPre);
        this.txtAccumulativeUnTimeDepostAmt.setPrecision(currencyPre);
    }

    @Override
    protected IObjectValue createNewData() {
        CompUnTimeDepositBillInfo objectValue = new CompUnTimeDepositBillInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setIsHis(false);
        objectValue.setIsreceived(false);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)this.companyInfo.getId().toString());
        this.copyValueToNewData_undeposit(objectValue);
        return objectValue;
    }

    private void copyValueToNewData_undeposit(CompUnTimeDepositBillInfo objectValue) {
        String id = (String)this.getUIContext().get("infoid");
        CompanyOrgUnitInfo DepCompany = null;
        if (id != null) {
            try {
                this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(id), this.getTimedepositSelectors());
                this.depositBalance = this.timeDepositBillInfo.getBalance();
                DepCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getDepCompany().getId()));
            }
            catch (Exception e) {
                this.handUIException(e.getCause());
            }
            objectValue.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
            objectValue.setTimeDepositBill(this.timeDepositBillInfo);
            objectValue.setCompany(this.timeDepositBillInfo.getCompany());
            objectValue.setDepCompany(DepCompany);
            objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
            objectValue.setExchangeRate(this.timeDepositBillInfo.getExchangeRate());
            objectValue.setUnDepositAmt(this.timeDepositBillInfo.getBalance());
            objectValue.setHandler(this.timeDepositBillInfo.getHandler());
            objectValue.setCertificateNo(this.timeDepositBillInfo.getCertificateNo());
            if (this.timeDepositBillInfo.isIsReDeposited()) {
                CompDepositAccountBillInfo rootRedeposit = this.getRootRedeposit(this.timeDepositBillInfo.getSourceBillId());
                objectValue.setCorpCurAcct(rootRedeposit.getCorpCurAcct());
            } else {
                objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
            }
            objectValue.setCorpDepAcct(this.timeDepositBillInfo.getCorpDepAcct());
            objectValue.setBank(this.timeDepositBillInfo.getDepositBank());
            objectValue.setUntimeDate(this.clearingHouse.getSettleDate());
            objectValue.setBizDate(this.clearingHouse.getSettleDate());
            try {
                Map hm = CompUnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId().toString()));
                Integer maxseq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
                objectValue.setUnTimeDepositSeqNo(maxseq + 1);
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
            Date lastUnDepositDate = this.timeDepositBillInfo.getLastUnDepositDate();
            Date effectiveDate = this.timeDepositBillInfo.getEffectiveDate();
            ArrayList<Date> li = new ArrayList<Date>();
            li.add(lastUnDepositDate);
            li.add(effectiveDate);
        }
    }

    private void setCorpCurAcctReDeposited(CompUnTimeDepositBillInfo objectValue) {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.timeDepositBillInfo)) {
            if (this.timeDepositBillInfo.isIsReDeposited()) {
                CompDepositAccountBillInfo rootRedeposit = this.getRootRedeposit(this.timeDepositBillInfo.getSourceBillId());
                objectValue.setCorpCurAcct(rootRedeposit.getCorpCurAcct());
            } else {
                objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
            }
        }
    }

    private CompDepositAccountBillInfo getRootRedeposit(String srcId) {
        CompDepositAccountBillInfo info = null;
        if (!EmptyUtil.isEmpty((String)srcId)) {
            try {
                info = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(srcId), this.getTimedepositSelectors());
                if (info.isIsReDeposited() && !EmptyUtil.isEmpty((String)info.getSourceBillId())) {
                    info = this.getRootRedeposit(info.getSourceBillId());
                }
            }
            catch (Exception e) {
                this.handUIException(e.getCause());
            }
        }
        return info;
    }

    private SelectorItemCollection getTimedepositSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("balance"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("corpCurAcct.*"));
        sic.add(new SelectorItemInfo("corpDepAcct.*"));
        sic.add(new SelectorItemInfo("depositBank.*"));
        sic.add(new SelectorItemInfo("DepCompany.*"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        Date intEndDate = DateTimeUtils.truncateDate((Date)this.editData.getUntimeDate());
        Date intStartDate = DateTimeUtils.truncateDate((Date)this.timeDepositBillInfo.getLastPayDate());
        if (intEndDate.compareTo(intStartDate) <= 0 || !FMClientHelper.verifyIsPlus((String)this.editData.getYearRate().toString()) && this.editData.getUnDepositType().equals((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT) || !FMClientHelper.verifyIsPlus((String)this.editData.getYearRate().toString()) && this.editData.getUnDepositType().equals((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT)) {
            super.actionSubmit_actionPerformed(e);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"138_CompUntimeDepositBillEditUI"));
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.getUIWindow() instanceof Dialog) {
                this.uiWindow.close();
            } else {
                this.txtNumber.setText("");
                this.prmtBank.setValue(null);
                this.prmtTimeDepositBill.setValue(null);
                this.txtUnTimeDepositSeqNo.setValue((Object)Constants.ZERO);
                this.prmtCompany.setValue(null);
                this.prmtHandler.setValue(null);
                this.prmtCorpDepAcct.setValue(null);
                this.prmtCorpCurAcct.setValue(null);
                this.pkEndDate.setValue(null);
                this.txtDepositAmt.setValue(null);
                this.txtAccumulativeUnTimeDepostAmt.setValue(null);
                this.txtRemAmt.setValue(null);
                this.txtExchangeRate.setValue(null);
                this.txtUnDepositAmt.setValue(null);
                this.txtlocalAmt.setValue(null);
                this.txtDescription.setText("");
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
        } else {
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            CompUnTimeDepositBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            CompUnTimeDepositBillInfo rInfo = this.editData;
            if (rInfo.getId() == null) {
                this.editData.setId(BOSUuid.create((BOSObjectType)rInfo.getBOSType()));
            }
            if (!this.isSubmit) {
                try {
                    if (this.editData.isIsCalInt()) {
                        this.isSubmit = true;
                        this.successHm = IntReceivedBillEditUI.showIntReceiveEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData, "1", (String)this.getUIContext().get("infoid"));
                    } else {
                        super.actionSubmit_actionPerformed(e);
                        this.successHm = new HashMap();
                        this.successHm.put("successFlag", Boolean.TRUE);
                    }
                }
                finally {
                    this.isSubmit = false;
                }
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.getUIWindow() instanceof Dialog) {
                Boolean succ;
                if (this.successHm != null && (succ = (Boolean)this.successHm.get("successFlag")) != null && succ.booleanValue()) {
                    this.uiWindow.close();
                }
            } else {
                this.txtNumber.setText("");
                this.prmtBank.setValue(null);
                this.prmtTimeDepositBill.setValue(null);
                this.txtUnTimeDepositSeqNo.setValue((Object)Constants.ZERO);
                this.prmtCompany.setValue(null);
                this.prmtHandler.setValue(null);
                this.prmtCorpDepAcct.setValue(null);
                this.prmtCorpCurAcct.setValue(null);
                this.pkEndDate.setValue(null);
                this.txtDepositAmt.setValue(null);
                this.txtAccumulativeUnTimeDepostAmt.setValue(null);
                this.txtRemAmt.setValue(null);
                this.txtExchangeRate.setValue(null);
                this.txtUnDepositAmt.setValue(null);
                this.txtlocalAmt.setValue(null);
                this.txtDescription.setText("");
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CompUnTimeDepositBillFactory.getRemoteInstance();
    }

    @Override
    protected void prmtTimeDepositBill_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTimeDepositBill_dataChanged(e);
        if (!EmptyUtil.isEmpty((Object)this.prmtTimeDepositBill.getValue())) {
            CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)this.prmtTimeDepositBill.getValue();
            this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), this.getTimedepositSelectors());
            this.setValueAccordToSelectedBill(this.timeDepositBillInfo);
            this.setUnDepostType(this.timeDepositBillInfo);
        }
    }

    private void setValueAccordToSelectedBill(CompDepositAccountBillInfo timeDepositBillInfo) throws EASBizException, BOSException {
        if (null == timeDepositBillInfo) {
            return;
        }
        this.prmtBank.setValue((Object)BankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getDepositBank().getId().toString())));
        this.prmtCompany.setValue((Object)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getDepCompany().getId().toString())));
        this.prmtCorpDepAcct.setValue((Object)InnerAccountFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCorpDepAcct().getId().toString())));
        if (timeDepositBillInfo.getCorpCurAcct() != null && this.getOprtState().equals(OprtState.ADDNEW) && !timeDepositBillInfo.isIsReDeposited()) {
            this.prmtCorpCurAcct.setValue((Object)InnerAccountFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCorpCurAcct().getId().toString())));
        }
        this.cboCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCurrency().getId().toString())));
        this.pkEndDate.setValue((Object)timeDepositBillInfo.getMaturityDay());
        this.txtDepositAmt.setValue((Object)timeDepositBillInfo.getAmount());
        this.txtUnDepositAmt.setMaximumValue((Comparable)timeDepositBillInfo.getAmount());
    }

    private void setUnDepostType(CompDepositAccountBillInfo timeDepositBillInfo) {
        if (null == timeDepositBillInfo) {
            return;
        }
        if (timeDepositBillInfo.getDepositType().getValue().equals("timedeposit") || timeDepositBillInfo.getDepositType().getValue().equals("timedeposit_outer")) {
            this.comboUnDepositType.removeAllItems();
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
        } else if (timeDepositBillInfo.getDepositType().getValue().equals("calldeposit") || timeDepositBillInfo.getDepositType().getValue().equals("calldeposit_outer")) {
            this.comboUnDepositType.removeAllItems();
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
        }
    }

    public static void showUnDeopsitWindow(CoreUIObject ui, String selectedValue) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"infoid", (Object)selectedValue);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CompUntimeDepositBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            if (uiWindow instanceof UIDialog) {
                FMClientHelper.settleUIDialogDimension((UIDialog)((UIDialog)uiWindow), (IUIObject)uiWindow.getUIObject());
            }
            uiWindow.show();
            Map successHm = ((CompUntimeDepositBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public Map getSuccessHm() {
        return this.successHm;
    }

    @Override
    protected void pkBillDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcRate((Date)this.pkBillDate.getValue());
    }

    private void calcRate(Date date) throws Exception {
        if (date != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
            if (currencyInfo == null) {
                return;
            }
            int prec = RecPayHandler.getExRatePrec((String)currencyInfo.getId().toString(), null, null, (Date)date);
            this.txtExchangeRate.setPrecision(prec);
            this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, null, (Date)date));
        }
    }

    @Override
    protected void chkIsCalInt_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsCalInt_itemStateChanged(e);
        this.chkIsYearRate.setVisible(this.chkIsCalInt.isSelected());
        this.chkIsYearRate.setSelected(this.chkIsCalInt.isSelected());
        this.initNotCalIntDays();
    }

    @Override
    protected void chkIsYearRate_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsYearRate_itemStateChanged(e);
        this.contYearRate.setEnabled(this.chkIsYearRate.isSelected());
        this.contYearRate.setVisible(this.contYearRate.isEnabled());
        if (this.contYearRate.isVisible() && this.editData.getTimeDepositBill() != null) {
            this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurRate());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.verifyInputValid();
        this.checkUndepositDate();
        this.checkUnDepositAmt();
    }

    private void verifyInputValid() throws TDException {
        if (this.prmtTimeDepositBill.getValue() == null) {
            throw new TDException(TDException.UNDEPOSIT_ERROR1);
        }
        if (this.txtNumber.isEnabled()) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        if (this.prmtCorpCurAcct.isRequired()) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCorpCurAcct);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBillDate);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtUnDepositAmt);
        if (!FMClientHelper.verifyIsPlus((String)this.txtUnDepositAmt.getBigDecimalValue().toString())) {
            this.txtUnDepositAmt.requestFocus(true);
            throw new TDException(TDException.UNDEPOSIT_NEGATIVE_EXC);
        }
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtNotCalIntDays, (BigDecimal)Constants.ZERO);
    }

    private void checkUndepositDate() throws TDException {
        Date lastUnDepositDate = this.timeDepositBillInfo.getLastUnDepositDate();
        Date effectiveDate = this.timeDepositBillInfo.getEffectiveDate();
        Date maturityDate = this.timeDepositBillInfo.getMaturityDay();
        Date unDepoistDate = (Date)this.pkBillDate.getValue();
        UnDepositTypeEnum unDepositTypeEnum = (UnDepositTypeEnum)this.comboUnDepositType.getSelectedItem();
        if (unDepoistDate.compareTo(this.getMinDate(lastUnDepositDate, effectiveDate)) < 0) {
            throw new TDException(TDException.UNDEPOSITDATE_EXC1);
        }
        if (unDepositTypeEnum.getValue().equals("matureUnDeposit")) {
            if (unDepoistDate.compareTo(maturityDate) < 0) {
                this.pkBillDate.requestFocus();
                throw new TDException(TDException.UNDEPOSITDATE_EXC2);
            }
        } else if (unDepositTypeEnum.getValue().equals("aheadUnDeposit") && unDepoistDate.compareTo(maturityDate) >= 0) {
            this.pkBillDate.requestFocus();
            throw new TDException(TDException.UNDEPOSITDATE_EXC3);
        }
    }

    private Date getMinDate(final Date lastUnDepositDate, final Date effectiveDate) {
        ArrayList li = new ArrayList(){
            {
                this.add(lastUnDepositDate);
                this.add(effectiveDate);
            }
        };
        return TimeDepositHelper.getInstance().getMaxDate(li);
    }

    private void checkUnDepositAmt() throws EASBizException, BOSException, TDException {
        CompDepositAccountBillInfo DepositBillInfo = (CompDepositAccountBillInfo)this.prmtTimeDepositBill.getValue();
        DepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(DepositBillInfo.getId().toString()));
        BigDecimal unDepositAmt = this.txtUnDepositAmt.getBigDecimalValue();
        if (unDepositAmt.compareTo(DepositBillInfo.getBalance()) != 0 && unDepositAmt.compareTo(DepositBillInfo.getBalance().subtract(DepositBillInfo.getIntFreeAmt())) > 0 && unDepositAmt.compareTo(Constants.ZERO) > 0) {
            throw new TDException(TDException.UNDEPOSITAMT_EXC1);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            CompDepositAccountBillInfo info = ((CompUnTimeDepositBillInfo)dataObject).getTimeDepositBill();
            try {
                if (info != null) {
                    this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), this.getTimedepositSelectors());
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            CompUnTimeDepositBillInfo unTimeDepositBillInfo = (CompUnTimeDepositBillInfo)dataObject;
            String sourceID = unTimeDepositBillInfo.getSourceBillId();
            if (this.timeDepositBillInfo == null && FMHelper.isInstanceof((String)sourceID, CompDepositAccountBillInfo.class)) {
                try {
                    this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getTimedepositSelectors());
                    this.depositBalance = this.timeDepositBillInfo.getBalance();
                }
                catch (Exception e) {
                    this.handUIException(e.getCause());
                }
            }
            if (FMHelper.isInstanceof((String)sourceID, UnTimeDepositApplyBillInfo.class)) {
                try {
                    if (UnTimeDepositApplyBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(sourceID))) {
                        sourceID = UnTimeDepositApplyBillFactory.getRemoteInstance().getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceID)).getSourceBillId();
                    }
                    if (!EmptyUtil.isEmpty((String)sourceID) && CompDepositAccountBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(sourceID))) {
                        this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getTimedepositSelectors());
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.timeDepositBillInfo != null) {
                if (FMHelper.isInstanceof((String)unTimeDepositBillInfo.getSourceBillId(), UnTimeDepositApplyBillInfo.class)) {
                    unTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
                    unTimeDepositBillInfo.setDepCompany(this.timeDepositBillInfo.getDepCompany());
                    unTimeDepositBillInfo.setBank(this.timeDepositBillInfo.getDepositBank());
                    unTimeDepositBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                } else {
                    unTimeDepositBillInfo.setUnDepositAmt(this.timeDepositBillInfo.getBalance());
                    unTimeDepositBillInfo.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
                }
                unTimeDepositBillInfo.setExchangeRate(this.timeDepositBillInfo.getExchangeRate());
                this.depositBalance = this.timeDepositBillInfo.getBalance();
                unTimeDepositBillInfo.setHandler(this.timeDepositBillInfo.getHandler());
                unTimeDepositBillInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                try {
                    Map hm = CompUnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId().toString()));
                    Integer maxseq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
                    unTimeDepositBillInfo.setUnTimeDepositSeqNo(maxseq + 1);
                }
                catch (BOSException e) {
                    MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                    SysUtil.abort((Throwable)e);
                }
                unTimeDepositBillInfo.setCompany(this.timeDepositBillInfo.getCompany());
                unTimeDepositBillInfo.setIsAppointRate(true);
                unTimeDepositBillInfo.setIsCalInt(true);
                unTimeDepositBillInfo.setIntDeAmt(Constants.ZERO);
                unTimeDepositBillInfo.setIntCurAmt(Constants.ZERO);
                unTimeDepositBillInfo.setIntSum(Constants.ZERO);
                unTimeDepositBillInfo.setYearRate(this.timeDepositBillInfo.getCurRate());
                FMClientHelper.initNumber((CoreBaseInfo)unTimeDepositBillInfo, (KDTextField)this.txtNumber, (String)this.companyInfo.getId().toString());
                this.setCorpCurAcctReDeposited(unTimeDepositBillInfo);
            }
        }
    }

    private void calcUnDepositAmtTotal() {
        if (null != this.txtUnTimeDepositSeqNo.getIntegerValue() && this.txtUnTimeDepositSeqNo.getIntegerValue() == 1) {
            if (this.txtDepositAmt.getBigDecimalValue() == null || this.txtUnDepositAmt.getBigDecimalValue() == null) {
                return;
            }
            BigDecimal accumulaAmt = this.timeDepositBillInfo.getAmount().subtract(this.depositBalance).add(this.txtUnDepositAmt.getBigDecimalValue());
            if (!this.getOprtState().equals(OprtState.VIEW)) {
                this.txtAccumulativeUnTimeDepostAmt.setValue((Object)accumulaAmt);
            }
            this.txtRemAmt.setValue((Object)this.txtDepositAmt.getBigDecimalValue().subtract(this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue()));
        } else {
            if (this.txtDepositAmt.getBigDecimalValue() == null) {
                return;
            }
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.txtDepositAmt.getBigDecimalValue().subtract(this.depositBalance).add(this.txtUnDepositAmt.getBigDecimalValue()));
            } else {
                this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.editData.getAccumulativeUnTimeDepostAmt());
            }
            this.txtRemAmt.setValue((Object)this.txtDepositAmt.getBigDecimalValue().subtract(this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue()));
        }
    }

    @Override
    protected void txtUnDepositAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (null == this.timeDepositBillInfo) {
            return;
        }
        this.calcUnDepositAmtTotal();
        this.setLocalAmt();
    }

    private void setLocalAmt() {
        if (null != this.txtExchangeRate.getBigDecimalValue() && null != this.txtUnDepositAmt.getBigDecimalValue()) {
            this.txtlocalAmt.setValue((Object)this.txtExchangeRate.getBigDecimalValue().multiply(this.txtUnDepositAmt.getBigDecimalValue()));
        }
    }

    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.setLocalAmt();
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TargetBillType", "CompDepositAccountBill");
        ctx.put("companyID", ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        this.getBillEdit().createFrom(null, ctx);
    }

    @Override
    protected void depositType_itemStateChanged(ItemEvent e) throws Exception {
        super.depositType_itemStateChanged(e);
        TimeDepositTypeEnum timeDepositType = (TimeDepositTypeEnum)this.depositType.getSelectedItem();
        if (timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            this.prmtCorpCurAcct.setValue(null);
            this.prmtCorpCurAcct.setRequired(false);
        } else if (timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER) {
            this.prmtCorpCurAcct.setRequired(true);
        }
        this.initNotCalIntDays();
    }

    @Override
    protected void comboUnDepositType_actionPerformed(ActionEvent e) throws Exception {
        UnDepositTypeEnum unDepositType = (UnDepositTypeEnum)this.comboUnDepositType.getSelectedItem();
        if (unDepositType == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
            this.txtUnDepositAmt.setEnabled(false);
            if (this.txtRemAmt.getBigDecimalValue() != null && this.txtUnDepositAmt.getBigDecimalValue() != null) {
                this.txtUnDepositAmt.setValue((Object)this.txtRemAmt.getBigDecimalValue().add(this.txtUnDepositAmt.getBigDecimalValue()));
                this.calcUnDepositAmtTotal();
            }
        } else {
            this.txtUnDepositAmt.setEnabled(true);
        }
        if (unDepositType == UnDepositTypeEnum.CONSULT_UNDEPOSIT) {
            this.chkIsCalInt.setSelected(true);
            this.chkIsYearRate.setSelected(true);
            if (this.editData.getTimeDepositBill() != null) {
                IntRateTypeInfo intType = this.editData.getTimeDepositBill().getIntRateTable();
                CurrencyInfo currency = this.editData.getTimeDepositBill().getCurrency();
                if (intType == null || null == currency) {
                    return;
                }
                this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurRate());
            }
            if (this.txtRemAmt.getBigDecimalValue() != null && this.txtUnDepositAmt.getBigDecimalValue() != null) {
                this.txtUnDepositAmt.setValue((Object)this.txtRemAmt.getBigDecimalValue().add(this.txtUnDepositAmt.getBigDecimalValue()));
                this.calcUnDepositAmtTotal();
            }
        } else if (unDepositType == UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT) {
            this.chkIsCalInt.setSelected(true);
            this.chkIsYearRate.setSelected(true);
            if (this.editData.getTimeDepositBill() != null) {
                this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurRate());
            }
        } else if (this.editData.getTimeDepositBill() != null && this.editData.getYearRate() == null) {
            this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurRate());
        }
        this.initNotCalIntDays();
    }

    @Override
    protected void comboUnDepositType_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (this.companyInfo.getBaseCurrency() != null && currencyInfo != null) {
            if (this.companyInfo.getBaseCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                this.txtExchangeRate.setEnabled(false);
                this.txtExchangeRate.setEditable(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
                this.txtExchangeRate.setEditable(true);
            }
        }
    }

    @Override
    protected void cboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cboCurrency_itemStateChanged(e);
    }

    @Override
    protected void prmtCorpCurAcct_willShow(SelectorEvent e) throws Exception {
        if (this.prmtCorpDepAcct.getData() != null) {
            InnerAccountInfo Acc = (InnerAccountInfo)this.prmtCorpDepAcct.getData();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)Acc.getApplyUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)this.clearingHouse.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("TYPE.Property", (Object)Integer.toString(1)));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtCorpCurAcct.setEntityViewInfo(evi);
            this.prmtCorpCurAcct.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CompUntimeDepositBillDataProvider data = new CompUntimeDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(COMPUNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CompUntimeDepositBillDataProvider data = new CompUntimeDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(COMPUNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "untimeDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

