/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.client.AbstractCreditApplyBillFilterUI;
import com.kingdee.eas.fm.fin.client.CreditApplyBillFilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditApplyBillFilterUI
extends AbstractCreditApplyBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditApplyBillFilterUI.class);
    private CompanyOrgUnitInfo companyif = SysContext.getSysContext().getCurrentFIUnit();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        this.cboRelations.setSelectedIndex(0);
        this.billState.setSelectedIndex(0);
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        FinClientHelper.cboRelationsItemStateChanged((CoreUIObject)this, this.cboRelations, this.contBank, this.jbpOrganization, this.contCompany, this.prmtCompany);
    }

    public boolean verify() {
        Date beginDate = (Date)this.dpBeginDate.getValue();
        Date endDate = (Date)this.dpEndDate.getValue();
        if (this.dpBeginDate.getValue() != null && this.dpEndDate.getValue() != null && beginDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"143_CreditApplyBillFilterUI"));
            this.dpBeginDate.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompany.setEnabledMultiSelection(true);
        this.jbpOrganization.setEnabledMultiSelection(true);
        FinClientHelper.initPrmtCompany((CoreUIObject)this, this.prmtCompany);
    }

    public Object getParam() {
        CreditApplyBillFilterParam param = new CreditApplyBillFilterParam();
        if (this.dpBeginDate.getValue() != null) {
            param.setDateBegin(DateTimeUtils.truncateDate((Date)this.dpBeginDate.getSqlDate()));
        }
        if (this.dpEndDate.getValue() != null) {
            param.setDateEnd(DateTimeUtils.truncateDate((Date)this.dpEndDate.getSqlDate()));
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        param.setCompanyIDs(this.getIdSetFromF7(this.prmtCompany));
        param.setBankIDs(this.getIdSetFromF7(this.jbpOrganization));
        Object selectedValue = this.cboRelations.getSelectedItem();
        if (selectedValue instanceof LimitIsBankCreditEnum) {
            param.setRelations((LimitIsBankCreditEnum)((Object)selectedValue));
        } else {
            param.setRelations(null);
        }
        if (this.billState.getSelectedIndex() > 0) {
            BillStateEnum state = (BillStateEnum)this.billState.getSelectedItem();
            param.setState(state);
        } else {
            param.setState(null);
        }
        return param;
    }

    public void setParam(Object param) {
        CreditApplyBillFilterParam clParam = (CreditApplyBillFilterParam)((Object)param);
        this.setCompanyIdSet(clParam.getCompanyIdSet());
        this.dpBeginDate.setValue((Object)clParam.getDateBegin());
        this.dpEndDate.setValue((Object)clParam.getDateEnd());
        try {
            Set creditCompanySet = clParam.getCompanyIDs();
            CoreBaseInfo[] ccc = RptFmClientUtil.getBaseInfoFromIdSet((Set)creditCompanySet);
            this.prmtCompany.setData((Object)ccc);
            LimitIsBankCreditEnum relations = clParam.getRelations();
            if (relations == null) {
                this.cboRelations.setSelectedIndex(0);
            } else {
                this.cboRelations.setSelectedItem((Object)relations);
            }
            Set bankIds = clParam.getBankIDs();
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)bankIds);
            this.jbpOrganization.setData((Object)c);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (clParam.getState() == null) {
            this.billState.setSelectedIndex(0);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.billState, (Object)clParam.getState());
        }
    }

    protected void init() throws Exception {
        super.init();
        this.cboRelations.insertItemAt((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"144_CreditApplyBillFilterUI"), 0);
        this.cboRelations.setSelectedIndex(0);
        this.billState.insertItemAt((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"144_CreditApplyBillFilterUI"), 0);
        this.billState.setSelectedIndex(0);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.billState.setSelectedIndex(0);
        this.prmtCompany.setValue(null);
        this.jbpOrganization.setValue(null);
        Date date = new Date();
        try {
            date = DateUtil.getTimeStampDayBegin();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.dpEndDate.setValue((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        this.dpBeginDate.setValue((Object)calendar.getTime());
    }

    protected Class getParamClass() {
        return CreditApplyBillFilterParam.class;
    }
}

