/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.fin.ApplyResultEnum;
import com.kingdee.eas.fm.fin.CreditApplyBillCollection;
import com.kingdee.eas.fm.fin.CreditApplyBillFactory;
import com.kingdee.eas.fm.fin.CreditApplyBillInfo;
import com.kingdee.eas.fm.fin.client.AbstractCreditApplyBillListUI;
import com.kingdee.eas.fm.fin.client.ChangeApplyResultUI;
import com.kingdee.eas.fm.fin.client.CreditApplyBillFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditApplyBillListUI
extends AbstractCreditApplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditApplyBillListUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.fin.CreditApplyBillResource";
    FillListener fillListener = new FillListener();
    private CommonQueryDialog queryDlg = null;
    private CreditApplyBillFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.tblMain.getColumn("issueDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("expiredDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(this.timeFormat);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(this.timeFormat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionApplyResult.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_collateresult"));
    }

    @Override
    public void actionApplyResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        HashSet<String> ids = new HashSet<String>();
        Boolean isCreateToLimit = null;
        BizEnumValueDTO billState = null;
        BizEnumValueDTO applyResult = null;
        HashSet<Integer> results = new HashSet<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            isCreateToLimit = (Boolean)row.getCell("isCreateToLimit").getValue();
            billState = (BizEnumValueDTO)row.getCell("billState").getValue();
            applyResult = (BizEnumValueDTO)row.getCell("applyResult").getValue();
            if (isCreateToLimit.booleanValue() || 3 != billState.getInt()) continue;
            ids.add(row.getCell("id").getValue().toString());
            results.add(new Integer(applyResult.getInt()));
        }
        if (results.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"selectSame"));
            SysUtil.abort();
        } else if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"noRecord"));
            SysUtil.abort();
        } else {
            Map uiContext = this.getUIContext();
            uiContext.put("oldValue", ApplyResultEnum.getEnum(applyResult.getInt()));
            if (selectRows.length == ids.size()) {
                ApplyResultEnum en = ChangeApplyResultUI.showChangeApplyResultUI((CoreUI)this, uiContext);
                if (en != null) {
                    CreditApplyBillFactory.getRemoteInstance().applyResult(ids, en);
                    this.refreshList();
                }
            } else {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"isContinue"));
                if (result == 0) {
                    uiContext.put("oldValue", ApplyResultEnum.getEnum((Integer)results.toArray()[0]));
                    ApplyResultEnum en = ChangeApplyResultUI.showChangeApplyResultUI((CoreUI)this, uiContext);
                    if (en != null) {
                        CreditApplyBillFactory.getRemoteInstance().applyResult(ids, en);
                        this.refreshList();
                    }
                }
            }
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"quotaAmount"};
    }

    protected String getCurrencyIdColName() {
        return "currencyId";
    }

    public CreditApplyBillListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        if (this.filterUI != null) {
            this.filterUI.setListUI((IUIObject)this);
        }
        try {
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(300);
            this.queryDlg.setWidth(500);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)resourcePath, (String)"filterUITitle"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return this.queryDlg;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CreditApplyBillFilterUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        CreditApplyBillInfo info = this.getSelectBillInfo();
        if (info == null) {
            return;
        }
        if (BillStateEnum.AUDITED.equals((Object)info.getBillState())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        String id = super.getSelectedKeyValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("id", (Object)id);
        filter.mergeFilter(this.getFilterForCreateCreditLimit(), "AND");
        view.setFilter(filter);
        CreditApplyBillCollection col = CreditApplyBillFactory.getRemoteInstance().getCreditApplyBillCollection(view);
        if (col.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"creditApplyBillListUI_error01"));
            SysUtil.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"140_CreditApplyBillEditUI"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditApplyBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        CreditApplyBillInfo objectValue = new CreditApplyBillInfo();
        return objectValue;
    }

    private CreditApplyBillInfo getSelectBillInfo() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("isCreateToLimit"));
        CreditApplyBillInfo info = CreditApplyBillFactory.getRemoteInstance().getCreditApplyBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        HashSet<String> idSet = new HashSet<String>();
        BizEnumValueDTO billState = null;
        String isCreateToLimit = "false";
        HashSet<Integer> results = new HashSet<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            billState = (BizEnumValueDTO)row.getCell("billState").getValue();
            String string = isCreateToLimit = row.getCell("isCreateToLimit").getValue() == null ? "false" : row.getCell("isCreateToLimit").getValue().toString();
            if (3 != billState.getInt() || !"false".equals(isCreateToLimit)) continue;
            idSet.add(row.getCell("id").getValue().toString());
            results.add(new Integer(billState.getInt()));
        }
        if (results.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"145_CreditApplyBillListUI"));
            SysUtil.abort();
        } else if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"146_CreditApplyBillListUI"));
            SysUtil.abort();
        } else {
            String[] idArray = idSet.toArray(new String[idSet.size()]);
            if (selectRows.length == idSet.size()) {
                for (int i = 0; i < idArray.length; ++i) {
                    CreditApplyBillFactory.getRemoteInstance().antiAudit(idArray[i]);
                }
                this.refreshList();
            } else {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"147_CreditApplyBillListUI"));
                if (result == 0) {
                    for (int i = 0; i < idArray.length; ++i) {
                        CreditApplyBillFactory.getRemoteInstance().antiAudit(idArray[i]);
                    }
                    this.refreshList();
                }
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        HashSet<String> idSet = new HashSet<String>();
        BizEnumValueDTO billState = null;
        HashSet<Integer> results = new HashSet<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            billState = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (2 != billState.getInt()) continue;
            idSet.add(row.getCell("id").getValue().toString());
            results.add(new Integer(billState.getInt()));
        }
        if (results.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"145_CreditApplyBillListUI"));
            SysUtil.abort();
        } else if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"148_CreditApplyBillListUI"));
            SysUtil.abort();
        } else {
            String[] idArray = idSet.toArray(new String[idSet.size()]);
            if (selectRows.length == idSet.size()) {
                for (int i = 0; i < idArray.length; ++i) {
                    CreditApplyBillFactory.getRemoteInstance().audit(idArray[i]);
                }
                this.refreshList();
            } else {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"147_CreditApplyBillListUI"));
                if (result == 0) {
                    for (int i = 0; i < idArray.length; ++i) {
                        CreditApplyBillFactory.getRemoteInstance().audit(idArray[i]);
                    }
                    this.refreshList();
                }
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public FilterInfo getFilterInfo() {
        if (this.isBotpFromCreditLimit()) {
            return this.getFilterForCreateCreditLimit();
        }
        return null;
    }

    private boolean isBotp() {
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        int status = (Integer)this.getUIContext().get("BOTPViewStatus");
        return status == 1;
    }

    private boolean isBotpFromCreditLimit() {
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx == null) {
            return false;
        }
        String createFrom = (String)botpCtx.get("isFromCreditApply");
        return "fromCreditApply".equals(createFrom);
    }

    private FilterInfo getFilterForCreateCreditLimit() {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("isCreateToLimit", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("applyResult", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("applyResult", (Object)new Integer(3)));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        return filter;
    }

    protected void execQuery() {
        if (this.isBotp() && this.isBotpFromCreditLimit()) {
            FilterInfo filter = this.getFilterForCreateCreditLimit();
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            IRow iRow = null;
            for (int i = firstRow; i <= lastRow; ++i) {
                iRow = CreditApplyBillListUI.this.tblMain.getRow(i);
                if (iRow.getCell("creditInst.name").getValue() != null) continue;
                iRow.getCell("creditInst.name").setValue(iRow.getCell("creditCompany.name").getValue());
            }
        }
    }
}

