/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractCreditLimitUsedFilterUI;
import com.kingdee.eas.fm.fin.client.CreditLimitUsedFilterParam;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class CreditLimitUsedFilterUI
extends AbstractCreditLimitUsedFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditLimitUsedFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public boolean verify() {
        Date beginDate = (Date)this.pkDateFrom.getValue();
        Date endDate = (Date)this.pkDateTo.getValue();
        Date endDayfrom = (Date)this.kDendDayfrom.getValue();
        Date endDayto = (Date)this.kdEndDayto.getValue();
        if (beginDate != null && endDate != null && beginDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"165_CreditLimitUsedFilterUI"));
            this.pkDateFrom.requestFocus();
            SysUtil.abort();
        }
        if (endDayfrom != null && endDayto != null && endDayfrom.after(endDayto)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"165_CreditLimitUsedFilterUI"));
            this.kDendDayfrom.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    public Object getParam() {
        CreditLimitUsedFilterParam filterParam = new CreditLimitUsedFilterParam();
        if (this.pkDateFrom.getValue() != null) {
            filterParam.setBeginDate(DateTimeUtils.truncateDate((Date)this.pkDateFrom.getSqlDate()));
        }
        if (this.pkDateTo.getValue() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((Date)this.pkDateTo.getSqlDate()));
        }
        if (this.kDendDayfrom.getValue() != null) {
            filterParam.setEndDayfrom(DateTimeUtils.truncateDate((Date)this.kDendDayfrom.getSqlDate()));
        }
        if (this.kdEndDayto.getValue() != null) {
            filterParam.setEndDayto(DateTimeUtils.truncateDate((Date)this.kdEndDayto.getSqlDate()));
        }
        int typeIndex = this.billType.getSelectedIndex();
        String billBOSType = null;
        if (typeIndex > 0) {
            if (typeIndex == 1) {
                billBOSType = new LoanInfo().getBOSType().toString().trim();
            } else if (typeIndex == 2) {
                billBOSType = new PayableBillInfo().getBOSType().toString().trim();
            } else if (typeIndex == 3) {
                billBOSType = new LetterOfCreditInfo().getBOSType().toString().trim();
            } else if (typeIndex == 4) {
                billBOSType = new LetterOfGuaranteeInfo().getBOSType().toString().trim();
            }
            filterParam.setBillBOSType(billBOSType);
        } else {
            filterParam.setBillBOSType(null);
        }
        return filterParam;
    }

    public void setParam(Object param) {
        CreditLimitUsedFilterParam filterParam = (CreditLimitUsedFilterParam)((Object)param);
        this.pkDateFrom.setValue((Object)filterParam.getBeginDate());
        this.pkDateTo.setValue((Object)filterParam.getEndDate());
        this.kDendDayfrom.setValue((Object)filterParam.getEndDayfrom());
        this.kdEndDayto.setValue((Object)filterParam.getEndDayto());
        if (filterParam.getBillBOSType() == null) {
            this.billType.setSelectedIndex(0);
        } else {
            String billBOSType = filterParam.getBillBOSType();
            if (billBOSType.equals(new LoanInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(1);
            } else if (billBOSType.equals(new PayableBillInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(2);
            } else if (billBOSType.equals(new LetterOfCreditInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(3);
            } else if (billBOSType.equals(new LetterOfGuaranteeInfo().getBOSType())) {
                this.billType.setSelectedIndex(4);
            }
        }
    }

    protected void init() throws Exception {
        this.btnCompanySelect.setVisible(false);
        this.billType.insertItemAt((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"144_CreditApplyBillFilterUI"), 0);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"Loan"), 1);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"CommercialDraft"), 2);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"LetterOfCredit"), 3);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"LetterOfGuarantee"), 4);
        super.init();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.billType.setSelectedIndex(0);
        Date date = new Date();
        try {
            date = SysUtil.getAppServerTime(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.pkDateFrom.setValue((Object)DateUtil.getFirstYearDate((Date)date));
        this.pkDateTo.setValue(null);
        this.kDendDayfrom.setValue(null);
        this.kdEndDayto.setValue((Object)date);
    }

    protected Class getParamClass() {
        return CreditLimitUsedFilterParam.class;
    }
}

