/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.ICreditUsage;
import com.kingdee.eas.fm.fin.client.AbstractCreditUsageListUI;
import com.kingdee.eas.fm.fin.client.CreditUsageEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class CreditUsageListUI
extends AbstractCreditUsageListUI {
    public static final String CU_BILLPOOL_ID = "c6oAAABGRJe2AIO2";
    private CommonQueryDialog dialog = null;

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected String getEditUIName() {
        return CreditUsageEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditUsageFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        return this.dialog;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ICreditUsage iCreditUsage = (ICreditUsage)this.getBizInterface();
        iCreditUsage.disable(this.getSelectedKeyValue());
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"CreditUsageCancelSuccessed"));
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ICreditUsage iCreditUsage = (ICreditUsage)this.getBizInterface();
        iCreditUsage.enable(this.getSelectedKeyValue());
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"CreditUsageUsedSuccessed"));
        this.refresh(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.selectIsEnabled();
    }

    private void selectIsEnabled() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        Object usedObj = this.tblMain.getRow(selectRow).getCell("isUsed").getValue();
        Boolean isUsed = (Boolean)usedObj;
        if (isUsed.booleanValue()) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CreditUsageInfo info = this.getCreditUsageInfo();
        if (info != null) {
            if (!info.isIsUsed()) {
                super.actionEdit_actionPerformed(e);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"CancelCreditUsageCanModify"));
                SysUtil.abort();
            }
        }
    }

    private CreditUsageInfo getCreditUsageInfo() throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        CreditUsageInfo info = (CreditUsageInfo)this.getBizInterface().getValue((IObjectPK)pk);
        return info;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkBillPool();
        super.actionRemove_actionPerformed(e);
    }

    private void checkBillPool() {
        String creditUsageId = this.getSelectedKeyValue();
        if (CU_BILLPOOL_ID.equals(creditUsageId)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"creditUsage_billPoolError");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }
}

