/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.fm.fin.FeeCollection;
import com.kingdee.eas.fm.fin.FeeManageFactory;
import com.kingdee.eas.fm.fin.FeeManageInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.client.AbstractFeeManageFMUI;
import com.kingdee.eas.fm.fin.client.FeeHandler;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JTextField;

public class FeeManageFMUI
extends AbstractFeeManageFMUI {
    private BankJournalHandler bankJournalHandler = new BankJournalHandler();
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    public static final int CURRENCY = 2;
    public static final int ISCREATORBEARCOLPOSITION = 3;
    public static final int CDITEMCOLPOSITION = 5;
    public static final int INNERACCOUNTCOLPOSITION = 6;
    public static final int BEARDEPTCOLPOSITION = 4;
    public static final int MONEYAMOUNTCOLPOSITION = 7;
    private static final String FIN_MONEYAMOUNT = "moneyAmount";
    public static final int EXCHANGERATECOLPOSITION = 8;
    public static final int SXFZBWBCOLPOSITION = 9;
    public static final int ACCOUNTCOLPOSITION = 10;
    public static final int ACCOUNTVIEWCOLPOSITION = 11;
    private LetterOfCreditInfo letterOfCreditInfo;
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.LetterOfCreditResource";
    private FeeHandler handler = new FeeHandler();
    private FeeCollection feeCollection = new FeeCollection();
    private TableBindHandler tableHandler = new TableBindHandler();

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        this.addLine();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.tableHandler.bindTableToData(this.kdtFee, (IObjectCollection)this.feeCollection, FeeManageInfo.class.getName());
    }

    public void addLine() {
        IObjectValue detailData = this.createNewData();
        IRow row = this.kdtFee.addRow();
        this.loadLineFileds(detailData, row);
    }

    private void loadLineFileds(IObjectValue obj, IRow row) {
        this.tableHandler.loadLineFields(this.kdtFee, row, obj);
        row.getCell("bizDate").setValue((Object)new Date());
        row.getCell("isCreatorBear").setValue((Object)Boolean.TRUE);
        row.getCell("sxfzbwb").getStyleAttributes().setLocked(true);
        row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtFee.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"moreThanZero"));
            return;
        }
        this.storeFields();
        this.verifyInput(e);
        this.handler.submitFeeCollection(this.feeCollection);
        this.showSubmitSuccess();
        this.feeCollection.clear();
        this.kdtFee.removeRows();
        this.addLine();
        this.storeFields();
        this.editData.remove("moneyamount");
    }

    protected IObjectValue createNewData() {
        FeeManageInfo objectValue = new FeeManageInfo();
        objectValue.setBusinessNumber(this.letterOfCreditInfo.getLetterNumber());
        objectValue.setLetterCreditID(this.letterOfCreditInfo.getId().toString());
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FeeManageFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.letterOfCreditInfo = (LetterOfCreditInfo)this.getUIContext().get("letterOfCreditID");
        try {
            this.letterOfCreditInfo = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(this.letterOfCreditInfo.getId().toString()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.txtBusinessNumber.setText(this.letterOfCreditInfo.getLetterNumber());
        this.txtBusinessNumber.setEditable(false);
        this.btnAddRowFee.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRowFee.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.initTable();
        super.onLoad();
        this.addLine();
        this.storeFields();
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionDelRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public boolean isisClearinghouse(CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        boolean flag = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString());
        return flag;
    }

    public void setInnerAccountFilter(KDBizPromptBox ptmtAccount, CompanyOrgUnitInfo Company) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (Company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)Company.getId().toString()));
        }
        evi.setFilter(filter);
        ptmtAccount.setEntityViewInfo(evi);
        ptmtAccount.setSelectorCollection(this.getCustomSelectors());
        ptmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        return sic;
    }

    private void isHideInnerAccountColl(boolean flag) {
        this.kdtFee.getColumn("innerAccount").getStyleAttributes().setHided(flag);
    }

    private void initTable() throws EASBizException, BOSException {
        this.kdtFee.putBindContents("editData", new String[]{"bizDate", "feeName", "currency", "isCreatorBear", "bearDept", "CdItem", "innerAccount", FIN_MONEYAMOUNT, "exchangeRate", "sxfzbwb", "accountBank", "accountView", "abtract", "company"});
        this.kdtFee.checkParsed();
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtFee, (boolean)true);
        String formatString = CtrlFormatUtilities.getDateFormatString();
        KDDatePicker bizDatePicker = new KDDatePicker();
        KDTDefaultCellEditor bizEditor = new KDTDefaultCellEditor(bizDatePicker);
        this.kdtFee.getColumn("bizDate").setEditor((ICellEditor)bizEditor);
        this.kdtFee.getColumn("bizDate").getStyleAttributes().setNumberFormat(formatString);
        KDBizPromptBox f7FeeName = new KDBizPromptBox();
        f7FeeName.setQueryInfo("com.kingdee.eas.fm.fin.app.FeeTypeMaintenanceQuery");
        f7FeeName.setEditable(true);
        f7FeeName.setEditable(true);
        f7FeeName.setVisible(true);
        f7FeeName.setDisplayFormat("$name$");
        f7FeeName.setEditFormat("$number$");
        f7FeeName.setCommitFormat("$number$");
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("AssociateType", (Object)"3"));
        filter1.getFilterItems().add(new FilterItemInfo("enabled", (Object)"1"));
        entityViewInfo1.setFilter(filter1);
        f7FeeName.setEntityViewInfo(entityViewInfo1);
        KDTDefaultCellEditor descEditor = new KDTDefaultCellEditor((IKDEditor)f7FeeName);
        this.kdtFee.getColumn("feeName").setEditor((ICellEditor)descEditor);
        KDBizPromptBox f7Currency = new KDBizPromptBox();
        f7Currency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        f7Currency.setEditable(true);
        f7Currency.setEditable(true);
        f7Currency.setVisible(true);
        f7Currency.setDisplayFormat("$name$");
        f7Currency.setEditFormat("$number$");
        f7Currency.setCommitFormat("$number$");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7Currency.setEntityViewInfo(evi);
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)f7Currency);
        this.kdtFee.getColumn("currency").setEditor((ICellEditor)currencyEditor);
        KDBizPromptBox f7CdItem = new KDBizPromptBox();
        f7CdItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.ProjectQuery");
        f7CdItem.setEditable(true);
        f7CdItem.setCommitFormat("$number$");
        EntityViewInfo entityViewInfoItem = new EntityViewInfo();
        FilterInfo filterItem = new FilterInfo();
        filterItem.getFilterItems().add(new FilterItemInfo("isListItem", (Object)"1"));
        entityViewInfoItem.setFilter(filterItem);
        f7CdItem.setEntityViewInfo(entityViewInfoItem);
        KDTDefaultCellEditor CdItemEditor = new KDTDefaultCellEditor((IKDEditor)f7CdItem);
        this.kdtFee.getColumn("CdItem").setEditor((ICellEditor)CdItemEditor);
        if (this.isisClearinghouse(this.CURRENT_COMPANY)) {
            this.isHideInnerAccountColl(false);
            KDBizPromptBox f7InnerAccount = new KDBizPromptBox();
            f7InnerAccount.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
            f7InnerAccount.setEditable(true);
            f7InnerAccount.setCommitFormat("$number$");
            if (this.CURRENT_COMPANY != null) {
                this.setInnerAccountFilter(f7InnerAccount, this.CURRENT_COMPANY);
            }
            KDTDefaultCellEditor InnerAccountEditor = new KDTDefaultCellEditor((IKDEditor)f7InnerAccount);
            this.kdtFee.getColumn("innerAccount").setEditor((ICellEditor)InnerAccountEditor);
        } else {
            this.isHideInnerAccountColl(true);
        }
        KDBizPromptBox f7BearDept = new KDBizPromptBox();
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)f7BearDept);
        KDTDefaultCellEditor bearDeptEditor = new KDTDefaultCellEditor((IKDEditor)f7BearDept);
        this.kdtFee.getColumn("bearDept").setEditor((ICellEditor)bearDeptEditor);
        KDFormattedTextField amountFormat = new KDFormattedTextField(1);
        amountFormat.setPrecision(2);
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)amountFormat);
        this.kdtFee.getColumn(FIN_MONEYAMOUNT).setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn(FIN_MONEYAMOUNT).getStyleAttributes().setNumberFormat("#0.00");
        this.kdtFee.getColumn(FIN_MONEYAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn("sxfzbwb").setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn("sxfzbwb").getStyleAttributes().setNumberFormat("#0.00");
        this.kdtFee.getColumn("sxfzbwb").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn("exchangeRate").setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn("exchangeRate").getStyleAttributes().setNumberFormat("#0.00");
        this.kdtFee.getColumn("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDBizPromptBox f7AccountBank = new KDBizPromptBox();
        f7AccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        f7AccountBank.setEditable(true);
        f7AccountBank.setEditable(true);
        f7AccountBank.setVisible(true);
        f7AccountBank.setDisplayFormat("$name$");
        f7AccountBank.setEditFormat("$number$");
        f7AccountBank.setCommitFormat("$number$");
        EntityViewInfo evi2 = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        evi2.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        f7AccountBank.setEntityViewInfo(evi2);
        KDTDefaultCellEditor accountBankEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountBank);
        this.kdtFee.getColumn("accountBank").setEditor((ICellEditor)accountBankEditor);
        KDBizPromptBox f7AccountView = new KDBizPromptBox();
        f7AccountView.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountView.setEditable(true);
        NTHelper.setF7AccountEvi((IUIObject)this, (String)this.CURRENT_COMPANY.getBaseCurrency().getId().toString(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (KDBizPromptBox)f7AccountView);
        KDTDefaultCellEditor accountViewEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountView);
        this.kdtFee.getColumn("accountView").setEditor((ICellEditor)accountViewEditor);
        this.kdtFee.getColumn("sxfzbwb").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setPrecision(2);
        KDTDefaultCellEditor exchangeRateNumberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.kdtFee.getColumn("exchangeRate").setEditor((ICellEditor)exchangeRateNumberEditor);
        KDTextField formattedTextFieldAB = new KDTextField();
        formattedTextFieldAB.setMaxLength(80);
        KDTDefaultCellEditor exchangeRateNumberEditorAB = new KDTDefaultCellEditor((JTextField)formattedTextFieldAB);
        this.kdtFee.getColumn("abtract").setEditor((ICellEditor)exchangeRateNumberEditorAB);
    }

    @Override
    protected void kdtFee_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal moneyAmount = (BigDecimal)this.kdtFee.getRow(0).getCell(FIN_MONEYAMOUNT).getValue();
        if (moneyAmount != null && moneyAmount.doubleValue() == 0.0) {
            this.kdtFee.getRow(0).getCell(FIN_MONEYAMOUNT).setValue((Object)this.editData.getMoneyAmount());
            return;
        }
        this.editData.setMoneyAmount(moneyAmount);
        super.kdtFee_editStopped(e);
        if (e.getColIndex() == 3) {
            Color c = null;
            boolean flag = false;
            if (this.kdtFee.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString().equals("false")) {
                c = Color.lightGray;
                flag = true;
                this.kdtFee.getCell(e.getRowIndex(), 4).setValue(null);
                this.kdtFee.getCell(e.getRowIndex(), 10).setValue(null);
                this.kdtFee.getCell(e.getRowIndex(), 11).setValue(null);
            } else {
                c = Color.WHITE;
                flag = false;
            }
            this.kdtFee.getCell(e.getRowIndex(), 4).getStyleAttributes().setBackground(c);
            this.kdtFee.getCell(e.getRowIndex(), 10).getStyleAttributes().setBackground(c);
            this.kdtFee.getCell(e.getRowIndex(), 11).getStyleAttributes().setBackground(c);
            this.kdtFee.getCell(e.getRowIndex(), 4).getStyleAttributes().setLocked(flag);
            this.kdtFee.getCell(e.getRowIndex(), 10).getStyleAttributes().setLocked(flag);
            this.kdtFee.getCell(e.getRowIndex(), 11).getStyleAttributes().setLocked(flag);
        }
        if (this.kdtFee.getCell(e.getRowIndex(), 2).getValue() != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.kdtFee.getCell(e.getRowIndex(), 2).getValue();
            KDFormattedTextField format = new KDFormattedTextField();
            format.setDataType(1);
            format.setPrecision(currencyInfo.getPrecision());
            this.kdtFee.getCell(e.getRowIndex(), 7).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)format));
        }
        BigDecimal amount = (BigDecimal)this.kdtFee.getCell(e.getRowIndex(), 7).getValue();
        ICell exchangeRateCell = this.kdtFee.getCell(e.getRowIndex(), 8);
        if (e.getColIndex() == 2 && this.kdtFee.getCell(e.getRowIndex(), 2).getValue() != null) {
            CurrencyInfo currencyinfo = (CurrencyInfo)this.kdtFee.getCell(e.getRowIndex(), 2).getValue();
            KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
            formattedTextField.setPrecision(currencyinfo.getPrecision());
            KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
            this.kdtFee.getCell(e.getRowIndex(), 7).setEditor((ICellEditor)numberEditor);
            this.kdtFee.getCell(e.getRowIndex(), 7).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)currencyinfo.getPrecision()));
            if (currencyinfo != null && this.CURRENT_COMPANY.getBaseCurrency() != null) {
                KDFormattedTextField localAmtTxt = new KDFormattedTextField(1);
                localAmtTxt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.CURRENT_COMPANY.getBaseCurrency().getId()));
                numberEditor = new KDTDefaultCellEditor((JTextField)localAmtTxt);
                this.kdtFee.getCell(e.getRowIndex(), 9).setEditor((ICellEditor)numberEditor);
                this.kdtFee.getCell(e.getRowIndex(), 9).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)this.CURRENT_COMPANY.getBaseCurrency().getId()));
                if (this.CURRENT_COMPANY.getBaseCurrency().getId().toString().equals(currencyinfo.getId().toString())) {
                    exchangeRateCell.setValue((Object)Constants.ONE);
                    KDFormattedTextField exRateTxt = new KDFormattedTextField(1);
                    exRateTxt.setPrecision(2);
                    KDTDefaultCellEditor LocEditor = new KDTDefaultCellEditor((JTextField)exRateTxt);
                    exchangeRateCell.setEditor((ICellEditor)LocEditor);
                    exchangeRateCell.getStyleAttributes().setLocked(true);
                    exchangeRateCell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
                } else {
                    try {
                        FeeManageInfo info = (FeeManageInfo)this.getDataObject();
                        if (info != null) {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, this.CURRENT_COMPANY, currencyinfo, this.CURRENT_COMPANY.getBaseCurrency(), info.getBizDate());
                            if (exchangeRateInfo != null) {
                                exchangeRateCell.setValue((Object)exchangeRateInfo.getConvertRate());
                            }
                            KDFormattedTextField LocTextField = new KDFormattedTextField(1);
                            if (exchangeRateInfo != null) {
                                LocTextField.setPrecision(exchangeRateInfo.getPrecision());
                                exchangeRateCell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)exchangeRateInfo.getPrecision()));
                            }
                            KDTDefaultCellEditor LocEditor = new KDTDefaultCellEditor((JTextField)LocTextField);
                            exchangeRateCell.setEditor((ICellEditor)LocEditor);
                            exchangeRateCell.getStyleAttributes().setLocked(false);
                        }
                    }
                    catch (EASBizException e1) {
                        this.kdtFee.getCell(e.getRowIndex(), 2).setValue(null);
                        throw e1;
                    }
                }
            }
        }
        BigDecimal exchangeRate = (BigDecimal)exchangeRateCell.getValue();
        if (amount != null && exchangeRate != null) {
            BigDecimal sxfzbwb = amount.multiply(exchangeRate);
            this.kdtFee.getCell(e.getRowIndex(), 9).setValue((Object)sxfzbwb);
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelRow_actionPerformed(e);
        this.removeLine();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.handler.issueDate = this.letterOfCreditInfo.getIssueDate();
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        int size = this.feeCollection.size();
        for (int i = 0; i < size; ++i) {
            FeeManageInfo info = this.feeCollection.get(i);
            this.handler.verifyFee((CoreUIObject)this, info);
            this.checkFinalCheckout(info.getBizDate());
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
    }

    public void removeLine() {
        if (this.kdtFee.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtFee)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kdtFee.getSelectManager().get().getTop();
        if (this.kdtFee.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        this.kdtFee.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    private void checkFinalCheckout(Date bizDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)bizDate);
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

