/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.client.F7ProjectUI;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AddBatchHelper;
import com.kingdee.eas.fi.cas.ControlTake;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingFeeAmortizationEnum;
import com.kingdee.eas.fm.fin.FinancingFeeBillFactory;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.FinancingFeeBillStateEnum;
import com.kingdee.eas.fm.fin.FinancingFeeInfo;
import com.kingdee.eas.fm.fin.FinancingFeeRourceEnum;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.client.AbstractFinancingFeeBillBathUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FinancingFeeBillBathUI
extends AbstractFinancingFeeBillBathUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingFeeBillBathUI.class);
    Map paramValue = new HashMap();
    List columnKeyList = new ArrayList();
    private BankJournalHandler bankJournalHandler = new BankJournalHandler();
    private CurrencyInfo currentCurrency = FMBillUtil.initCurrentCurrency((CompanyOrgUnitInfo)this.currentCompany);

    public void onLoad() throws Exception {
        super.onLoad();
        IRow row = this.addRow(-1);
        this.fillRowControl(row);
        this.initControlValue(row);
        this.actionAuditResult.setVisible(false);
        this.tblMain.getColumn("localCurAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.currentCurrency.getPrecision()));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        CurrencyCollection Currency2 = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.paramValue.put("CurrencyColection", Currency2.toArray());
        this.tblMain.checkParsed();
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                IRow row = FinancingFeeBillBathUI.this.tblMain.getRow(FinancingFeeBillBathUI.this.tblMain.getSelectManager().getActiveRowIndex() + 1);
                FinancingFeeBillBathUI.this.fillRowControl(row);
                FinancingFeeBillBathUI.this.initControlValue(row);
            }
        });
        KDTextField txtNumber = new KDTextField();
        txtNumber.setMaxLength(80);
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)txtNumber);
        this.tblMain.getColumn("number").setEditor((ICellEditor)numberEditor);
        this.tblMain.getColumn("number").getStyleAttributes().setBackground(new Color(16579551));
        String formatString = CtrlFormatUtilities.getDateFormatString();
        KDDatePicker bizDatePicker = new KDDatePicker();
        KDTDefaultCellEditor bizEditor = new KDTDefaultCellEditor(bizDatePicker);
        this.tblMain.getColumn("bizDate").setEditor((ICellEditor)bizEditor);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(formatString);
        KDTColumns column = this.tblMain.getColumns();
        for (int i = 0; i < column.size(); ++i) {
            this.columnKeyList.add(column.getColumn(i).getKey());
        }
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        KDBizPromptBox f7BearProj = new KDBizPromptBox();
        GeneralKDPromptSelectorAdaptor adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7BearProj, (Component)new F7ProjectUI(), (Object)this.ui, "com.kingdee.eas.basedata.assistant.app.F7ProjectQuery");
        f7BearProj.setSelector((KDPromptSelector)adaptor);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        evi.setFilter(fInfo);
        f7BearProj.setCommitFormat("$number$;$name$");
        f7BearProj.setDisplayFormat("$number$ $name$");
        f7BearProj.setEditFormat("$number$");
        f7BearProj.setEntityViewInfo(evi);
        KDTDefaultCellEditor bearProjEditor = new KDTDefaultCellEditor((IKDEditor)f7BearProj);
        this.tblMain.getColumn("Project").setEditor((ICellEditor)bearProjEditor);
        KDBizPromptBox f7AccountView = new KDBizPromptBox();
        f7AccountView.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountView.setDisplayFormat("$name$");
        f7AccountView.setEditFormat("$number$");
        f7AccountView.setCommitFormat("$number$");
        f7AccountView.setEditable(true);
        this.initF7Acct((IUIObject)this, f7AccountView, this.currentCompany, this.currentCompany.getBaseCurrency());
        KDTDefaultCellEditor accountViewEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountView);
        this.tblMain.getColumn("OppAccount").setEditor((ICellEditor)accountViewEditor);
        this.tblMain.getColumn("PayAccount").setEditor((ICellEditor)accountViewEditor);
        ObjectValueRender payAccountReader = new ObjectValueRender();
        payAccountReader.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("PayAccount").setRenderer((IBasicRender)payAccountReader);
        KDTextField txtPayeeUnit = new KDTextField();
        txtPayeeUnit.setMaxLength(80);
        KDTDefaultCellEditor payeeUnitEditor = new KDTDefaultCellEditor((JTextField)txtPayeeUnit);
        this.tblMain.getColumn("PayeeUnit").setEditor((ICellEditor)payeeUnitEditor);
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(200);
        KDTDefaultCellEditor remarkEditor = new KDTDefaultCellEditor((JTextField)txtRemark);
        this.tblMain.getColumn("description").setEditor((ICellEditor)remarkEditor);
        ICellEditor chkIsRelBankedit = ControlTake.getKDComboBoxEditor((Object[])FinancingFeeAmortizationEnum.getEnumList().toArray());
        this.tblMain.getColumn("isloanshare").setEditor(chkIsRelBankedit);
    }

    public void initF7Acct(IUIObject owner, KDBizPromptBox f7Acct, CompanyOrgUnitInfo company, CurrencyInfo currency) {
        if (company.getAccountTable() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        f7Acct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        f7Acct.setEntityViewInfo(evi);
        f7Acct.setDisplayFormat("$number$-$name$");
        f7Acct.setEditFormat("$number$");
        f7Acct.setCommitFormat("$number$");
        f7Acct.setEditable(true);
        f7Acct.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, filter, false, true));
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
    }

    private void fillRowControl(IRow row) {
        ICellEditor currency = ControlTake.getKDComboBoxEditor((Object[])((Object[])this.paramValue.get("CurrencyColection")));
        FinancingFeeBillBathUI.bindContents(row, "Currency", currency);
        ICellEditor financingProducts = ControlTake.getF7Editor((String)"com.kingdee.eas.fm.fin.app.FinancingProductsQuery");
        FinancingFeeBillBathUI.bindContents(row, "FinProducts", financingProducts);
        ICellEditor financingFee = ControlTake.getF7Editor((String)"com.kingdee.eas.fm.fin.app.FinancingFeeQuery");
        FinancingFeeBillBathUI.bindContents(row, "FinancingFee", financingFee);
        ICellEditor amount = ControlTake.getKDFormattedTextFieldEditor((int)1);
        FinancingFeeBillBathUI.bindContents(row, "Amount", amount);
        ICellEditor exchangeRate = ControlTake.getKDFormattedTextFieldEditor((int)1);
        ((KDFormattedTextField)exchangeRate.getComponent()).setMinimumValue((Comparable)Constants.ZERO);
        FinancingFeeBillBathUI.bindContents(row, "Rate", exchangeRate);
        ICellEditor FeeRate = ControlTake.getKDFormattedTextFieldEditor((int)1);
        ((KDFormattedTextField)FeeRate.getComponent()).setMinimumValue((Comparable)Constants.ZERO);
        FinancingFeeBillBathUI.bindContents(row, "FeeRate", FeeRate);
        ICellEditor outBgItem = ControlTake.getF7Editor((String)"");
        FMClientHelper.initBgItemF7((KDBizPromptBox)((KDBizPromptBox)outBgItem.getComponent()), (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FinancingFeeBillBathUI.bindContents(row, "outBgItemName", outBgItem);
        row.getCell("SourceBillType").getStyleAttributes().setBackground(Color.lightGray);
        row.getCell("SourceBillNm").getStyleAttributes().setBackground(Color.lightGray);
        row.getCell("FinProducts").getStyleAttributes().setBackground(Color.lightGray);
        row.getCell("localCurAmount").getStyleAttributes().setBackground(Color.lightGray);
        row.getCell("isloanshare").setValue((Object)FinancingFeeAmortizationEnum.NOAMORTIZATION);
    }

    public static void bindContents(IRow row, String name, ICellEditor cellEditor) {
        cellEditor.getComponent().setName(name);
        if (cellEditor.getComponent() instanceof KDDatePicker) {
            ((KDDatePicker)cellEditor.getComponent()).setUserObject((Object)row);
        } else if (cellEditor.getComponent() instanceof KDCheckBox) {
            ((KDCheckBox)cellEditor.getComponent()).setUserObject((Object)row);
        } else if (cellEditor.getComponent() instanceof KDComboBox) {
            ((KDComboBox)cellEditor.getComponent()).setUserObject((Object)row);
        } else if (cellEditor.getComponent() instanceof KDTextField) {
            ((KDTextField)cellEditor.getComponent()).setUserObject((Object)row);
        } else if (cellEditor.getComponent() instanceof KDFormattedTextField) {
            ((KDFormattedTextField)cellEditor.getComponent()).setUserObject((Object)row);
        } else if (cellEditor.getComponent() instanceof KDBizPromptBox) {
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            row.getCell(name).setRenderer((IBasicRender)avr);
            ((KDBizPromptBox)cellEditor.getComponent()).setUserObject((Object)row);
        }
        if (row.getCell(name) != null) {
            row.getCell(name).setEditor(cellEditor);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopyLine.setEnabled(true);
        this.actionCopyLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_copyline"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FinancingFeeBillFactory.getRemoteInstance();
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumn("Amount").getColumnIndex() || colIndex == this.tblMain.getColumn("Rate").getColumnIndex()) {
            this.callLocalCurAmount(rowIndex);
        } else if (colIndex == this.tblMain.getColumn("Currency").getColumnIndex()) {
            this.initKDTableFormat(rowIndex);
            this.callLocalCurAmount(rowIndex);
            if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
                this.setPayBankAccountEvi(this.tblMain.getRow(rowIndex));
            }
        } else if (colIndex == this.tblMain.getColumn("PayBankAccount").getColumnIndex()) {
            IRow row = this.tblMain.getRow(rowIndex);
            AccountBankInfo bankAcct = (AccountBankInfo)row.getCell("PayBankAccount").getValue();
            if (!FMHelper.isEmpty((CoreBaseInfo)bankAcct)) {
                row.getCell("PayAccount").setValue((Object)bankAcct.getAccount());
                row.getCell("PayAccount").getStyleAttributes().setLocked(true);
                row.getCell("PayAccount").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            } else {
                row.getCell("PayAccount").setValue(null);
                row.getCell("PayAccount").getStyleAttributes().setLocked(false);
                row.getCell("PayAccount").getStyleAttributes().setBackground(Color.WHITE);
            }
        }
    }

    private void setPayBankAccountEvi(IRow row) {
        row.getCell("PayBankAccount").setValue(null);
        row.getCell("PayAccount").setValue(null);
        row.getCell("PayAccount").getStyleAttributes().setLocked(false);
        row.getCell("PayAccount").getStyleAttributes().setBackground(Color.WHITE);
        String currencyid = ((CurrencyInfo)row.getCell("Currency").getValue()).getId().toString();
        String companyId = this.currentCompany.getId().toString();
        KDBizPromptBox f7AccountBank = new KDBizPromptBox();
        f7AccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        f7AccountBank.setEditable(true);
        f7AccountBank.setDisplayFormat("$number$ $name$");
        f7AccountBank.setEditFormat("$number$");
        f7AccountBank.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyid));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        evi.setFilter(filter);
        f7AccountBank.setEntityViewInfo(evi);
        f7AccountBank.getQueryAgent().resetRuntimeEntityView();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("account.*");
        f7AccountBank.setSelectorCollection(selectors);
        KDTDefaultCellEditor accountBankEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountBank);
        this.tblMain.getColumn("PayBankAccount").setEditor(null);
        this.tblMain.getColumn("PayBankAccount").setEditor((ICellEditor)accountBankEditor);
        ObjectValueRender payBankAccountReader = new ObjectValueRender();
        payBankAccountReader.setFormat((IDataFormat)new BizDataFormat("$number$ $name$"));
        this.tblMain.getColumn("PayBankAccount").setRenderer((IBasicRender)payBankAccountReader);
    }

    protected void callLocalCurAmount(int rowIndex) {
        BigDecimal extRate;
        IRow row = this.tblMain.getRow(rowIndex);
        BigDecimal Amount = (BigDecimal)row.getCell("Amount").getValue();
        if (Amount == null) {
            Amount = Constants.ZERO;
        }
        if (FMHelper.isEmpty((Object)(extRate = (BigDecimal)row.getCell("Rate").getValue()))) {
            extRate = Constants.ONE;
        }
        row.getCell("localCurAmount").setValue((Object)FMHelper.getLocalAmount((BigDecimal)Amount, (BigDecimal)extRate));
    }

    private void initKDTableFormat(int rowIndex) throws EASBizException, BOSException {
        IRow row = this.tblMain.getRow(rowIndex);
        Date date = (Date)row.getCell("bizDate").getValue();
        CurrencyInfo baseCurrency = this.currentCompany.getBaseCurrency();
        CurrencyInfo currency = (CurrencyInfo)row.getCell("Currency").getValue();
        this.initExchangeRate(null, row.getCell("Rate"), this.currentCompany, currency, baseCurrency, date);
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)currency.getId());
        String format = FMClientHelper.getKDTNumFormat((int)precision);
        row.getCell("Amount").getStyleAttributes().setNumberFormat(format);
        this.callLocalCurAmount(rowIndex);
    }

    private void initExchangeRate(Context ctx, ICell cellRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 2;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            cellRate.setValue((Object)rate);
            cellRate.getStyleAttributes().setLocked(true);
            String format = FMClientHelper.getKDTNumFormat((int)5);
            cellRate.getStyleAttributes().setNumberFormat(format);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date);
        if (exchangeRateInfo == null) {
            rate = Constants.ONE;
        } else {
            rate = exchangeRateInfo.getConvertRate();
            precision = exchangeRateInfo.getPrecision();
        }
        cellRate.setValue((Object)rate);
        cellRate.getStyleAttributes().setLocked(false);
        String format = FMClientHelper.getKDTNumFormat((int)precision);
        cellRate.getStyleAttributes().setNumberFormat(format);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.storeFields();
        this.verifyInput(e);
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            this.checkFinalCheckout(DateTimeUtils.truncateDate((Date)((Date)row.getCell("bizDate").getValue())));
            FinancingFeeBillInfo info = (FinancingFeeBillInfo)this.createNewData();
            info.setNumber((String)row.getCell("number").getValue());
            info.setBizDate(DateTimeUtils.truncateDate((Date)((Date)row.getCell("bizDate").getValue())));
            info.setFinancingFee((FinancingFeeInfo)row.getCell("FinancingFee").getValue());
            info.setPayeeUnit((String)row.getCell("PayeeUnit").getValue());
            info.setPayBankAccount((AccountBankInfo)row.getCell("PayBankAccount").getValue());
            info.setCurrency((CurrencyInfo)row.getCell("Currency").getValue());
            info.setPayAccount((AccountViewInfo)row.getCell("PayAccount").getValue());
            info.setFeeRate((BigDecimal)row.getCell("FeeRate").getValue());
            info.setAmount((BigDecimal)row.getCell("Amount").getValue());
            info.setOppAccount((AccountViewInfo)row.getCell("OppAccount").getValue());
            info.setRate((BigDecimal)row.getCell("Rate").getValue());
            info.setLocalCurAmount((BigDecimal)row.getCell("localCurAmount").getValue());
            info.setProject((ProjectInfo)row.getCell("Project").getValue());
            info.setDescription((String)row.getCell("description").getValue());
            FMClientHelper.storeFieldsBgItem((ICell)row.getCell("outBgItemName"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
            info.setSourceBillId((String)this.paramValue.get("SourceBillId"));
            info.setIsloanshare((FinancingFeeAmortizationEnum)((Object)row.getCell("isloanshare").getValue()));
            coll.add((CoreBaseInfo)info);
        }
        FinancingFeeBillFactory.getRemoteInstance().submit(coll);
        this.tblMain.removeRows();
        this.actionAddLine_actionPerformed(e);
        this.showSubmitSuccess();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.addRow(-1);
        this.fillRowControl(row);
        this.initControlValue(row);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            IRow row = this.addRow(rowNumber + 1);
            this.fillRowControl(row);
            this.initControlValue(row);
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            if (rowNumber < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if (rowNumber >= 0) {
                this.tblMain.removeRow(rowNumber);
            }
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            if (rowNumber < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            IRow row = this.tblMain.getRow(rowNumber);
            IRow copyRow = this.addRow(-1);
            this.fillRowControl(copyRow);
            this.setDefaultLocCurAmount(copyRow, "localCurAmount");
            for (int i = 0; i < this.columnKeyList.size(); ++i) {
                if (this.columnKeyList.get(i).equals("number")) {
                    this.setDefaultNumber(copyRow, "number");
                    continue;
                }
                if (this.columnKeyList.get(i).equals("FeeRate")) {
                    AddBatchHelper.getKDFormattedTextField((IRow)copyRow, (String)"FeeRate").setPrecision(2);
                    copyRow.getCell("FeeRate").setValue((Object)AddBatchHelper.getKDFormattedTextField((IRow)row, (String)"FeeRate").getNumberValue());
                    String format = FMClientHelper.getKDTNumFormat((int)2);
                    copyRow.getCell("FeeRate").getStyleAttributes().setNumberFormat(format);
                    continue;
                }
                copyRow.getCell((String)this.columnKeyList.get(i)).setValue(row.getCell((String)this.columnKeyList.get(i)).getValue());
                if (!this.columnKeyList.get(i).equals("PayAccount") || row.getCell((String)this.columnKeyList.get(i)).getValue() == null) continue;
                copyRow.getCell(i).getStyleAttributes().setLocked(true);
                copyRow.getCell(i).getStyleAttributes().setBackground(Color.lightGray);
            }
            this.initKDTableFormat(copyRow.getRowIndex());
        }
    }

    private IRow addRow(int rowNumber) {
        IRow row = rowNumber >= 0 ? this.tblMain.addRow(rowNumber) : this.tblMain.addRow();
        return row;
    }

    private void initControlValue(IRow row) {
        this.setDefaultSourceValue(row);
        this.setDefaultNumber(row, "number");
        this.setDefaultBizDate(row, "bizDate");
        this.setDefaultCurrency(row, "Currency");
        this.setDefaultExchangeRate(row, "Rate");
        this.setDefaultAmount(row, "Amount");
        this.setDefaultFeeRate(row, "FeeRate");
        this.setDefaultLocCurAmount(row, "localCurAmount");
    }

    private void setDefaultNumber(IRow row, String key) {
        this.initNumber((CoreBaseInfo)new FinancingFeeBillInfo(), row, key);
    }

    private void setDefaultSourceValue(IRow row) {
        row.getCell("SourceBillType").setValue(this.paramValue.get("SourceBillType"));
        row.getCell("SourceBillNm").setValue(this.paramValue.get("SourceBillNm"));
        row.getCell("FinProducts").setValue(this.paramValue.get("FinProducts"));
    }

    private void setDefaultFeeRate(IRow row, String name) {
        AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).setPrecision(2);
        AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).setNumberValue((Number)new BigDecimal("0.00"));
        row.getCell(name).setValue((Object)AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).getNumberValue());
        String format = FMClientHelper.getKDTNumFormat((int)2);
        row.getCell(name).getStyleAttributes().setNumberFormat(format);
    }

    private void setDefaultAmount(IRow row, String name) {
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.currentCompany.getBaseCurrency().getId());
        AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).setPrecision(precision);
        AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).setNumberValue((Number)Constants.ZERO);
        row.getCell(name).setValue((Object)AddBatchHelper.getKDFormattedTextField((IRow)row, (String)name).getNumberValue());
        String format = FMClientHelper.getKDTNumFormat((int)precision);
        row.getCell(name).getStyleAttributes().setNumberFormat(format);
    }

    private void setDefaultLocCurAmount(IRow row, String name) {
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.currentCompany.getBaseCurrency().getId());
        String format = FMClientHelper.getKDTNumFormat((int)precision);
        row.getCell(name).setValue((Object)Constants.ZERO);
        row.getCell(name).getStyleAttributes().setNumberFormat(format);
    }

    private void setDefaultExchangeRate(IRow row, String name) {
        CurrencyInfo currency = (CurrencyInfo)row.getCell("Currency").getValue();
        try {
            this.initExchangeRate(null, row.getCell("Rate"), this.currentCompany, currency, this.baseCurrency, new Date());
            row.getCell(name).getStyleAttributes().setLocked(true);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void setDefaultCurrency(IRow row, String name) {
        FMClientHelper.setSelectObject((KDComboBox)AddBatchHelper.getKDComboBox((IRow)row, (String)name), (Object)this.currentCompany.getBaseCurrency());
        row.getCell(name).setValue(AddBatchHelper.getKDComboBox((IRow)row, (String)name).getSelectedItem());
        this.setPayBankAccountEvi(row);
    }

    private void setDefaultBizDate(IRow row, String name) {
        row.getCell(name).setValue((Object)new Date());
    }

    protected IObjectValue createNewData() {
        FinancingFeeBillInfo objectValue = new FinancingFeeBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCreateTime(DateUtil.getTimeStampDayBegin());
        objectValue.setState(FinancingFeeBillStateEnum.SAVE);
        FinancingFeeRourceEnum sourceBillType = (FinancingFeeRourceEnum)((Object)this.getUIContext().get("sourceBillType"));
        this.paramValue.put("SourceBillType", sourceBillType);
        objectValue.setSourceBillType(sourceBillType);
        String SourceBillNm = (String)this.getUIContext().get("sourceBillNm");
        this.paramValue.put("SourceBillNm", SourceBillNm);
        objectValue.setSourceBillNm(SourceBillNm);
        FinancingProductsInfo finProduct = (FinancingProductsInfo)this.getUIContext().get("FinancingProduct");
        this.paramValue.put("FinProducts", finProduct);
        this.paramValue.put("SourceBillId", this.getUIContext().get("id"));
        objectValue.setFinProducts(finProduct);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        boolean hasNumber = FMClientHelper.hasNumber((CoreBaseInfo)new FinancingFeeBillInfo(), (String)this.currentCompany.getId().toString());
        this.tblMain.getColumn("number").setRequired(!hasNumber);
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        for (i = 0; i < this.columnKeyList.size(); ++i) {
            if (!this.tblMain.getColumn((String)this.columnKeyList.get(i)).isRequired()) continue;
            FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)((String)this.columnKeyList.get(i)));
        }
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            IRow row = this.tblMain.getRow(i);
            FMClientVerifyHelper.verifyInputIsZero((CoreUIObject)this, (KDTable)this.tblMain, (IRow)row, (String)"Amount");
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("PayeeUnit"));
        sic.add(new SelectorItemInfo("SourceBillType"));
        sic.add(new SelectorItemInfo("SourceBillNm"));
        sic.add(new SelectorItemInfo("FeeRate"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Rate"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("Project.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("FinProducts.name"));
        sic.add(new SelectorItemInfo("FinancingFee.name"));
        sic.add(new SelectorItemInfo("PayBankAccount.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        sic.add(new SelectorItemInfo("OppAccount.name"));
        sic.add(new SelectorItemInfo("localCurAmount"));
        sic.add(new SelectorItemInfo("PayAccount.name"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    private void initNumber(CoreBaseInfo info, IRow row, String key) {
        String companyId = this.currentCompany.getId().toString();
        boolean rst = FMClientHelper.hasNumber((CoreBaseInfo)info, (String)companyId);
        if (rst) {
            row.getCell(key).getStyleAttributes().setLocked(true);
            row.getCell(key).getStyleAttributes().setBackground(Color.lightGray);
            String number = FMClientHelper.getDispNumber((CoreBaseInfo)info, (String)companyId);
            if (!FMHelper.isEmpty((String)number)) {
                row.getCell(key).setValue((Object)number);
            }
        } else {
            row.getCell(key).getStyleAttributes().setLocked(false);
        }
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    private void checkFinalCheckout(Date bizDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)companyInfo.getId().toString(), (Date)bizDate);
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

