/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.client.AbstractFinancingFeeBillFilterUI;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillFilterParam;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingFeeBillFilterUI
extends AbstractFinancingFeeBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingFeeBillFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        this.kdpDateBegin.setValue((Object)cal.getTime());
        this.kdpDateEnd.setValue((Object)DateUtil.getDayBegin());
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comBoCurrency);
        this.comBoCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comBoCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        this.kdpDateBegin.setValue((Object)cal.getTime());
        this.kdpDateEnd.setValue((Object)DateUtil.getDayBegin());
        this.prmtFeeType.setValue(null);
        FMClientHelper.setSelectObject((KDComboBox)this.comBoCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.ckLoan.setSelected(true);
        this.ckSLloan.setSelected(true);
        this.ckBond.setSelected(true);
        this.ckPerson.setSelected(true);
        this.setCompanyIds(new String[]{""});
    }

    public Object getParam() {
        FinancingFeeBillFilterParam param = new FinancingFeeBillFilterParam();
        param.setStartBizDate(this.kdpDateBegin.getSqlDate());
        param.setEndBizDate(this.kdpDateEnd.getSqlDate());
        param.setCompanyIdSet(this.getCompanyIdSet());
        if (null != this.comBoCurrency.getSelectedItem()) {
            if (!(this.comBoCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
                param.setCurrencyId(((CurrencyInfo)this.comBoCurrency.getSelectedItem()).getId().toString());
            } else {
                param.setCurrencyId(null);
            }
        }
        param.setFeeTypeSet(this.getIdSetFromF7(this.prmtFeeType));
        HashSet<String> sourceSet = new HashSet<String>();
        if (this.ckLoan.isSelected()) {
            sourceSet.add(String.valueOf(new Integer(1)));
        }
        if (this.ckPerson.isSelected()) {
            sourceSet.add(String.valueOf(new Integer(5)));
        }
        if (this.ckSLloan.isSelected()) {
            sourceSet.add(String.valueOf(new Integer(2)));
        }
        if (this.ckBond.isSelected()) {
            sourceSet.add(String.valueOf(new Integer(3)));
            sourceSet.add(String.valueOf(new Integer(4)));
        }
        param.setFeeSourceSet(sourceSet);
        return param;
    }

    public void setParam(Object param) {
        FinancingFeeBillFilterParam iparam = (FinancingFeeBillFilterParam)((Object)param);
        this.kdpDateBegin.setValue((Object)iparam.getStartBizDate());
        this.kdpDateEnd.setValue((Object)iparam.getEndBizDate());
        try {
            if (FMHelper.isEmpty((String)iparam.getCurrencyId())) {
                FMClientHelper.setSelectObject((KDComboBox)this.comBoCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            } else {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(iparam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.comBoCurrency, (Object)cur);
            }
            this.prmtFeeType.setData((Object)this.getBaseInfoFromIdSet(iparam.getFeeTypeSet()));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setCompanyIdSet(iparam.getCompanyIdSet());
        this.ckLoan.setSelected(iparam.getFeeSourceSet().contains(String.valueOf(new Integer(1))));
        this.ckPerson.setSelected(iparam.getFeeSourceSet().contains(String.valueOf(new Integer(5))));
        this.ckSLloan.setSelected(iparam.getFeeSourceSet().contains(String.valueOf(new Integer(2))));
        this.ckBond.setSelected(iparam.getFeeSourceSet().contains(String.valueOf(new Integer(3))));
    }

    public boolean verify() {
        Set<String> SourceSet;
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdpDateBegin);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdpDateEnd);
        if (DateTimeUtils.truncateDate((Date)((Date)this.kdpDateBegin.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.kdpDateEnd.getValue())))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"FinFeeFilterDate"));
            SysUtil.abort();
        }
        if (FMHelper.isEmpty(SourceSet = ((FinancingFeeBillFilterParam)((Object)this.getParam())).getFeeSourceSet()) || SourceSet.size() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"FeeSourceFilter"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return FinancingFeeBillFilterParam.class;
    }
}

