/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.AccrualCalculator;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.fin.AbstractCompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.client.AbstractIntReceivedBillEditUI;
import com.kingdee.eas.fm.fin.client.TimeDepositHelper;
import com.kingdee.eas.fm.fin.util.AccrualCalculatorPropertyUtil;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IntReceivedBillEditUI
extends AbstractIntReceivedBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceivedBillEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private String intReceivedBillType;
    public static final String INTRECEIVEDBILL_FILENAME = "/FM/IM/INTRECEIVED";
    private CompDepositAccountBillInfo timeDepositBillInfo;
    private TimeDepositHelper helper;
    private CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    private CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo;
    private boolean isSuccess = false;
    private IObjectPK pk = null;
    IObjectPK pk1;

    public void onLoad() throws Exception {
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.initCurrency();
        this.initCustomedVariable();
        super.onLoad();
        if (OprtState.VIEW != this.getOprtState() && !"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            if (IntReceivedBillTypeEnum.INTBILL_PAYINTEREST.equals(this.comboIntReceiveType.getSelectedItem())) {
                this.btnSave.setVisible(true);
            }
            this.txtCreInterest.setEnabled(true);
            this.txtDeInterest.setEnabled(true);
            this.txtDigest.setEnabled(true);
            this.prmtBgItem.setEnabled(true);
            this.prmtProject.setEnabled(true);
        } else {
            this.txtCreInterest.setEnabled(false);
            this.txtDeInterest.setEnabled(false);
            this.txtDigest.setEditable(false);
            this.prmtBgItem.setEnabled(false);
            this.prmtProject.setEnabled(false);
            this.btnTDPrint.setEnabled(true);
            this.btnTDPrint.setVisible(true);
            this.btnTDPrintPreview.setEnabled(true);
            this.btnTDPrintPreview.setVisible(true);
            this.actionTDPrintPreview.setEnabled(true);
            this.actionTDPrint.setEnabled(true);
        }
        if (OprtState.EDIT == this.getOprtState()) {
            this.btnTDPrint.setEnabled(false);
            this.btnTDPrint.setVisible(false);
            this.btnTDPrintPreview.setEnabled(false);
            this.btnTDPrintPreview.setVisible(false);
            this.actionTDPrintPreview.setEnabled(false);
            this.actionTDPrint.setEnabled(false);
        }
        if ((OprtState.ADDNEW == this.getOprtState() || OprtState.EDIT == this.getOprtState()) && IntReceivedBillTypeEnum.PRE_DRAWING.equals(this.comboIntReceiveType.getSelectedItem())) {
            this.prmpCurAcct.setEnabled(true);
            this.prmpCurAcct.setRequired(false);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1).toString()));
            evi.setFilter(filter);
            this.prmpCurAcct.setEntityViewInfo(evi);
        }
        if (!IntReceivedBillTypeEnum.INTBILL_PAYINTEREST.equals(this.comboIntReceiveType.getSelectedItem())) {
            this.txtStrikeBalance.setVisible(false);
            this.strikeBalance.setVisible(false);
        }
        this.txtShijiAmt.setEnabled(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtIntervalDays.setHorizontalAlignment(4);
        this.txtDepositAmt.setHorizontalAlignment(4);
        this.txtYearDays.setHorizontalAlignment(4);
        this.txtDepYearRate.setHorizontalAlignment(4);
        this.txtDeInterest.setHorizontalAlignment(4);
        this.txtCreYearRate.setHorizontalAlignment(4);
        this.txtCreInterest.setHorizontalAlignment(4);
        this.txtYingjiAmt.setHorizontalAlignment(4);
        this.txtShijiAmt.setHorizontalAlignment(4);
        this.txtDepositAmt.setRemoveingZeroInDispaly(false);
        this.txtDepYearRate.setRemoveingZeroInDispaly(false);
        this.txtCreYearRate.setRemoveingZeroInDispaly(false);
        this.txtYingjiAmt.setRemoveingZeroInDispaly(false);
        this.txtShijiAmt.setRemoveingZeroInDispaly(false);
        this.txtDeInterest.setRemoveingZeroInDispaly(false);
        this.txtCreInterest.setRemoveingZeroInDispaly(false);
        this.txtDepositAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.menuItemViewBg.setVisible(true);
        this.btViewBg.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
    }

    private void initControls() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.isPreDrawInt()) {
                this.initControlsPreDrawInt();
            } else if (this.isRedopsitInt()) {
                this.initControlsRedopsitInt();
            } else if (this.isUnTimeDepositInt()) {
                this.initUnTimeDepositInt();
            }
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.initControls();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionViewBdgBalance.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_check"));
    }

    private void initCustomedVariable() throws Exception {
        this.intReceivedBillType = (String)this.getUIContext().get("intType");
        if (this.isRedopsitInt()) {
            String sourceID = (String)this.getUIContext().get("sourceTimeBillID");
            this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getSelectorsForQueryTimeDeposit());
        } else if (this.isUnTimeDepositInt()) {
            String pk = (String)this.getUIContext().get("sourceTimeBillID");
            this.CompUnTimeDepositBillInfo = (CompUnTimeDepositBillInfo)this.getUIContext().get("UnDipositID");
            pk = pk != null ? pk : this.CompUnTimeDepositBillInfo.getTimeDepositBill().getId().toString();
            this.timeDepositBillInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(pk), this.getSelectorsForQueryTimeDeposit());
            this.CompUnTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
        }
    }

    public SelectorItemCollection getSelectorsForQueryTimeDeposit() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("DepCompany.id"));
        sic.add(new SelectorItemInfo("DepCompany.name"));
        sic.add(new SelectorItemInfo("DepositType"));
        sic.add(new SelectorItemInfo("interm.*"));
        sic.add("depositBank.*");
        sic.add("accountant.*");
        sic.add("corpCurAcct.*");
        sic.add("corpDepAcct.*");
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBillID.number"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add("project.name");
        sic.add("project.number");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        sic.add("fundFlowItem.*");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CompIntReceivedBillFactory.getRemoteInstance();
    }

    private void initUnTimeDepositInt() {
        this.txtYingjiAmt.setMaximumValue((Comparable)this.txtShijiAmt.getBigDecimalValue());
        this.prmpCurAcct.setEnabled(true);
    }

    private void initControlsRedopsitInt() {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.timeDepositBillInfo) && !this.isAccrualToDepositAmt()) {
            this.prmpCurAcct.setEnabled(true);
        }
        this.initOtherContrlos_RedepositInt();
    }

    private void initOtherContrlos_RedepositInt() {
        this.txtNumber.setEnabled(false);
    }

    private void initControlsPreDrawInt() {
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString()));
        this.setPre(5);
        this.setPre2(baseCurrPre);
    }

    private void setPre(int currencyPre) {
        this.txtDepYearRate.setDataType(1);
        this.txtCreYearRate.setDataType(1);
        this.txtCreYearRate.setPrecision(currencyPre);
        this.txtDepYearRate.setPrecision(currencyPre);
    }

    private void setPre2(int currencyPre) {
        this.txtDepositAmt.setPrecision(currencyPre);
        this.txtDeInterest.setPrecision(currencyPre);
        this.txtCreInterest.setPrecision(currencyPre);
        this.txtYingjiAmt.setPrecision(currencyPre);
        this.txtShijiAmt.setPrecision(currencyPre);
    }

    private boolean isUnTimeDepositInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("1");
    }

    private boolean isRedopsitInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("2");
    }

    private boolean isPreDrawInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("0");
    }

    private boolean isPayInt() {
        return IntReceivedBillTypeEnum.INTBILL_PAYINTEREST.equals(this.comboIntReceiveType.getSelectedItem());
    }

    protected IObjectValue createNewData() {
        CompIntReceivedBillInfo objectValue = new CompIntReceivedBillInfo();
        objectValue.setCompany(this.currentCompany);
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setIsreceived(false);
        if (this.isPreDrawInt()) {
            this.setOtherValue_DrawInt(objectValue);
        } else if (this.isRedopsitInt()) {
            this.setOtherValue_ReDopsitInt(objectValue);
            this.setCorpCurAcct_ReDeposit(objectValue);
        } else if (this.isUnTimeDepositInt()) {
            this.setOtherValue_UnTimeDepositInt(objectValue);
        }
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        objectValue.setIntervalDays(Math.abs(objectValue.getIntervalDays()));
        return objectValue;
    }

    private void setCorpCurAcct_ReDeposit(CompIntReceivedBillInfo objectValue) {
        if (this.timeDepositBillInfo.isIsReDeposited()) {
            if (this.isAccrualToDepositAmt()) {
                objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
            } else {
                CompDepositAccountBillInfo rootRedeposit = this.getRootRedeposit(this.timeDepositBillInfo.getSourceBillId());
                objectValue.setCorpCurAcct(rootRedeposit.getCorpCurAcct());
            }
        } else if (this.isAccrualToDepositAmt()) {
            objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpDepAcct());
        } else {
            objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
        }
    }

    private boolean isAccrualToDepositAmt() {
        boolean isAccrualToDepositAmt = false;
        CompDepositAccountBillInfo reDeposit = (CompDepositAccountBillInfo)this.getUIContext().get("ObjectInfo_ID");
        if (!EmptyUtil.isEmpty((CoreBaseInfo)reDeposit)) {
            isAccrualToDepositAmt = reDeposit.isIsAccrualToDepositAmt();
        }
        return isAccrualToDepositAmt;
    }

    private CompDepositAccountBillInfo getRootRedeposit(String srcId) {
        CompDepositAccountBillInfo info = null;
        if (!EmptyUtil.isEmpty((String)srcId)) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("corpCurAcct.*"));
                sic.add(new SelectorItemInfo("corpDepAcct.*"));
                info = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(srcId), sic);
                if (info.isIsReDeposited() && !EmptyUtil.isEmpty((String)info.getSourceBillId())) {
                    info = this.getRootRedeposit(info.getSourceBillId());
                }
            }
            catch (Exception e) {
                this.handUIException(e.getCause());
            }
        }
        return info;
    }

    private void setOtherValue_DrawInt(CompIntReceivedBillInfo objectValue) {
        objectValue.setSrcBillID(this.timeDepositBillInfo.getId().toString());
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.PRE_DRAWING);
    }

    private void setOtherValue_ReDopsitInt(CompIntReceivedBillInfo objectValue) {
        objectValue.setSrcBillID(this.timeDepositBillInfo.getId().toString());
        objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
        objectValue.setDepCompany(this.timeDepositBillInfo.getDepCompany());
        String sourceBillID = (String)this.getUIContext().get("sourceTimeBillID");
        AbstractCompDepositAccountBillInfo sourceInfo = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("interm.*");
            sic.add("depositBank.*");
            sic.add("accountant.*");
            sourceInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID), sic);
            objectValue.setTimeDepositBillID((CompDepositAccountBillInfo)sourceInfo);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        objectValue.setIntRateTypeExpression(sourceInfo.getIntRateTypeExpression());
        objectValue.setYearDays(sourceInfo.getYearDays());
        objectValue.setEffectiveDate(sourceInfo.getLastPayDate());
        objectValue.setEndDate(this.getIntBillEnDate(sourceInfo.getMaturityDay()));
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.INTBILL_REDEPOSIT);
        objectValue.setBank(this.timeDepositBillInfo.getDepositBank());
        objectValue.setCompany(this.timeDepositBillInfo.getCompany());
        objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
        BigDecimal floorAmt = sourceInfo.getIntFreeAmt() == null ? Constants.ZERO : sourceInfo.getIntFreeAmt();
        objectValue.setDepositAmt(sourceInfo.getBalance().subtract(floorAmt));
        objectValue.setDepYearRate(this.getYearRate_Redeposit((CompDepositAccountBillInfo)sourceInfo, objectValue.getEndDate()));
        boolean param_FT001 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        int days = 0;
        days = param_FT001 && (TermTypeEnum.MONTH.equals((Object)this.timeDepositBillInfo.getInterm().getType()) || TermTypeEnum.YEAR.equals((Object)this.timeDepositBillInfo.getInterm().getType())) && this.timeDepositBillInfo.getLastPayDate().compareTo(this.timeDepositBillInfo.getEffectiveDate()) == 0 ? (this.timeDepositBillInfo.getDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositBillInfo.getDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER ? TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1 : (TermTypeEnum.MONTH.equals((Object)this.timeDepositBillInfo.getInterm().getType()) ? this.timeDepositBillInfo.getInterm().getTerm() * 30 : this.timeDepositBillInfo.getInterm().getTerm() * 360)) : TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1;
        objectValue.setIntervalDays(days);
        objectValue.setCreYearRate(sourceInfo.getCurRate());
        objectValue.setCorpCurAcct(this.timeDepositBillInfo.getCorpCurAcct());
        objectValue.setCreInterest(Constants.ZERO);
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        aceni.setIntTerm(sourceInfo.getInterm());
        aceni.setStartDate(this.timeDepositBillInfo.getEffectiveDate());
        AccrualCalculatorPropertyUtil.copyPropertiesValue(null, aceni, (CoreBaseInfo)this.timeDepositBillInfo, objectValue.getIntReceiveType());
        aceni.setFloorAmtTmp(this.timeDepositBillInfo.getIntFreeAmt());
        aceni.setTimeDepositType(this.timeDepositBillInfo.getDepositType());
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(null, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    private void setOtherValue_UnTimeDepositInt(CompIntReceivedBillInfo objectValue) {
        CompanyOrgUnitInfo DepCompany = null;
        InnerAccountInfo CorpCurAcct = null;
        try {
            DepCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getDepCompany().getId()));
            if (this.CompUnTimeDepositBillInfo.getCorpCurAcct() != null && InnerAccountFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(this.CompUnTimeDepositBillInfo.getCorpCurAcct().getId()))) {
                CorpCurAcct = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(this.CompUnTimeDepositBillInfo.getCorpCurAcct().getId()));
            }
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
        objectValue.setSrcBillID(this.CompUnTimeDepositBillInfo.getId().toString());
        String sourceBillID = (String)this.getUIContext().get("sourceTimeBillID") != null ? (String)this.getUIContext().get("sourceTimeBillID") : this.timeDepositBillInfo.getId().toString();
        AbstractCompDepositAccountBillInfo sourceInfo = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("interm.*");
            sic.add("depositBank.*");
            sic.add("accountant.*");
            sourceInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID), sic);
            objectValue.setTimeDepositBillID((CompDepositAccountBillInfo)sourceInfo);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        objectValue.setIntRateTypeExpression(sourceInfo.getIntRateTypeExpression());
        objectValue.setYearDays(sourceInfo.getYearDays());
        objectValue.setEffectiveDate(this.timeDepositBillInfo.getLastPayDate());
        objectValue.setEndDate(this.calcEndDate(this.CompUnTimeDepositBillInfo.getUntimeDate()));
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT);
        objectValue.setBank(this.timeDepositBillInfo.getDepositBank());
        objectValue.setCompany(this.timeDepositBillInfo.getCompany());
        objectValue.setDepCompany(DepCompany);
        objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
        if (this.CompUnTimeDepositBillInfo.getUnDepositAmt().compareTo(this.timeDepositBillInfo.getBalance()) == 0) {
            BigDecimal floorAmtTmp = this.timeDepositBillInfo.getIntFreeAmt() == null ? Constants.ZERO : this.timeDepositBillInfo.getIntFreeAmt();
            objectValue.setDepositAmt(this.CompUnTimeDepositBillInfo.getUnDepositAmt().subtract(floorAmtTmp));
        } else {
            objectValue.setDepositAmt(this.CompUnTimeDepositBillInfo.getUnDepositAmt());
        }
        objectValue.setDepYearRate(this.getYearRate_Redeposit(this.timeDepositBillInfo, objectValue.getEndDate()));
        objectValue.setCorpCurAcct(CorpCurAcct);
        objectValue.setCreYearRate(this.CompUnTimeDepositBillInfo.getYearRate());
        boolean param_FT001 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        int days = 0;
        days = param_FT001 ? TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1 : TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1;
        objectValue.setIntervalDays(days);
        objectValue.setCreInterest(this.calcCurrentAccrual(objectValue));
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        this.CompUnTimeDepositBillInfo.setInfo(objectValue);
        aceni.setIntTerm(sourceInfo.getInterm());
        aceni.setStartDate(this.timeDepositBillInfo.getEffectiveDate());
        AccrualCalculatorPropertyUtil.copyPropertiesValue(null, aceni, (CoreBaseInfo)this.CompUnTimeDepositBillInfo, objectValue.getIntReceiveType());
        aceni.setYearRate(objectValue.getDepYearRate());
        aceni.setTimeDepositType(this.timeDepositBillInfo.getDepositType());
        if (this.CompUnTimeDepositBillInfo.getUnDepositAmt().compareTo(this.timeDepositBillInfo.getBalance()) == 0) {
            aceni.setLastUnde(true);
            aceni.setFloorAmtTmp(this.timeDepositBillInfo.getIntFreeAmt());
        }
        TimeDepositTypeEnum timeDepositType = this.CompUnTimeDepositBillInfo.getDepositType();
        if (this.CompUnTimeDepositBillInfo.getUnDepositType() == UnDepositTypeEnum.CONSULT_UNDEPOSIT && (timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            int notCalIntDays = 0;
            notCalIntDays = this.CompUnTimeDepositBillInfo.getNotCalIntDays();
            objectValue.setIntervalDays(days - notCalIntDays);
            aceni.setUnDepositDate(DateTimeUtils.addDay((Date)this.CompUnTimeDepositBillInfo.getUntimeDate(), (long)(-1 * notCalIntDays)));
        }
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(null, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    private CompanyOrgUnitInfo getCompany(String uid) {
        CompanyOrgUnitInfo info = null;
        try {
            info = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(uid));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private BankInfo getBank(String bankid) {
        BankInfo info = null;
        try {
            info = (BankInfo)BankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(bankid));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private void calcInterst(CompIntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(Constants.ZERO);
        objectValue.setCreInterest(Constants.ZERO);
        if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("consultUnDeposit")) {
            int days = this.getDeDays("consultUnDeposit", objectValue);
            this.calcDeInterst(objectValue, days);
        } else if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("matureUnDeposit")) {
            int days = this.getDeDays("matureUnDeposit", objectValue);
            this.calcDeInterst(objectValue, days);
            this.calcCuInterst(objectValue);
        } else {
            this.calcCuInterst(objectValue);
        }
    }

    private void calcDeInterst(CompIntReceivedBillInfo objectValue, int days) {
        BigDecimal unDeposiAmt = objectValue.getDepositAmt();
        BigDecimal yearRate = objectValue.getDepYearRate();
        BigDecimal yearDays = new BigDecimal(String.valueOf(this.timeDepositBillInfo.getYearDays()));
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = objectValue.getIntRateTypeExpression();
        BigDecimal base = Constants.ONE_HUNDRED;
        if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
            base = Constants.ONE_THOUSAND;
        }
        BigDecimal tmp = yearRate.divide(yearDays.multiply(base), 8, 4);
        objectValue.setDeInterest(unDeposiAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(days))).setScale(8, 4));
    }

    @Override
    protected void txtCreInterest_dataChanged(DataChangeEvent arg0) throws Exception {
        this.setShijiAmt();
    }

    @Override
    protected void txtDeInterest_dataChanged(DataChangeEvent arg0) throws Exception {
        this.setShijiAmt();
    }

    private void setShijiAmt() {
        BigDecimal creInterest = this.txtCreInterest.getBigDecimalValue();
        BigDecimal deInterest = this.txtDeInterest.getBigDecimalValue();
        this.txtShijiAmt.setValue((Object)FMHelper.add((BigDecimal)creInterest, (BigDecimal)deInterest));
    }

    @Override
    protected void comboRateExpression_actionPerformed(ActionEvent e) {
        this.initRateLabTxt();
    }

    private void initRateLabTxt() {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        String strValue = "";
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contCreYearRate.setBoundLabelText(strValue);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCreYearRate.setBoundLabelText(strValue);
        } else {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCreYearRate.setBoundLabelText(strValue);
        }
    }

    private void calcCuInterst(CompIntReceivedBillInfo objectValue) {
        BigDecimal unDeposiAmt = objectValue.getDepositAmt();
        BigDecimal yearRate = objectValue.getCreYearRate();
        BigDecimal yearDays = new BigDecimal(String.valueOf(this.timeDepositBillInfo.getYearDays()));
        int days = 0;
        if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("matureUnDeposit")) {
            days = this.getCuDays(objectValue, 0);
        } else if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("aheadUnDeposit") || this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("unConsultUnDeposit")) {
            days = this.getCuDays(objectValue, 1);
        }
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = objectValue.getIntRateTypeExpression();
        BigDecimal base = Constants.ONE_HUNDRED;
        if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
            base = Constants.ONE_THOUSAND;
        }
        BigDecimal tmp = yearRate.divide(yearDays.multiply(base), 8, 4);
        objectValue.setCreInterest(unDeposiAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(days))).setScale(8, 4));
    }

    public BigDecimal calcCurrentAccrual(CompIntReceivedBillInfo objectValue) {
        BigDecimal result = Constants.ZERO;
        BigDecimal natualAmt = objectValue.getDepositAmt();
        BigDecimal rate = objectValue.getCreYearRate();
        BigDecimal yearDays = new BigDecimal(String.valueOf(this.timeDepositBillInfo.getYearDays()));
        int days = 0;
        BigDecimal base = Constants.ONE_HUNDRED;
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = objectValue.getIntRateTypeExpression();
        if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
            base = Constants.ONE_THOUSAND;
        }
        if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("matureUnDeposit")) {
            days = this.getCuDays(objectValue, 0);
        } else if (this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("aheadUnDeposit") || this.CompUnTimeDepositBillInfo.getUnDepositType().getValue().equals("unConsultUnDeposit")) {
            days = this.getCuDays(objectValue, 1);
        }
        BigDecimal intervalDays = new BigDecimal(String.valueOf(days));
        if (natualAmt != null && rate != null && yearDays != null && intervalDays != null) {
            BigDecimal tmp = Constants.ZERO;
            tmp = yearDays.multiply(base);
            result = natualAmt.multiply(intervalDays).multiply(rate).divide(tmp, 4);
        }
        return result;
    }

    private int getDeDays(String undeposit_value, CompIntReceivedBillInfo info) {
        int returnDays = 0;
        if (undeposit_value.equals("consultUnDeposit")) {
            returnDays = info.getIntervalDays();
        } else if (undeposit_value.equals("matureUnDeposit")) {
            returnDays = this.calcDaysBetweenTwoDate(this.timeDepositBillInfo.getEffectiveDate(), this.calcEndDate(this.timeDepositBillInfo.getMaturityDay()));
        }
        return returnDays;
    }

    private int getCuDays(CompIntReceivedBillInfo objectValue, int type) {
        int days = 0;
        if (0 == type) {
            int daysTmp = this.calcDaysBetweenTwoDate(this.timeDepositBillInfo.getMaturityDay(), objectValue.getEndDate());
            if (daysTmp > 0) {
                days = daysTmp;
            }
        } else if (1 == type) {
            days = this.calcDaysBetweenTwoDate(objectValue.getEffectiveDate(), objectValue.getEndDate());
        }
        return days;
    }

    private int calcDaysBetweenTwoDate(Date startDate, Date endDate) {
        long days = DateUtil.dateDiff((String)"d", (Date)startDate, (Date)endDate);
        return new Long(days).intValue() + 1;
    }

    private Date calcEndDate(Date billDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(billDate);
        c.add(5, -1);
        return c.getTime();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        UIUtil.setSelectObject((KDComboBox)this.comboIntReceiveType, (Object)this.editData.getIntReceiveType());
        this.editData.setIntervalDays(Math.abs(this.editData.getIntervalDays()));
        this.initRateLabTxt();
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        if (this.isRedopsitInt()) {
            this.editData.setDepYearRate(this.txtDepYearRate.getBigDecimalValue());
            this.editData.setCreInterest(this.txtCreInterest.getBigDecimalValue());
        } else if (!this.isUnTimeDepositInt()) {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
            this.editData.setDescription(this.txtDigest.getText());
            this.editData.setYingjiAmt(this.txtYingjiAmt.getBigDecimalValue());
        }
        this.editData.setIsreceived(false);
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    private int getIntervalDays(CompDepositAccountBillInfo info) {
        long beginTime = info.getEffectiveDate().getTime();
        long endTime = info.getMaturityDay().getTime();
        long betweenDays = (long)((double)((endTime - beginTime) / 86400000L) + 0.5);
        return new Long(betweenDays + 1L).intValue();
    }

    private BigDecimal getDeInterest(CompDepositAccountBillInfo info, BigDecimal yearRate, int intervalDays) {
        BigDecimal yearDays = new BigDecimal(String.valueOf(info.getYearDays()));
        BigDecimal remAmt = info.getBalance().subtract(info.getIntFreeAmt());
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = info.getIntRateTypeExpression();
        BigDecimal base = Constants.ONE_HUNDRED;
        if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
            base = Constants.ONE_THOUSAND;
        }
        BigDecimal tmp = yearRate.divide(yearDays.multiply(base), 8, 4);
        return remAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(intervalDays))).setScale(8, 4);
    }

    private BigDecimal getYearRate_Redeposit(CompDepositAccountBillInfo info, Date endDate) {
        BigDecimal returnValue = Constants.ZERO;
        if (info.getDepositType().getValue().equals("timedeposit") || info.getDepositType().getValue().equals("timedeposit_outer")) {
            returnValue = info.getRate();
        } else if (info.getDepositType().getValue().equals("calldeposit") || info.getDepositType().getValue().equals("calldeposit_outer")) {
            try {
                returnValue = TimeDepositHelper.getInstance().calcYearRate(null, info.getIntRateTable(), info.getCurrency(), endDate);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    private Date getIntBillEnDate(Date maturityDay) {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(maturityDay);
        endDate.add(5, -1);
        return endDate.getTime();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.pk1 = null;
        this.verify(e);
        if (this.isRedopsitInt()) {
            try {
                this.editData.setCompDepositAccountBillInfo((CompDepositAccountBillInfo)this.getUIContext().get("ObjectInfo_ID"));
                this.editData.setSourceBillId(this.editData.getCompDepositAccountBillInfo().getId().toString());
                this.editData.setAddNewType("2");
                super.actionSubmit_actionPerformed(e);
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                this.isSuccess = true;
                this.disposeUIWindow();
            }
            catch (Exception ex) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
                SysUtil.abort();
            }
        } else if (this.isPayInt()) {
            this.editData.setCompDepositAccountBillInfo((CompDepositAccountBillInfo)this.getUIContext().get("ObjectInfo_ID"));
            this.editData.setAddNewType("3");
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            this.isSuccess = true;
            this.btnSubmit.setEnabled(false);
            this.txtCreInterest.setEnabled(false);
            this.txtDeInterest.setEnabled(false);
            this.txtDigest.setEditable(false);
            this.btnSave.setVisible(false);
            this.pkBizDate.setEnabled(false);
        } else if (this.isUnTimeDepositInt()) {
            this.editData.setUnTimeDepositBillInfo((CompUnTimeDepositBillInfo)this.getUIContext().get("UnDipositID"));
            this.editData.setAddNewType("1");
            this.editData.setHasEffected(false);
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            this.isSuccess = true;
            this.disposeUIWindow();
        } else {
            this.editData.setAddNewType("intReceiveBill_save");
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    public boolean submitSuccess() {
        return this.isSuccess;
    }

    public Map getSubmitStatus() {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        hm.put("successFlag", new Boolean(this.isSuccess));
        hm.put("intBillID", (Boolean)this.pk);
        return hm;
    }

    private void setAutoNumber() {
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            try {
                if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    sysNumber = FrameWorkUtils.getCodeRuleClient((CoreBillBaseInfo)this.editData, (String)SysContext.getSysContext().getCurrentOrgUnit().getString("id"));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (sysNumber != null && sysNumber.trim().length() > 0) {
                this.editData.setNumber(sysNumber);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        CompIntReceivedBillInfo info = this.editData;
        String boName = "com.kingdee.eas.fm.fin.app.CompIntReceivedBill";
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)boName, null, (IObjectValue)info);
    }

    public static Map showIntReceiveEditUI(CoreUIObject ui, CoreBaseInfo info, String intbill_redeposit_value, String sourceBillID) {
        Map successStatus = null;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            if (info instanceof CompDepositAccountBillInfo) {
                uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
                uiContext.put((Object)"ObjectInfo_ID", (Object)info);
                uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
            } else if (info instanceof CompUnTimeDepositBillInfo) {
                uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
                uiContext.put((Object)"UnDipositID", (Object)info);
                uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceivedBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            if (uiWindow instanceof UIDialog) {
                FMClientHelper.settleUIDialogDimension((UIDialog)((UIDialog)uiWindow), (IUIObject)uiWindow.getUIObject());
            }
            uiWindow.show();
            successStatus = ((IntReceivedBillEditUI)uiWindow.getUIObject()).getSubmitStatus();
            Boolean flag = (Boolean)successStatus.get("successFlag");
            if (flag.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        return successStatus;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(INTRECEIVEDBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.IntReceivedBillTDQuery");
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(INTRECEIVEDBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected void prmpCurAcct_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = this.getFilterItems();
        evi.setFilter(filter);
        this.prmpCurAcct.setEntityViewInfo(evi);
        this.prmpCurAcct.getQueryAgent().resetRuntimeEntityView();
        super.prmpCurAcct_willShow(e);
    }

    private FilterInfo getFilterItems() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)company.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1), CompareType.EQUALS));
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)clearingHouse.getId().toString(), CompareType.EQUALS));
        return filter;
    }
}

