/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanAdjustInterestEditUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanAdjustInterestEditUI
extends AbstractLoanAdjustInterestEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanAdjustInterestEditUI.class);
    private boolean successFlag;
    private IntRateTypeInfo rateTypeInfo;
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanAdjustInterestFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.txtAdjustPenAccrualRate.setPrecision(5);
        this.txtAdjustPenAccrualRate.setHorizontalAlignment(4);
        this.txtAdjustPenAccrualRate.setRemoveingZeroInDispaly(false);
        this.txtAdjustPenAccrualRate.setRemoveingZeroInEdit(true);
        this.txtAdjustAfterRate.setPrecision(8);
        this.txtAdjustAfterRate.setRemoveingZeroInDispaly(false);
        this.txtAdjustAfterRate.setRemoveingZeroInEdit(true);
        this.txtAdjustAfterRate.setHorizontalAlignment(4);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
        this.txtRateAdjustPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtBasePoints.setPrecision(6);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtBasePoints.setSupportedEmpty(false);
        this.txtBasePoints.setMaximumValue((Comparable)Integer.valueOf(100));
        this.txtBasePoints.setMinimumValue((Comparable)Integer.valueOf(-100));
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.txtAdjustAfterRate.setNegatived(false);
        this.txtAdjustAfterRate.setSupportedEmpty(false);
        this.txtAdjustPenAccrualRate.setNegatived(false);
        this.txtAdjustPenAccrualRate.setSupportedEmpty(false);
        this.txtYearDays.setHorizontalAlignment(4);
        this.pkAdjustDate.setSupportedEmpty(false);
        this.dpFirstRateAdjustDate.setSupportedEmpty(false);
        this.txtNumber.setMaxLength(80);
        this.txtContractNum.setMaxLength(100);
        this.txtDescription.setMaxLength(150);
        this.comboIntRateTypeExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoanAdjustInterestEditUI.this.beforeActionPerformed(e);
                try {
                    LoanAdjustInterestEditUI.this.comboIntRateTypeExpression_actionPerformed(e);
                }
                catch (Exception exc) {
                    LoanAdjustInterestEditUI.this.handUIException(exc);
                }
                finally {
                    LoanAdjustInterestEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.comboPenAccrualType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoanAdjustInterestEditUI.this.beforeActionPerformed(e);
                try {
                    LoanAdjustInterestEditUI.this.comboPenAccrualType_actionPerformed(e);
                }
                catch (Exception exc) {
                    LoanAdjustInterestEditUI.this.handUIException(exc);
                }
                finally {
                    LoanAdjustInterestEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        } else {
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        }
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.kDLabelContainer2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"259_LoanAdjustInterestEditUI"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.kDLabelContainer2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"260_LoanAdjustInterestEditUI"));
        }
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        LoanInfo loanInfo = null;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.initAdjRate();
            if (this.getUIContext().get("LoanID") != null) {
                IObjectPK pk = (IObjectPK)this.getUIContext().get("LoanID");
                loanInfo = LoanFactory.getRemoteInstance().getLoanInfo(pk, this.getLoanInfoSelector());
            }
        } else if (this.editData.getLoan() != null) {
            loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.editData.getLoan().getId().toString()), this.getLoanInfoSelector());
        }
        this.initModifyRateType(loanInfo);
    }

    private void initModifyRateType(LoanInfo loanInfo) throws BOSException {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (!this.canLprConvert(loanInfo)) {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR);
            }
            if (!this.canLprModify(loanInfo)) {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR_Adjustment);
            }
            if ("lJlpCQEQEADgAAc+wKgSjiR9knQ=".equals(loanInfo.getIntRateType().getId().toString()) && loanInfo.isIsLPR()) {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.Agreement);
            }
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            if (IntRateModifyType.LPR.equals((Object)this.editData.getModifyRateType())) {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR_Adjustment);
            } else if (IntRateModifyType.LPR_Adjustment.equals((Object)this.editData.getModifyRateType())) {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR);
                this.combModifyRateType.removeItem((Object)IntRateModifyType.Agreement);
            } else {
                this.combModifyRateType.removeItem((Object)IntRateModifyType.LPR_Adjustment);
            }
        }
    }

    private boolean canLprConvert(LoanInfo loanInfo) {
        if (loanInfo.isIsLPR()) {
            return false;
        }
        return !loanInfo.getIntRateType().isIsLPR() || !loanInfo.getFloatAction().equals((Object)FloatActionEnum.LPR);
    }

    private boolean canLprModify(LoanInfo loanInfo) throws BOSException {
        return loanInfo.getIntRateType().isIsLPR() && loanInfo.getFloatAction().equals((Object)FloatActionEnum.LPR) || this.LprConverted(loanInfo);
    }

    private boolean LprConverted(LoanInfo info) throws BOSException {
        LoanAdjustInterestInfo adjInfo;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("IntRateType.isLPR"));
        evi.getSelector().add(new SelectorItemInfo("adjustSeq"));
        SorterItemInfo sort = new SorterItemInfo("adjustSeq");
        sort.setSortType(SortType.DESCEND);
        evi.getSorter().add(sort);
        LoanAdjustInterestCollection coll = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestCollection(evi);
        return coll.size() > 0 && (adjInfo = coll.get(0)).getIntRateType() != null && adjInfo.getIntRateType().isIsLPR();
    }

    private void initAdjRate() throws EASBizException, BOSException {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateType == null) {
            this.txtAdjustAfterRate.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else if (this.isXUEXILILV(intRateType)) {
            this.txtAdjustAfterRate.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else {
            this.txtAdjustAfterRate.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem())));
        }
    }

    protected boolean isXUEXILILV(IntRateTypeInfo intRateType) {
        return intRateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        }
    }

    protected void comboPenAccrualType_actionPerformed(ActionEvent e) {
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.kDLabelContainer2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"259_LoanAdjustInterestEditUI"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.kDLabelContainer2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"260_LoanAdjustInterestEditUI"));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkAdjustDate});
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        this.txtYearDays.setValue((Object)new Integer(this.editData.getYearDays()));
        this.txtAdjustAfterRate.setValue((Object)this.editData.getAdjustAfterRate());
        this.txtAdjustPenAccrualRate.setValue((Object)this.editData.getPenAccrualRate());
        this.prmtIntRateType.setData((Object)this.editData.getIntRateType());
        if (this.editData.getFloatAction() != null) {
            this.combFloatAction.setSelectedItem((Object)this.editData.getFloatAction());
        } else {
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
        }
        this.txtBasePoints.setValue((Object)this.editData.getBasePoints());
        if (this.editData.getFirstRateAdjustDate() != null) {
            this.dpFirstRateAdjustDate.setValue((Object)this.editData.getFirstRateAdjustDate());
        } else {
            this.dpFirstRateAdjustDate.setValue((Object)this.editData.getAdjustDate());
        }
        this.txtRateAdjustPeriod.setValue((Object)this.editData.getRateAdjustPeriod());
        if (this.editData.getModifyRateType() != null) {
            this.combModifyRateType.setSelectedItem((Object)this.editData.getModifyRateType());
        } else {
            LoanInfo loanInfo = null;
            if (this.getOprtState().equals(OprtState.ADDNEW) && this.getUIContext().get("LoanID") != null) {
                IObjectPK pk = (IObjectPK)this.getUIContext().get("LoanID");
                try {
                    loanInfo = LoanFactory.getRemoteInstance().getLoanInfo(pk, this.getLoanInfoSelector());
                    if (this.canLprConvert(loanInfo)) {
                        this.combModifyRateType.setSelectedItem((Object)IntRateModifyType.LPR);
                    } else if (this.canLprModify(loanInfo)) {
                        this.combModifyRateType.setSelectedItem((Object)IntRateModifyType.LPR_Adjustment);
                        this.dpFirstRateAdjustDate.setEnabled(false);
                        this.txtRateAdjustPeriod.setValue((Object)loanInfo.getRateAdjustPeriod());
                    } else {
                        this.combModifyRateType.setSelectedItem((Object)IntRateModifyType.Agreement);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"261_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
        if (this.txtAdjustPenAccrualRate.getBigDecimalValue().compareTo(Constants.ZERO) < 0 || this.txtAdjustPenAccrualRate.getBigDecimalValue().compareTo(Constants.ONE_HUNDRED) >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"263_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
    }

    public static void show(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"LoanID", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanAdjustInterestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((LoanAdjustInterestEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return false;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    public void checkDate() throws Exception {
        Date firstRateAdjustDate = this.dpFirstRateAdjustDate.getSqlDate();
        Date adjustDate = this.pkAdjustDate.getSqlDate();
        java.util.Date adjDate = (java.util.Date)this.pkAdjustDate.getValue();
        if (adjDate.before(this.editData.getLoan().getIssueDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"348_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateModifyType.equals((Object)IntRateModifyType.LPR) && !this.isFixedInterest(intRateType) && adjustDate.getTime() > firstRateAdjustDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"349_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
        java.util.Date lastSettleDate = null;
        java.util.Date comDate = null;
        java.util.Date lastPreDate = this.editData.getLoan().getLastPreIntDate();
        lastSettleDate = this.editData.getLoan().getLastIntDate();
        if (lastPreDate == null && lastSettleDate == null) {
            return;
        }
        comDate = lastSettleDate != null ? lastSettleDate : lastPreDate;
        if (lastSettleDate != null && lastPreDate != null) {
            comDate = lastSettleDate.getTime() > lastPreDate.getTime() ? lastSettleDate : lastPreDate;
        }
        if (adjDate.getTime() <= comDate.getTime()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"540_LoanAdjustInterestEditUI");
            msg = MessageFormat.format(msg, this.editData.getLoan().getNumber());
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSourceLoanIntRateType();
        this.checkDate();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkSourceLoanIntRateType();
        this.checkDate();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    private void checkSourceLoanIntRateType() {
        if (IntRateModifyType.Agreement.equals(this.combModifyRateType.getSelectedItem()) && !"lJlpCQEQEADgAAc+wKgSjiR9knQ=".equals(this.editData.getLoan().getIntRateType().getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"350_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
    }

    private IntRateTypeInfo getLprRate() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        view.setTopCount(1);
        IntRateTypeCollection rateColl = IntRateTypeFactory.getRemoteInstance().getIntRateTypeCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)rateColl)) {
            this.rateTypeInfo = rateColl.get(0);
            return this.rateTypeInfo;
        }
        return null;
    }

    protected IObjectValue createNewData() {
        LoanAdjustInterestInfo adjustInfo = new LoanAdjustInterestInfo();
        if (this.getUIContext().get("LoanID") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("LoanID");
            try {
                LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo(pk, this.getLoanInfoSelector());
                adjustInfo.setLoan(loanInfo);
                adjustInfo.setCreditorAsCompany(loanInfo.getGroupID());
                adjustInfo.setCreditorAsBank(loanInfo.getInstitution());
                adjustInfo.setAccount(loanInfo.getBankAcct());
                adjustInfo.setContractNum(loanInfo.getContractNum());
                adjustInfo.setAdjustSeq(LoanAdjustInterestFactory.getRemoteInstance().getMaxSeq(pk));
                adjustInfo.setAdjustDate(DateUtil.getDayBegin());
                adjustInfo.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
                adjustInfo.setYearDays(360);
                adjustInfo.setBasePoints(Constants.ZERO);
                adjustInfo.setAdjustAfterRate(Constants.ZERO);
                adjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
                adjustInfo.setPenAccrualRate(Constants.ZERO);
                adjustInfo.setIsUsed(IsOrNoEnum.NO);
                adjustInfo.setCreator(this.userinfo);
                adjustInfo.setCompany(loanInfo.getCompany());
                this.currentCompany = loanInfo.getCompany();
                adjustInfo.setIntRateType(this.getLprRate());
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"526_IntReceivePayDateChooseUI"), loanInfo.getNumber(), adjustInfo.getAdjustSeq());
                adjustInfo.setDescription(msgStr);
                this.baseCurrency = loanInfo.getCurrency();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            adjustInfo.setAdjustDate(DateUtil.getDayBegin());
            adjustInfo.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            adjustInfo.setYearDays(360);
            adjustInfo.setAdjustAfterRate(Constants.ZERO);
            adjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
            adjustInfo.setPenAccrualRate(Constants.ZERO);
            adjustInfo.setIsUsed(IsOrNoEnum.NO);
            adjustInfo.setCreator(this.userinfo);
            adjustInfo.setCompany(this.currentCompany);
        }
        return adjustInfo;
    }

    private SelectorItemCollection getLoanInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        sic.add(new SelectorItemInfo("GroupID.number"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("intRateType.isLPR"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("creditorAsCompany.id"));
        sic.add(new SelectorItemInfo("creditorAsCompany.name"));
        sic.add(new SelectorItemInfo("creditorAsCompany.number"));
        sic.add(new SelectorItemInfo("creditorAsBank.id"));
        sic.add(new SelectorItemInfo("creditorAsBank.name"));
        sic.add(new SelectorItemInfo("creditorAsBank.number"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("contractNum"));
        sic.add(new SelectorItemInfo("adjustSeq"));
        sic.add(new SelectorItemInfo("adjustDate"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("adjustAfterRate"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        LoanAdjustInterestInfo rateAdjustInfo = (LoanAdjustInterestInfo)this.getDataObject();
        if (rateAdjustInfo.getLoan() != null) {
            if (rateAdjustInfo.getLoan().isIsBankLoan()) {
                this.contCreditorAsCompany.setVisible(false);
                this.contCreditorAsBank.setVisible(true);
            } else {
                this.contCreditorAsCompany.setVisible(true);
                this.contCreditorAsBank.setVisible(false);
            }
        } else {
            this.contCreditorAsCompany.setVisible(true);
            this.contCreditorAsBank.setVisible(false);
        }
    }

    private void prmtModifyRateHide(boolean isHide) {
        if (isHide) {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 98, 290, 19, 261));
            super.add((Component)this.kDLabelContainer1, (Object)new KDLayout.Constraints(10, 120, 290, 19, 261));
            super.add((Component)this.contDescription, (Object)new KDLayout.Constraints(10, 164, 690, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(10, 186, 290, 19, 261));
            super.add((Component)this.contIntRateTypeExpression, (Object)new KDLayout.Constraints(320, 98, 380, 19, 137));
            super.add((Component)this.contAdjustAfterRate, (Object)new KDLayout.Constraints(320, 120, 380, 19, 137));
            super.add((Component)this.kDLabelContainer2, (Object)new KDLayout.Constraints(320, 142, 380, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(320, 186, 380, 19, 137));
        } else {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 166, 290, 19, 261));
            super.add((Component)this.kDLabelContainer1, (Object)new KDLayout.Constraints(10, 188, 290, 19, 261));
            this.contDescription.setBounds(new Rectangle(10, 210, 690, 19));
            this.add((Component)this.contDescription, new KDLayout.Constraints(10, 210, 690, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(10, 232, 290, 19, 261));
            this.add((Component)this.contIntRateTypeExpression, new KDLayout.Constraints(320, 142, 380, 19, 137));
            this.add((Component)this.contAdjustAfterRate, new KDLayout.Constraints(320, 164, 380, 19, 137));
            this.add((Component)this.kDLabelContainer2, new KDLayout.Constraints(320, 186, 380, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(320, 232, 380, 19, 137));
        }
    }

    private void prmtIntRateTypeHide(boolean isHide) {
        if (isHide) {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 120, 290, 19, 261));
            super.add((Component)this.kDLabelContainer1, (Object)new KDLayout.Constraints(10, 142, 290, 19, 261));
            super.add((Component)this.contDescription, (Object)new KDLayout.Constraints(10, 164, 690, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(10, 188, 290, 19, 261));
            super.add((Component)this.contIntRateTypeExpression, (Object)new KDLayout.Constraints(320, 98, 380, 19, 137));
            super.add((Component)this.contAdjustAfterRate, (Object)new KDLayout.Constraints(320, 120, 380, 19, 137));
            super.add((Component)this.kDLabelContainer2, (Object)new KDLayout.Constraints(320, 142, 380, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(320, 188, 380, 19, 137));
        } else {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 166, 290, 19, 261));
            super.add((Component)this.kDLabelContainer1, (Object)new KDLayout.Constraints(10, 188, 290, 19, 261));
            this.contDescription.setBounds(new Rectangle(10, 210, 690, 19));
            this.add((Component)this.contDescription, new KDLayout.Constraints(10, 210, 690, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(10, 232, 290, 19, 261));
            this.add((Component)this.contIntRateTypeExpression, new KDLayout.Constraints(320, 142, 380, 19, 137));
            this.add((Component)this.contAdjustAfterRate, new KDLayout.Constraints(320, 164, 380, 19, 137));
            this.add((Component)this.kDLabelContainer2, new KDLayout.Constraints(320, 186, 380, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(320, 232, 380, 19, 137));
        }
    }

    @Override
    protected void combModifyRateType_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            this.contIntRateType.setVisible(false);
            this.prmtIntRateType.setRequired(false);
            this.prmtIntRateType.setData(null);
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedItem(null);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setText(null);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            this.comboIntRateTypeExpression.setEnabled(true);
            this.comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtAdjustAfterRate.setEnabled(true);
            this.txtAdjustAfterRate.setValue((Object)Constants.ZERO);
            this.prmtModifyRateHide(true);
        } else if (IntRateModifyType.LPR.equals((Object)intRateModifyType)) {
            this.contIntRateType.setVisible(true);
            this.prmtIntRateType.setRequired(true);
            this.prmtIntRateType.setData((Object)this.rateTypeInfo);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"FixedRate", CompareType.EQUALS));
            filter.setMaskString("(#0 and #1) or #2");
            evi.setFilter(filter);
            this.prmtIntRateType.setEntityViewInfo(evi);
            this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            if (this.isFixedInterest(intRateType)) {
                this.txtYearDays.setEnabled(false);
                this.contBasePoints.setVisible(true);
                this.contIntRateTypeExpression.setEnabled(false);
            } else {
                this.contFloatAction.setVisible(true);
                this.combFloatAction.setEnabled(false);
                this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
                this.contBasePoints.setVisible(true);
                this.txtBasePoints.setRequired(true);
                this.txtBasePoints.setValue((Object)Constants.ZERO);
                this.contFirstRateAdjustDate.setVisible(true);
                this.setFirstAdjDate();
                this.contRateAdjustPeriod.setVisible(true);
                this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
                this.contMonth.setVisible(true);
                this.comboIntRateTypeExpression.setEnabled(false);
            }
            this.prmtModifyRateHide(false);
        } else if (IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) {
            this.contIntRateType.setVisible(true);
            this.prmtIntRateType.setRequired(true);
            this.prmtIntRateType.setData((Object)this.rateTypeInfo);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
            evi.setFilter(filter);
            this.prmtIntRateType.setEntityViewInfo(evi);
            this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setEnabled(false);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.contBasePoints.setVisible(true);
            this.txtBasePoints.setRequired(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.setFirstAdjDate();
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(true);
            this.comboIntRateTypeExpression.setEnabled(false);
            this.prmtModifyRateHide(false);
        }
    }

    private void setFirstAdjDate() {
        this.dpFirstRateAdjustDate.setValue((Object)this.pkAdjustDate.getSqlDate());
    }

    @Override
    protected void prmtIntRateType_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType) || this.isFixedInterest(intRateType)) {
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedIndex(-1);
            this.comboIntRateTypeExpression.setEnabled(true);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtAdjustAfterRate.setEnabled(true);
            this.txtAdjustAfterRate.setValue((Object)Constants.ZERO);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            if (this.isFixedInterest(intRateType)) {
                this.prmtIntRateTypeHide(true);
            }
        } else if (!IntRateModifyType.Agreement.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType)) {
            this.prmtIntRateTypeHide(false);
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.combFloatAction.setEnabled(false);
            this.contBasePoints.setVisible(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.setFirstAdjDate();
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)FinHelper.ZERO_INT);
            this.contMonth.setVisible(true);
            this.comboIntRateTypeExpression.setEnabled(false);
            this.txtYearDays.setEnabled(false);
            this.txtAdjustAfterRate.setEnabled(false);
            this.txtAdjustAfterRate.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem())));
            if (intRateType != null) {
                int intRate = intRateType.getFactorDay();
                String RateExpreValue = intRateType.getRateExpression().getValue();
                if (RateExpreValue.equals("year")) {
                    this.comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
                    this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
                } else if (RateExpreValue.equals("month")) {
                    this.comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.MONTH);
                    this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
                } else {
                    this.comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.DAY);
                    this.contAdjustAfterRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
                }
                this.txtYearDays.setValue((Object)new Integer(intRate));
            }
        }
    }

    @Override
    protected void pkAdjustDate_dataChanged(DataChangeEvent e) throws Exception {
        this.dpFirstRateAdjustDate.setValue((Object)this.pkAdjustDate.getSqlDate());
    }

    @Override
    protected void dpFirstRateAdjustDate_dataChanged(DataChangeEvent e) throws Exception {
        java.util.Date firstRateAdjDate = (java.util.Date)this.dpFirstRateAdjustDate.getValue();
        java.util.Date adjDate = (java.util.Date)this.pkAdjustDate.getValue();
        if (firstRateAdjDate != null && adjDate != null && firstRateAdjDate.getTime() < adjDate.getTime()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"351_LoanAdjustInterestEditUI"));
            this.dpFirstRateAdjustDate.setValue((Object)adjDate);
            SysUtil.abort();
        }
    }

    @Override
    protected void comboIntRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpress = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            this.txtYearDays.setText("360");
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
            this.txtYearDays.setText("30");
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.DAY)) {
            this.txtYearDays.setText("1");
        }
    }

    @Override
    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if (!IntRateModifyType.Agreement.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType)) {
            BigDecimal yieldRate = this.getYieldRate(intRateType, (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem()));
            this.txtAdjustAfterRate.setValue((Object)yieldRate);
            this.txtAdjustAfterRate.setEnabled(false);
        }
    }

    private BigDecimal getYieldRate(IntRateTypeInfo intRateType, FloatActionEnum floatAction) throws BOSException, EASBizException {
        java.util.Date date = DateTimeUtils.truncateDate((java.util.Date)this.pkAdjustDate.getSqlDate());
        BigDecimal bdBP = this.txtBasePoints.getBigDecimalValue();
        if (this.baseCurrency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), this.baseCurrency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    private boolean isFixedInterest(IntRateTypeInfo intRateType) {
        if (intRateType == null) {
            return false;
        }
        return intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    @Override
    protected void prmtIntRateType_willShow(SelectorEvent e) throws Exception {
        if (this.combModifyRateType.getSelectedItem() != null) {
            IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
            if (intRateModifyType.equals((Object)IntRateModifyType.LPR)) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo evi = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
                evi.setFilter(filter);
                this.prmtIntRateType.setEntityViewInfo(evi);
                this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            } else if (intRateModifyType.equals((Object)IntRateModifyType.LPR_Adjustment)) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo evi = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.TRUE));
                evi.setFilter(filter);
                this.prmtIntRateType.setEntityViewInfo(evi);
                this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            }
        }
    }
}

