/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.cl.modelutils.ClientUtils;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.LoanTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanApplyBillEditUI;
import com.kingdee.eas.fm.fin.client.F7FinancingProductsTreeUI;
import com.kingdee.eas.fm.fin.client.LetterOfCreditListUI;
import com.kingdee.eas.fm.fin.client.LoanApplyClientHelper;
import com.kingdee.eas.fm.fin.client.LoanModel;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanApplyBillEditUI
extends AbstractLoanApplyBillEditUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanApplyClientResource";
    private boolean isFromLetterOfCredit = false;
    private String letterOfCreditBillID = null;
    private static final Logger logger = CoreUIObject.getLogger(LoanApplyBillEditUI.class);
    private static final String tdTemplateFile = "/FM/FIN/LOANAPPLYBILL";

    protected void initUIProp() throws Exception {
        FpCashDirectionEnum[] fpFilters = new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other};
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])fpFilters, (boolean)true, (boolean)true);
        super.initUIProp();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
    }

    private void loadFieldsInterestCtrl() {
        try {
            IntRateTypeExpressionEnum intRateTypeExpressionEnum;
            if (this.editData.getIntRateType() == null) {
                ClientUtils.initControlsBeforeOnLoad(null, null, (KDBizPromptBox)this.prmtIntRateType);
            }
            this.txtBasePoints.setPrecision(6);
            this.txtYearDays.setPrecision(0);
            if (EmptyUtil.isEmpty((String)this.txtBasePoints.getText())) {
                this.txtBasePoints.setValue((Object)new Integer(0));
            }
            if (this.comboRateTypeExpression.getSelectedItem() == null) {
                this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            }
            if ((intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateTypeExpression.getSelectedItem()) == IntRateTypeExpressionEnum.YEAR) {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI"));
                this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"678_LoanEditUI"));
            } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
                this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"679_LoanEditUI"));
            } else {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
                this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"679_LoanEditUI"));
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "fin_loanapply_02addnew";
        }
        return "fin_loanapply_01view";
    }

    @Override
    public void loadFields() {
        Map listeners = null;
        try {
            listeners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        this.txtYieldRate.setPrecision(10);
        this.txtYieldRate.setRemoveingZeroInDispaly(false);
        this.comboGtInputMode.setSelectedItem((Object)this.editData.getGuaranteeTypeInputMode());
        this.prmtBank.setValue((Object)this.editData.getBank());
        if (EmptyUtil.isEmpty((String)this.txtHorizon.getText())) {
            this.txtHorizon.setValue((Object)new Integer(0));
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            LoanApplyClientHelper.loanPropertyChanged(this.comboLoanProperty, this.comboLoanType, false);
        }
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listeners);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.loadFieldsInterestCtrl();
        LoanApplyClientHelper.loanTypeChanged(this.comboLoanProperty, this.comboLoanType, this.contFinancingOrg, this.contBank, this.contCustomer);
        IntRateTypeInfo intRateInfo = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateInfo == null || ClientUtils.isConsultativeRate((IntRateTypeInfo)intRateInfo)) {
            this.txtBasePoints.setEnabled(false);
            this.comboRateTypeExpression.setEnabled(true);
            this.txtYearDays.setEnabled(true);
            this.txtYieldRate.setEnabled(true);
            this.combFloatAction.setEnabled(false);
        } else {
            this.txtBasePoints.setEnabled(this.getOprtState() != OprtState.VIEW);
            this.comboRateTypeExpression.setEnabled(false);
            this.txtYearDays.setEnabled(false);
            this.txtYieldRate.setEnabled(false);
            this.combFloatAction.setEnabled(true);
        }
        if (this.editData.getFloatAction() != null) {
            this.combFloatAction.setSelectedItem((Object)this.editData.getFloatAction());
        } else {
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.BASEINTRATE_FLOAT);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanApplyBillFactory.getRemoteInstance();
    }

    private void initInterestCtrl() throws Exception {
        this.txtYearDays.setPrecision(0);
        this.txtBasePoints.setEnabled(false);
        this.txtBasePoints.setPrecision(6);
    }

    @Override
    protected void comboRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == null || intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"678_LoanEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"679_LoanEditUI"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"679_LoanEditUI"));
        }
    }

    @Override
    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        super.txtBasePoints_dataChanged(e);
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateType == null || ClientUtils.isConsultativeRate((IntRateTypeInfo)intRateType)) {
            this.txtYieldRate.setValue((Object)new BigDecimal("0"));
        } else {
            this.txtYieldRate.setValue((Object)this.getYieldRate());
        }
    }

    @Override
    protected void combFloatAction_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        Date date = DateTimeUtils.truncateDate((Date)this.pkEffectiveDate.getSqlDate());
        BigDecimal bdBP = this.txtBasePoints.getBigDecimalValue();
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateType == null) {
            this.txtYieldRate.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else if (ClientUtils.isConsultativeRate((IntRateTypeInfo)intRateType)) {
            this.txtYieldRate.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else {
            FloatActionEnum floatActionEnum = null;
            Object obj = this.combFloatAction.getSelectedItem();
            floatActionEnum = obj == null ? FloatActionEnum.BASEINTRATE_FLOAT : (FloatActionEnum)((Object)obj);
            this.txtYieldRate.setValue((Object)this.getYieldRate());
        }
    }

    private BigDecimal getYieldRate() throws EASBizException, BOSException {
        BigDecimal bdBP;
        Date date;
        IntRateTypeInfo intRateType;
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        BigDecimal yieldRate = this.calcYieldRate(currency, intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData(), date = DateTimeUtils.truncateDate((Date)this.pkEffectiveDate.getSqlDate()), bdBP = this.txtBasePoints.getBigDecimalValue(), (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem()));
        if (yieldRate.signum() == -1) {
            yieldRate = Constants.ZERO;
        }
        return yieldRate;
    }

    private BigDecimal calcYieldRate(CurrencyInfo currency, IntRateTypeInfo intRateType, Date date, BigDecimal bdBP, FloatActionEnum floatAction) throws BOSException, EASBizException {
        BigDecimal bdYieldRate = Constants.ZERO;
        if (currency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
        }
        return bdYieldRate;
    }

    @Override
    protected void prmtIntRateType_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtIntRateType.getData();
        if (obj != null && obj.toString() != null && obj.toString().trim().length() == 0) {
            return;
        }
        IntRateTypeInfo intRateInfo = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateInfo == null || ClientUtils.isConsultativeRate((IntRateTypeInfo)intRateInfo)) {
            this.txtYieldRate.setEnabled(true);
            this.txtYieldRate.setValue((Object)new BigDecimal("0"));
            this.comboRateTypeExpression.setEnabled(true);
            this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI"));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"678_LoanEditUI"));
            this.txtBasePoints.setEnabled(false);
            this.txtBasePoints.setValue((Object)new BigDecimal("0"));
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.BASEINTRATE_FLOAT);
            this.combFloatAction.setEnabled(false);
        } else {
            this.combFloatAction.setEnabled(true);
            this.txtYieldRate.setEnabled(false);
            this.txtYieldRate.setValue((Object)this.getYieldRate());
            this.comboRateTypeExpression.setEnabled(false);
            if (intRateInfo != null) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("factorDay"));
                intRateInfo = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(intRateInfo.getId()), evi.getSelector());
                this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.getEnum((String)intRateInfo.getRateExpression().getValue()));
                this.txtYearDays.setEnabled(false);
                this.txtYearDays.setValue((Object)new Integer(intRateInfo.getFactorDay()));
                this.txtBasePoints.setEnabled(this.getOprtState() != OprtState.VIEW);
                String strContYieldRate = intRateInfo.getRateExpression().equals((Object)com.kingdee.eas.fm.common.IntRateTypeExpressionEnum.YEAR) ? EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI") : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI");
                String strBasePoints = intRateInfo.getRateExpression().equals((Object)com.kingdee.eas.fm.common.IntRateTypeExpressionEnum.YEAR) ? EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"678_LoanEditUI") : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"679_LoanEditUI");
                this.contYieldRate.setBoundLabelText(strContYieldRate);
                this.contBasePoints.setBoundLabelText(strBasePoints);
            }
        }
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboGtInputMode.addItems(GuaranteeTypeInputModeEnum.getEnumList().toArray());
        this.initComponent();
        this.initInterestCtrl();
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        this.actionCopyFrom.setVisible(false);
        this.actionCopy.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        this.txtHorizon.setPrecision(1);
        this.txtAreaPurpose.setMaxLength(255);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.txtYieldRate.setPrecision(10);
        this.txtYieldRate.setRemoveingZeroInDispaly(false);
        this.initFinProduct();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItems, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.LoanApplyBill", null, (IObjectValue)this.editData);
    }

    private void initFinProduct() throws Exception {
        this.prmtFinProduct.setQueryInfo("com.kingdee.eas.fm.fin.app.FinancingProductsQuery");
        this.prmtFinProduct.setDisplayFormat("$name$");
        this.prmtFinProduct.setEditFormat("$number$");
        this.prmtFinProduct.setCommitFormat("$number$");
        this.prmtFinProduct.setEntityViewInfo(LoanModel.getFinProductFilter(FinancingBillTypeEnum.Loan));
        this.prmtFinProduct.addSelectorListener(new SelectorListener(){
            F7FinancingProductsTreeUI prmtParent_F7ListUI = null;

            public void willShow(SelectorEvent e) {
                if (this.prmtParent_F7ListUI == null) {
                    try {
                        this.prmtParent_F7ListUI = new F7FinancingProductsTreeUI();
                    }
                    catch (Exception e1) {
                        LoanApplyBillEditUI.this.handUIException(e1);
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(1), CompareType.EQUALS));
                    this.prmtParent_F7ListUI.setFilterInfo(filter);
                    HashMap<String, Window> ctx = new HashMap<String, Window>();
                    ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor((Component)((Object)this.prmtParent_F7ListUI)));
                    this.prmtParent_F7ListUI.setF7Use(true, ctx);
                    LoanApplyBillEditUI.this.prmtFinProduct.setSelector((KDPromptSelector)this.prmtParent_F7ListUI);
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        UIUtil.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkApplyDate});
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    private void initComponent() throws Exception {
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank, (boolean)true);
        this.pkEffectiveDate.setSupportedEmpty(false);
        this.pkMaturityDate.setSupportedEmpty(false);
        this.pkApplyDate.setSupportedEmpty(false);
        this.txtApplyLoanAmt.setSupportedEmpty(false);
        this.comboLoanType.removeItem((Object)LoanTypeEnum.EntLoan);
        this.prmtFinancingOrg.setEnabledMultiSelection(false);
        this.prmtBank.setEnabledMultiSelection(false);
        this.actionAddNew.setVisible(false);
        if (this.getBOTPViewStatus() == 1) {
            this.comboLoanProperty.setEnabled(false);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1) {
            ((LoanApplyBillInfo)dataObject).setCompany(this.currentCompany);
            ((LoanApplyBillInfo)dataObject).setCreator(this.userinfo);
            ((LoanApplyBillInfo)dataObject).setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
            this.isFromLetterOfCredit((LoanApplyBillInfo)dataObject);
        }
    }

    private void isFromLetterOfCredit(LoanApplyBillInfo info) {
        BOSObjectType bosType;
        if (info.getSourceBillId() != null && (bosType = BOSUuid.read((String)info.getSourceBillId()).getType()).equals((Object)LetterOfCreditInfo.BOSTYPE)) {
            this.isFromLetterOfCredit = true;
            this.letterOfCreditBillID = info.getSourceBillId();
        }
    }

    protected IObjectValue createNewData() {
        LoanApplyBillInfo info = new LoanApplyBillInfo();
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setApplyDate(new Timestamp(System.currentTimeMillis()));
        info.setLoanProperty(LoanPropertyEnum.OutGroup);
        info.setLoanType(LoanTypeEnum.Bank);
        info.setApplyLoanAmt(Constants.ZERO);
        info.setEffectiveDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setMaturityDate(info.getEffectiveDate());
        info.setStatus(LoanApplyBillStatusEnum.SAVE);
        info.setHorizon(FinHorizon.getHorizon(info.getEffectiveDate(), info.getMaturityDate()));
        info.setCompany(this.currentCompany);
        info.setCreator(this.userinfo);
        info.setIsGenLoanBill(false);
        info.setIsGenLoanOrgBill(false);
        info.setYieldRate(new BigDecimal("0.0000000000"));
        info.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.assure);
        info.setBasePoints(Constants.ZERO);
        info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtIntRateType, (boolean)true);
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        this.doBizVerify();
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtYieldRate);
        if (this.editData.getYieldRate().compareTo(new BigDecimal("100")) >= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"271_LoanApplyBillEditUI"));
            SysUtil.abort();
        }
    }

    private void doBizVerify() {
        if (this.txtApplyLoanAmt.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"apply_amt_error"));
            this.txtApplyLoanAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.pkEffectiveDate.getSqlDate().compareTo(this.pkMaturityDate.getSqlDate()) >= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"enddate_error"));
            this.pkMaturityDate.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void comboLoanProperty_itemStateChanged(ItemEvent e) throws Exception {
        LoanApplyClientHelper.loanPropertyChanged(this.comboLoanProperty, this.comboLoanType, false);
        this.prmtAccountBank.setValue(null);
        FMClientHelper.setFilter_FinancingOrg((KDBizPromptBox)this.prmtFinancingOrg);
    }

    @Override
    protected void comboLoanType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtFinancingOrg.setValue(null);
        this.prmtBank.setValue(null);
        LoanApplyClientHelper.loanTypeChanged(this.comboLoanProperty, this.comboLoanType, this.contFinancingOrg, this.contBank, this.contCustomer);
        this.prmtFinancingOrg.setRequired(this.contFinancingOrg.isVisible());
        this.prmtBank.setRequired(this.contBank.isVisible());
    }

    @Override
    protected void pkEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calaHorison();
        if (this.txtYieldRate.getValue() == null || this.txtYieldRate.getBigDecimalValue().compareTo(Constants.ZERO) == 0) {
            this.txtYieldRate.setValue((Object)this.getYieldRate());
        }
        this.txtYearDays.setPrecision(0);
    }

    @Override
    protected void pkMaturityDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calaHorison();
    }

    private void calaHorison() {
        if (this.pkEffectiveDate.getValue() == null || this.pkMaturityDate.getValue() == null) {
            this.txtHorizon.setValue((Object)Constants.ZERO);
        } else {
            this.txtHorizon.setValue((Object)FinHorizon.getHorizon(this.pkEffectiveDate, this.pkMaturityDate));
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.txtYieldRate.setValue((Object)this.getYieldRate());
        this.txtYearDays.setPrecision(0);
    }

    @Override
    protected void prmtAccountBank_willCommit(CommitEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo acctBank = (AccountBankInfo)this.prmtAccountBank.getValue();
        if (acctBank == null) {
            this.prmtBank.setValue(null);
            this.comboCurrency.setEnabled(true);
        } else {
            if (acctBank.getBank() != null && this.comboLoanProperty.getSelectedItem().equals((Object)LoanPropertyEnum.OutGroup)) {
                BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(acctBank.getBank().getId().toString()));
                this.prmtBank.setValue((Object)bank);
            }
            if (acctBank.isIsByCurrency()) {
                UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)acctBank.getCurrency());
                this.comboCurrency.setEnabled(false);
            } else {
                this.comboCurrency.setEnabled(true);
            }
        }
    }

    protected void setprmtDistributeAcctBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        String currencyID = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3) ");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    public void initDataStatus() {
        super.initDataStatus();
        LoanApplyBillInfo loanApplyInfo = (LoanApplyBillInfo)this.getDataObject();
        this.setVisiableFroLoaner(loanApplyInfo);
        this.setOtherControls();
        boolean isSave = loanApplyInfo.getStatus() == LoanApplyBillStatusEnum.SAVE;
        this.actionSave.setVisible(isSave);
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.actionTDPrint.setVisible(false);
            this.actionTDPrintPreview.setVisible(false);
        }
        if (this.getOprtState() == OprtState.EDIT) {
            this.txtNumber.setEnabled(false);
        }
    }

    private void setOtherControls() {
        boolean isFlag = !this.getOprtState().equals(OprtState.ADDNEW) && !this.getOprtState().equals(OprtState.EDIT);
        this.actionPre.setEnabled(isFlag);
        this.actionPre.setVisible(isFlag);
        this.actionNext.setEnabled(isFlag);
        this.actionNext.setVisible(isFlag);
        this.actionFirst.setEnabled(isFlag);
        this.actionFirst.setVisible(isFlag);
        this.actionLast.setEnabled(isFlag);
        this.actionLast.setVisible(isFlag);
        this.actionPrint.setVisible(isFlag);
        this.actionPrintPreview.setVisible(isFlag);
        this.actionEdit.setVisible(isFlag);
        this.actionRemove.setVisible(isFlag);
    }

    private void setVisiableFroLoaner(LoanApplyBillInfo loanApplyInfo) {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)loanApplyInfo)) {
            boolean isVisiableFinacring = false;
            boolean isVisiableBank = false;
            if (loanApplyInfo.getLoanProperty() == LoanPropertyEnum.InGroup) {
                isVisiableFinacring = true;
            } else if (loanApplyInfo.getLoanProperty() == LoanPropertyEnum.OutGroup) {
                isVisiableBank = true;
            }
            this.contFinancingOrg.setVisible(isVisiableFinacring);
            this.prmtFinancingOrg.setRequired(isVisiableFinacring);
            this.contBank.setVisible(isVisiableBank);
            this.prmtBank.setRequired(isVisiableBank);
        } else {
            this.contFinancingOrg.setVisible(false);
            this.prmtFinancingOrg.setRequired(false);
            this.contCustomer.setVisible(false);
            this.prmtCustomer.setRequired(false);
            this.contBank.setVisible(true);
            this.prmtBank.setRequired(true);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFromLetterOfCredit) {
            this.actionSubmit_actionPerformed(e);
        } else {
            super.actionSave_actionPerformed(e);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFromLetterOfCredit) {
            this.verifyInput(e);
            int res = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"submitReturnCreditLimit"));
            if (res == 0) {
                FMClientHelper.generateDestBill((CoreBillListUI)new LetterOfCreditListUI(), (String)new LetterOfCreditInfo().getBOSType().toString(), (String)new RepaymentInfo().getBOSType().toString(), (String)this.letterOfCreditBillID, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory", (BigDecimal)this.txtApplyLoanAmt.getBigDecimalValue());
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            super.actionSubmit_actionPerformed(e);
            this.getUIWindow().close();
        } else {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void editCheck() throws Exception {
        if (this.editData.isIsGenLoanBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error2"));
            SysUtil.abort();
        }
        if (this.editData.isIsGenLoanOrgBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error3"));
            SysUtil.abort();
        }
        if (this.editData.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error1"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.removeCheck();
        super.actionRemove_actionPerformed(e);
    }

    private void removeCheck() throws Exception {
        if (this.editData.isIsGenLoanBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error2"));
            SysUtil.abort();
        }
        if (this.editData.isIsGenLoanOrgBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error3"));
            SysUtil.abort();
        }
        if (this.editData.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error1"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("financingOrg.id"));
        sic.add(new SelectorItemInfo("financingOrg.number"));
        sic.add(new SelectorItemInfo("financingOrg.name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("finProduct.name"));
        sic.add(new SelectorItemInfo("IntRateType.id"));
        sic.add(new SelectorItemInfo("IntRateType.name"));
        sic.add(new SelectorItemInfo("IntRateType.number"));
        sic.add("bgItemID");
        sic.add("bgItemNumber");
        sic.add("bgItemName");
        sic.add("fundFlowItem.*");
        return sic;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData.getId() == null || this.editData.getId().toString().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"noSaveBill"));
            SysUtil.abort();
        }
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected boolean isModifySave() {
        return this.editData.getStatus().equals((Object)LoanApplyBillStatusEnum.SAVE);
    }

    public boolean checkBeforeWindowClosing() {
        boolean idsInProcess = false;
        try {
            if (!EmptyUtil.isEmpty((Object)this.editData.getId())) {
                idsInProcess = FMHelper.hasWFInstance(null, (String)this.editData.getId().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("FINDVIEW".equalsIgnoreCase(this.getOprtState()) || idsInProcess) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.LoanApplyBillTDQuery");
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("fromLoanApply", "LoanApplyBill");
        this.getBillEdit().createFrom(null, ctx);
    }

    public int getBtpCreateFromType() {
        return 0;
    }
}

