/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinancingResultEnum;
import com.kingdee.eas.fm.fin.ILoanApplyBill;
import com.kingdee.eas.fm.fin.LoanApplyBillCollection;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanApplyException;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.client.AbstractLoanApplyBillListUI;
import com.kingdee.eas.fm.fin.client.ChangeFinResultUI;
import com.kingdee.eas.fm.fin.client.LoanApplyBillDataProvider;
import com.kingdee.eas.fm.fin.client.LoanApplyBillEditUI;
import com.kingdee.eas.fm.fin.client.LoanApplyBillFilterParam;
import com.kingdee.eas.fm.fin.client.LoanApplyBillFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanApplyBillListUI
extends AbstractLoanApplyBillListUI
implements IDelegationSupport {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanApplyClientResource";
    private static final Logger logger = CoreUIObject.getLogger(LoanApplyBillListUI.class);
    private LoanApplyBillFilterUI filterUI;
    private static boolean FIN022 = false;
    FillListener fillListener = new FillListener();
    private static final String tdTemplateFile = "/FM/FIN/LOANAPPLYBILL";

    public void onLoad() throws Exception {
        FIN022 = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN022", (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId()));
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.actionCreateTo.setEnabled(false);
        this.actionCopyTo.setVisible(false);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("maturityDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public SelectorItemCollection getSelectorsForViewBdgBalance() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("usePayableCo.*"));
        sic.add(new SelectorItemInfo("provideCoAccount.*"));
        sic.add(new SelectorItemInfo("payBank.*"));
        sic.add(new SelectorItemInfo("receiverSp.*"));
        sic.add(new SelectorItemInfo("receiveCoAccount.*"));
        sic.add(new SelectorItemInfo("applayCompany.*"));
        sic.add(new SelectorItemInfo("noteType.*"));
        sic.add(new SelectorItemInfo("provideCo.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("receiverCp.*"));
        sic.add(new SelectorItemInfo("receiveCoBank.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanApplyBillInfo info = (LoanApplyBillInfo)((ILoanApplyBill)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id), this.getSelectorsForViewBdgBalance());
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        info.setCompany(company);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.LoanApplyBill", null, (IObjectValue)info);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeBtnCreateToStatus();
    }

    private void changeBtnCreateToStatus() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanApplyBillInfo info = (LoanApplyBillInfo)((ILoanApplyBill)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id));
        if (info != null && !info.isIsGenLoanBill() && LoanApplyBillStatusEnum.AUDITED == info.getStatus() && 0 != info.getFinancingResult().getValue()) {
            this.actionCreateTo.setEnabled(true);
        } else {
            this.actionCreateTo.setEnabled(false);
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.isIsGenLoanOrgBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"592_LoanApply"));
            this.abort();
        }
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            this.abort();
        }
        try {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            if (FIN022) {
                FMClientHelper.generateDestBillWithCU((CtrlUnitInfo)orgUnitInfo, (CoreBillListUI)this, (String)LoanApplyBillInfo.BOSTYPE.toString(), (String)LoanContractInfo.BOSTYPE.toString(), (String)id);
            } else {
                FMClientHelper.generateDestBillWithCU((CtrlUnitInfo)orgUnitInfo, (CoreBillListUI)this, (String)LoanApplyBillInfo.BOSTYPE.toString(), (String)LoanInfo.BOSTYPE.toString(), (String)id);
            }
        }
        catch (Exception ex) {
            iMutex.releaseObjIDForUpdate(id);
            throw ex;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionChangeResult.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected String getEditUIName() {
        return LoanApplyBillEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return super.getEditUIModal();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanApplyBillFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void submitCheck() throws Exception {
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"submit_error"));
            SysUtil.abort();
        }
    }

    private void editCheck() throws Exception {
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.isIsGenLoanBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error2"));
            SysUtil.abort();
        }
        if (info.isIsGenLoanOrgBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error3"));
            SysUtil.abort();
        }
        if (info.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"edit_error1"));
            SysUtil.abort();
        }
    }

    private LoanApplyBillInfo getSelectedInfo() throws Exception {
        this.checkSelected();
        return LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.removeCheck();
        super.actionRemove_actionPerformed(e);
    }

    private void removeCheck() throws Exception {
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.isIsGenLoanBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error2"));
            SysUtil.abort();
        }
        if (info.isIsGenLoanOrgBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error3"));
            SysUtil.abort();
        }
        if (info.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"delete_error1"));
            SysUtil.abort();
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        LoanPropertyEnum loanPro = LoanPropertyEnum.OutGroup;
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("LoanApplyBillType") != null) {
            loanPro = (LoanPropertyEnum)((Object)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("LoanApplyBillType"));
        }
        if (this.getBOTPViewStatus() == 1) {
            // empty if block
        }
        if (this.filterUI == null) {
            this.filterUI = new LoanApplyBillFilterUI(loanPro);
        }
        return this.filterUI;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAudit();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        LoanApplyBillFactory.getRemoteInstance().batchAudit(IDs);
        this.refreshList();
    }

    private void checkAudit() throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("status").getValue();
            if (status.getInt() == 0) {
                throw new LoanApplyException(LoanApplyException.SAVE_BILL_AUDIT_ERROR, new Object[]{row.getCell("number").getValue()});
            }
            if (status.getInt() != 3) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"274_LoanApplyBillListUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAntiAudit();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        LoanApplyBillFactory.getRemoteInstance().batchAntiAudit(IDs);
        this.refreshList();
    }

    private void checkAntiAudit() throws Exception {
        this.checkSelected();
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(new HashSet(this.getSelectedIdValues()));
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            if (tmpInfo.isIsGenLoanBill()) {
                throw new LoanApplyException(LoanApplyException.HAS_GEN_LOAN_BILL, new Object[]{tmpInfo.getNumber()});
            }
            if (tmpInfo.isIsGenLoanOrgBill()) {
                throw new LoanApplyException(LoanApplyException.HAS_GEN_LOAN_ORG_BILL, new Object[]{tmpInfo.getNumber()});
            }
            if (tmpInfo.getStatus() == LoanApplyBillStatusEnum.AUDITED) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"275_LoanApplyBillListUI"));
            SysUtil.abort();
        }
    }

    private LoanApplyBillCollection getLoanApplyCol(Set idSet) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillCollection(evi);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("financingOrg.number"));
        sic.add(new SelectorItemInfo("bank.bankAreaType"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("finProduct.id"));
        sic.add(new SelectorItemInfo("finProduct.number"));
        sic.add(new SelectorItemInfo("finProduct.name"));
        sic.add(new SelectorItemInfo("finProduct.FinancingSource"));
        sic.add("bgItemID");
        sic.add("bgItemNumber");
        sic.add("bgItemName");
        return sic;
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        List returnMsg = new ArrayList();
        try {
            this.checkSelected();
            this.submitCheck();
            returnMsg = LoanApplyBillFactory.getRemoteInstance().batchSubmit(new HashSet(this.getSelectedIdValues()));
        }
        catch (Exception ex) {
            if (!(ex instanceof AbortException)) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.showMsg(returnMsg);
        this.refreshList();
    }

    private void showMsg(List returnMsg) {
        String msg = this.getMsgFromList(returnMsg);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    private String getMsgFromList(List returnMsg) {
        if (returnMsg.size() == 0) {
            return EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"276_LoanApplyBillListUI");
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < returnMsg.size(); ++i) {
            sb.append(returnMsg.get(i).toString()).append("\n");
        }
        return sb.toString();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (null == filter) {
            filter = new FilterInfo();
        }
        filter.getFilterItems().add(new FilterItemInfo("isBond", (Object)0));
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
                if (null == filter) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
                filter.getFilterItems().add(new FilterItemInfo("isGenLoanOrgBill", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("financingOrg.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
                return filter;
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoan") != null) {
                String companyid;
                Map btp = (Map)this.getUIContext().get("BTPEDITPARAMETER");
                if (null == filter) {
                    filter = new FilterInfo();
                }
                if ((companyid = (String)btp.get("CurrencyID")) == null) {
                    companyid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
                }
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
                filter.getFilterItems().add(new FilterItemInfo("isGenLoanBill", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("financingResult", (Object)0, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isGenLoanOrgBill", (Object)Boolean.FALSE));
                return filter;
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoanContract") != null) {
                if (null == filter) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
                filter.getFilterItems().add(new FilterItemInfo("isGenLoanBill", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
                return filter;
            }
        }
        return filter;
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            String targetBillType = (String)btpeditparameter.get("TargetBill");
            if (targetBillType != null && "Loan".equals(targetBillType)) {
                this.getUIContext().put("LoanApplyBillType", LoanPropertyEnum.OutGroup);
                filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoanBill", (Object)Boolean.FALSE));
                filterInfo.getFilterItems().add(new FilterItemInfo("financingResult", (Object)new Integer(1)));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
                CompanyOrgUnitInfo currentCompanyParam = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyParam.getId().toString()));
            } else if (targetBillType != null && "LoanContract".equals(targetBillType)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoanBill", (Object)Boolean.FALSE));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
                CompanyOrgUnitInfo currentCompanyParam = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyParam.getId().toString()));
            }
        }
        if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BTPCreateMode") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        }
        return filterInfo;
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0 && this.getBOTPViewStatus() == 1) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanApplyBillFilterParam param = (LoanApplyBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.LoanApply).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionChangeResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Object row = null;
        HashSet<String> ids = new HashSet<String>();
        Boolean isGenLoanBill = null;
        int billstatus = 0;
        int finResult = 0;
        HashSet<Integer> results = new HashSet<Integer>();
        LoanApplyBillCollection loanApplyColl = LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillCollection("select isGenLoanBill, status, financingResult where id in " + FMHelper.setTran2String(new HashSet(idList)));
        for (int i = 0; i < loanApplyColl.size(); ++i) {
            LoanApplyBillInfo loanApplyBillInfo = loanApplyColl.get(i);
            isGenLoanBill = loanApplyBillInfo.getBoolean("isGenLoanBill");
            billstatus = (Integer)loanApplyBillInfo.get("status");
            finResult = (Integer)loanApplyBillInfo.get("financingResult");
            if (isGenLoanBill.booleanValue() || 3 != billstatus) continue;
            ids.add(loanApplyBillInfo.get("id").toString());
            results.add(finResult);
        }
        if (results.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"msg001"));
            SysUtil.abort();
        } else if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"msg002"));
            SysUtil.abort();
        } else {
            Map uiContext = this.getUIContext();
            uiContext.put("oldValue", FinancingResultEnum.getEnum(finResult));
            if (idList.size() == ids.size()) {
                FinancingResultEnum en = ChangeFinResultUI.showChangeFinResultUI((CoreUI)this, uiContext);
                if (en != null) {
                    LoanApplyBillFacadeFactory.getRemoteInstance().changeFinResult(ids, en);
                    this.refreshList();
                }
            } else {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"msg003"));
                if (result == 0) {
                    uiContext.put("oldValue", FinancingResultEnum.getEnum((Integer)results.toArray()[0]));
                    FinancingResultEnum en = ChangeFinResultUI.showChangeFinResultUI((CoreUI)this, uiContext);
                    if (en != null) {
                        LoanApplyBillFacadeFactory.getRemoteInstance().changeFinResult(ids, en);
                        this.refreshList();
                    }
                }
            }
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        LoanApplyBillDataProvider data = new LoanApplyBillDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.LoanApplyBillTDQuery");
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        destBosTypeList.clear();
        LoanInfo info = new LoanInfo();
        String addBosType = info.getBOSType().toString();
        destBosTypeList.add(addBosType);
        return destBosTypeList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LoanApplyBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                String rateExpression;
                row = tblMain.getRow(i);
                Integer precesion = (Integer)row.getCell("currency.precision").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
                row.getCell("horizon").getStyleAttributes().setNumberFormat("%r{#,##0.0}f");
                row.getCell("horizon").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("basePoints").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("basePoints").getStyleAttributes().setNumberFormat("###,##0.000000\\%");
                row.getCell("yearDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ICell yrc = row.getCell("yieldRate");
                yrc.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (row.getCell("intRateTypeExpression").getValue() == null || (rateExpression = row.getCell("intRateTypeExpression").getValue().toString()) == null) continue;
                if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                    yrc.getStyleAttributes().setNumberFormat("###,##0.0000000000\\%");
                    row.getCell("basePoints").getStyleAttributes().setNumberFormat("###,##0.000000\\%");
                    continue;
                }
                yrc.getStyleAttributes().setNumberFormat("###,##0.0000000000\\\u2030");
                row.getCell("basePoints").getStyleAttributes().setNumberFormat("###,##0.000000\\\u2030");
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "applyLoanAmt", format);
            this.setNumberFormat(row, "basePoints", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

