/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.LoanDeferFactory;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.client.AbstractLoanDeferListUI;
import com.kingdee.eas.fm.fin.client.FinListProcessUtils;
import com.kingdee.eas.fm.fin.client.LoanDeferEditUI;
import com.kingdee.eas.fm.fin.client.LoanDeferFilterUI;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanDeferListUI
extends AbstractLoanDeferListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanDeferListUI.class);
    private LoanDeferFilterUI filterUI;
    private LoanDeferInfo loanDeferInfo;
    FillListener fillListener = new FillListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.loanDeferInfo = this.getDeferInfo();
        this.checkSeq(this.loanDeferInfo, 2);
        if (this.loanDeferInfo.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"278_LoanDeferListUI"));
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanDeferFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanDeferFactory.getRemoteInstance();
    }

    protected void checkOnlyUnion() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompanyCommon)) {
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        } else {
            this.btnAddNew.setVisible(true);
            this.menuItemAddNew.setVisible(true);
            this.btnEdit.setVisible(true);
            this.menuItemEdit.setVisible(true);
            this.btnRemove.setVisible(true);
            this.menuItemRemove.setVisible(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkOnlyUnion();
        IColumn exchangeRateColumn = this.tblMain.getColumn("exchangeRate");
        exchangeRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        exchangeRateColumn.getStyleAttributes().setNumberFormat("%r{#,##0.0000}f");
        IColumn yearDaysColumn = this.tblMain.getColumn("yearDays");
        yearDaysColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("beforeDeferDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("afterDeferDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected String getEditUIName() {
        return LoanDeferEditUI.class.getName();
    }

    private void checkCanModify(LoanDeferInfo info) throws Exception {
        this.checkSelected();
        if (info.isFivouchered()) {
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR2);
        }
        if (info.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"279_LoanDeferListUI"));
            this.abort();
        }
        this.checkSeq(info, 1);
    }

    private void checkSeq(LoanDeferInfo info, int type) throws Exception {
        Map map = LoanDeferFactory.getRemoteInstance().getInitDate((IObjectPK)new ObjectUuidPK(info.getLoan().getId().toString()));
        Integer maxSeq = (Integer)map.get("maxDeferSeq");
        if (info.getSeq() != maxSeq - 1) {
            if (type == 1) {
                throw new CHLoanException(CHLoanException.POSTPONE_ERROR3);
            }
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR4);
        }
    }

    private LoanDeferInfo getDeferInfo() throws Exception {
        return LoanDeferFactory.getRemoteInstance().getLoanDeferInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        this.loanDeferInfo = this.getDeferInfo();
        if (this.loanDeferInfo.getChLoanExtendBill() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"280_LoanDeferListUI"));
            this.abort();
        }
        this.checkCanModify(this.loanDeferInfo);
        super.actionEdit_actionPerformed(e);
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FinListProcessUtils.antiAudit((ListUI)this, this.tblMain, this.getSelectedIdValues());
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FinListProcessUtils.audit((ListUI)this, this.tblMain, this.getSelectedIdValues());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        String selectedKeyValue = this.getSelectedKeyValue();
        if (selectedKeyValue == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectedKeyValue));
        LoanDeferInfo info = (LoanDeferInfo)this.getBizInterface().getValue((IObjectPK)pk, selector);
        if (StatusExtEnum.AUDIT == info.getStatusExtEnum()) {
            if (info.isFivouchered()) {
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(true);
                this.actionAntiAudit.setEnabled(false);
            } else {
                this.actionVoucher.setEnabled(true);
                this.actionDelVoucher.setEnabled(false);
                this.actionAntiAudit.setEnabled(true);
            }
        } else {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("fromBankLoan", "TraceUp");
        this.getUIContext().put("addType", hm);
        super.actionTraceUp_actionPerformed(e);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LoanDeferListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("curid").getValue();
                FMClientHelper.setNumberFormat((IRow)row, (String)"balance", (String)currencyId);
                if (LoanDeferListUI.this.baseCurrencyCommon != null) {
                    String baseCurrency = LoanDeferListUI.this.baseCurrencyCommon.getId().toString();
                    FMClientHelper.setNumberFormat((IRow)row, (String)"localAmount", (String)baseCurrency);
                }
                String rateFormat = "";
                BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
                Object enu = exp.getValue();
                rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("deferRate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("deferRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                exp = (BizEnumValueInfo)row.getCell("penaIntType").getValue();
                enu = exp.getValue();
                rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("peneIntRate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("peneIntRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

