/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FromBillType;
import com.kingdee.eas.fm.fin.LoanExhBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanExhibitionFactory;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanExhibitionEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LoanExhibitionEditUI
extends AbstractLoanExhibitionEditUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanRepayResource";
    private static final Logger logger = CoreUIObject.getLogger(LoanExhibitionEditUI.class);

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        super.onLoad();
        this.contLoanBalance.setEnabled(false);
        this.contLocalAmount.setEnabled(false);
        this.contExhBeforeDate.setEnabled(false);
        this.contSourceBillType.setEnabled(false);
        this.contSourceBillNumber.setEnabled(false);
        this.contCreator.setEnabled(false);
        this.contCompany.setEnabled(false);
        if (FromBillType.Loan.equals((Object)this.editData.getSourceBillType()) && this.editData.getLoanBank() != null) {
            this.contCreditors.setVisible(false);
            this.prmtCreditors.setRequired(false);
            this.kDLabelContainer3.setVisible(true);
            this.prmtLoanBank.setRequired(true);
        } else {
            this.contCreditors.setVisible(true);
            this.prmtCreditors.setRequired(true);
            this.kDLabelContainer3.setVisible(false);
            this.prmtLoanBank.setRequired(false);
        }
        this.actionCopy.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.contCreditors.setEnabled(false);
        this.kDLabelContainer3.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionCreateFrom.setVisible(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        CashHelper.initCombCurrency((KDComboBox)this.prmtCurrency, (boolean)false);
        this.txtLoanBalance.setHorizontalAlignment(4);
        this.txtLoanBalance.setPrecision(2);
        this.txtLoanBalance.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtExchangeRate.setPrecision(2);
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtLocalAmount.setHorizontalAlignment(4);
        this.txtLocalAmount.setPrecision(2);
        this.txtLocalAmount.setRemoveingZeroInDispaly(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBizDate(DateTimeUtils.truncateDate((Date)this.editData.getBizDate()));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getSourceBillNumber() == null) {
            this.comboSourceBillType.setSelectedItem(null);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        if (this.editData.getCurrency() != null) {
            this.prmtCurrency.setSelectedItem((Object)this.editData.getCurrency());
        }
        if (this.editData.getExchangeRate() != null) {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanExhibitionFactory.getRemoteInstance();
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "LoanExhibition");
        billEdit.createFrom(null, map);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.editData.setState(LoanExhBillStatusEnum.submit);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setState(LoanExhBillStatusEnum.save);
        super.actionSave_actionPerformed(e);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW)) {
            try {
                LoanExhibitionInfo info = (LoanExhibitionInfo)dataObject;
                if (info.getFundTranExt() != null) {
                    info.setSourceBillType(FromBillType.FundTransfer);
                } else if (info.getCHLoanExtend() != null) {
                    info.setSourceBillType(FromBillType.ChLoan);
                } else if (info.getConsignLoanExt() != null) {
                    info.setSourceBillType(FromBillType.ConsignmentLoan);
                } else if (info.getLoanDefer() != null) {
                    info.setSourceBillType(FromBillType.Loan);
                    if (info.getSourceBillId() != null) {
                        LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
                        if (!loanInfo.isIsGroupLoan()) {
                            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(loanInfo.getInstitution().getId()));
                            this.editData.setLoanBank(bankInfo);
                        } else {
                            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(loanInfo.getGroupID().getId()));
                            this.editData.setCreditors(company);
                        }
                    }
                } else {
                    info.setSourceBillType(null);
                }
                this.setLocalAmountValue(info);
                info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                info.setCompany(this.currentCompany);
                info.setBizDate(DateUtil.getDayBegin());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void setLocalAmountValue(LoanExhibitionInfo model) throws Exception {
        CurrencyInfo info = null;
        if (model != null) {
            info = model.getCurrency();
        }
        if (info != null) {
            this.txtLoanBalance.setPrecision(info.getPrecision());
            this.txtLoanBalance.setRemoveingZeroInDispaly(false);
            this.txtLoanBalance.setValue((Object)model.getLoanBalance());
            int prec = CasRecPayHandler.getExRatePrec((String)info.getId().toString(), null, (CompanyOrgUnitInfo)this.currentCompany, (Date)((Date)this.pkapplyDate.getValue()));
            this.txtExchangeRate.setPrecision(prec);
            this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)info, null, (Date)((Date)this.pkapplyDate.getValue())));
            this.txtExchangeRate.setRemoveingZeroInDispaly(false);
            this.txtExchangeRate.setRemoveingZeroInEdit(true);
            boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)info, null);
            if (isLocalCurrency) {
                this.txtExchangeRate.setEnabled(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
            this.txtLocalAmount.setValue((Object)this.getDecimal(this.txtLoanBalance.getNumberValue()).multiply(this.getDecimal(this.txtExchangeRate.getNumberValue())));
        }
        model.setExchangeRate(this.getDecimal(this.txtExchangeRate.getNumberValue()));
        model.setLocalAmount(this.getDecimal(this.txtLocalAmount.getNumberValue()));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("creditors.id"));
        sic.add(new SelectorItemInfo("creditors.name"));
        sic.add(new SelectorItemInfo("LoanDefer.id"));
        sic.add(new SelectorItemInfo("LoanDefer.name"));
        sic.add(new SelectorItemInfo("FundTranExt.id"));
        sic.add(new SelectorItemInfo("FundTranExt.name"));
        sic.add(new SelectorItemInfo("CHLoanExtend.id"));
        sic.add(new SelectorItemInfo("CHLoanExtend.name"));
        sic.add(new SelectorItemInfo("ConsignLoanExt.id"));
        sic.add(new SelectorItemInfo("ConsignLoanExt.name"));
        sic.add(new SelectorItemInfo("loanBank.id"));
        sic.add(new SelectorItemInfo("loanBank.name"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if ("".equals(this.txtSourceBillNumber.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"315_LoanExhibitionEditUI"));
            SysUtil.abort();
        }
        this.txtNumber.setRequired(this.txtNumber.isEnabled());
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        Date dateBegin = DateTimeUtils.truncateDate((Date)this.pkExhBeforeDate.getSqlDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)this.pkExhAfterDate.getSqlDate());
        if (!dateEnd.after(dateBegin)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"316_LoanExhibitionEditUI"));
            this.pkExhAfterDate.requestFocus();
            this.abort();
        }
    }

    protected IObjectValue createNewData() {
        LoanExhibitionInfo info = new LoanExhibitionInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCompany(this.currentCompany);
        info.setState(LoanExhBillStatusEnum.save);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setBizDate(DateUtil.getDayBegin());
        info.setExhBeforeDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setLoanBalance(new BigDecimal(0.0));
        info.setExchangeRate(Constants.ONE);
        info.setCurrency(this.currentCompany.getBaseCurrency());
        info.setLocalAmount(FMHelper.multiply((BigDecimal)info.getLoanBalance(), (BigDecimal)info.getExchangeRate()));
        info.setIsForExh(false);
        info.setSourceBillType(null);
        this.txtExchangeRate.setEnabled(false);
        return info;
    }

    private void calcLocalAmount() {
        BigDecimal bdRetAmount = this.txtLoanBalance.getBigDecimalValue();
        BigDecimal bdLocalRate = this.txtExchangeRate.getBigDecimalValue();
        if (bdLocalRate != null && bdRetAmount != null) {
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)bdRetAmount.multiply(bdLocalRate));
        }
    }

    @Override
    protected void pkExhAfterDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExhAfterDate_dataChanged(e);
    }

    @Override
    protected void prmtCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getItem() != null && e.getItem() instanceof CurrencyInfo) {
            CurrencyInfo curr = (CurrencyInfo)e.getItem();
            FMClientHelper.setCompontDisplayFormat((CoreUIObject)this, (CurrencyInfo)curr);
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtExchangeRate, this.currentCompany, curr, this.baseCurrency, (Date)this.pkapplyDate.getValue(), null);
        }
    }

    private BigDecimal getDecimal(Object o) {
        if (o != null) {
            return (BigDecimal)o;
        }
        return Constants.ZERO;
    }

    @Override
    protected void txtLoanBalance_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLoanBalance_dataChanged(e);
    }

    @Override
    protected void txtLocalAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalAmount_dataChanged(e);
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.editData != null && this.editData.getLoanBalance() != null) {
            this.txtLoanBalance.setValue((Object)this.editData.getLoanBalance());
            this.txtLocalAmount.setValue((Object)this.txtLoanBalance.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        LoanExhibitionInfo guaranteeApplyInfo = (LoanExhibitionInfo)this.getDataObject();
        if (guaranteeApplyInfo != null && guaranteeApplyInfo.getState() != null && !guaranteeApplyInfo.getState().equals((Object)LoanExhBillStatusEnum.save)) {
            this.actionSave.setEnabled(false);
        }
    }

    protected boolean isModifySave() {
        return this.editData.getState() == null || this.editData.getState().equals((Object)LoanExhBillStatusEnum.save);
    }
}

