/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.fin.FromBillType;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.LoanExhBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanExhibitionFactory;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanExhibitionListUI;
import com.kingdee.eas.fm.fin.client.LoanExhibitionDataProvider;
import com.kingdee.eas.fm.fin.client.LoanExhibitionEditUI;
import com.kingdee.eas.fm.fin.client.LoanExhibitionFilter2UI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanExhibitionListUI
extends AbstractLoanExhibitionListUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanRepayResource";
    private LoanExhibitionFilter2UI filterUI;
    private static final Logger logger = CoreUIObject.getLogger(LoanExhibitionListUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    FillListener fillListener = new FillListener();
    private static final String tdTemplateFile = "/FM/FIN/LOANEXHIBITIONAPPLY";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanExhibitionFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanExhibitionFilter2UI();
        }
        return this.filterUI;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        LoanExhibitionInfo objectValue = new LoanExhibitionInfo();
        return objectValue;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkAntiAudit();
            HashSet IDs = new HashSet(this.getSelectedIdValues());
            LoanExhibitionFactory.getRemoteInstance().batchAntiAudit(IDs);
        }
        catch (Exception ex) {
            if (ex instanceof AbortException) {
                logger.debug((Object)ex.getMessage());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.refreshList();
    }

    private void checkAntiAudit() throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            ICell cellIsCreateRepay;
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cellStatus = this.tblMain.getRow(rowNum).getCell("state");
            if (cellStatus == null || cellStatus.getValue() != null && !LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
                SysUtil.abort();
            }
            if ((cellIsCreateRepay = this.tblMain.getRow(rowNum).getCell("isForExh")) == null || cellIsCreateRepay.getValue() == null || cellIsCreateRepay.getValue().equals(Boolean.TRUE)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"317_LoanExhibitionListUI"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellIsCreateRepay;
                    ICell cellStatus = this.tblMain.getRow(j).getCell("state");
                    if (cellStatus == null || cellStatus.getValue() == null || !LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
                        SysUtil.abort();
                    }
                    if ((cellIsCreateRepay = this.tblMain.getRow(j).getCell("isForExh")) != null && cellIsCreateRepay.getValue() != null && !cellIsCreateRepay.getValue().equals(Boolean.TRUE)) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"317_LoanExhibitionListUI"));
                    SysUtil.abort();
                }
            }
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkCreateTo();
        super.actionCreateTo_actionPerformed(e);
    }

    private void checkCreateTo() {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cellStatus = this.tblMain.getRow(rowNum).getCell("state");
        if (cellStatus.getValue() != null && !LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
            SysUtil.abort();
        }
        String id = this.getSelectedKeyValue();
        LoanExhibitionInfo loanExhibitionInfo = new LoanExhibitionInfo();
        try {
            loanExhibitionInfo = LoanExhibitionFactory.getRemoteInstance().getLoanExhibitionInfo((IObjectPK)new ObjectUuidPK(id));
            if (loanExhibitionInfo.getState() != LoanExhBillStatusEnum.audit && loanExhibitionInfo.getSourceBillType() != FromBillType.Loan) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkAudit();
            HashSet IDs = new HashSet(this.getSelectedIdValues());
            boolean idsInProcess = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
            if (idsInProcess) {
                this.actionMultiapprove_actionPerformed(e);
                return;
            }
            LoanExhibitionFactory.getRemoteInstance().batchAudit(IDs);
        }
        catch (Exception ex) {
            if (ex instanceof AbortException) {
                logger.debug((Object)ex.getMessage());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.refreshList();
    }

    private void checkAudit() throws Exception {
        block6: {
            int size;
            KDTSelectBlock selectBlock;
            block4: {
                ICell cellStatus;
                block5: {
                    this.checkSelected();
                    selectBlock = null;
                    size = this.tblMain.getSelectManager().size();
                    if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
                        return;
                    }
                    if (size != 1 || this.tblMain.getSelectManager().get().getTop() != this.tblMain.getSelectManager().get().getBottom()) break block4;
                    int rowNum = this.tblMain.getSelectManager().get().getTop();
                    cellStatus = this.tblMain.getRow(rowNum).getCell("state");
                    if (cellStatus != null && cellStatus.getValue() != null && !LoanExhBillStatusEnum.save.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) break block5;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditError"));
                    SysUtil.abort();
                    break block6;
                }
                if (!LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) break block6;
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditedError"));
                SysUtil.abort();
                break block6;
            }
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellStatus = this.tblMain.getRow(j).getCell("state");
                    if (cellStatus == null || cellStatus.getValue() == null || LoanExhBillStatusEnum.save.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditError"));
                        SysUtil.abort();
                        continue;
                    }
                    if (!LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditedError"));
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cellStatus = this.tblMain.getRow(rowNum).getCell("state");
            if (cellStatus.getValue() != null && LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellStatus = this.tblMain.getRow(j).getCell("state");
                    if (cellStatus.getValue() == null || !LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                    SysUtil.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cellStatus = this.tblMain.getRow(rowNum).getCell("state");
            if (cellStatus.getValue() != null && LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"editError"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellStatus = this.tblMain.getRow(j).getCell("state");
                    if (cellStatus.getValue() == null || !LoanExhBillStatusEnum.audit.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionView.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionTDPrint.setVisible(false);
            this.actionTDPrintPreview.setVisible(false);
        }
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionCopyTo.setVisible(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        super.onLoad();
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("exhBeforeDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("exhAfterDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(dformat);
        String dtime = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dtime);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dtime);
    }

    protected String getEntityBOSType() throws Exception {
        LoanExhibitionInfo info = new LoanExhibitionInfo();
        return info.getBOSType().toString();
    }

    protected String getEditUIName() {
        return LoanExhibitionEditUI.class.getName();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAntiAudit.setEnabled(true);
        this.btnAudit.setEnabled(true);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2"));
            filter.getFilterItems().add(new FilterItemInfo("isForExh", (Object)"0"));
            Map btpPara = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            if (btpPara.get("fundTransfer") != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"1"));
                filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
            } else {
                if (btpPara.get("fromLoanExhibition") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"3"));
                    filter.getFilterItems().add(new FilterItemInfo("LoanDefer.company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                    return filter;
                }
                if (btpPara.get("showType") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"2"));
                    filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                    return filter;
                }
                if (btpPara.get("consigen") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"0"));
                    filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                    return filter;
                }
            }
        }
        return filter;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 5;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        destBosTypeList.clear();
        LoanDeferInfo info = new LoanDeferInfo();
        String addBosType = info.getBOSType().toString();
        destBosTypeList.add(addBosType);
        return destBosTypeList;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("fromBankLoan", "TraceDown");
        this.getUIContext().put("addType", hm);
        super.actionTraceDown_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        LoanExhibitionDataProvider data = new LoanExhibitionDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.LoanExhibitionTDQuery");
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LoanExhibitionListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyID = null;
            String baseCurrencyId = null;
            try {
                baseCurrencyId = LoanExhibitionListUI.this.contextHelp.getCompanyBaseCurrency(LoanExhibitionListUI.this.contextHelp.getCurrentCompany()).getId().toString();
            }
            catch (Exception e1) {
                LoanExhibitionListUI.this.handUIExceptionAndAbort(e1);
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyID = (String)row.getCell("currency.id").getValue();
                if (currencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"loanBalance", (String)currencyID);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"localAmount", (String)baseCurrencyId);
                }
                int prec = CasRecPayHandler.getExRatePrec((String)currencyID, null, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany(), (Date)((Date)row.getCell("bizDate").getValue()));
                FMARAPUtil.setPrecision((ICell)row.getCell("exchangeRate"), (int)prec);
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "loanBalance", format);
            this.setNumberFormat(row, "localAmount", format);
            this.setNumberFormat(row, "exchangeRate", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

