/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AddBatchHelper;
import com.kingdee.eas.fi.cas.ControlTake;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanInterestBathEditUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LoanInterestBathEditUI
extends AbstractLoanInterestBathEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanInterestBathEditUI.class);
    private static final String NUMBER = "number";
    private static final String INTERESTTYPE = "interestType";
    private static final String LOANNUMBER = "loan.number";
    private static final String COMPANYNAME = "company.name";
    private static final String LOANCURRENCY = "loan.currency";
    private static final String CREDITORASBANKNAME = "creditorAsBank.name";
    private static final String BEGINDATE = "beginDate";
    private static final String ENDDATE = "endDate";
    private static final String DAYS = "days";
    private static final String AMOUNT = "amount";
    private static final String INTEREST = "interest";
    private static final String REALINTEREST = "realInterest";
    private static final String PUNISHINTEREST = "punishInterest";
    private static final String REALPUNISHINTEREST = "realPunishInterest";
    private static final String INTCURRENCYNAME = "intCurrency.name";
    private static final String INTCURRENCYRATE = "intCurrencyRate";
    private static final String INTCURRENCYAMT = "intCurrencyAmt";
    private static final String ACCOUNTNAME = "account.name";
    private static final String INTFEEACCTVIEWNAME = "intFeeAcctView.name";
    private static final String DESCRIPTION = "description";
    private static final String EXCHANGE = "exchange";
    private static final String INTRATETYPEEXPRESSION = "intRateTypeExpression";
    private static final String INTRATE = "intRate";
    private static final String PUNISHINTTYPE = "punishIntType";
    private static final String PUNISHINTRATE = "punishIntRate";
    private RepaymentCollection reColl = new RepaymentCollection();
    private Map loanInterestMap = new HashMap();
    private Map map = new HashMap();
    private boolean isSubmit = false;

    public void onLoad() throws Exception {
        this.reColl = (RepaymentCollection)((Object)this.getUIContext().get("repaymentColl"));
        super.onLoad();
        this.initUIProp();
        this.fillData();
        this.actionSubmit.setEnabled(true);
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
    }

    public static IUIWindow showDialogWindows(IUIObject ui, RepaymentCollection repaymentColl) throws UIException {
        if (repaymentColl == null || repaymentColl.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"repaymentColl", (Object)repaymentColl);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanInterestBathEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return uiWindow;
    }

    public Map getEditData() {
        if (this.isSubmit) {
            return this.map;
        }
        return new HashMap();
    }

    protected void initUIProp() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        KDTextField loanNumberEditor = new KDTextField();
        loanNumberEditor.setEnabled(false);
        KDTDefaultCellEditor loanNumberCellEditor = new KDTDefaultCellEditor((JTextField)loanNumberEditor);
        this.tblMain.getColumn(LOANNUMBER).setEditor((ICellEditor)loanNumberCellEditor);
        this.tblMain.getColumn(LOANNUMBER).getStyleAttributes().setLocked(true);
        KDTextField interestTypeEditor = new KDTextField();
        interestTypeEditor.setEnabled(false);
        KDTDefaultCellEditor interestTypeCellEditor = new KDTDefaultCellEditor((JTextField)interestTypeEditor);
        this.tblMain.getColumn(INTERESTTYPE).setEditor((ICellEditor)interestTypeCellEditor);
        this.tblMain.getColumn(INTERESTTYPE).getStyleAttributes().setLocked(true);
        KDTextField creditorAsBankNameEditor = new KDTextField();
        creditorAsBankNameEditor.setEnabled(false);
        KDTDefaultCellEditor creditorAsBankNameCellEditor = new KDTDefaultCellEditor((JTextField)creditorAsBankNameEditor);
        this.tblMain.getColumn(CREDITORASBANKNAME).setEditor((ICellEditor)creditorAsBankNameCellEditor);
        this.tblMain.getColumn(CREDITORASBANKNAME).getStyleAttributes().setLocked(true);
        KDDatePicker editor1 = new KDDatePicker();
        editor1.setEnabled(false);
        KDTDefaultCellEditor cellEditor1 = new KDTDefaultCellEditor(editor1);
        this.tblMain.getColumn(BEGINDATE).setEditor((ICellEditor)cellEditor1);
        this.tblMain.getColumn(BEGINDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker editor2 = new KDDatePicker();
        editor2.setEnabled(false);
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor(editor2);
        this.tblMain.getColumn(ENDDATE).setEditor((ICellEditor)cellEditor2);
        this.tblMain.getColumn(ENDDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDFormattedTextField daysEditor = new KDFormattedTextField();
        daysEditor.setEnabled(false);
        KDTDefaultCellEditor daysCellEditor = new KDTDefaultCellEditor((JTextField)daysEditor);
        this.tblMain.getColumn(DAYS).setEditor((ICellEditor)daysCellEditor);
        this.tblMain.getColumn(DAYS).getStyleAttributes().setLocked(true);
        KDFormattedTextField amountEditor = new KDFormattedTextField();
        amountEditor.setEnabled(false);
        amountEditor.setDataType(1);
        amountEditor.setPrecision(2);
        amountEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor amountCellEditor = new KDTDefaultCellEditor((JTextField)amountEditor);
        this.tblMain.getColumn(AMOUNT).setEditor((ICellEditor)amountCellEditor);
        String amountFtm = "%r-[ ]{###,###,##0.00}15.2n";
        this.tblMain.getColumn(AMOUNT).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.getColumn(AMOUNT).getStyleAttributes().setLocked(true);
        KDFormattedTextField interestEditor = new KDFormattedTextField();
        interestEditor.setEnabled(false);
        interestEditor.setDataType(1);
        interestEditor.setPrecision(2);
        interestEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor interestCellEditor = new KDTDefaultCellEditor((JTextField)interestEditor);
        this.tblMain.getColumn(INTEREST).setEditor((ICellEditor)interestCellEditor);
        this.tblMain.getColumn(INTEREST).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.getColumn(INTEREST).getStyleAttributes().setLocked(true);
        KDFormattedTextField realinterestEditor = new KDFormattedTextField();
        realinterestEditor.setEnabled(true);
        realinterestEditor.setHorizontalAlignment(4);
        realinterestEditor.setDataType(1);
        realinterestEditor.setPrecision(2);
        realinterestEditor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    LoanInterestBathEditUI.this.realinterest_dataChanged(e);
                }
                catch (Exception exc) {
                    LoanInterestBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor realinterestCellEditor = new KDTDefaultCellEditor((JTextField)realinterestEditor);
        this.tblMain.getColumn(REALINTEREST).setEditor((ICellEditor)realinterestCellEditor);
        this.tblMain.getColumn(REALINTEREST).getStyleAttributes().setNumberFormat(amountFtm);
        KDFormattedTextField punishinterestEditor = new KDFormattedTextField();
        punishinterestEditor.setEnabled(false);
        punishinterestEditor.setDataType(1);
        punishinterestEditor.setPrecision(2);
        punishinterestEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor punishinterestCellEditor = new KDTDefaultCellEditor((JTextField)punishinterestEditor);
        this.tblMain.getColumn(PUNISHINTEREST).setEditor((ICellEditor)punishinterestCellEditor);
        this.tblMain.getColumn(PUNISHINTEREST).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.getColumn(PUNISHINTEREST).getStyleAttributes().setLocked(true);
        KDFormattedTextField realPunishInterestEditor = new KDFormattedTextField();
        realPunishInterestEditor.setEnabled(true);
        realPunishInterestEditor.setDataType(1);
        realPunishInterestEditor.setPrecision(2);
        realPunishInterestEditor.setHorizontalAlignment(4);
        realPunishInterestEditor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    LoanInterestBathEditUI.this.realPunishInterest_dataChanged(e);
                }
                catch (Exception exc) {
                    LoanInterestBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor realPunishInterestCellEditor = new KDTDefaultCellEditor((JTextField)realPunishInterestEditor);
        this.tblMain.getColumn(REALPUNISHINTEREST).setEditor((ICellEditor)realPunishInterestCellEditor);
        this.tblMain.getColumn(REALPUNISHINTEREST).getStyleAttributes().setNumberFormat(amountFtm);
        KDBizPromptBox companynameEditor = new KDBizPromptBox();
        companynameEditor.setEditable(false);
        companynameEditor.setEnabled(false);
        companynameEditor.setDisplayFormat("$name$");
        companynameEditor.setEditFormat("$name$");
        companynameEditor.setCommitFormat("$name$");
        companynameEditor.setMaxLength(80);
        companynameEditor.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", companynameEditor));
        companynameEditor.getQueryAgent().resetRuntimeEntityView();
        companynameEditor.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        KDTDefaultCellEditor companynameCellEditor = new KDTDefaultCellEditor((IKDEditor)companynameEditor);
        this.tblMain.getColumn(COMPANYNAME).setEditor((ICellEditor)companynameCellEditor);
        this.tblMain.getColumn(COMPANYNAME).getStyleAttributes().setLocked(true);
        KDBizPromptBox editor3 = new KDBizPromptBox();
        editor3.setEditable(false);
        editor3.setDisplayFormat("$name$");
        editor3.setEditFormat("$name$");
        editor3.setCommitFormat("$name$");
        editor3.setMaxLength(80);
        editor3.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", editor3));
        editor3.getQueryAgent().resetRuntimeEntityView();
        editor3.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        editor3.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    LoanInterestBathEditUI.this.intCurrency_dataChanged(e);
                }
                catch (Exception exc) {
                    LoanInterestBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor cellEditor3 = new KDTDefaultCellEditor((IKDEditor)editor3);
        this.tblMain.getColumn(INTCURRENCYNAME).setEditor((ICellEditor)cellEditor3);
        KDBizPromptBox loancurrencyEditor = new KDBizPromptBox();
        loancurrencyEditor.setEditable(false);
        loancurrencyEditor.setEnabled(false);
        loancurrencyEditor.setDisplayFormat("$name$");
        loancurrencyEditor.setEditFormat("$name$");
        loancurrencyEditor.setCommitFormat("$name$");
        loancurrencyEditor.setMaxLength(80);
        loancurrencyEditor.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", editor3));
        loancurrencyEditor.getQueryAgent().resetRuntimeEntityView();
        loancurrencyEditor.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        KDTDefaultCellEditor loancurrencyCellEditor = new KDTDefaultCellEditor((IKDEditor)loancurrencyEditor);
        this.tblMain.getColumn(LOANCURRENCY).setEditor((ICellEditor)loancurrencyCellEditor);
        this.tblMain.getColumn(LOANCURRENCY).getStyleAttributes().setLocked(true);
        KDFormattedTextField intCurrencyRateEditor = new KDFormattedTextField();
        intCurrencyRateEditor.setEnabled(true);
        intCurrencyRateEditor.setDataType(1);
        intCurrencyRateEditor.setHorizontalAlignment(4);
        intCurrencyRateEditor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    LoanInterestBathEditUI.this.intCurrencyRate_dataChanged(e);
                }
                catch (Exception exc) {
                    LoanInterestBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor intCurrencyRateCellEditor = new KDTDefaultCellEditor((JTextField)intCurrencyRateEditor);
        this.tblMain.getColumn(INTCURRENCYRATE).setEditor((ICellEditor)intCurrencyRateCellEditor);
        KDFormattedTextField intCurrencyAmtEditor = new KDFormattedTextField();
        intCurrencyAmtEditor.setEnabled(false);
        intCurrencyAmtEditor.setPrecision(2);
        intCurrencyAmtEditor.setDataType(1);
        intCurrencyAmtEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor intCurrencyAmtCellEditor = new KDTDefaultCellEditor((JTextField)intCurrencyAmtEditor);
        this.tblMain.getColumn(INTCURRENCYAMT).setEditor((ICellEditor)intCurrencyAmtCellEditor);
        this.tblMain.getColumn(INTCURRENCYAMT).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.getColumn(INTCURRENCYAMT).getStyleAttributes().setLocked(true);
        KDTextField descriptionEditor = new KDTextField();
        descriptionEditor.setEnabled(true);
        KDTDefaultCellEditor descriptionCellEditor = new KDTDefaultCellEditor((JTextField)descriptionEditor);
        this.tblMain.getColumn(DESCRIPTION).setEditor((ICellEditor)descriptionCellEditor);
        KDFormattedTextField exchangeEditor = new KDFormattedTextField();
        exchangeEditor.setDataType(1);
        exchangeEditor.setEnabled(true);
        KDTDefaultCellEditor exchangeCellEditor = new KDTDefaultCellEditor((JTextField)exchangeEditor);
        this.tblMain.getColumn(EXCHANGE).setEditor((ICellEditor)exchangeCellEditor);
        KDComboBox editor6 = new KDComboBox();
        editor6.removeAllItems();
        editor6.setEnabled(false);
        Object[] intRateEnum = IntRateTypeExpressionEnum.getEnumList().toArray();
        if (intRateEnum != null && intRateEnum.length >= 0) {
            editor6.addItems(intRateEnum);
        }
        KDTDefaultCellEditor cellEditor6 = new KDTDefaultCellEditor((JComboBox)editor6);
        this.tblMain.getColumn(INTRATETYPEEXPRESSION).setEditor((ICellEditor)cellEditor6);
        this.tblMain.getColumn(INTRATETYPEEXPRESSION).getStyleAttributes().setLocked(true);
        KDFormattedTextField txtRate = new KDFormattedTextField();
        txtRate.setDataType(1);
        txtRate.setPrecision(4);
        txtRate.setHorizontalAlignment(4);
        txtRate.setEditable(false);
        this.tblMain.getColumn(INTRATE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRate));
        String numberFtm = "%r-[ ]{###,###,##0.0000%}15.2n";
        this.tblMain.getColumn(INTRATE).getStyleAttributes().setNumberFormat(numberFtm);
        this.tblMain.getColumn(INTRATE).getStyleAttributes().setLocked(true);
        KDTextField punishIntTypeEditor = new KDTextField();
        punishIntTypeEditor.setEnabled(false);
        KDTDefaultCellEditor punishIntTypeCellEditor = new KDTDefaultCellEditor((JTextField)punishIntTypeEditor);
        this.tblMain.getColumn(PUNISHINTTYPE).setEditor((ICellEditor)punishIntTypeCellEditor);
        this.tblMain.getColumn(PUNISHINTTYPE).getStyleAttributes().setLocked(true);
        KDFormattedTextField punishIntRateEditor = new KDFormattedTextField();
        punishIntRateEditor.setEnabled(false);
        punishIntRateEditor.setPrecision(5);
        KDTDefaultCellEditor punishIntRateCellEditor = new KDTDefaultCellEditor((JTextField)punishIntRateEditor);
        this.tblMain.getColumn(PUNISHINTRATE).setEditor((ICellEditor)punishIntRateCellEditor);
        String punishIntRateFtm = "%r-[ ]{###,###,##0.00000}15.2n";
        this.tblMain.getColumn(PUNISHINTRATE).getStyleAttributes().setNumberFormat(punishIntRateFtm);
        this.tblMain.getColumn(PUNISHINTRATE).getStyleAttributes().setLocked(true);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                LoanInterestBathEditUI.this.tableValueChanged4KDPrediction(e);
            }
        });
    }

    protected void tableValueChanged4KDPrediction(KDTEditEvent e) {
        if (this.tblMain.getRowCount() > 1) {
            BigDecimal amountTotal = Constants.ZERO;
            BigDecimal interestTotal = Constants.ZERO;
            BigDecimal realInterestotal = Constants.ZERO;
            BigDecimal punishInterestTotal = Constants.ZERO;
            BigDecimal realPunishInterestTotal = Constants.ZERO;
            int size = this.tblMain.getRowCount() - 1;
            for (int i = 0; i < size; ++i) {
                if (this.tblMain.getRow(i).getCell(AMOUNT).getValue() != null) {
                    BigDecimal amount = (BigDecimal)this.tblMain.getRow(i).getCell(AMOUNT).getValue();
                    amountTotal = amountTotal.add(amount);
                }
                if (this.tblMain.getRow(i).getCell(INTEREST).getValue() != null) {
                    BigDecimal interest = (BigDecimal)this.tblMain.getRow(i).getCell(INTEREST).getValue();
                    interestTotal = interestTotal.add(interest);
                }
                if (this.tblMain.getRow(i).getCell(REALINTEREST).getValue() != null) {
                    BigDecimal realInterest = (BigDecimal)this.tblMain.getRow(i).getCell(REALINTEREST).getValue();
                    realInterestotal = realInterestotal.add(realInterest);
                }
                if (this.tblMain.getRow(i).getCell(PUNISHINTEREST).getValue() != null) {
                    BigDecimal punishInterest = (BigDecimal)this.tblMain.getRow(i).getCell(PUNISHINTEREST).getValue();
                    punishInterestTotal = punishInterestTotal.add(punishInterest);
                }
                if (this.tblMain.getRow(i).getCell(REALPUNISHINTEREST).getValue() == null) continue;
                BigDecimal realPunishInterest = (BigDecimal)this.tblMain.getRow(i).getCell(REALPUNISHINTEREST).getValue();
                realPunishInterestTotal = realPunishInterestTotal.add(realPunishInterest);
            }
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(AMOUNT).setValue((Object)amountTotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(INTEREST).setValue((Object)interestTotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(REALINTEREST).setValue((Object)realInterestotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(PUNISHINTEREST).setValue((Object)punishInterestTotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(REALPUNISHINTEREST).setValue((Object)realPunishInterestTotal);
        } else if (this.tblMain.getRowCount() == 1 && this.tblMain.getCell(0, NUMBER).getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"))) {
            this.tblMain.getCell(0, AMOUNT).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, INTEREST).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, REALINTEREST).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, PUNISHINTEREST).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, REALPUNISHINTEREST).setValue((Object)Constants.ZERO);
        }
    }

    protected void realinterest_dataChanged(DataChangeEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        BigDecimal realInterest = (BigDecimal)e.getNewValue();
        BigDecimal realPunishInterest = (BigDecimal)row.getCell(REALPUNISHINTEREST).getValue();
        BigDecimal convertRate = (BigDecimal)row.getCell(INTCURRENCYRATE).getValue();
        this.setTxtIntCurrencyAmt(realInterest, realPunishInterest, convertRate, row);
    }

    protected void realPunishInterest_dataChanged(DataChangeEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        BigDecimal realInterest = (BigDecimal)row.getCell(REALINTEREST).getValue();
        BigDecimal realPunishInterest = (BigDecimal)e.getNewValue();
        BigDecimal convertRate = (BigDecimal)row.getCell(INTCURRENCYRATE).getValue();
        this.setTxtIntCurrencyAmt(realInterest, realPunishInterest, convertRate, row);
    }

    protected void intCurrencyRate_dataChanged(DataChangeEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        BigDecimal realInterest = (BigDecimal)row.getCell(REALINTEREST).getValue();
        BigDecimal realPunishInterest = (BigDecimal)row.getCell(REALPUNISHINTEREST).getValue();
        BigDecimal convertRate = (BigDecimal)e.getNewValue();
        this.setTxtIntCurrencyAmt(realInterest, realPunishInterest, convertRate, row);
    }

    private void intCurrency_dataChanged(DataChangeEvent e) {
        if (!e.getNewValue().equals(e.getOldValue())) {
            try {
                int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
                IRow row = this.tblMain.getRow(rowIndex);
                CurrencyInfo currency = FMClientHelper.getCurrencyInfo((BOSUuid)((CurrencyInfo)e.getNewValue()).getId());
                CurrencyInfo sourceCurrency = (CurrencyInfo)row.getCell(LOANCURRENCY).getValue();
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)row.getCell(COMPANYNAME).getValue();
                this.setF7Filter(row, currency, company);
                if (!currency.getId().toString().equals(sourceCurrency.getId().toString())) {
                    ExchangeRateInfo exchangeRate = FMClientHelper.findExchangeRate((String)sourceCurrency.getId().toString(), (String)currency.getId().toString());
                    BigDecimal convertRate = BigDecimal.ONE;
                    if (exchangeRate != null) {
                        convertRate = exchangeRate.getConvertRate();
                    }
                    BigDecimal realInterest = (BigDecimal)row.getCell(REALINTEREST).getValue();
                    BigDecimal realPunishInterest = (BigDecimal)row.getCell(REALPUNISHINTEREST).getValue();
                    this.setTxtIntCurrencyAmt(realInterest, realPunishInterest, convertRate, row);
                    row.getCell(INTCURRENCYRATE).setValue((Object)convertRate);
                    row.getCell(EXCHANGE).setValue((Object)convertRate);
                    row.getCell(EXCHANGE).getStyleAttributes().setLocked(false);
                    row.getCell(INTCURRENCYRATE).getStyleAttributes().setLocked(false);
                } else {
                    row.getCell(INTCURRENCYRATE).setValue((Object)BigDecimal.ONE);
                    row.getCell(EXCHANGE).setValue((Object)BigDecimal.ONE);
                    row.getCell(EXCHANGE).getStyleAttributes().setLocked(true);
                    row.getCell(INTCURRENCYRATE).getStyleAttributes().setLocked(true);
                }
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void setTxtIntCurrencyAmt(BigDecimal realInterest, BigDecimal realPunishInterest, BigDecimal convertRate, IRow row) {
        BigDecimal amount = convertRate.multiply(realInterest.add(realPunishInterest));
        row.getCell(INTCURRENCYAMT).setValue((Object)amount);
    }

    protected void fillData() throws BOSException, EASBizException {
        IRow row = null;
        BigDecimal amountTotal = Constants.ZERO;
        BigDecimal interestTotal = Constants.ZERO;
        BigDecimal realInterestotal = Constants.ZERO;
        BigDecimal punishInterestTotal = Constants.ZERO;
        BigDecimal realPunishInterestTotal = Constants.ZERO;
        for (int i = 0; i < this.reColl.size(); ++i) {
            RepaymentInfo repaymentInfo = this.reColl.get(i);
            LoanInfo loanInfo = FinHelper.getInstance().getLoanPassByRepayment(repaymentInfo);
            Date startDate = this.getStartDate(loanInfo);
            Date endDate = this.getEndDate(loanInfo, repaymentInfo);
            LoanInterestInfo info = LoanInterestFactory.getRemoteInstance().calInt(startDate, endDate, repaymentInfo);
            info.setRepaymentInfo(repaymentInfo);
            info.setInterestType(IntCalTypeEnum.REPAY_INT);
            this.map.put(repaymentInfo, info);
            this.loanInterestMap.put(i, info);
            row = this.tblMain.addRow();
            KDTextField txtNumber = new KDTextField();
            txtNumber.setMaxLength(80);
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)txtNumber, (String)info.getCompany().getId().toString());
            row.getCell(NUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtNumber));
            row.getCell(NUMBER).setValue((Object)txtNumber.getText());
            row.getCell("id").setValue((Object)i);
            row.getCell(INTERESTTYPE).setValue((Object)info.getInterestType());
            row.getCell(LOANNUMBER).setValue((Object)info.getLoan().getNumber());
            row.getCell(COMPANYNAME).setValue((Object)info.getCompany());
            row.getCell(LOANCURRENCY).setValue((Object)info.getLoan().getCurrency());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCreditorAsBank())) {
                row.getCell(CREDITORASBANKNAME).setValue((Object)info.getCreditorAsBank().getName());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCreditorAsCompany())) {
                row.getCell(CREDITORASBANKNAME).setValue((Object)info.getCreditorAsCompany().getName());
            }
            row.getCell(BEGINDATE).setValue((Object)info.getBeginDate());
            row.getCell(ENDDATE).setValue((Object)info.getEndDate());
            row.getCell(DAYS).setValue((Object)info.getDays());
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            amountTotal = amountTotal.add(info.getAmount());
            row.getCell(INTEREST).setValue((Object)info.getInterest());
            interestTotal = interestTotal.add(info.getInterest());
            row.getCell(REALINTEREST).setValue((Object)info.getRealInterest());
            realInterestotal = realInterestotal.add(info.getRealInterest());
            row.getCell(PUNISHINTEREST).setValue((Object)info.getPunishInterest());
            punishInterestTotal = punishInterestTotal.add(info.getPunishInterest());
            row.getCell(REALPUNISHINTEREST).setValue((Object)info.getRealPunishInterest());
            realPunishInterestTotal = realPunishInterestTotal.add(info.getRealPunishInterest());
            ICellEditor account = ControlTake.getF7Editor((String)"com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
            AddBatchHelper.bindContents((IRow)row, (String)ACCOUNTNAME, (ICellEditor)account);
            ICellEditor intFeeAcctView = ControlTake.getF7Editor((String)"com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            AddBatchHelper.bindContents((IRow)row, (String)INTFEEACCTVIEWNAME, (ICellEditor)intFeeAcctView);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)loanInfo.getCurrency())) {
                CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(loanInfo.getCurrency().getId().toString()));
                row.getCell(INTCURRENCYNAME).setValue((Object)currencyInfo);
                this.setF7Filter(row, currencyInfo, info.getCompany());
            }
            row.getCell(INTCURRENCYRATE).setValue((Object)BigDecimal.ONE);
            row.getCell(INTCURRENCYRATE).getStyleAttributes().setLocked(true);
            row.getCell(INTCURRENCYAMT).setValue((Object)info.getRealInterest().add(info.getRealPunishInterest()));
            if (!EmptyUtil.isEmpty((CoreBaseInfo)loanInfo.getBankAcct())) {
                AccountBankInfo accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(loanInfo.getBankAcct().getId().toString()));
                row.getCell(ACCOUNTNAME).setValue((Object)accountBank);
            }
            row.getCell(EXCHANGE).setValue((Object)info.getExchange());
            row.getCell(EXCHANGE).getStyleAttributes().setLocked(true);
            row.getCell(INTRATETYPEEXPRESSION).setValue((Object)info.getIntRateTypeExpression());
            row.getCell(INTRATE).setValue((Object)info.getIntRate());
            row.getCell(PUNISHINTTYPE).setValue((Object)info.getPunishIntType());
            row.getCell(PUNISHINTRATE).setValue((Object)info.getPunishIntRate());
        }
        row = this.tblMain.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell(NUMBER).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        row.getCell(AMOUNT).setValue((Object)amountTotal);
        row.getCell(INTEREST).setValue((Object)interestTotal);
        row.getCell(REALINTEREST).setValue((Object)realInterestotal);
        row.getCell(PUNISHINTEREST).setValue((Object)punishInterestTotal);
        row.getCell(REALPUNISHINTEREST).setValue((Object)realPunishInterestTotal);
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
    }

    private void setF7Filter(IRow row, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company) {
        try {
            KDBizPromptBox accountF7 = AddBatchHelper.getF7((IRow)row, (String)ACCOUNTNAME);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            filter.setMaskString("(#0 or #1) and #2 and #3");
            ev.setFilter(filter);
            accountF7.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
            accountF7.setEntityViewInfo(ev);
            accountF7.setEnabledMultiSelection(false);
            accountF7.setEditFormat("$name$");
            accountF7.setDisplayFormat("$name$");
            accountF7.setCommitFormat("$name$");
            accountF7.getQueryAgent().resetRuntimeEntityView();
            KDBizPromptBox intFeeAcctViewF7 = AddBatchHelper.getF7((IRow)row, (String)INTFEEACCTVIEWNAME);
            EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)company.getCU().getId().toString(), (String)company.getId().toString(), (String)currencyInfo.getId().toString(), (boolean)false);
            AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, company, treeevi.getFilter(), false, true);
            intFeeAcctViewF7.setSelector((KDPromptSelector)opseelect);
            EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)company.getCU().getId().toString(), (String)company.getId().toString(), (String)currencyInfo.getId().toString(), (boolean)true);
            intFeeAcctViewF7.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            intFeeAcctViewF7.setEntityViewInfo(evi);
            intFeeAcctViewF7.setEnabledMultiSelection(false);
            intFeeAcctViewF7.setEditFormat("$name$");
            intFeeAcctViewF7.setDisplayFormat("$name$");
            intFeeAcctViewF7.setCommitFormat("$name$");
            intFeeAcctViewF7.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Date getEndDate(LoanInfo loanInfo, RepaymentInfo repaymentInfo) {
        Calendar c = Calendar.getInstance();
        c.setTime(repaymentInfo.getBizDate());
        c.add(6, -1);
        return c.getTime();
    }

    private Date getStartDate(LoanInfo loanInfo) {
        Date loanStartDate = loanInfo.getIssueDate();
        Date lastIntDate = loanInfo.getLastIntDate();
        if (lastIntDate == null) {
            return loanStartDate;
        }
        return this.maxDate(loanStartDate, lastIntDate);
    }

    private Date maxDate(Date date1, Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        StringBuilder errorBuilder = new StringBuilder();
        int error = 0;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!EmptyUtil.isEmpty((Object)row.getCell(NUMBER).getValue()) && row.getCell(NUMBER).getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"))) continue;
            int loanInterestId = (Integer)row.getCell("id").getValue();
            LoanInterestInfo info = (LoanInterestInfo)this.loanInterestMap.get(loanInterestId);
            info.setRealInterest((BigDecimal)row.getCell(REALINTEREST).getValue());
            info.setRealPunishInterest((BigDecimal)row.getCell(REALPUNISHINTEREST).getValue());
            info.setIntCurrency((CurrencyInfo)row.getCell(INTCURRENCYNAME).getValue());
            info.setIntCurrencyRate((BigDecimal)row.getCell(INTCURRENCYRATE).getValue());
            info.setIntCurrencyAmt((BigDecimal)row.getCell(INTCURRENCYAMT).getValue());
            info.setAccount((AccountBankInfo)row.getCell(ACCOUNTNAME).getValue());
            info.setIntFeeAcctView((AccountViewInfo)row.getCell(INTFEEACCTVIEWNAME).getValue());
            info.setDescription((String)row.getCell(DESCRIPTION).getValue());
            boolean rst = FMClientHelper.hasNumber((CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            if (!rst && EmptyUtil.isEmpty((Object)row.getCell(NUMBER).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"272_BondsInterestBathEditUI"));
                SysUtil.abort();
            }
            if (!EmptyUtil.isEmpty((Object)row.getCell(NUMBER).getValue())) {
                info.setNumber((String)row.getCell(NUMBER).getValue());
            }
            try {
                LoanInterestFactory.getRemoteInstance().submit((CoreBaseInfo)info);
                continue;
            }
            catch (Exception e2) {
                errorBuilder.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"274_BondsInterestBathEditUI") + e2.getMessage());
                ++error;
            }
        }
        if (errorBuilder.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"275_BondsInterestBathEditUI") + (this.reColl.size() - error) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"276_BondsInterestBathEditUI")), (String)errorBuilder.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"277_BondsInterestBathEditUI"));
        }
        this.isSubmit = true;
        this.disposeUIWindow();
    }
}

