/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanInterestWriteFpItemUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LoanInterestWriteFpItemUI
extends AbstractLoanInterestWriteFpItemUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanInterestWriteFpItemUI.class);
    private LoanInterestCollection loanIntCol;
    Map hm = new HashMap();

    public void onLoad() throws Exception {
        this.loanIntCol = (LoanInterestCollection)((Object)this.getUIContext().get("loanIntCol"));
        super.onLoad();
        this.setSize(new Dimension(600, 100));
        this.initTable();
        this.loadTable();
    }

    protected void initTable() {
        String[] lockedCols = this.getLockedColName();
        this.tbl.checkParsed();
        for (int i = 0; i < lockedCols.length; ++i) {
            this.tbl.getColumn(lockedCols[i]).getStyleAttributes().setLocked(true);
        }
        String[] backgroundCols = this.getBackgroundColName();
        for (int j = 0; j < backgroundCols.length; ++j) {
            this.tbl.getColumn(backgroundCols[j]).getStyleAttributes().setBackground(new Color(16579551));
        }
        this.tbl.getColumn("interest").getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
        this.tbl.getColumn("interest").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tbl.getColumn("punishInterest").getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
        this.tbl.getColumn("punishInterest").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tbl.getColumn("beginDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.tbl.getColumn("endDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        KDFormattedTextField txtRealInterest = new KDFormattedTextField();
        txtRealInterest.setDataType(1);
        txtRealInterest.setPrecision(5);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtRealInterest);
        this.tbl.getColumn("realInterest").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRealInterest));
        this.tbl.getColumn("realInterest").getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
        this.tbl.getColumn("realInterest").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtRealPunishInterest = new KDFormattedTextField();
        txtRealPunishInterest.setDataType(1);
        txtRealPunishInterest.setPrecision(5);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtRealPunishInterest);
        this.tbl.getColumn("realPunishInterest").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRealPunishInterest));
        this.tbl.getColumn("realPunishInterest").getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
        this.tbl.getColumn("realPunishInterest").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        ObjectValueRender avrLoan = new ObjectValueRender();
        avrLoan.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tbl.getColumn("loan.number").setRenderer((IBasicRender)avrLoan);
        KDBizPromptBox prmtBgItem = new KDBizPromptBox();
        FMClientHelper.initBgItemF7((KDBizPromptBox)prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.tbl.getColumn("bgItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBgItem));
    }

    protected void loadTable() {
        this.tbl.removeRows(false);
        IRow row = null;
        Iterator iter = this.loanIntCol.iterator();
        while (iter.hasNext()) {
            LoanInterestInfo element = (LoanInterestInfo)iter.next();
            row = this.tbl.addRow();
            row.getCell("id").setValue((Object)element.getId().toString());
            row.getCell("loan.number").setValue((Object)element.getLoan());
            if (element.getCreditorAsBank() != null) {
                row.getCell("creditorAsBank.name").setValue((Object)element.getCreditorAsBank());
            } else {
                row.getCell("creditorAsBank.name").setValue((Object)element.getCreditorAsCompany());
            }
            row.getCell("account.name").setValue((Object)element.getAccount());
            row.getCell("beginDate").setValue((Object)element.getBeginDate());
            row.getCell("endDate").setValue((Object)element.getEndDate());
            row.getCell("interest").setValue((Object)element.getInterest());
            row.getCell("realInterest").setValue((Object)element.getRealInterest());
            row.getCell("punishInterest").setValue((Object)element.getPunishInterest());
            row.getCell("realPunishInterest").setValue((Object)element.getRealPunishInterest());
            FMClientHelper.loadFieldsBgItem((ICell)row.getCell("bgItem"), (CoreBaseInfo)element, (FMBgItemProp)element.getBgItemProps()[0]);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public static Map showRecInterestLoanUI(CoreUI ui, LoanInterestCollection loanIntCol) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"loanIntCol", (Object)loanIntCol);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanInterestWriteFpItemUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((LoanInterestWriteFpItemUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        String msg = (String)returnValue.get("failureMsg");
        if (msg != null && msg.length() > 0) {
            MsgBox.showInfo((String)msg);
            msg = null;
        }
        return returnValue;
    }

    private Map getReturnValue() {
        return this.hm;
    }

    protected String[] getLockedColName() {
        return new String[]{"loan.number", "creditorAsBank.name", "account.name", "beginDate", "endDate", "interest", "punishInterest"};
    }

    protected String[] getBackgroundColName() {
        return new String[]{"realInterest", "realPunishInterest"};
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        super.actionSubmit_actionPerformed(e);
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            LoanInterestInfo intInfo = this.loanIntCol.get(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            FMClientHelper.storeFieldsBgItem((ICell)row.getCell("bgItem"), (CoreBaseInfo)intInfo, (FMBgItemProp)intInfo.getBgItemProps()[0]);
            intInfo.setRealInterest((BigDecimal)row.getCell("realInterest").getValue());
            intInfo.setRealPunishInterest((BigDecimal)row.getCell("realPunishInterest").getValue());
        }
        this.hm = LoanInterestFactory.getRemoteInstance().batchSave(this.loanIntCol);
        if (((Set)this.hm.get("createdID")).size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"334_LoanInterestWriteFpItemUI"));
            this.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private boolean verify() {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            if (row.getCell("bgItem").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"335_LoanInterestWriteFpItemUI"));
            this.abort();
        }
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.hm.put("createdID", new HashSet());
        super.disposeUIWindow();
    }
}

