/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanTypeEnum;
import com.kingdee.eas.util.client.ExceptionHandler;

public class LoanModel {
    public static EntityViewInfo getBankAcctFilter() {
        EntityViewInfo eviprmtBankAcct = new EntityViewInfo();
        FilterInfo filterprmtBankAcct = new FilterInfo();
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (CURRENT_COMPANY != null) {
            filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString()));
        }
        filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        eviprmtBankAcct.setFilter(filterprmtBankAcct);
        return eviprmtBankAcct;
    }

    public static EntityViewInfo getLoanAcctFilter() {
        FilterInfo filterInfocp = new FilterInfo();
        filterInfocp.getFilterItems().add(new FilterItemInfo("CompanyID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString()));
        filterInfocp.getFilterItems().add(new FilterItemInfo("accountTypeID.property", (Object)FMHelper.asSet((int[])new int[]{0, 1}), CompareType.INCLUDE));
        filterInfocp.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfocp.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfocp.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfocp.getFilterItems().add(new FilterItemInfo("isCash", (Object)Constants.FALSE));
        filterInfocp.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.FALSE));
        EntityViewInfo evicp = new EntityViewInfo();
        evicp.setFilter(filterInfocp);
        return evicp;
    }

    public static EntityViewInfo getSettlementAcctFilter() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("accountTableID.*"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        try {
            currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()), sic);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CompanyID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString()));
        if (currentCompany.getAccountTable() != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)currentCompany.getAccountTable().getId().toString()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getBankAcctF7Filter(LoanTypeEnum type, String bankid) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String companyId = CURRENT_COMPANY.getId().toString();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        if (LoanTypeEnum.Bank == type && bankid != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankid));
        }
        return evi;
    }

    public static EntityViewInfo getBankAcctF7Filter(boolean isBank, String id) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        if (id != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bank.id", (Object)id));
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bank.isBank", (Object)new Boolean(isBank)));
        return evi;
    }

    public static EntityViewInfo getConBillF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("remainConAmount", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isMulCon", (Object)new Boolean(true)));
        return evi;
    }

    public static EntityViewInfo getFinProductFilter(FinancingBillTypeEnum finBillType) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(finBillType.getValue())));
        return evi;
    }

    public static EntityViewInfo getConBillF7Filter(CompanyOrgUnitInfo company) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        CompanyOrgUnitInfo CURRENT_COMPANY = company;
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("remainConAmount", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isMulCon", (Object)new Boolean(true)));
        return evi;
    }

    public static EntityViewInfo getFpItemFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("direction", (Object)new String("in")));
        return evi;
    }
}

