/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FromBillType;
import com.kingdee.eas.fm.fin.ILoanRepayApplyInterestFacade;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.LoanRepayApplyInterestFacadeFactory;
import com.kingdee.eas.fm.fin.LoanRepayStatusEnum;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanRepaymentApplyEditUI;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IChLoan;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class LoanRepaymentApplyEditUI
extends AbstractLoanRepaymentApplyEditUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanRepayResource";
    private static final Logger logger = CoreUIObject.getLogger(LoanRepaymentApplyEditUI.class);

    @Override
    public void loadFields() {
        if (this.txtrateAmount.getBigDecimalValue() != null) {
            this.editData.setBigDecimal("rateAmount", this.txtrateAmount.getBigDecimalValue());
        }
        super.loadFields();
        if (FromBillType.Loan.equals((Object)this.editData.getSourceBillType()) && this.editData.getLoanBank() != null) {
            this.contapplyOrg.setVisible(false);
            this.kDLabelContainer3.setVisible(true);
            this.prmtapplyOrg.setRequired(false);
            this.prmtLoanBank.setRequired(true);
        } else {
            this.contapplyOrg.setVisible(true);
            this.kDLabelContainer3.setVisible(false);
            this.prmtapplyOrg.setRequired(true);
            this.prmtLoanBank.setRequired(false);
        }
        if (this.editData.getSourcBillNumber() == null) {
            this.sourceBillType.setSelectedItem(null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi = CasRecPayHandler.getAccountBankEvi((String)this.currentCompany.getId().toString(), null);
        this.prmtRepayAcctBank.setEntityViewInfo(evi);
        this.editData.setLoanProperty((LoanPropertyEnum)((Object)this.comboLoanProperty.getSelectedItem()));
        if (this.editData.getLoanProperty() == LoanPropertyEnum.InGroup) {
            UIUtil.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)((Object)LoanPropertyEnum.InGroup));
        } else {
            UIUtil.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)((Object)LoanPropertyEnum.OutGroup));
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.editData != null) {
            boolean isCanSaved = this.editData.getStatus() == null || this.editData.getStatus() == LoanRepayStatusEnum.SAVE;
            this.actionSave.setEnabled(isCanSaved);
        }
        this.storeFields();
        this.initOldData(this.getDataObject());
    }

    public void onLoad() throws Exception {
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        super.onLoad();
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.txtrate.setEnabled(false);
        this.txtrateAmount.setRequired(true);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "LoanRepaymentApply");
        billEdit.createFrom(null, map);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW)) {
            LoanRepaymentApplyInfo info;
            block15: {
                info = (LoanRepaymentApplyInfo)dataObject;
                if (info.getFundTransfer() != null) {
                    info.setSourceBillType(FromBillType.FundTransfer);
                    this.editData.setLoanProperty(LoanPropertyEnum.InGroup);
                } else if (info.getChLoan() != null) {
                    info.setSourceBillType(FromBillType.ChLoan);
                    this.editData.setLoanProperty(LoanPropertyEnum.InGroup);
                } else if (info.getCconsignmentLoan() != null) {
                    info.setSourceBillType(FromBillType.ConsignmentLoan);
                    this.editData.setLoanProperty(LoanPropertyEnum.InGroup);
                } else if (info.getLoan() != null) {
                    info.setSourceBillType(FromBillType.Loan);
                    BOTRelationInfo bot = this.getMakeRelations().get(0);
                    info.setSourceBillId(bot.getSrcObjectID());
                    try {
                        if (info.getSourceBillId() == null) break block15;
                        LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
                        if (!loanInfo.isIsGroupLoan()) {
                            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(loanInfo.getInstitution().getId()));
                            this.editData.setLoanBank(bankInfo);
                            this.editData.setLoanProperty(LoanPropertyEnum.OutGroup);
                            break block15;
                        }
                        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(loanInfo.getGroupID().getId()));
                        this.editData.setCreditors(company);
                        this.editData.setLoanProperty(LoanPropertyEnum.InGroup);
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                } else {
                    info.setSourceBillType(null);
                }
            }
            if (this.txtrateAmount.getNumberValue() != null && this.txtrateAmount.getNumberValue().longValue() == 0L) {
                this.txtrepayAmount.setValue((Object)(info.getRepayAmount() == null ? Constants.ZERO : info.getRepayAmount()));
                this.countRateAmount();
            }
            if (info.isIsRepayInt()) {
                this.calInt(info);
            }
            info.setTotalRepayAmt(this.txtrate.getBigDecimalValue());
            info.setCompany(this.currentCompany);
            info.setStatus(LoanRepayStatusEnum.SAVE);
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            this.setRepayAcctBank(info);
        }
    }

    private void setRepayAcctBank(LoanRepaymentApplyInfo info) {
        if (info.getRepayAcctBank() != null) {
            AccountBankInfo tmpBankAcctInfo = null;
            try {
                AccountBankInfo coreBaseInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getRepayAcctBank().getId().toString()));
                if (coreBaseInfo != null && coreBaseInfo instanceof AccountBankInfo) {
                    tmpBankAcctInfo = coreBaseInfo;
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            info.setRepayAcctBank(tmpBankAcctInfo);
        }
    }

    public void calInt(LoanRepaymentApplyInfo info) {
        block20: {
            try {
                if (info.getSourceBillType() == null) break block20;
                ILoanRepayApplyInterestFacade facade = LoanRepayApplyInterestFacadeFactory.getRemoteInstance();
                if (FromBillType.FundTransfer.equals((Object)info.getSourceBillType()) && (info.getFundTransfer() != null || info.getFundTransfer().getId() != null) && info.getRepayDate() != null && info.getRepayDate().after(info.getLastSettleDate())) {
                    FundTransferInterestBillInfo fundInt;
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(info.getFundTransfer().getId().toString());
                    FundTransferRepayBillInfo repay = new FundTransferRepayBillInfo();
                    repay.setLoan(info.getFundTransfer());
                    repay.setRepayAmt(info.getRepayAmount());
                    repay.setRepayDate(info.getRepayDate());
                    List list = facade.fundTransferInt(info.getLastSettleDate(), info.getRepayDate(), repay);
                    if (list.size() > 0 && (fundInt = (FundTransferInterestBillInfo)list.get(0)) != null && fundInt.getLoanInterestInfo() != null) {
                        com.kingdee.eas.fm.im.util.LoanInterestInfo loanInt = fundInt.getLoanInterestInfo();
                        this.txtrateAmount.setValue((Object)(loanInt.getInterest() == null ? Constants.ZERO : loanInt.getInterest()));
                        this.punlishAmount.setValue((Object)(loanInt.getPunishInterest() == null ? Constants.ZERO : loanInt.getPunishInterest()));
                        BigDecimal principal = this.editData.getRepayAmount();
                        if (principal == null) {
                            principal = info.getRepayAmount();
                        }
                        BigDecimal totalAmt = principal.add(loanInt.getInterest());
                        if (this.chkIsCalPunishInt.isSelected()) {
                            totalAmt = totalAmt.add(loanInt.getPunishInterest());
                        }
                        this.txtrate.setValue((Object)(totalAmt == null ? Constants.ZERO : totalAmt));
                    }
                    break block20;
                }
                if (FromBillType.ConsignmentLoan.equals((Object)info.getSourceBillType()) && info.getCconsignmentLoan() != null && info.getCconsignmentLoan().getId() != null && info.getRepayDate() != null && info.getRepayDate().after(info.getLastSettleDate())) {
                    ConsignLoanIntBillInfo cosInt;
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(info.getCconsignmentLoan().getId().toString());
                    ConsingnRepaymentBillInfo repay = new ConsingnRepaymentBillInfo();
                    repay.setLoan(info.getCconsignmentLoan());
                    repay.setRepayAmt(info.getRepayAmount());
                    repay.setRepayDate(info.getRepayDate());
                    List list = facade.consignmentLoanInt(info.getLastSettleDate(), info.getRepayDate(), repay);
                    if (list.size() > 0 && (cosInt = (ConsignLoanIntBillInfo)list.get(0)) != null && cosInt.getLoanInterestInfo() != null) {
                        com.kingdee.eas.fm.im.util.LoanInterestInfo loanInt = cosInt.getLoanInterestInfo();
                        this.txtrateAmount.setValue((Object)(loanInt.getInterest() == null ? Constants.ZERO : loanInt.getInterest()));
                        this.punlishAmount.setValue((Object)(loanInt.getPunishInterest() == null ? Constants.ZERO : loanInt.getPunishInterest()));
                        BigDecimal principal = this.editData.getRepayAmount();
                        if (principal == null) {
                            principal = info.getRepayAmount();
                        }
                        BigDecimal totalAmt = principal.add(loanInt.getInterest());
                        if (this.chkIsCalPunishInt.isSelected()) {
                            totalAmt = totalAmt.add(loanInt.getPunishInterest());
                        }
                        this.txtrate.setValue((Object)(totalAmt == null ? Constants.ZERO : totalAmt));
                    }
                    break block20;
                }
                if (FromBillType.ChLoan.equals((Object)info.getSourceBillType()) && (info.getChLoan() != null || info.getChLoan().getId() != null) && info.getRepayDate() != null && info.getRepayDate().after(info.getLastSettleDate())) {
                    HashSet<String> idSet = new HashSet<String>();
                    try {
                        LoanInterestBillInfo loanInt;
                        IChLoan chLoanBill = ChLoanFactory.getRemoteInstance();
                        ObjectUuidPK pk = new ObjectUuidPK(info.getChLoan().getId());
                        ChLoanInfo chLoanInfo = chLoanBill.getChLoanInfo((IObjectPK)pk);
                        idSet.add(info.getChLoan().getId().toString());
                        EntRepaymentBillInfo repay = new EntRepaymentBillInfo();
                        repay.setRepayTotalAmt(Constants.ZERO);
                        repay.setLoanBillID(chLoanInfo);
                        repay.setChLoanInfo(chLoanInfo);
                        repay.setRepayAmt(info.getRepayAmount());
                        repay.setRepayDate(info.getRepayDate());
                        List list = facade.chLoanInt(info.getLastSettleDate(), info.getRepayDate(), repay);
                        if (list.size() > 0 && (loanInt = (LoanInterestBillInfo)list.get(0)) != null) {
                            this.txtrateAmount.setValue((Object)(loanInt.getInterest() == null ? Constants.ZERO : loanInt.getInterest()));
                            this.punlishAmount.setValue((Object)(loanInt.getPunishInterest() == null ? Constants.ZERO : loanInt.getPunishInterest()));
                            BigDecimal principal = this.editData.getRepayAmount();
                            if (principal == null) {
                                principal = info.getRepayAmount();
                            }
                            BigDecimal totalAmt = principal.add(loanInt.getInterest());
                            if (this.chkIsCalPunishInt.isSelected()) {
                                totalAmt = totalAmt.add(loanInt.getPunishInterest());
                            }
                            this.txtrate.setValue((Object)(totalAmt == null ? Constants.ZERO : totalAmt));
                        }
                        break block20;
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    break block20;
                }
                if (FromBillType.Loan.equals((Object)info.getSourceBillType()) && (info.getLoan() != null || info.getLoan().getId() != null) && info.getRepayDate() != null && info.getRepayDate().compareTo(info.getLastSettleDate()) >= 0) {
                    LoanInterestInfo loanInt;
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(info.getLoan().getId().toString());
                    RepaymentInfo repay = new RepaymentInfo();
                    repay.setSourceBillId(info.getLoan().getId().toString());
                    repay.setLoan(info.getLoan());
                    repay.setAmount(info.getRepayAmount());
                    repay.setBizDate(info.getRepayDate());
                    repay.setIsCalInt(true);
                    repay.setIsCalPunishInt(true);
                    repay.setAddAmount(new BigDecimal(0));
                    repay.setIsRepayInt(true);
                    List list = facade.loanInt(info.getLastSettleDate(), info.getRepayDate(), repay);
                    if (list.size() > 0 && (loanInt = (LoanInterestInfo)list.get(0)) != null) {
                        this.txtrateAmount.setValue((Object)(loanInt.getInterest() == null ? Constants.ZERO : loanInt.getInterest()));
                        this.punlishAmount.setValue((Object)(loanInt.getPunishInterest() == null ? Constants.ZERO : loanInt.getPunishInterest()));
                        BigDecimal principal = this.editData.getRepayAmount();
                        if (principal == null) {
                            principal = info.getRepayAmount();
                        }
                        BigDecimal totalAmt = principal.add(loanInt.getInterest());
                        if (this.chkIsCalPunishInt.isSelected()) {
                            totalAmt = totalAmt.add(loanInt.getPunishInterest());
                        }
                        this.txtrate.setValue((Object)(totalAmt == null ? Constants.ZERO : totalAmt));
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    protected IObjectValue createNewData() {
        LoanRepaymentApplyInfo info = new LoanRepaymentApplyInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCompany(this.currentCompany);
        info.setStatus(LoanRepayStatusEnum.SAVE);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setRepayDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setRateAmount(new BigDecimal(0));
        info.setSourceBillType(null);
        info.setLoanProperty(LoanPropertyEnum.OutGroup);
        return info;
    }

    private void initComponent() throws Exception {
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtRepayAcctBank, (boolean)true);
        this.prmtRepayAcctBank.setEnabledMultiSelection(false);
        this.actionAddNew.setVisible(false);
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    @Override
    protected void pkrepayDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkrepayDate.getValue() != null && this.pklastSettleDate.getValue() != null) {
            if (this.pkrepayDate.getSqlDate().compareTo(this.pklastSettleDate.getSqlDate()) == -1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"repayDateVarity"));
                SysUtil.abort();
            } else {
                this.editData.setRepayDate(this.pkrepayDate.getSqlDate());
                if (this.chkIsRepayInt.isSelected()) {
                    this.calInt(this.editData);
                }
            }
        }
    }

    protected void txtrate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtrate.getValue() != null && this.txtrate.getBigDecimalValue().compareTo(new BigDecimal(0)) == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"reteVarity"));
            SysUtil.abort();
        }
    }

    @Override
    protected void txtrepayAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtrepayAmount.getValue() != null) {
            if (this.txtrepayAmount.getBigDecimalValue().compareTo(new BigDecimal(0)) == -1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"repayAmountVarity"));
                this.txtrepayAmount.setValue((Object)this.editData.getLoanBalance());
                SysUtil.abort();
            } else if (this.txtrepayAmount.getBigDecimalValue().compareTo(this.editData.getLoanBalance() == null ? Constants.ZERO : this.editData.getLoanBalance()) == 1) {
                this.txtrepayAmount.setValue((Object)this.editData.getLoanBalance());
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"repayAmountOverVarity"));
                SysUtil.abort();
            } else {
                this.editData.setRepayAmount(this.txtrepayAmount.getBigDecimalValue());
                if (this.chkIsRepayInt.isSelected()) {
                    this.calInt(this.editData);
                } else {
                    this.countRateAmount();
                }
            }
        }
    }

    @Override
    protected void chkIsCalPunishInt_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIsCalPunishInt.isSelected()) {
            this.calInt(this.editData);
        } else {
            this.countRateAmount();
            this.punlishAmount.setValue((Object)new BigDecimal(0));
        }
    }

    @Override
    protected void chkIsRepayInt_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIsRepayInt.isSelected()) {
            this.calInt(this.editData);
        } else {
            this.countRateAmount();
            this.txtrateAmount.setValue((Object)new BigDecimal(0));
        }
    }

    @Override
    protected void txtrateAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.countRateAmount();
        super.txtrateAmount_dataChanged(e);
    }

    @Override
    protected void punlishAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.countRateAmount();
        super.punlishAmount_dataChanged(e);
    }

    private void countRateAmount() {
        BigDecimal punlish;
        BigDecimal repayAmt = this.txtrepayAmount.getValue() != null ? this.txtrepayAmount.getBigDecimalValue() : Constants.ZERO;
        BigDecimal rateAmount = this.txtrateAmount.getValue() != null ? this.txtrateAmount.getBigDecimalValue() : Constants.ZERO;
        BigDecimal bigDecimal = punlish = this.punlishAmount.getValue() != null ? this.punlishAmount.getBigDecimalValue() : Constants.ZERO;
        if (this.chkIsCalPunishInt.isSelected()) {
            repayAmt = repayAmt.add(punlish);
        }
        if (this.chkIsRepayInt.isSelected()) {
            repayAmt = repayAmt.add(rateAmount);
        }
        this.txtrate.setValue((Object)repayAmt);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            this.setOprtState("ADDNEW");
            return "fin_loanrepaymentapply_02addnew";
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "fin_loanrepaymentapply_02addnew";
        }
        return "fin_loanrepaymentapply_01view";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("sourcBillNumber"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("lastSettleDate"));
        sic.add(new SelectorItemInfo("repayDate"));
        sic.add(new SelectorItemInfo("repayAmount"));
        sic.add(new SelectorItemInfo("totalRepayAmt"));
        sic.add(new SelectorItemInfo("rateAmount"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("creditors.id"));
        sic.add(new SelectorItemInfo("creditors.name"));
        sic.add(new SelectorItemInfo("repayApplyDes"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("isRepayInt"));
        sic.add(new SelectorItemInfo("isCalPunishInt"));
        sic.add(new SelectorItemInfo("punishAmount"));
        sic.add(new SelectorItemInfo("loan.id"));
        sic.add(new SelectorItemInfo("loan.name"));
        sic.add(new SelectorItemInfo("chLoan.id"));
        sic.add(new SelectorItemInfo("chLoan.name"));
        sic.add(new SelectorItemInfo("fundTransfer.id"));
        sic.add(new SelectorItemInfo("fundTransfer.name"));
        sic.add(new SelectorItemInfo("cconsignmentLoan.id"));
        sic.add(new SelectorItemInfo("cconsignmentLoan.name"));
        sic.add(new SelectorItemInfo("repayAcctBank.id"));
        sic.add(new SelectorItemInfo("repayAcctBank.name"));
        sic.add(new SelectorItemInfo("loanBank.id"));
        sic.add(new SelectorItemInfo("loanBank.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("loanProperty"));
        return sic;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.editData.setStatus(LoanRepayStatusEnum.SUBMIT);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.editData.setStatus(LoanRepayStatusEnum.SAVE);
        super.actionSave_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.txtNumber.setRequired(this.txtNumber.isEnabled());
        if (this.pkrepayDate.getValue() != null && this.pklastSettleDate.getValue() != null && this.pkrepayDate.getSqlDate().compareTo(this.pklastSettleDate.getSqlDate()) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"repayDateVarity"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    @Override
    protected void sourceBillType_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setApplyDate(DateTimeUtils.truncateDate((Date)this.editData.getApplyDate()));
        this.editData.setRepayDate(DateTimeUtils.truncateDate((Date)this.editData.getRepayDate()));
        this.editData.setLastSettleDate(DateTimeUtils.truncateDate((Date)this.editData.getLastSettleDate()));
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        return super.getSrcBosTypeForBotp(srcBosTypeList);
    }

    protected void initDataStatus() {
        boolean isActionEnabled;
        super.initDataStatus();
        boolean bl = isActionEnabled = this.getOprtState().equals(OprtState.VIEW) || "FINDVIEW".equals(this.getOprtState());
        if (this.editData != null) {
            boolean isCanSaved = this.editData.getStatus() == null || this.editData.getStatus() == LoanRepayStatusEnum.SAVE;
            this.actionSave.setEnabled(isCanSaved);
        }
        this.actionCreateFrom.setEnabled(!isActionEnabled);
        this.actionCreateFrom.setVisible(!isActionEnabled);
        if (LoanRepayStatusEnum.AUDITED.equals((Object)((LoanRepaymentApplyInfo)this.getDataObject()).getStatus())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
        this.unLockUI();
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.bizPromptCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
    }
}

