/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterOfCreditAcctRecStatusEnum;
import com.kingdee.eas.fm.fin.LockRemitFactory;
import com.kingdee.eas.fm.fin.LockRemitInfo;
import com.kingdee.eas.fm.fin.client.AbstractLockRemitEditUI;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class LockRemitEditUI
extends AbstractLockRemitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LockRemitEditUI.class);
    LetterOfCreditReachInfo info;

    public void onLoad() throws Exception {
        this.initProEvi();
        super.onLoad();
        this.initUIProp();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.initUIData();
        }
        this.fillLossAmount();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initComByLockRemit();
        UIUtil.setSelectObject((KDComboBox)this.comboSrcCurrency, (Object)this.info.getCredit().getCurrency());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String baseCurrId = currentCompany.getBaseCurrency().getId().toString();
        try {
            CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrId));
            UIUtil.setSelectObject((KDComboBox)this.comboDestCurrency, (Object)baseCurrency);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && "audited".equals(this.editData.getBillState().getValue())) {
            this.pkbizDate.setEnabled(false);
            this.txtrate.setEnabled(false);
            this.txtlockRate.setEnabled(false);
            this.pkpayDate.setEnabled(false);
        }
        this.txtmessage.setText(this.editData.getMessage());
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setMessage(this.txtmessage.getText());
        this.editData.setSrcCurrency((CurrencyInfo)this.comboSrcCurrency.getSelectedItem());
        this.editData.setDestCurrency((CurrencyInfo)this.comboDestCurrency.getSelectedItem());
    }

    protected void initProEvi() throws Exception {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection colls = iCurrency.getCurrencyCollection(true);
        FinUtils.initCurrencyComboBox(this.comboSrcCurrency, colls);
        FinUtils.initCurrencyComboBox(this.comboDestCurrency, colls);
    }

    protected void initUIProp() throws Exception {
        this.pklockRemitDate.setSupportedEmpty(false);
        this.pkpayDate.setSupportedEmpty(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtrate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlockRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtactLockRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlossAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtreachBillAmt);
        this.txtrate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtlockRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtactLockRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtrate.setPrecision(4);
        this.txtlockRate.setPrecision(4);
        this.txtactLockRate.setPrecision(4);
        this.txtlossAmount.setPrecision(4);
        this.txtreachBillAmt.setPrecision(4);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LockRemitFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.txtactLockRate.isEnabled()) {
            ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtactLockRate);
        }
        super.verifyInput(e);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        this.info = (LetterOfCreditReachInfo)this.getUIContext().get("LetterOfCreditReach");
        LockRemitInfo objectValue = new LockRemitInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        if (this.info != null) {
            objectValue.setSourceBillId(this.info.getId().toString());
        }
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setReachBillNumber(this.info.getNumber());
        objectValue.setCredit(this.info.getCredit());
        objectValue.setContractNumber(this.info.getCredit().getContractNumber());
        objectValue.setReachBillAmt(this.info.getAmount());
        objectValue.setBillState(LetterOfCreditAcctRecStatusEnum.SUBMITED);
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("billState"));
        return sic;
    }

    private void initUIData() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String baseCurrId = currentCompany.getBaseCurrency().getId().toString();
        CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrId));
        UIUtil.setSelectObject((KDComboBox)this.comboDestCurrency, (Object)baseCurrency);
        this.pkacctRecDate.setValue((Object)this.info.getAccREcord().getBizDate());
        this.pkpayDate.setValue((Object)this.info.getAccREcord().getPayDate());
        UIUtil.setSelectObject((KDComboBox)this.comboSrcCurrency, (Object)this.info.getCredit().getCurrency());
        String companyid = currentCompany.getId().toString();
        String srcCurrId = this.info.getCredit().getCurrency().getId().toString();
        String destCurrId = baseCurrency.getId().toString();
        ExchangeRateInfo rate = FMClientHelper.getExRateInfo((String)companyid, (String)srcCurrId, (String)destCurrId, (Date)this.info.getAccREcord().getBizDate());
        int prec = this.info.getCredit().getCurrency().getPrecision();
        if (rate != null) {
            this.txtrate.setValue((Object)rate.getConvertRate());
            this.txtrate.setPrecision(rate.getPrecision());
            this.txtlockRate.setPrecision(rate.getPrecision());
            this.txtactLockRate.setPrecision(rate.getPrecision());
        } else {
            this.txtrate.setValue((Object)Constants.ONE);
            this.txtrate.setPrecision(prec);
            this.txtlockRate.setPrecision(prec);
            this.txtactLockRate.setPrecision(prec);
        }
        this.txtlossAmount.setPrecision(prec);
        this.txtreachBillAmt.setPrecision(prec);
        this.pklockRemitDate.setValue((Object)DateUtil.getDayBegin());
        this.txtlockRate.setValue((Object)Constants.ZERO);
        this.txtactLockRate.setValue(null);
        this.txtlossAmount.setValue((Object)Constants.ZERO);
    }

    @Override
    protected void chkisLockRemit_actionPerformed(ActionEvent e) throws Exception {
        this.initComByLockRemit();
        this.fillLossAmount();
    }

    @Override
    protected void txtlockRate_dataChanged(DataChangeEvent e) throws Exception {
        this.fillLossAmount();
    }

    @Override
    protected void txtrate_dataChanged(DataChangeEvent e) throws Exception {
        this.fillLossAmount();
    }

    private void initComByLockRemit() {
        if (this.chkisLockRemit.isSelected()) {
            this.pklockRemitDate.setEnabled(true);
            this.txtactLockRate.setEnabled(true);
            this.txtactLockRate.setRequired(true);
        } else {
            this.pklockRemitDate.setEnabled(false);
            this.txtactLockRate.setEnabled(false);
            this.txtactLockRate.setValue(null);
            this.txtactLockRate.setRequired(false);
            this.pklockRemitDate.setValue((Object)DateUtil.getDayBegin());
        }
    }

    private void fillLossAmount() throws EASBizException, BOSException {
        if (this.info == null) {
            this.getInfoById();
        }
        BigDecimal amount = this.info.getAmount();
        BigDecimal rate = this.txtrate.getBigDecimalValue();
        BigDecimal lockRate = this.txtlockRate.getBigDecimalValue();
        if (rate != null && lockRate != null) {
            BigDecimal lossAmt = lockRate.subtract(rate).multiply(amount);
            this.txtlossAmount.setValue((Object)lossAmt);
        }
    }

    private void getInfoById() throws EASBizException, BOSException {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && !EmptyUtil.isEmpty((String)this.editData.getSourceBillId())) {
            String id = this.editData.getSourceBillId();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("Credit.Currency.*"));
            sic.add(new SelectorItemInfo("AccREcord.bizDate"));
            sic.add(new SelectorItemInfo("AccREcord.payDate"));
            this.info = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionExitCurrent_actionPerformed(e);
    }
}

