/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.client.AbstractModifyLetterFilterUI;
import com.kingdee.eas.fm.fin.client.ModifyLetterFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class ModifyLetterFilterUI
extends AbstractModifyLetterFilterUI {
    private static final long serialVersionUID = -1228407551171325296L;
    private static final Logger logger = CoreUIObject.getLogger(ModifyLetterFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        ModifyLetterFilterParam filterParam = new ModifyLetterFilterParam();
        filterParam.setBeginDate((Date)this.kdBeginDate.getValue());
        filterParam.setEndDate((Date)this.kdEndDate.getValue());
        Set prmtLetterNumberSet = this.getIdSetFromF7(this.prmtLetterNumber);
        filterParam.setCompanyIdSet(this.getCompanyIdSet());
        if (prmtLetterNumberSet.size() > 0) {
            filterParam.setLetterOfCreditNumberSet(prmtLetterNumberSet);
        }
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        ModifyLetterFilterParam filterParam = (ModifyLetterFilterParam)((Object)param);
        this.kdBeginDate.setValue((Object)filterParam.getBeginDate());
        this.kdEndDate.setValue((Object)filterParam.getEndDate());
        try {
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            this.prmtLetterNumber.setData((Object)this.getBaseInfoFromIdSet(filterParam.getLetterOfCreditNumberSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.kdBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.kdEndDate.setValue((Object)new Date());
        this.prmtLetterNumber.setValue(null);
    }

    protected void init() throws Exception {
        super.init();
        this.kdBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.kdEndDate.setValue((Object)new Date());
    }

    public boolean verify() {
        java.sql.Date startDate = this.kdBeginDate.getSqlDate();
        java.sql.Date endDate = this.kdEndDate.getSqlDate();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.client.LetterOfCreditResource", (String)"EndDateMustLaterBeginDate");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdBeginDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdEndDate);
        return super.verify();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initLetterNumberPromtBox();
    }

    public void initLetterNumberPromtBox() {
        this.prmtLetterNumber.setQueryInfo("com.kingdee.eas.fm.fin.app.ModifyLetterFilterQuery");
        this.prmtLetterNumber.setDisplayFormat("$LetterNumber$");
        this.prmtLetterNumber.setEditFormat("$LetterNumber$");
        this.prmtLetterNumber.setCommitFormat("$LetterNumber$");
        this.prmtLetterNumber.setEditable(true);
        this.prmtLetterNumber.setVisible(true);
        this.prmtLetterNumber.setEnabledMultiSelection(true);
    }

    protected Class getParamClass() {
        return ModifyLetterFilterParam.class;
    }
}

