/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.client.AbstractRptFinanceCostMeasureFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptFinanceCostMeasureFilterUI
extends AbstractRptFinanceCostMeasureFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(RptFinanceCostMeasureFilterUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    private boolean isVirtualCompany = false;

    public void onInit(RptParams params) throws Exception {
        super.onInit(params);
        this.doInit();
    }

    public void clear() {
        super.clear();
        this.doInit();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void doInit() {
        if (this.currentCompany == null) {
            this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        this.isVirtualCompany = this.isVirtualCompany();
        if (this.isVirtualCompany) {
            this.btnSelectCompany.setEnabled(true);
            this.btnSelectCompany.setVisible(true);
        } else {
            this.btnSelectCompany.setEnabled(false);
            this.btnSelectCompany.setVisible(false);
        }
        this.unit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.forCompany.setSelected(true);
        this.outGroup.setSelected(true);
        this.containBonds.setSelected(true);
        this.bankProp.setEnabledMultiSelection(true);
        this.companyProp.setEnabledMultiSelection(true);
        CurrencyInfo currency = null;
        try {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.currencyProp.setData(currency);
        this.startDate.setValue((Object)RptFinanceCostMeasureFilterUI.getYearFirst(Integer.valueOf(RptFinanceCostMeasureFilterUI.getSysYear())));
        this.endDate.setValue((Object)new Date());
    }

    public static String getSysYear() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        return year;
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void kDCheckBoxOutGroup_itemStateChanged(ItemEvent e) throws Exception {
        this.setBankAndCompany();
    }

    @Override
    protected void kDCheckBoxInGroup_itemStateChanged(ItemEvent e) throws Exception {
        this.setBankAndCompany();
    }

    @Override
    protected void kDCheckBoxContainBonds_itemStateChanged(ItemEvent e) throws Exception {
        this.resetSearchCondition();
    }

    public void setBankAndCompany() {
        if (this.outGroup.isSelected() && !this.inGroup.isSelected()) {
            this.bankProp.setVisible(true);
            this.bankProp.setEnabled(true);
            this.companyProp.setVisible(false);
            this.companyProp.setData(null);
            this.containBonds.setEditable(true);
            try {
                FinUtils.initBankTree((IUIObject)this, this.bankProp, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!this.outGroup.isSelected() && this.inGroup.isSelected()) {
            this.bankProp.setVisible(false);
            this.companyProp.setVisible(true);
            this.companyProp.setEnabled(true);
            this.bankProp.setData(null);
            this.containBonds.setSelected(false);
            this.containBonds.setEnabled(false);
        } else {
            this.bankProp.setData(null);
            this.bankProp.setEnabled(false);
            this.companyProp.setData(null);
            this.companyProp.setEnabled(false);
            this.containBonds.setEnabled(true);
        }
    }

    public void resetSearchCondition() {
        if (this.containBonds.isSelected()) {
            if (this.forDebteeComapny.isSelected() || this.forArea.isSelected() || this.forDebtee.isSelected()) {
                this.forCompany.setSelected(true);
            }
            this.forDebteeComapny.setSelected(false);
            this.forDebteeComapny.setEnabled(false);
            this.forArea.setSelected(false);
            this.forArea.setEnabled(false);
            this.forDebtee.setSelected(false);
            this.forDebtee.setEnabled(false);
            this.bankProp.setEnabled(false);
        } else {
            this.forDebteeComapny.setEnabled(true);
            this.forArea.setEnabled(true);
            this.forDebtee.setEnabled(true);
        }
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        rcm.setProperty("bankIdSet", this.getF7Bank());
        rcm.setProperty("unit", this.unit.getSelectedItem());
        rcm.setProperty("RateCurrencySet", (Object)this.getIdSetFromF7(this.currencyProp));
        rcm.setProperty("startDate", this.startDate.getValue());
        rcm.setProperty("endDate", this.endDate.getValue());
        rcm.setProperty("isVirtualCompany", (Object)this.isVirtualCompany);
        rcm.setProperty("forCompany", (Object)this.forCompany.isSelected());
        rcm.setProperty("forDebtee", (Object)this.forDebtee.isSelected());
        rcm.setProperty("forCurrency", (Object)this.forCurrency.isSelected());
        rcm.setProperty("forDebteeCompany", (Object)this.forDebteeComapny.isSelected());
        rcm.setProperty("forArea", (Object)this.forArea.isSelected());
        rcm.setProperty("forFinanceType", (Object)this.financeType.isSelected());
        rcm.setProperty("inGroup", (Object)this.inGroup.isSelected());
        rcm.setProperty("outGroup", (Object)this.outGroup.isSelected());
        return rcm.toRptParams();
    }

    protected Set<String> getF7Bank() {
        if (!this.inGroup.isSelected() && this.outGroup.isSelected()) {
            return this.getIdSetFromF7(this.bankProp);
        }
        if (this.inGroup.isSelected() && !this.outGroup.isSelected()) {
            return this.getIdSetFromF7(this.companyProp);
        }
        return new HashSet<String>();
    }

    public void setCustomCondition(RptParams params) {
        super.setCustomCondition(params);
        RptConditionManager rm = new RptConditionManager(params);
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        rm.restoreAllStatus((Container)((Object)this));
    }

    public boolean verify() {
        Date endTime;
        Date beginTime;
        if (this.isVirtualCompany && EmptyUtil.isEmpty((Collection)this.companyIdSet)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"385_RptFinanceCostMeasureFilterUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.startDate.getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"386_RptFinanceCostMeasureFilterUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.endDate.getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"387_RptFinanceCostMeasureFilterUI"));
            SysUtil.abort();
        }
        if ((beginTime = (Date)this.startDate.getValue()).equals(endTime = (Date)this.endDate.getValue()) || beginTime.after(endTime)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"388_RptFinanceCostMeasureFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public boolean isVirtualCompany() {
        boolean flag = false;
        try {
            if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                flag = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return flag;
    }
}

