/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.RptGrantCreditFundDetailFilterParam;
import com.kingdee.eas.fm.fin.client.AbstractRptGrantCreditFundFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.log4j.Logger;

public class RptGrantCreditFundFilterUI
extends AbstractRptGrantCreditFundFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptGrantCreditFundFilterUI.class);

    public RptGrantCreditFundFilterUI() throws Exception {
        this.btnCompanySelect.setVisible(true);
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        FinClientHelper.cboRelationsItemStateChanged((CoreUIObject)this, this.cboRelations, this.contBank, this.jbpOrganization, this.contCompany, this.prmtCompany);
    }

    public Object getParam() {
        RptGrantCreditFundDetailFilterParam param = new RptGrantCreditFundDetailFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setOrganizationIdSet(this.getIdSetFromF7(this.jbpOrganization));
        param.setDateFrom(DateUtil.getDayBegin((java.util.Date)((java.util.Date)this.jdForm.getValue())));
        param.setDateTo(DateUtil.getDayBegin((java.util.Date)((java.util.Date)this.jdTo.getValue())));
        param.setAmount(this.jtAmount.getBigDecimalValue());
        param.setUnit((AmountUnitEnum)this.jtAmountUnit.getSelectedItem());
        param.setClosedState(this.checkClosed.isSelected());
        param.setOrganizationIdSet_Company(this.getIdSetFromF7(this.prmtCompany));
        Object selectedValue = this.cboRelations.getSelectedItem();
        if (selectedValue instanceof LimitIsBankCreditEnum) {
            param.setRelations((LimitIsBankCreditEnum)((Object)selectedValue));
        } else {
            param.setRelations(null);
        }
        int orderType = 0;
        if (this.jrbCompany.isSelected()) {
            orderType = 1;
        } else if (this.jrbOrganization.isSelected()) {
            orderType = 2;
            if (param.getRelations() == null) {
                orderType = 5;
            } else if (param.getRelations() == LimitIsBankCreditEnum.INNER) {
                orderType = 4;
            }
        } else if (this.jrbCurrency.isSelected()) {
            orderType = 3;
        }
        param.setOrderType(orderType);
        return param;
    }

    public void setParam(Object param) {
        RptGrantCreditFundDetailFilterParam newparam = (RptGrantCreditFundDetailFilterParam)param;
        this.setCompanyIdSet(newparam.getCompanyIdSet());
        this.checkClosed.setSelected(newparam.getClosedState());
        this.jdForm.setValue((Object)newparam.getDateFrom());
        this.jdTo.setValue((Object)newparam.getDateTo());
        this.jtAmount.setValue((Object)newparam.getAmount());
        FMClientHelper.setSelectObject((KDComboBox)this.jtAmountUnit, (Object)newparam.getUnit());
        switch (newparam.getOrderType()) {
            case 1: {
                this.jrbCompany.setSelected(true);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                this.jrbOrganization.setSelected(true);
                break;
            }
            case 3: {
                this.jrbCurrency.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate status!");
            }
        }
        if (newparam.getRelations() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboRelations, (Object)((Object)newparam.getRelations()));
        }
        if (null != newparam.getOrganizationIdSet()) {
            try {
                this.jbpOrganization.setData((Object)this.getBaseInfoFromIdSet(newparam.getOrganizationIdSet()));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        this.initControl();
    }

    private void initControl() {
        this.jbpOrganization.setData(null);
        this.jbpOrganization.setEditable(true);
        this.jdForm.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.jdTo.setValue((Object)DateUtil.getLastDayOfCurMonth());
        FMClientHelper.setSelectObject((KDComboBox)this.jtAmountUnit, (Object)AmountUnitEnum.wan_yuan);
        this.jtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.jtAmount);
        this.jtAmount.setPrecision(2);
        this.jtAmount.setValue((Object)new BigDecimal("10.00"));
        this.jrbCompany.setSelected(true);
        this.checkClosed.setSelected(false);
        FinClientHelper.initFilterUI((CoreUIObject)this, this.prmtCompany, this.cboRelations);
    }

    public void clear() {
        super.clear();
        this.initControl();
    }

    public boolean verify() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && this.getCompanyIdSet().size() <= 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"406_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
            return false;
        }
        Date kdDateFrom = this.jdForm.getSqlDate();
        Date kdDateTo = this.jdTo.getSqlDate();
        if (kdDateFrom == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"407_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
        }
        if (kdDateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"137_CompDepositBillFilterUI"));
            SysUtil.abort();
        }
        if (kdDateFrom.compareTo(kdDateTo) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"408_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyFilterCompanyIdSet((FMFilterBaseUI)this);
        return super.verify();
    }

    protected Class getParamClass() {
        return RptGrantCreditFundDetailFilterParam.class;
    }
}

