/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.RptLoanDetailFilterParam;
import com.kingdee.eas.fm.fin.client.AbstractRptLoanDetailFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptLoanDetailFilterUI
extends AbstractRptLoanDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptLoanDetailFilterUI.class);

    public RptLoanDetailFilterUI() throws Exception {
        this.setSize(420, 400);
    }

    public Object getParam() {
        RptLoanDetailFilterParam param = new RptLoanDetailFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        if (this.kDCheckBoxOutGroup.isSelected()) {
            param.setBankIdSet(this.getIdSetFromF7(this.prmtInstitution));
        } else {
            param.setBankIdSet(this.getIdSetFromF7(this.prmtInGroup));
        }
        param.setFinProductTypeIdSet(this.getIdSetFromF7(this.prmtFinProductType));
        param.setAmount(this.txtAmount.getBigDecimalValue());
        java.util.Date dateFrom = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateFrom.getSqlDate());
        param.setDateFrom(new Date(dateFrom.getTime()));
        java.util.Date dateTo = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateTo.getSqlDate());
        param.setDateTo(new Date(dateTo.getTime()));
        param.setUnit((AmountUnitEnum)this.statUnit.getSelectedItem());
        param.setDimType(this.kDButtonGroupLoanDetail.getValue() + 1);
        param.setIsViewZeroOfBalance(this.isViewZeroOfBalance.isSelected());
        param.setIsViewRepayment(this.isViewRepayment.isSelected());
        param.setIsViewLongTime(this.isViewLongTime.isSelected());
        param.setDebteeState(this.getDebteeState());
        param.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        return param;
    }

    public void setParam(Object param) {
        RptLoanDetailFilterParam loParam = (RptLoanDetailFilterParam)param;
        try {
            this.setCompanyIdSet(this.filterCompanyWithPermission(loParam.getCompanyIdSet()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.txtAmount.setValue((Object)loParam.getAmount());
        try {
            if (this.kDCheckBoxOutGroup.isSelected()) {
                this.prmtInstitution.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
            } else {
                this.prmtInGroup.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
            }
            this.prmtFinProductType.setData((Object)this.getBaseInfoFromIdSet(loParam.getFinProductTypeIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.rptLDFDateFrom.setValue((Object)loParam.getDateFrom());
        this.rptLDFDateTo.setValue((Object)loParam.getDateTo());
        FMClientHelper.setSelectObject((KDComboBox)this.statUnit, (Object)loParam.getUnit());
        this.kDButtonGroupLoanDetail.setValue(loParam.getDimType() - 1);
        this.isViewZeroOfBalance.setSelected(loParam.isIsViewZeroOfBalance());
        this.isViewRepayment.setSelected(loParam.isIsViewRepayment());
        this.isViewLongTime.setSelected(loParam.isIsViewLongTime());
        if ("1".equals(loParam.getDebteeState())) {
            this.kDCheckBoxOutGroup.setSelected(true);
            this.kDCheckBoxInGroup.setSelected(true);
        } else if ("2".equals(loParam.getDebteeState())) {
            this.kDCheckBoxOutGroup.setSelected(true);
            this.kDCheckBoxInGroup.setSelected(false);
        } else if ("3".equals(loParam.getDebteeState())) {
            this.kDCheckBoxOutGroup.setSelected(false);
            this.kDCheckBoxInGroup.setSelected(true);
        } else {
            this.kDCheckBoxOutGroup.setSelected(false);
            this.kDCheckBoxInGroup.setSelected(false);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)loParam.getCurrency())) {
            this.kdtHistory.setSelected(true);
            this.prmtCurrency.setData(null);
        } else {
            this.kdtCurrent.setSelected(true);
            this.prmtCurrency.setData((Object)loParam.getCurrency());
        }
    }

    public Set filterCompanyWithPermission(Set companyIdSet) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        IPermission permission = PermissionFactory.getRemoteInstance();
        Set idSet = permission.getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, "fin_LoanDetail_list");
        companyIdSet.retainAll(idSet);
        return companyIdSet;
    }

    protected String getDebteeState() {
        if (this.kDCheckBoxOutGroup.isSelected() && this.kDCheckBoxInGroup.isSelected()) {
            return new String("1");
        }
        if (this.kDCheckBoxOutGroup.isSelected() && !this.kDCheckBoxInGroup.isSelected()) {
            return new String("2");
        }
        if (!this.kDCheckBoxOutGroup.isSelected() && this.kDCheckBoxInGroup.isSelected()) {
            return new String("3");
        }
        return new String("4");
    }

    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    public void clear() {
        super.clear();
        this.doInit();
    }

    private void doInit() {
        this.prmtInstitution.setEditable(true);
        this.initFirstDayOfMonth(this.rptLDFDateFrom);
        this.initLastDayOfMonth(this.rptLDFDateTo);
        this.txtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setValue((Object)Constants.TEN);
        this.prmtInstitution.setData(null);
        FMClientHelper.setSelectObject((KDComboBox)this.statUnit, (Object)AmountUnitEnum.wan_yuan);
        this.kDButtonGroupLoanDetail.setValue(0);
        this.isViewZeroOfBalance.setSelected(false);
        this.isViewRepayment.setSelected(false);
        this.isViewLongTime.setSelected(false);
        this.kDLabelContainerOutGroup.setVisible(true);
        this.kDLabelContainerInGroup.setVisible(false);
        this.kDCheckBoxOutGroup.setSelected(true);
        this.kDCheckBoxInGroup.setSelected(false);
        this.prmtInstitution.setDisplayFormat("$name$");
        this.prmtInstitution.setEditFormat("$number$");
        this.prmtInstitution.setEnabledMultiSelection(true);
        this.prmtInstitution.setEditable(true);
        this.prmtInstitution.setCommitFormat("$number$");
        this.prmtInstitution.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        try {
            FinUtils.initBankTree((IUIObject)this, this.prmtInstitution, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prmtInGroup.setEntityViewInfo(FinUtils.getPrmtGroupF7Filter());
        this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
        this.kdtHistory.setSelected(true);
        this.kdtCurrent.setSelected(false);
        this.prmtCurrency.setEnabled(false);
        this.prmtCurrency.setData(null);
        FinClientHelper.initFinProduct(this.prmtFinProductType);
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    public boolean verify() {
        Date kdDateFrom = this.rptLDFDateFrom.getSqlDate();
        Date kdDateTo = this.rptLDFDateTo.getSqlDate();
        if (kdDateFrom == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"407_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
        }
        if (kdDateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"137_CompDepositBillFilterUI"));
            SysUtil.abort();
        }
        if (kdDateFrom.compareTo(kdDateTo) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"408_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
        }
        if (!this.kDCheckBoxOutGroup.isSelected() & !this.kDCheckBoxInGroup.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"416_RptLoanBalanceFilterUI"));
            return false;
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return RptLoanDetailFilterParam.class;
    }

    @Override
    protected void kDCheckBoxOutGroup_itemStateChanged(ItemEvent e) throws Exception {
        this.adjustInstitution();
    }

    @Override
    protected void kDCheckBoxInGroup_itemStateChanged(ItemEvent e) throws Exception {
        this.adjustInstitution();
    }

    protected void adjustInstitution() {
        if (this.kDCheckBoxOutGroup.isSelected() & this.kDCheckBoxInGroup.isSelected()) {
            this.prmtInstitution.setData(null);
            this.prmtInstitution.setEnabled(false);
            this.prmtInGroup.setData(null);
            this.prmtInGroup.setEnabled(false);
            this.kDLabelContainerOutGroup.setVisible(true);
            this.kDLabelContainerInGroup.setVisible(false);
        } else if (this.kDCheckBoxOutGroup.isSelected() & !this.kDCheckBoxInGroup.isSelected()) {
            this.kDLabelContainerOutGroup.setVisible(true);
            this.prmtInstitution.setEnabled(true);
            this.kDLabelContainerInGroup.setVisible(false);
            this.prmtInGroup.setData(null);
        } else if (!this.kDCheckBoxOutGroup.isSelected() & this.kDCheckBoxInGroup.isSelected()) {
            this.kDLabelContainerOutGroup.setVisible(false);
            this.prmtInstitution.setData(null);
            this.kDLabelContainerInGroup.setVisible(true);
            this.prmtInGroup.setEnabled(true);
        } else {
            this.prmtInstitution.setData(null);
            this.prmtInstitution.setEnabled(true);
            this.prmtInGroup.setData(null);
            this.prmtInGroup.setEnabled(true);
            this.kDLabelContainerOutGroup.setVisible(true);
            this.kDLabelContainerInGroup.setVisible(false);
        }
    }

    @Override
    protected void kdtHistory_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtCurrency.setEnabled(false);
        this.prmtCurrency.setData(null);
    }

    @Override
    protected void kdtCurrent_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtCurrency.setEnabled(true);
        BOSUuid id = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        this.prmtCurrency.setData((Object)currency);
    }
}

