/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.client.AbstractRptTimeDepositBalanceFilterUI;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RptTimeDepositBalanceFilterUI
extends AbstractRptTimeDepositBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositBalanceFilterUI.class);
    private CurrencyInfo baseCurrency;

    public RptTimeDepositBalanceFilterUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        this.prmtBank.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
        this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
    }

    public void clear() {
        super.clear();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.btnCompanySelect.setVisible(true);
        this.btnCompanySelect.setEnabled(true);
        this.kDLabelContainer7.setVisible(false);
    }

    private void customInit() {
        this.initCurrency();
        this.initDate();
        this.initBillType();
        this.initStatisticalUnit();
        this.intQueryType();
        this.initAmt();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public boolean verify() {
        this.checkAmtValid();
        return super.verify();
    }

    private void checkAmtValid() {
        if (this.kdftAmtFrom.getBigDecimalValue().compareTo(this.kdftAmtTo.getBigDecimalValue()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"435_RptTimeDepositBalanceFilterUI"));
            SysUtil.abort();
        }
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboCurrency.setSelectedItem((Object)this.baseCurrency);
    }

    private void initDate() {
        this.dpEndDate.setSupportedEmpty(false);
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
    }

    private void initBillType() {
        this.cboType.removeAllItems();
        this.cboType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    private void initStatisticalUnit() {
        this.comboUnit.removeAllItems();
        this.comboUnit.addItems(StatisticalUnitEnum.getEnumList().toArray());
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
    }

    private void intQueryType() {
        this.rdByDepComp.setSelected(true);
    }

    private void initAmt() {
        this.kdftAmtFrom.setPrecision(2);
        this.kdftAmtTo.setPrecision(2);
        this.kdftAmtFrom.setSupportedEmpty(false);
        this.kdftAmtTo.setSupportedEmpty(false);
        this.kdftAmtFrom.setMinimumValue((Comparable)Constants.ZERO);
        this.kdftAmtTo.setMinimumValue((Comparable)Constants.ZERO);
        this.kdftAmtFrom.setValue((Object)Constants.ZERO);
        this.kdftAmtTo.setValue((Object)Constants.ZERO);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        RptTimeDepositBalanceFilterParam filterParam = new RptTimeDepositBalanceFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyIDs(this.getCurrencyParam());
        Object obj = this.cboType.getSelectedItem();
        if (obj instanceof TimeDepositTypeEnum) {
            filterParam.setTimeDepositType((TimeDepositTypeEnum)obj);
        } else {
            filterParam.setTimeDepositType(null);
        }
        filterParam.setDepCompanyIDs(this.getCompanyIds());
        filterParam.setStatisticalUnit((StatisticalUnitEnum)this.comboUnit.getSelectedItem());
        filterParam.setAmtFrom(this.kdftAmtFrom.getBigDecimalValue());
        filterParam.setAmtTo(this.kdftAmtTo.getBigDecimalValue());
        if (this.rdByDepComp.isSelected()) {
            filterParam.setQueryType("By_Bank");
        } else if (this.rdByCurrency.isSelected()) {
            filterParam.setQueryType("By_Currency");
        }
        return filterParam;
    }

    private String[] getCurrencyParam() {
        String[] currencyIds = null;
        Object currencySelected = this.comboCurrency.getSelectedItem();
        if (currencySelected instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            currencyIds = new String[]{info.getId().toString()};
        } else {
            currencyIds = null;
        }
        return currencyIds;
    }

    public void setParam(Object param) {
        RptTimeDepositBalanceFilterParam filterParam = (RptTimeDepositBalanceFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            if (filterParam.getCurrencyIDs() != null && filterParam.getCurrencyIDs().length > 0) {
                String selectedId = filterParam.getCurrencyIDs()[0];
                this.comboCurrency.setSelectedItem((Object)this.getSelectCurrency(selectedId));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
            this.prmtBank.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getDepCompanyIDs())));
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (filterParam.getTimeDepositType() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboType, (Object)filterParam.getTimeDepositType());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboUnit.setSelectedItem((Object)filterParam.getStatisticalUnit());
        this.kdftAmtFrom.setValue((Object)filterParam.getAmtFrom());
        this.kdftAmtTo.setValue((Object)filterParam.getAmtTo());
        if ("By_Bank".equals(filterParam.getQueryType())) {
            this.rdByDepComp.setSelected(true);
        } else if ("By_Currency".equals(filterParam.getQueryType())) {
            this.rdByCurrency.setSelected(true);
        }
    }

    private CurrencyInfo getSelectCurrency(String selectedId) {
        CurrencyInfo selectedInfo = null;
        try {
            selectedInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        return selectedInfo;
    }

    protected Class getParamClass() {
        return RptTimeDepositBalanceFilterParam.class;
    }
}

