/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.client.AbstractRptTimeDepositDetailFilterUI;
import com.kingdee.eas.fm.fin.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class RptTimeDepositDetailFilterUI
extends AbstractRptTimeDepositDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositDetailFilterUI.class);
    private CurrencyInfo baseCurrency;

    public RptTimeDepositDetailFilterUI() throws Exception {
        this.prmtDepCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        this.prmtDepCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.prmtDepCompany.setValue(null);
        this.btnCompanySelect.setVisible(true);
        this.btnCompanySelect.setEnabled(true);
        this.kDLabelContainer7.setVisible(false);
        CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
        this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
    }

    public void clear() {
        super.clear();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
    }

    private void customInit() {
        this.initCurrency();
        this.initDate();
        this.initBillType();
        this.initStatisticalUnit();
        this.intQueryType();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboCurrency.setSelectedItem((Object)this.baseCurrency);
    }

    private void initDate() {
        java.util.Date now = DateUtil.getDayBegin();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private void initBillType() {
        this.cboType.removeAllItems();
        this.cboType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    private void initStatisticalUnit() {
        this.comboUnit.removeAllItems();
        this.comboUnit.addItems(StatisticalUnitEnum.getEnumList().toArray());
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
    }

    private void intQueryType() {
        this.rdByDepCompany.setSelected(true);
    }

    private java.util.Date getStartDate(java.util.Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public Object getParam() {
        RptTimeDepositDetailFilterParam filterParam = new RptTimeDepositDetailFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setStartDate(this.dpStartDate.getSqlDate());
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyIDs(this.getCurrencyParam());
        Object obj = this.cboType.getSelectedItem();
        if (obj instanceof TimeDepositTypeEnum) {
            filterParam.setTimeDepositType((TimeDepositTypeEnum)obj);
        } else {
            filterParam.setTimeDepositType(null);
        }
        filterParam.setDepCompanyIDs(this.getCompanyIds());
        filterParam.setStatisticalUnit((StatisticalUnitEnum)this.comboUnit.getSelectedItem());
        if (this.rdByDepCompany.isSelected()) {
            filterParam.setQueryType("By_DepCompany");
        } else if (this.rdByCurrency.isSelected()) {
            filterParam.setQueryType("By_Currency");
        }
        return filterParam;
    }

    private String[] getCurrencyParam() {
        String[] currencyIds = null;
        Object currencySelected = this.comboCurrency.getSelectedItem();
        if (currencySelected instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            currencyIds = new String[]{info.getId().toString()};
        } else {
            currencyIds = null;
        }
        return currencyIds;
    }

    public void setParam(Object param) {
        RptTimeDepositDetailFilterParam filterParam = (RptTimeDepositDetailFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            if (filterParam.getCurrencyIDs() != null && filterParam.getCurrencyIDs().length > 0) {
                String selectedId = filterParam.getCurrencyIDs()[0];
                this.comboCurrency.setSelectedItem((Object)this.getSelectCurrency(selectedId));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
            this.prmtDepCompany.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getDepCompanyIDs())));
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (filterParam.getTimeDepositType() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboType, (Object)filterParam.getTimeDepositType());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboUnit.setSelectedItem((Object)filterParam.getStatisticalUnit());
        if ("By_DepCompany".equals(filterParam.getQueryType())) {
            this.rdByDepCompany.setSelected(true);
        } else if ("By_Currency".equals(filterParam.getQueryType())) {
            this.rdByCurrency.setSelected(true);
        }
    }

    private CurrencyInfo getSelectCurrency(String selectedId) {
        CurrencyInfo selectedInfo = null;
        try {
            selectedInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        return selectedInfo;
    }

    public boolean verify() {
        Date kdDateTo;
        Date kdDateFrom = this.dpStartDate.getSqlDate();
        if (kdDateFrom.compareTo(kdDateTo = this.dpEndDate.getSqlDate()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"436_RptTimeDepositDetailFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return RptTimeDepositDetailFilterParam.class;
    }
}

