/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.fin.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.fin.client.RptTimeDepositFilterParamAdapterTest;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;

public class RptTimeDepositHandlerAdapter
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final String TDSOURCE_PATH = "com.kingdee.eas.fm.fin.TimeDeposittResource";
    private RptTimeDepositFilterParamAdapterTest params;
    private CompanyOrgUnitInfo currentCompany;
    private int queryType;
    private String orderByColumn = "fdepcompanyid";
    private Date endDate;
    private StatisticalUnitEnum amountUnit;
    private String[] currencyIDs;
    private String[] DepCompanyIDs;
    private String unit;
    private int precisionLocalCurrency = 2;

    public RptTimeDepositHandlerAdapter(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    public RptTimeDepositHandlerAdapter(KDTable tblMain, FilterInfo filterInfo) {
        super(filterInfo, tblMain);
    }

    protected void prepare() {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            this.precisionLocalCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId())).getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.queryType = this.params.getType();
        if (this.queryType == 0) {
            this.orderByColumn = " depcompanyName";
        } else if (this.queryType == 1) {
            this.orderByColumn = " companyName";
        } else if (this.queryType == 2) {
            this.orderByColumn = " fcurrencyName";
        }
        this.endDate = this.params.getEndDate();
        this.amountUnit = this.params.getStatisticalUnit();
        this.currencyIDs = this.params.getCurrencyIDs();
        this.DepCompanyIDs = this.params.getDepCompanyIDs();
        this.unit = "1";
        if (this.amountUnit.equals((Object)StatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( td.FEffectedStatus <> 1  ");
        if (this.currentCompany == null) {
            this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        sb.append(" and td.fcompanyid='").append(this.currentCompany.getId().toString()).append("' ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and td.fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.DepCompanyIDs != null && this.DepCompanyIDs.length > 0) {
            sb.append(" and td.fdepcompanyid in ").append(this.getValues(this.DepCompanyIDs));
        }
        if (this.params instanceof RptTimeDepositDetailFilterParam) {
            Date startDate = ((RptTimeDepositDetailFilterParam)this.params).getStartDate();
            Date endDate = ((RptTimeDepositDetailFilterParam)this.params).getEndDate();
            sb.append(" and td.feffectivedate <= { ").append(FMConstants.FORMAT_TIME.format(endDate)).append("}");
            sb.append(" and td.feffectivedate >= { ").append(FMConstants.FORMAT_TIME.format(startDate)).append("}");
        } else if (this.params instanceof RptTimeDepositBalanceFilterParam) {
            if (this.endDate != null) {
                sb.append(" and td.feffectivedate <={ ").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("}   ");
            }
            if (this.params.getAmtFrom() != null && this.params.getAmtFrom().compareTo(Constants.ZERO) > 0) {
                sb.append(" and td.FAmount >= ").append(this.params.getAmtFrom());
            }
            if (this.params.getAmtTo() != null && this.params.getAmtTo().compareTo(Constants.ZERO) > 0) {
                sb.append(" and td.FAmount <= ").append(this.params.getAmtTo());
            }
        }
        if (this.params.getTimeDepositType() != null) {
            sb.append(" and td.FDepositType = '").append(this.params.getTimeDepositType().getValue()).append("' ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getValues(String[] IDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < IDs.length; ++i) {
            sb.append("'").append(IDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    public void setChloanDetailFilterParam(RptTimeDepositFilterParamAdapterTest rptChloanDetailFilterParam) {
        this.params = rptChloanDetailFilterParam;
    }

    public void initHeader() {
        super.initHeader();
    }

    protected String getQueryPath() {
        return "";
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    private String getDetailSQL() {
        StringBuffer sbDetailSQL = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sbDetailSQL.append("select fcurrencyid,fcompanyid,fintratetableid,fdepcompanyid,                                                          \n");
        sbDetailSQL.append("       fcurrencyName,companyName,rateTypeName,depcompanyName,                                                         \n");
        sbDetailSQL.append("       FDepositType, fcurrencyPrecision,                                                                                           \n");
        sbDetailSQL.append("       fnumber,fid,                                                                                             \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       finitbalanceofhistorybill/" + this.unit + " as FAmount,                                                                                             \n");
        sbDetailSQL.append("       finitbalanceofhistorybill*fexchangerate/" + this.unit + " as FNaturalAmt,                                                                                        \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       undepositamt/" + this.unit + " as undepositamt,                                                                                            \n");
        sbDetailSQL.append("       undepositamtLoacl/" + this.unit + " as undepositamtLoacl,                                                                                       \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       (FAmount - undepositamt)/" + this.unit + " as balance,                                                                 \n");
        sbDetailSQL.append("       (FNaturalAmt - undepositamtLoacl)/" + this.unit + " as balanceLocal,                                                  \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("  fintratetypeexpression,\t\t\t\t\t\t\t\t\t\t\t\n");
        sbDetailSQL.append("       fintratetypeexpressiondis,                                                                                  \n");
        sbDetailSQL.append("       FYearDays,                                                                                             \n");
        sbDetailSQL.append("       rate,                                                                                                    \n");
        sbDetailSQL.append("       currate,                                                                                      \n");
        sbDetailSQL.append("       feffectivedate,                                                                                          \n");
        sbDetailSQL.append("       fmaturityday,                                                                                            \n");
        sbDetailSQL.append("       fdescription,                                                                                            \n");
        sbDetailSQL.append("       fcertificateno                                                                                           \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       from                                                                                                     \n");
        sbDetailSQL.append("       (                                                                                                        \n");
        sbDetailSQL.append("        select                                                                                                  \n");
        sbDetailSQL.append("        td.fcurrencyid as fcurrencyid,                                                                          \n");
        sbDetailSQL.append("        td.fcompanyid as fcompanyid,                                                                            \n");
        sbDetailSQL.append("        td.fintratetableid as fintratetableid,                                                                  \n");
        sbDetailSQL.append("        td.fdepcompanyid as fdepcompanyid,                                                                           \n");
        sbDetailSQL.append("        cur.FNAME_").append(loc).append("  as fcurrencyName,  cur.fprecision as fcurrencyPrecision,                                                                        \n");
        sbDetailSQL.append("        com.FNAME_").append(loc).append("  as companyName,                                                                            \n");
        sbDetailSQL.append("        rateType.FNAME_").append(loc).append("  as rateTypeName,                                                                      \n");
        sbDetailSQL.append("        depcompany.FNAME_").append(loc).append("  as depcompanyName,                                                                              \n");
        sbDetailSQL.append(" td.finitbalanceofhistorybill as finitbalanceofhistorybill,td.fexchangerate as fexchangerate, \n");
        sbDetailSQL.append(" (                                                 ");
        sbDetailSQL.append("          case td.fdeposittype                 ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"437_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"438_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"497_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"498_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append("           else ''                                 ");
        sbDetailSQL.append("           end                                     ");
        sbDetailSQL.append(" )as fdeposittype,                             ");
        sbDetailSQL.append("        td.fnumber as fnumber, td.fid as fid,                                                                   \n");
        sbDetailSQL.append("        td.finitbalanceofhistorybill as FAmount,                                                                          \n");
        sbDetailSQL.append("        td.finitbalanceofhistorybill*td.fexchangerate as FNaturalAmt,                                                    \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("        (select isnull(sum(fundepositamt),0) from t_fin_untimedepositbill                                           \n");
        sbDetailSQL.append("         where FUntimeDate <= {" + FMConstants.FORMAT_TIME.format(this.endDate) + "} and  ftimedepositbillid = td.fid                  \n");
        sbDetailSQL.append("         ) +                                                                                                    \n");
        sbDetailSQL.append("         ( case td.FIsChangeByReDeposited                                                                               \n");
        sbDetailSQL.append("          when 1 then ( " + this.getDeducted() + ")                                             \n");
        sbDetailSQL.append("          else 0                                                                                                \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("          ) as undepositamt,                                                                                    \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("        (select isnull(sum(fundepositamt*t_fin_untimedepositbill.fexchangerate),0) from t_fin_untimedepositbill      \n");
        sbDetailSQL.append("         where FUntimeDate <= {" + FMConstants.FORMAT_TIME.format(this.endDate) + "} and  ftimedepositbillid = td.fid                  \n");
        sbDetailSQL.append("        )  +                                                                                                   \n");
        sbDetailSQL.append("        (case td.FIsChangeByReDeposited                                                                              \n");
        sbDetailSQL.append("          when 1 then ( " + this.getDedcutedLocal() + ")         \n");
        sbDetailSQL.append("          else 0                                                                                                \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("        ) as undepositamtLoacl,                                                                                 \n");
        sbDetailSQL.append(" td.fintratetypeexpression, \n");
        sbDetailSQL.append(" (                                        ");
        sbDetailSQL.append("         case td.fintratetypeexpression   ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"439_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"440_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"441_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append("          else ''                         ");
        sbDetailSQL.append("          end                             ");
        sbDetailSQL.append(" ) as  fintratetypeexpressiondis,            ");
        sbDetailSQL.append("        td.FYearDays,                                                                                         \n");
        sbDetailSQL.append("        td.fyearrate as rate,                                                                                 \n");
        sbDetailSQL.append("        td.fcuryearrate as currate,                                                                             \n");
        sbDetailSQL.append("        td.feffectivedate as feffectivedate,                                                                    \n");
        sbDetailSQL.append("        td.fmaturityday as fmaturityday,                                                                        \n");
        sbDetailSQL.append("        td.fdescription as fdescription,                                                                        \n");
        sbDetailSQL.append("        td.fcertificateno as fcertificateno                                                                     \n");
        sbDetailSQL.append("        from T_FIN_CompDepositAccountBill td                                                                            \n");
        sbDetailSQL.append("        left outer join  t_org_company com on com.fid = td.fcompanyid                                           \n");
        sbDetailSQL.append("        left outer join  t_org_company DepCompany on DepCompany.fid = td.fdepcompanyid                                         \n");
        sbDetailSQL.append("        left outer join  t_bd_currency cur on cur.fid = td.fcurrencyid                                          \n");
        sbDetailSQL.append("        left outer join  T_INT_IntRateType rateType on rateType.fid = td.fintratetableid                        \n");
        sbDetailSQL.append("        where                                                                             ").append(this.getCommonFilterToChLoan());
        sbDetailSQL.append(") aa  \n");
        if (this.params instanceof RptTimeDepositBalanceFilterParam) {
            sbDetailSQL.append(" where (FAmount - undepositamt) >0 ");
        }
        sbDetailSQL.append(" order by ").append(this.orderByColumn);
        return sbDetailSQL.toString();
    }

    private String getDeducted() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select isnull(sum((timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt)),0) ");
        sql.append(" from T_FIN_CompDepositAccountBill timinner");
        Date endDate = this.params.getEndDate();
        sql.append(" where timinner.feffectivedate <= {" + FMConstants.FORMAT_TIME.format(endDate) + "} and timinner.fsourcebillid = td.fid and ").append(this.getCommonFilterToChLoan());
        return sql.toString();
    }

    private String getDedcutedLocal() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select isnull(sum((timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt)*timinner.fexchangerate),0) ");
        sql.append(" from T_FIN_CompDepositAccountBill timinner");
        Date endDate = this.params.getEndDate();
        sql.append(" where timinner.feffectivedate <= {" + FMConstants.FORMAT_TIME.format(endDate) + "} and timinner.fsourcebillid = td.fid and ").append(this.getCommonFilterToChLoan());
        return sql.toString();
    }

    protected void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
        this.initCommonColumn();
        IRow row = this.formatCommonHeadRow();
        this.formatCustomerHeadRow(row);
        IRow rowH = this.kdt.addHeadRow();
        this.kdt.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.kdt.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.kdt.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.kdt.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.kdt.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.kdt.getHeadMergeManager().mergeBlock(0, 5, 0, 6);
        rowH.getCell("depositAmt").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("depositAmtLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 7, 0, 8);
        rowH.getCell("undepositAmt").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("undepositAmtLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 9, 0, 10);
        rowH.getCell("balance").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("balanceLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 11, 1, 11);
        this.kdt.getHeadMergeManager().mergeBlock(0, 12, 1, 12);
        this.kdt.getHeadMergeManager().mergeBlock(0, 13, 1, 13);
        this.kdt.getHeadMergeManager().mergeBlock(0, 14, 1, 14);
        this.kdt.getHeadMergeManager().mergeBlock(0, 15, 1, 15);
        this.kdt.getHeadMergeManager().mergeBlock(0, 16, 1, 16);
        this.kdt.getHeadMergeManager().mergeBlock(0, 17, 1, 17);
        this.kdt.getHeadMergeManager().mergeBlock(0, 18, 1, 18);
        this.kdt.getHeadMergeManager().mergeBlock(0, 19, 1, 19);
    }

    protected void initCommonColumn() {
        IColumn cNumber = this.kdt.addColumn();
        cNumber.setKey("number");
        this.formatCol(cNumber);
        IColumn cAmt = this.kdt.addColumn();
        cAmt.setKey("depositAmt");
        this.formatCol(cAmt, 1);
        IColumn cAmtLoacl = this.kdt.addColumn();
        cAmtLoacl.setKey("depositAmtLocal");
        this.formatCol(cAmtLoacl, 1);
        IColumn cUndepositAmt = this.kdt.addColumn();
        cUndepositAmt.setKey("undepositAmt");
        this.formatCol(cUndepositAmt, 1);
        IColumn cUndepositAmtLocal = this.kdt.addColumn();
        cUndepositAmtLocal.setKey("undepositAmtLocal");
        this.formatCol(cUndepositAmtLocal, 1);
        IColumn cBalance = this.kdt.addColumn();
        cBalance.setKey("balance");
        this.formatCol(cBalance, 1);
        IColumn cBalanceLocal = this.kdt.addColumn();
        cBalanceLocal.setKey("balanceLocal");
        this.formatCol(cBalanceLocal, 1);
        IColumn cIntExpression = this.kdt.addColumn();
        cIntExpression.setKey("intExpression");
        this.formatCol(cBalanceLocal, 0);
        IColumn cYearDays = this.kdt.addColumn();
        cYearDays.setKey("yearDays");
        this.formatCol(cYearDays, 0);
        IColumn rRate = this.kdt.addColumn();
        rRate.setKey("rate");
        this.formatCol(rRate, 2);
        IColumn cCurRate = this.kdt.addColumn();
        cCurRate.setKey("curRate");
        this.formatCol(cCurRate, 2);
        IColumn cEffectivedate = this.kdt.addColumn();
        cEffectivedate.setKey("effectiveDate");
        this.formatCol(cEffectivedate, 0);
        IColumn cMaturityday = this.kdt.addColumn();
        cMaturityday.setKey("maturityday");
        this.formatCol(cMaturityday, 0);
        IColumn cDescription = this.kdt.addColumn();
        cDescription.setKey("description");
        this.formatCol(cDescription);
        IColumn cCertificateno = this.kdt.addColumn();
        cCertificateno.setKey("certificateno");
        this.formatCol(cCertificateno);
        IColumn cID = this.kdt.addColumn();
        cID.setKey("id");
        cID.getStyleAttributes().setHided(true);
        IColumn cCurrencyPrecision = this.kdt.addColumn();
        cCurrencyPrecision.setKey("currency.precision");
        cCurrencyPrecision.getStyleAttributes().setHided(true);
    }

    protected IRow formatCommonHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("number").setValue((Object)this.getResString("rpt_balance_number"));
        headRow.getCell("depositAmt").setValue((Object)this.getResString("rpt_common_principal"));
        headRow.getCell("depositAmtLocal").setValue((Object)this.getResString("rpt_common_principal"));
        headRow.getCell("undepositAmt").setValue((Object)this.getResString("rpt_common_unDepositAmt"));
        headRow.getCell("undepositAmtLocal").setValue((Object)this.getResString("rpt_common_unDepositAmt"));
        headRow.getCell("balance").setValue((Object)this.getResString("rpt_common_balance"));
        headRow.getCell("balanceLocal").setValue((Object)this.getResString("rpt_common_balance"));
        headRow.getCell("intExpression").setValue((Object)this.getResString("rpt_balance_rateExpression"));
        headRow.getCell("yearDays").setValue((Object)this.getResString("rpt_balance_yearDays"));
        headRow.getCell("rate").setValue((Object)this.getResString("rpt_balance_rate"));
        headRow.getCell("curRate").setValue((Object)this.getResString("rpt_balance_curRate"));
        headRow.getCell("effectiveDate").setValue((Object)this.getResString("rpt_balance_effectiveDate"));
        headRow.getCell("maturityday").setValue((Object)this.getResString("rpt_balance_maturityDate"));
        headRow.getCell("description").setValue((Object)this.getResString("rpt_balance_diggest"));
        headRow.getCell("certificateno").setValue((Object)this.getResString("rpt_balance_certiNo"));
        headRow.getCell("id").setValue((Object)this.getResString(""));
        headRow.getCell("currency.precision").setValue((Object)this.getResString(""));
        return headRow;
    }

    protected void formatCol(IColumn col, int type) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (type == 1) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        } else if (type == 2) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
        }
    }

    protected void formatCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)TDSOURCE_PATH, (String)key);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        String dformat = FMHelper.getDateFormatString();
        this.kdt.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(dformat);
        this.kdt.getColumn("maturityday").getStyleAttributes().setNumberFormat(dformat);
    }

    protected void initCustomHeader() {
    }

    protected void formatCustomerHeadRow(IRow row) {
    }

    protected void setContentToCommonColumn(IRow row, IRowSet rs) throws SQLException {
        row.getCell("currency.precision").setValue(rs.getObject("fcurrencyPrecision"));
        int precision = Integer.parseInt(row.getCell("currency.precision").getValue().toString());
        row.getCell("number").setValue(rs.getObject("fnumber"));
        row.getCell("depositAmt").setValue(rs.getObject("FAmount"));
        this.initDecimalCol(row.getCell("depositAmt"), precision);
        row.getCell("depositAmtLocal").setValue(rs.getObject("FNaturalAmt"));
        this.initDecimalCol(row.getCell("depositAmtLocal"), precision);
        row.getCell("undepositAmt").setValue(rs.getObject("undepositamt"));
        this.initDecimalCol(row.getCell("undepositAmt"), precision);
        row.getCell("undepositAmtLocal").setValue(rs.getObject("undepositamtLoacl"));
        this.initDecimalCol(row.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        row.getCell("balance").setValue(rs.getObject("balance"));
        this.initDecimalCol(row.getCell("balance"), precision);
        row.getCell("balanceLocal").setValue(rs.getObject("balanceLocal"));
        this.initDecimalCol(row.getCell("balanceLocal"), precision);
        row.getCell("intExpression").setValue(rs.getObject("fintratetypeexpressiondis"));
        row.getCell("yearDays").setValue(rs.getObject("FYearDays"));
        BigDecimal rateTmp = rs.getObject("rate") == null ? Constants.ZERO : (BigDecimal)rs.getObject("rate");
        row.getCell("rate").setValue((Object)rateTmp);
        rateTmp = rs.getObject("curRate") == null ? Constants.ZERO : (BigDecimal)rs.getObject("curRate");
        row.getCell("curRate").setValue((Object)rateTmp);
        if (rs.getObject("fintratetypeexpression") != null && rs.getObject("fintratetypeexpression").toString().equals("year")) {
            row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.00\\%");
            row.getCell("curRate").getStyleAttributes().setNumberFormat("#,##0.00\\%");
        } else {
            row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.00\\\u2030");
            row.getCell("curRate").getStyleAttributes().setNumberFormat("#,##0.00\\\u2030");
        }
        row.getCell("effectiveDate").setValue((Object)rs.getDate("feffectivedate"));
        row.getCell("maturityday").setValue((Object)rs.getDate("fmaturityday"));
        row.getCell("description").setValue(rs.getObject("fdescription"));
        row.getCell("certificateno").setValue(rs.getObject("fcertificateno"));
        row.getCell("id").setValue(rs.getObject("fid"));
    }

    public void endDataFill() {
        super.endDataFill();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    public void setTableStateRow() {
        this.queryType = this.params.getType();
        if (this.queryType == 0) {
            this.kdt.getColumn("depcompany").setStat(true);
        } else if (this.queryType == 1) {
            this.kdt.getColumn("company").setStat(true);
        } else if (this.queryType == 2) {
            this.kdt.getColumn("currency").setStat(true);
        }
        IRow subtotalRow = this.kdt.getGroupManager().getStatRowTemplate(0);
        subtotalRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
        subtotalRow.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalRow.getCell("depositAmtLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("depositAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCell(subtotalRow.getCell("depositAmtLocal"));
        this.initDecimalCol(subtotalRow.getCell("depositAmtLocal"), this.precisionLocalCurrency);
        subtotalRow.getCell("undepositAmtLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("undepositAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCell(subtotalRow.getCell("undepositAmtLocal"));
        this.initDecimalCol(subtotalRow.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        subtotalRow.getCell("balanceLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("balanceLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.initDecimalCell(subtotalRow.getCell("balanceLocal"));
        this.initDecimalCol(subtotalRow.getCell("balanceLocal"), this.precisionLocalCurrency);
        subtotalRow.getCell("depositAmtLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        subtotalRow.getCell("undepositAmtLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        subtotalRow.getCell("balanceLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow summationRow = this.kdt.getGroupManager().getStatRowTemplate(-1);
        summationRow.getCell("depositAmtLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("depositAmtLocal"), this.precisionLocalCurrency);
        summationRow.getCell("undepositAmtLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        summationRow.getCell("balanceLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("balanceLocal"), this.precisionLocalCurrency);
        summationRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        summationRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        summationRow.getCell("depositAmtLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        summationRow.getCell("undepositAmtLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        summationRow.getCell("balanceLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        summationRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    private void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }
}

