/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.IRPTGetAppDateFacade;
import com.kingdee.eas.fm.fin.RPTGetAppDateFacadeFactory;
import com.kingdee.eas.fm.fin.client.AbstractSetCreditExpiredDateUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SetCreditExpiredDateUI
extends AbstractSetCreditExpiredDateUI {
    int count = 0;
    private static final Logger logger = CoreUIObject.getLogger(SetCreditExpiredDateUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private String paramValue = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "FIN019");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CreditLimitInfo info = this.getInfo();
        this.txtExpiredDate.setValue((Object)info.getExpiredDate());
        if (info.getDeferDay() > 0) {
            this.txtDeferDay.setValue((Object)new Integer(info.getDeferDay()), false);
        }
        this.txtClosedDate.setValue((Object)info.getCreditCloseDate());
    }

    protected int dateDeferDays(java.util.Date dt1, java.util.Date dt2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(dt1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(dt2);
        int diff = Integer.parseInt(String.valueOf((c1.getTimeInMillis() - c2.getTimeInMillis()) / 1000L / 60L / 60L / 24L));
        return diff;
    }

    @Override
    protected void txtClosedDate_dataChanged(DataChangeEvent e) throws Exception {
        Date dt1 = this.txtClosedDate.getSqlDate();
        Date dt2 = this.txtExpiredDate.getSqlDate();
        int days = this.dateDeferDays(dt1, dt2);
        this.txtDeferDay.setValue((Object)new Integer(days));
    }

    public CreditLimitInfo getInfo() throws EASBizException, BOSException {
        String creditLimitID = this.getUIContext().get("ID").toString();
        CreditLimitInfo info = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitID));
        return info;
    }

    @Override
    protected void txtDeferDay_stateChanged(ChangeEvent e) throws Exception {
        int days = Integer.parseInt(this.txtDeferDay.getValue().toString());
        if (days > Integer.valueOf(this.paramValue)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"513_DaysOfDelay");
            msg = MessageFormat.format(msg, this.paramValue);
            MsgBox.showWarning((String)msg);
            this.txtDeferDay.setValue((Object)Integer.valueOf(this.paramValue));
            SysUtil.abort();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.txtExpiredDate.getSqlDate());
        calendar.set(5, calendar.get(5) + days);
        this.txtClosedDate.setValue((Object)calendar.getTime());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.verify()) {
            CreditLimitInfo info = this.getInfo();
            info.setDeferDay(Integer.parseInt(this.txtDeferDay.getValue().toString()));
            info.setCreditCloseDate(this.txtClosedDate.getSqlDate());
            if (info.isIsClosed()) {
                IRPTGetAppDateFacade iRPTGetAppDateFacade = RPTGetAppDateFacadeFactory.getRemoteInstance();
                if (info.getCreditCloseDate().after(iRPTGetAppDateFacade.getAppDate()) && !info.isIsClosedByHand()) {
                    info.setIsClosed(false);
                }
            }
            CreditLimitFactory.getRemoteInstance().submit((CoreBaseInfo)info);
            this.uiWindow.close();
        }
    }

    private boolean verify() {
        int days = Integer.parseInt(this.txtDeferDay.getValue().toString());
        return days <= Integer.valueOf(this.paramValue);
    }
}

