/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.fin.AbstractFinancingBillInfo;
import com.kingdee.eas.fm.fin.BillTypeEnum;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.WagePropertEnum;
import com.kingdee.eas.fm.fin.client.AbstractWageEditUI;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class WageEditUI
extends AbstractWageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WageEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static String Resourcepath = "com.kingdee.eas.fm.fin.FinResource";

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getRelation().equals((Object)LoanPropertyEnum.InGroup)) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboRelation, (Object)((Object)LoanPropertyEnum.InGroup));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboRelation, (Object)((Object)LoanPropertyEnum.OutGroup));
        }
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion();
        this.kdtEntrys.checkParsed();
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.txtWagerate.setPrecision(4);
        super.onLoad();
        this.menuItemSave.setVisible(false);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtHorizon);
        this.txtHorizon.setPrecision(1);
        this.txtLocalCurExRate.setPrecision(5);
        this.txtNumber.setMaxLength(80);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtLocalCurExRate);
        this.PrmptOwnerCompany.setEntityViewInfo(FinUtils.getPrmtGroupF7Filter());
        this.txtAmountlocalcur.setHorizontalAlignment(4);
        this.txtWageAmount.setHorizontalAlignment(4);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        this.txtWagerate.setHorizontalAlignment(4);
        this.txtFee.setHorizontalAlignment(4);
        this.txtHorizon.setHorizontalAlignment(4);
        this.txtAmountlocalcur.setRemoveingZeroInDispaly(false);
        this.txtLocalCurExRate.setRemoveingZeroInDispaly(false);
        this.txtWageAmount.setRemoveingZeroInDispaly(false);
        this.txtFee.setRemoveingZeroInDispaly(false);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtHorizon.setRemoveingZeroInDispaly(false);
        this.txtWagerate.setRemoveingZeroInDispaly(false);
        this.prmtWageType.setRequired(true);
        this.txtWagerate.setEnabled(false);
        this.txtWageAmount.setEnabled(true);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        this.initF7Filter();
        this.setUIEnable();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, this.prmtInstitution, null, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("billStatus");
        return sic;
    }

    protected void setUIEnable() {
        if (this.editData == null || FinBillStatusEnum.AUDITED != this.editData.getBillStatus()) {
            return;
        }
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
        IKDComponent[] components = new IKDComponent[]{this.txtAmount, this.txtWageAmount, this.pkIssuedate, this.pkExpireddate};
        FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)true);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public void loadFields() {
        this.ShowLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void ShowLoad() {
        super.loadFields();
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
        this.txtAmountlocalcur.setValue((Object)this.editData.getAmountlocalcur());
        if (!this.editData.isOwnerRight()) {
            this.TxtRightName.setEditable(true);
        }
        this.ShowEntryUsedAmount();
        this.kdtEntrys.getColumn("IssueDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.kdtEntrys.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
    }

    protected void ShowEntryUsedAmount() {
        try {
            int n = this.kdtEntrys.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object info;
                IRow row = this.kdtEntrys.getRow(i);
                BigDecimal depositAmt = null;
                BigDecimal balance = null;
                BillTypeEnum billtype = (BillTypeEnum)((Object)row.getCell("billtype").getValue());
                if (billtype.equals((Object)BillTypeEnum.PAYABLEBILL)) {
                    info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    depositAmt = info.getAmount();
                    balance = info.getBalance();
                } else if (billtype.equals((Object)BillTypeEnum.LOAN)) {
                    info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    depositAmt = ((AbstractFinancingBillInfo)info).getAmount();
                    balance = ((AbstractFinancingBillInfo)info).getBalance();
                } else if (billtype.equals((Object)BillTypeEnum.LETTEROFCREDIT)) {
                    info = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    depositAmt = ((AbstractFinancingBillInfo)info).getAmount();
                    balance = ((AbstractFinancingBillInfo)info).getBalance();
                } else if (billtype.equals((Object)BillTypeEnum.LETTEROFGUARANTEE)) {
                    info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    depositAmt = info.getAmount();
                    balance = info.getBalance();
                } else if (billtype.equals((Object)BillTypeEnum.LOANCONTRACT)) {
                    info = LoanContractFactory.getRemoteInstance().getLoanContractInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    if (info != null) {
                        depositAmt = info.getAmount();
                        balance = info.getBalance();
                    }
                } else if (billtype.equals((Object)BillTypeEnum.LOANFETCH)) {
                    info = LoanFetchFactory.getRemoteInstance().getLoanFetchInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()));
                    if (info != null) {
                        depositAmt = info.getAmount();
                        balance = info.getBalance();
                    }
                } else if (billtype.equals((Object)BillTypeEnum.BOND_RELEASE_REPORT) && (info = BondReleaseReportFactory.getRemoteInstance().getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(row.getCell("billid").getValue().toString()))) != null) {
                    depositAmt = info.getAmount();
                    balance = info.getBalance();
                }
                row.getCell("AccountAmount").setValue((Object)depositAmt);
                row.getCell("Balance").setValue((Object)balance);
            }
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        WageInfo info = new WageInfo();
        info.setRelation(LoanPropertyEnum.OutGroup);
        info.setHorizon(Constants.ZERO);
        info.setAmount(Constants.ZERO);
        info.setAmountlocalcur(Constants.ZERO);
        info.setFee(Constants.ZERO);
        info.setWageAmount(Constants.ZERO);
        info.setWagerate(Constants.ZERO);
        info.setIssuedate(new Date());
        info.setExpireddate(new Date());
        info.setIsAntiWage(false);
        info.setProperty(WagePropertEnum.Wage);
        info.setCompany(this.currentCompany);
        info.setOwnerCompany(this.currentCompany);
        info.setBizDate(new Date());
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        info.setHandler(info.getCreator());
        info.setOwnerRight(true);
        if (this.currentCompany != null) {
            info.setOwnerRightName(this.currentCompany.getName());
            info.setCurrency(this.currentCompany.getBaseCurrency());
        }
        info.setLocalCurExRate(new BigDecimal(String.valueOf(1)));
        info.setIsRelationRec(false);
        info.setUsedamount(Constants.ZERO);
        info.setRemark("");
        this.prmtInstitution.setRequired(true);
        FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WageFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtGuarantee);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtWageType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.TxtRightName);
        if (this.comboRelation.getSelectedItem() == LoanPropertyEnum.InGroup) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCustomerCompany);
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtInstitution);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.PrmptOwnerCompany);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        if (!FMClientHelper.verifyIsPlus((String)this.txtAmount.getBigDecimalValue().toString())) {
            this.txtAmount.requestFocus(true);
            throw new FinBizException(FinBizException.WAGEAMT_NEGATIVE_EXC);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtWagerate);
        if (!FMClientHelper.verifyIsPlus((String)this.txtWagerate.getBigDecimalValue().toString())) {
            this.txtWagerate.requestFocus(true);
            throw new TDException(TDException.WAGERATELESS);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtWageAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssuedate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpireddate);
        Date issueDate = (Date)this.pkIssuedate.getValue();
        Date expiredDate = (Date)this.pkExpireddate.getValue();
        if (!expiredDate.after(issueDate)) {
            this.pkExpireddate.requestFocus();
            throw new FinBizException(FinBizException.ENDDATEMUSTAFTERBEGINDATE);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        if (this.Txtremark.getText().length() > 2000) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"496_WageEditUI"));
            SysUtil.abort();
        }
    }

    private static void initKDTPrecesion(KDTable kdt, String[] cols, int prec) {
        String format = FMClientHelper.getKDTNumFormat((int)prec);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = kdt.getColumn(cols[i]);
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo != null) {
            int pre = ChLoanHelper.getInstance().getCurrencyPre(currencyInfo.getId().toString());
            this.txtAmountlocalcur.setPrecision(pre);
            this.txtWageAmount.setPrecision(pre);
            this.txtAmount.setPrecision(pre);
            this.txtFee.setPrecision(pre);
            WageEditUI.initKDTPrecesion(this.kdtEntrys, new String[]{"AccountAmount", "Balance", "realWage"}, currencyInfo.getPrecision());
        }
        if (currencyInfo == null) {
            return;
        }
        if (this.currentCompany.getBaseCurrency() != null && currencyInfo != null) {
            if (this.currentCompany.getBaseCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                this.txtLocalCurExRate.setEnabled(false);
                this.txtLocalCurExRate.setEditable(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
                this.txtLocalCurExRate.setEditable(true);
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    this.txtLocalCurExRate.setRequired(false);
                }
            }
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        String baseCurrencyId = this.currentCompany.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currencyInfo.getId().toString())) {
            this.txtLocalCurExRate.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtLocalCurExRate.setEnabled(true);
        }
        WageEditUI.initKDTPrecesion(this.kdtEntrys, new String[]{"AccountAmount", "Balance", "realWage"}, currencyInfo.getPrecision());
        this.setPre(currencyInfo);
        this.calcRate(currencyInfo, null, this.currentCompany, new Date());
        this.calcNaturalAmt();
    }

    private void setPre(CurrencyInfo CurrencyInfo2) {
        this.txtAmount.setPrecision(CurrencyInfo2.getPrecision());
        this.txtAmount.setRemoveingZeroInDispaly(true);
        this.txtAmountlocalcur.setPrecision(CurrencyInfo2.getPrecision());
        this.txtAmountlocalcur.setRemoveingZeroInDispaly(true);
        this.txtWageAmount.setPrecision(CurrencyInfo2.getPrecision());
        this.txtWageAmount.setRemoveingZeroInDispaly(true);
    }

    private void calcRate(CurrencyInfo currencyInfo, String destCurrId, CompanyOrgUnitInfo company, Date date) throws Exception {
        this.txtLocalCurExRate.setPrecision(4);
        this.txtLocalCurExRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, null, (Date)date));
    }

    private void calcNaturalAmt() {
        BigDecimal depositAmt = this.txtAmount.getBigDecimalValue();
        BigDecimal exchangeRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (depositAmt == null || exchangeRate == null) {
            return;
        }
        this.txtAmountlocalcur.setValue((Object)depositAmt.multiply(exchangeRate));
    }

    private void calcWageAmt() {
        BigDecimal depositAmt = this.txtAmount.getBigDecimalValue();
        BigDecimal Rate = this.txtWageAmount.getBigDecimalValue();
        if (depositAmt == null || Rate == null) {
            return;
        }
        float depositAmtFloat = Float.parseFloat(depositAmt.toString());
        float RateFloat = Float.parseFloat(Rate.toString());
        if (depositAmtFloat == 0.0f || RateFloat == 0.0f) {
            this.txtWagerate.setValue((Object)Constants.ZERO);
        }
        if (depositAmt == null || Rate == null || !FMClientHelper.verifyIsPlus((String)depositAmt.toString()) || !FMClientHelper.verifyIsPlus((String)Rate.toString())) {
            return;
        }
        BigDecimal temp = Rate.divide(depositAmt, 6, 4);
        this.txtWagerate.setValue((Object)temp.multiply(Constants.ONE_HUNDRED));
    }

    @Override
    protected void comboRelation_itemStateChanged(ItemEvent e) throws Exception {
        super.comboRelation_itemStateChanged(e);
        if (this.comboRelation.getSelectedItem() == LoanPropertyEnum.OutGroup) {
            this.contCustomerCompany.setVisible(false);
            this.prmtCustomerCompany.setValue(null);
            this.prmtCustomerCompany.setRequired(false);
            this.contInstitution.setVisible(true);
            this.prmtInstitution.setRequired(true);
        } else if (this.comboRelation.getSelectedItem() == LoanPropertyEnum.InGroup) {
            this.prmtCustomerCompany.setVisible(true);
            this.prmtInstitution.setValue(null);
            this.prmtInstitution.setRequired(false);
            this.contCustomerCompany.setVisible(true);
            this.prmtCustomerCompany.setRequired(true);
            this.contInstitution.setVisible(false);
        }
    }

    @Override
    protected void pkExpireddate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpireddate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon(this.pkIssuedate, this.pkExpireddate));
    }

    @Override
    protected void pkIssuedate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssuedate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon(this.pkIssuedate, this.pkExpireddate));
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        this.calcNaturalAmt();
        this.calcWageAmt();
    }

    @Override
    protected void txtWagerate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtWagerate_dataChanged(e);
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        this.calcNaturalAmt();
    }

    @Override
    protected void CkboxOwnerRight_itemStateChanged(ItemEvent e) throws Exception {
        super.CkboxOwnerRight_itemStateChanged(e);
        if (this.CkboxOwnerRight.isSelected()) {
            this.TxtRightName.setText(this.currentCompany.getName());
            this.TxtRightName.setEditable(false);
        } else {
            this.TxtRightName.setText(null);
            this.TxtRightName.setEditable(true);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType type;
        BOSObjectType bosType;
        this.storeFields();
        this.checkFinalCheckout();
        if (this.editData.getSourceBillId() != null && (bosType = BOSUuid.read((String)this.editData.getSourceBillId()).getType()).equals((Object)(type = new DraftCollateralizationRequestInfo().getBOSType()))) {
            WageFactory.getRemoteInstance().updateCollateral((IObjectPK)new ObjectUuidPK(this.editData.getSourceBillId()), true);
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void txtWagerate_focusLost(FocusEvent e) throws Exception {
        super.txtWagerate_focusLost(e);
    }

    public static boolean verifyTooBigger(String value, double target) {
        boolean result = false;
        try {
            double big = Double.parseDouble(value);
            if (big > target) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = true;
        }
        return result;
    }

    @Override
    protected void comboProperty_actionPerformed(ActionEvent e) throws Exception {
        super.comboProperty_actionPerformed(e);
        if ((WagePropertEnum)((Object)this.comboProperty.getSelectedItem()) == WagePropertEnum.Pledge) {
            this.contAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contImpawnAmount"));
            this.contWageAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contImpawnWageAmount"));
        } else {
            this.contAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contPledgeAmount"));
            this.contWageAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contPledgeWageAmount"));
        }
    }

    @Override
    protected void comboProperty_itemStateChanged(ItemEvent e) throws Exception {
        super.comboProperty_itemStateChanged(e);
        if ((WagePropertEnum)((Object)this.comboProperty.getSelectedItem()) == WagePropertEnum.Pledge) {
            this.contAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contImpawnAmount"));
            this.contWageAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contImpawnWageAmount"));
        } else {
            this.contAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contPledgeAmount"));
            this.contWageAmount.setBoundLabelText(EASResource.getString((String)Resourcepath, (String)"contPledgeWageAmount"));
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    protected boolean isVoucherVisible() {
        return true;
    }

    @Override
    public void prmtOppAccountView_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setOppAcctEvi(info);
    }

    private void setOppAcctEvi(CurrencyInfo currencyInfo) throws EASBizException, BOSException, ParserException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        this.prmtOppAccountView.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false, (boolean)true);
        EntityViewInfo evi = new EntityViewInfo(treeevi.toString());
        FilterInfo filterIsLeaf = new FilterInfo();
        filterIsLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        evi.getFilter().mergeFilter(filterIsLeaf, "and");
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        this.prmtOppAccountView.setSelector((KDPromptSelector)opseelect);
        this.prmtOppAccountView.setEntityViewInfo(evi);
    }

    @Override
    public void prmtOppAccountView_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setOppAcctEvi(info);
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected void txtWageAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcWageAmt();
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)companyInfo.getId().toString(), (Date)this.editData.getIssuedate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkFinalCheckout();
        super.actionSave_actionPerformed(e);
    }
}

