/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp;

import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.AbstractCycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class CycleRangeInfo
extends AbstractCycleRangeInfo
implements Serializable {
    public CycleRangeInfo() {
    }

    protected CycleRangeInfo(String pkField) {
        super(pkField);
    }

    public String genTimeKey() {
        return String.valueOf(this.getBeginDate().getTime());
    }

    public String genDateKey() {
        CycleTypeEnum type = this.getType();
        if (type.equals((Object)CycleTypeEnum.YEAR)) {
            return Integer.toString(this.getYear());
        }
        if (type.equals((Object)CycleTypeEnum.QUARTER)) {
            return Integer.toString(this.getYear()) + Integer.toString(this.getQuarter());
        }
        if (type.equals((Object)CycleTypeEnum.MONTH)) {
            return Integer.toString(this.getYear()) + Integer.toString(this.getMonth());
        }
        return Constants.FORMAT_DAY.format(this.getBeginDate());
    }

    public static Date dateKeyToDate(CycleTypeEnum type, String key) {
        if (type.equals((Object)CycleTypeEnum.YEAR)) {
            return new GregorianCalendar(Integer.parseInt(key), 0, 1).getTime();
        }
        if (type.equals((Object)CycleTypeEnum.QUARTER)) {
            return new GregorianCalendar(Integer.parseInt(key.substring(0, 4)), 3 * (Integer.parseInt(key.substring(4, 5)) - 1), 1).getTime();
        }
        if (type.equals((Object)CycleTypeEnum.MONTH)) {
            return new GregorianCalendar(Integer.parseInt(key.substring(0, 4)), Integer.parseInt(key.substring(4, key.length())) - 1, 1).getTime();
        }
        try {
            return new SimpleDateFormat().parse(key);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String toString() {
        CycleTypeEnum cycleTypeEnum = this.getType();
        int year = this.getYear();
        int month = this.getMonth();
        Date beginDate = this.getBeginDate();
        Date endDate = this.getEndDate();
        String periodStr = "";
        if (cycleTypeEnum == CycleTypeEnum.DAY) {
            periodStr = FMHelper.dateCompare((Date)beginDate, (Date)endDate) == 0 ? Constants.FORMAT_DAY.format(beginDate) : Constants.FORMAT_DAY.format(beginDate) + " - " + Constants.FORMAT_DAY.format(endDate);
        } else if (cycleTypeEnum == CycleTypeEnum.WEEK) {
            periodStr = Constants.FORMAT_DAY.format(beginDate) + "." + Constants.FORMAT_DAY.format(endDate);
        } else if (cycleTypeEnum == CycleTypeEnum.MONTH) {
            periodStr = Constants.FORMAT_MONTH.format(beginDate);
        } else if (cycleTypeEnum == CycleTypeEnum.QUARTER) {
            periodStr = Constants.FORMAT_QUARTER.format(endDate);
        } else if (cycleTypeEnum == CycleTypeEnum.YEAR) {
            periodStr = Constants.FORMAT_YEAR.format(beginDate);
        }
        return periodStr;
    }

    public void setBeginDate(Date item) {
        super.setBeginDate(item);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(item);
        this.setYear(cal.get(1));
        this.setMonth(cal.get(2) + 1);
        this.setQuarter(cal.get(2) / 3 + 1);
    }
}

