/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaBaseProxy;
import com.kingdee.eas.fm.fp.FixedFPItemCollection;
import com.kingdee.eas.fm.fp.FixedFPItemFactory;
import com.kingdee.eas.fm.fp.IFixedFPItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FPFormulaProxy
extends FPFormulaBaseProxy {
    private static final String FD_CURRENCYNUMBER = "currencyNumber";
    private static final String FD_COMPANYNUMBER = "companyNumber";
    private static final Logger logger = Logger.getLogger(FPFormulaProxy.class);
    public static final String PRE_FIX = "com.kingdee.eas.fm.formula.";

    public FPFormulaProxy(Context ctx2) {
        super(ctx2);
    }

    public FPFormulaProxy() {
    }

    public BigDecimal FPAC(String billType, String filterString, String actionDate, String dateType) throws EASBizException, BOSException {
        FMVerifyHelper.checkBlank((String)billType, (Object[])new String[]{"billType"});
        String companyNumber = this.getFormulaCtx().getCompany();
        String currencyNumber = this.getFormulaCtx().getCurrency();
        Date end = this.getFormulaCtx().getEnd();
        Date begin = this.getFormulaCtx().getBegin();
        return this.fpc(billType, companyNumber, currencyNumber, filterString, actionDate, 0, dateType, begin, end);
    }

    private BigDecimal fpc(String billType, String companyNumber, String currencyNumber, String filterString, String actionDate, int offset, String dateType, Date beginDate, Date endDate) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("filterString" + filterString));
        }
        FMVerifyHelper.checkBlank((String)billType, (Object[])new String[]{"billType"});
        FMVerifyHelper.checkBlank((String)companyNumber, (Object[])new String[]{FD_COMPANYNUMBER});
        FMVerifyHelper.checkBlank((String)currencyNumber, (Object[])new String[]{FD_CURRENCYNUMBER});
        FMVerifyHelper.checkBlank((String)currencyNumber, (Object[])new String[]{"dateType"});
        filterString = this.getFormulaCtx().parse(filterString);
        GregorianCalendar calBegin = new GregorianCalendar();
        calBegin.setTime(beginDate);
        ((Calendar)calBegin).add(5, -offset);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(endDate);
        ((Calendar)calEnd).add(5, -offset);
        String sb = this.getFpcSql(billType, companyNumber, currencyNumber, filterString, actionDate, dateType, calBegin.getTime(), calEnd.getTime());
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FPFC SQL: \n " + sb));
        }
        BigDecimal result = Constants.ZERO;
        try {
            conn = this.getConnnection();
            stmt = conn.prepareStatement(sb);
            rs = stmt.executeQuery();
            if (rs.next() && (result = rs.getBigDecimal(1)) == null) {
                result = Constants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"sql error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private String getFpcSql(String billType, String companyNumber, String currencyNumber, String filterString, String actionDate, String dateType, Date beginDate, Date endDate) throws BOSException {
        if (filterString == null || filterString.trim().length() == 0) {
            filterString = "1=1";
        }
        String queryName = PRE_FIX + billType;
        MetaDataPK pk = new MetaDataPK(queryName);
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)pk);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(sql.length() + 20);
        sb.append("select sum(");
        sb.append(dateType);
        sb.append(") \n");
        sb.append(" from (\n");
        sb.append(sql);
        sb.append(") a where \n");
        if (!FMHelper.isEmpty((String)companyNumber)) {
            sb.append("(");
            sb.append("companyNumber='");
            sb.append(companyNumber);
            sb.append("') and \n");
        }
        if (!FMHelper.isEmpty((String)companyNumber)) {
            sb.append("(");
            sb.append("currencyNumber='");
            sb.append(currencyNumber);
            sb.append("') and \n");
        }
        sb.append("(");
        sb.append(actionDate + ">={");
        sb.append(Constants.FORMAT_DAY.format(beginDate));
        sb.append("}) and \n");
        sb.append("(");
        sb.append(actionDate + "<{");
        sb.append(Constants.FORMAT_DAY.format(DateUtil.getAfterDay((Date)endDate)));
        sb.append("}) and \n");
        sb.append("(");
        sb.append(filterString);
        sb.append(")");
        return sb.toString();
    }

    public BigDecimal FPFC(String billType, String filterString, String actionDate, int offset, String dateType) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((String)billType, (Object[])new String[]{"billType"});
        String companyNumber = this.getFormulaCtx().getCompany();
        String currencyNumber = this.getFormulaCtx().getCurrency();
        Date end = this.getFormulaCtx().getEnd();
        Date begin = this.getFormulaCtx().getBegin();
        return this.fpc(billType, companyNumber, currencyNumber, filterString, actionDate, offset, dateType, begin, end);
    }

    private BigDecimal FPFIX(String companyNumber, CycleTypeEnum ctype, FPCycleIntervalEnum cInterval, String[] itemAry, Date begin, Date end, String currencyNumber) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((Object[])itemAry)) {
            return Constants.ZERO;
        }
        IFixedFPItem fix = null;
        fix = this.isServerSide ? FixedFPItemFactory.getLocalInstance(this.ctx) : FixedFPItemFactory.getRemoteInstance();
        FMVerifyHelper.checkBlank((String)companyNumber, (Object[])new String[]{FD_COMPANYNUMBER});
        FMVerifyHelper.checkBlank((Object)((Object)ctype), (Object[])new String[]{"ctype"});
        FMVerifyHelper.checkBlank((Object)((Object)cInterval), (Object[])new String[]{"cInterval"});
        FMVerifyHelper.checkBlank((Object[])itemAry, (Object[])new String[]{"itemAry"});
        FMVerifyHelper.checkBlank((String)currencyNumber, (Object[])new String[]{FD_CURRENCYNUMBER});
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyNumber));
        filter.getFilterItems().add(new FilterItemInfo("cycleType", (Object)new Integer(ctype.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("cycleInterval", (Object)new Integer(cInterval.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        HashSet<String> set = new HashSet<String>(itemAry.length);
        for (int i = 0; i < itemAry.length; ++i) {
            set.add(itemAry[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)begin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)end, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)begin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)end, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)begin, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)end, CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and ((#5 and #6 ) or (#7 and #8) or (#9 and #10)) ");
        ev.setFilter(filter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fixed ev: \n" + ev));
        }
        FixedFPItemCollection coll = fix.getFixedFPItemCollection(ev);
        BigDecimal result = Constants.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            result = result.add(coll.get(i).getAmount());
        }
        return result;
    }

    public BigDecimal FPFIX(String items) throws EASBizException, BOSException {
        FMVerifyHelper.checkBlank((String)items, (Object[])new String[]{"items"});
        String companyNumber = this.getFormulaCtx().getCompany();
        String currencyNumber = this.getFormulaCtx().getCurrency();
        Date end = this.getFormulaCtx().getEnd();
        Date begin = this.getFormulaCtx().getBegin();
        CycleTypeEnum ctype = this.getFormulaCtx().getCycleType();
        FPCycleIntervalEnum cInterval = this.getFormulaCtx().getCycleInterval();
        String[] s = StringUtils.split((String)items, (String)";");
        return this.FPFIX(companyNumber, ctype, cInterval, s, begin, end, currencyNumber);
    }
}

