/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.RptBaseHandler;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPSumAnalysisCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.fm.fp.client.FPSumAnalysisUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractFPSumAnalysisHandler
extends RptBaseHandler {
    public void fillData(KDTable tblMain, Map cache, boolean isDispActual) {
        IRow headRow = tblMain.getHeadRow(0);
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            String itemName = row.getCell(0).getValue().toString();
            int j = 1;
            while (j < tblMain.getColumnCount()) {
                Object[] value = (Object[])cache.get(itemName + headRow.getCell(j).getUserObject());
                if (value == null) {
                    ++j;
                    continue;
                }
                row.getCell(j).setValue(value[0]);
                ++j;
                if (!isDispActual) continue;
                row.getCell(j).setValue(value[1]);
                ++j;
            }
        }
    }

    public void fillFirstCol(KDTable tblMain, IRowSet rs) throws SQLException {
        String key = this.getFirstColKey();
        rs.beforeFirst();
        String lstName = null;
        String expressionKey = this.getExpressionKey();
        while (rs.next()) {
            String exp;
            String entryName = rs.getString(key);
            if (entryName.equals(lstName)) continue;
            IRow row = tblMain.addRow();
            row.getCell(0).setValue((Object)entryName);
            if (!FMHelper.isEmpty((String)expressionKey) && !FMHelper.isEmpty((String)(exp = rs.getString(expressionKey)))) {
                row.setUserObject((Object)exp);
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
            }
            lstName = entryName;
        }
    }

    protected String getExpressionKey() {
        return "FPITEMEXPRESSION";
    }

    public void insertHeader(KDTable tblMain, FPSumAnalysisCondParam param, int amountNumber, IObjectCollection coll) {
        tblMain.addColumns(1 + coll.size() * amountNumber);
        tblMain.addHeadRows(amountNumber);
        IRow headRow = tblMain.getHeadRow(0);
        FPSumAnalysisOrderEnum firstColType = this.getFirstColType();
        headRow.getCell(0).setValue((Object)firstColType);
        if (param.getIsDispActual()) {
            String sPlan = EASResource.getString((String)FPSumAnalysisUI.resourcePath, (String)"PLANAMOUNT");
            String sActual = EASResource.getString((String)FPSumAnalysisUI.resourcePath, (String)"ACTUALAMOUNT");
            IRow headRow1 = tblMain.getHeadRow(1);
            headRow1.getCell(0).setValue((Object)firstColType);
            tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
            for (int idx = 1; idx < tblMain.getColumnCount(); idx += 2) {
                headRow1.getCell(idx).setValue((Object)sPlan);
                tblMain.getHeadMergeManager().mergeBlock(0, idx, 0, idx + 1);
                headRow1.getCell(idx + 1).setValue((Object)sActual);
            }
        }
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        for (int i = 1; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(numberFtm);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public abstract FPSumAnalysisOrderEnum getFirstColType();

    public void initCycleHeader(KDTable tblMain, CycleTypeEnum cycleType, int amountNumber, CycleRangeCollection coll) {
        IRow headRow = tblMain.getHeadRow(0);
        int idex = 1;
        for (int i = 0; i < coll.size(); ++i) {
            for (int j = 0; j < amountNumber; ++j) {
                ICell cell = headRow.getCell(idex);
                CycleRangeInfo info = coll.get(i);
                cell.setValue((Object)info.toString());
                cell.setUserObject((Object)info.genDateKey());
                ++idex;
            }
        }
    }

    public void initCompanyHeader(KDTable tblMain, int amountNumber, CompanyOrgUnitCollection coll) {
        IRow headRow = tblMain.getHeadRow(0);
        int idx = 1;
        for (int i = 0; i < coll.size(); ++i) {
            for (int j = 0; j < amountNumber; ++j) {
                ICell cell = headRow.getCell(idx);
                CompanyOrgUnitInfo info = coll.get(i);
                cell.setValue((Object)info.getName());
                cell.setUserObject((Object)info.getId());
                ++idx;
            }
        }
    }

    public abstract String getFirstColKey();

    public abstract void initTreeList(FPSumAnalysisCondParam var1, DefaultKingdeeTreeNode var2);

    public abstract void initTableHeader(KDTable var1, FPSumAnalysisCondParam var2) throws Exception;

    public abstract IRowSet getRowset(IMetaDataPK var1, EntityViewInfo var2, FPSumAnalysisCondParam var3, CoreBaseInfo var4) throws BOSException;

    public abstract Map getRowsetMap(IRowSet var1, CycleTypeEnum var2) throws SQLException;

    public CompanyOrgUnitCollection getCompanyColl(FPSumAnalysisCondParam param) {
        String[] companyId = param.getCompanyIdAry();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < companyId.length; ++i) {
            set.add(companyId[i]);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add("name");
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        CompanyOrgUnitCollection coll = null;
        try {
            ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
            coll = company.getCompanyOrgUnitCollection(ev);
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return coll;
    }

    public abstract boolean isStatusItems();

    public void initItemsStatus(KDTable tblMain, FPSumAnalysisCondParam param, CoreBaseInfo info) {
        int i;
        if (!this.isStatusItems()) {
            return;
        }
        if (tblMain.getRowCount() < 4) {
            return;
        }
        tblMain.getRow(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        tblMain.getRow(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        tblMain.getRow(2).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        tblMain.getRow(tblMain.getRowCount() - 1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        tblMain.getScriptManager().setAutoRun(false);
        String forBalance = null;
        int amountSize = param.getIsDispActual() ? 2 : 1;
        forBalance = "=cell(" + tblMain.getRowCount() + ",COLUMN_INDEX-" + amountSize + ").value";
        IRow row0 = tblMain.getRow(0);
        IRow row1 = tblMain.getRow(1);
        IRow row2 = tblMain.getRow(2);
        for (i = 1; i < tblMain.getColumnCount(); ++i) {
            BigDecimal actual = this.getActualBegining(tblMain, param, info, i);
            row0.getCell(i).setValue((Object)actual);
            if (i <= amountSize || param.getOrderOne() != 1) continue;
            row1.getCell(i).setExpressions(forBalance);
        }
        FPClientHelper.fillCellExpression(tblMain);
        for (i = 1; i < tblMain.getColumnCount(); ++i) {
            BigDecimal val = (BigDecimal)row0.getCell(i).getValue();
            if (val != null && val.compareTo(Constants.ZERO) != 0) {
                row2.getCell(i).setValue((Object)val);
                continue;
            }
            row2.getCell(i).setExpressions("=cell(ROW_INDEX-1,COLUMN_INDEX).value");
        }
        tblMain.getScriptManager().run();
    }

    public abstract BigDecimal getActualBegining(KDTable var1, FPSumAnalysisCondParam var2, CoreBaseInfo var3, int var4);
}

