/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.fm.fp.AdjustFormFilterParam;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.client.AbstractAdjustFormFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;

public class AdjustFormFilterUI
extends AbstractAdjustFormFilterUI {
    private String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.initFormNumF7();
    }

    protected void init() throws Exception {
        super.init();
        this.initCompanyIds();
        this.fmtAmountFrom.setValue(null);
        this.fmtAmountTo.setValue(null);
        this.f7FormNumberForm.setHasCUDefaultFilter(false);
        this.f7FormNumberTo.setHasCUDefaultFilter(false);
        this.fmtAmountFrom.setSupportedEmpty(true);
        this.fmtAmountTo.setSupportedEmpty(true);
        this.fmtAmountFrom.setDataType(1);
        this.fmtAmountFrom.setPrecision(4);
        this.fmtAmountTo.setDataType(1);
        this.fmtAmountTo.setPrecision(4);
        this.initFormNumF7();
    }

    protected void initCompanyIds() throws BOSException {
        String[] companyIds = new String[]{this.currentCompany.getId().toString()};
        this.setCompanyIds(companyIds);
    }

    public Object getParam() {
        AdjustFormFilterParam param = new AdjustFormFilterParam();
        if (this.getCompanyIds() != null) {
            String[] companyIds = this.getCompanyIds();
            param.setCompanyIdAry(companyIds);
        }
        if (this.f7FormNumberForm.getValue() != null) {
            param.setFpFormNumberFrom(((FPFormInfo)this.f7FormNumberForm.getValue()).getNumber());
        }
        if (this.f7FormNumberTo.getValue() != null) {
            param.setFpFormNumberTo(((FPFormInfo)this.f7FormNumberTo.getValue()).getNumber().toString());
        }
        if (this.fmtAmountFrom.getNumberValue() != null) {
            param.setBeginAmount(this.fmtAmountFrom.getBigDecimalValue());
        }
        if (this.fmtAmountTo.getNumberValue() != null) {
            param.setEndAmount(this.fmtAmountTo.getBigDecimalValue());
        }
        param.setCollectFlag(this.chkIsCollect.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof AdjustFormFilterParam)) {
            return;
        }
        AdjustFormFilterParam adjustParam = (AdjustFormFilterParam)param;
        String[] companyIds = adjustParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        if (adjustParam.getFpFormNumberFrom() != null) {
            FPFormInfo beginForm = new FPFormInfo();
            beginForm.setNumber(adjustParam.getFpFormNumberFrom());
            this.f7FormNumberForm.setValue((Object)beginForm);
        }
        if (adjustParam.getFpFormNumberTo() != null) {
            FPFormInfo endForm = new FPFormInfo();
            endForm.setNumber(adjustParam.getFpFormNumberTo());
            this.f7FormNumberTo.setValue((Object)endForm);
        }
        this.fmtAmountFrom.setValue((Object)adjustParam.getBeginAmount());
        this.fmtAmountTo.setValue((Object)adjustParam.getEndAmount());
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void initFormNumF7() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (this.getCompanyIds() != null) {
            fi.getFilterItems().add(this.getCompanyFilterItem());
        }
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(10)));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(20)));
        if (this.getCompanyIds() != null) {
            fi.setMaskString("#0 and (#1 or #2)");
        } else {
            fi.setMaskString("#1 or #2");
        }
        ev.setFilter(fi);
        this.f7FormNumberForm.setEntityViewInfo(ev);
        this.f7FormNumberTo.setEntityViewInfo(ev);
        this.f7FormNumberForm.setData(null);
        this.f7FormNumberTo.setData(null);
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        this.amountVerify();
        return true;
    }

    private void amountVerify() {
        BigDecimal amountFrom = this.fmtAmountFrom.getBigDecimalValue();
        BigDecimal amountTo = this.fmtAmountTo.getBigDecimalValue();
        if (amountFrom != null && amountTo != null && amountFrom.compareTo(amountTo) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AdjustFromBigTo"));
            SysUtil.abort();
        }
    }
}

