/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fp.AdjustFormFilterParam;
import com.kingdee.eas.fm.fp.client.AbstractAdjustFormListUI;
import com.kingdee.eas.fm.fp.client.AdjustFormFilterUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;

public class AdjustFormListUI
extends AbstractAdjustFormListUI {
    private AdjustFormFilterUI filterUI;
    boolean isInitStatueSyle = false;
    private int maxPrecision = 8;
    FillListener fillListener = new FillListener();

    public AdjustFormListUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected String getEditUIName() {
        return FPFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AdjustFactory.getRemoteInstance();
    }

    private void initStatusStyle(KDTable table) {
        table.getColumn(1).setGroup(true);
        table.getColumn(2).setGroup(true);
        table.getColumn(3).setGroup(true);
        table.getColumn(4).setGroup(true);
        table.getColumn(2).setStat(true);
        int k = table.getColumnIndex("entriesAugmentAmount");
        this.initSubState(table, FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR, "FPFormSubTotal", 1, 2, k);
    }

    private void initSubState(KDTable table, Color bg, String lbl, int i, int j, int k) {
        IRow row2 = table.getGroupManager().getStatRowTemplate(i);
        row2.getStyleAttributes().setBackground(bg);
        row2.getCell(j).setValue((Object)EASResource.getString((String)FPFormClientHelper.resourcePath, (String)lbl));
        row2.getCell(k).setExpressions("SUM");
        row2.getCell(k).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.currencyFormat(row2.getCell(k));
    }

    public static void main(String[] args) {
        FMLoginModel login = FMLoginModel.newInstance();
        login.login("fengrenfei", "", "eas", "eas41");
        String uiname = AdjustFormListUI.class.getName();
        System.out.println(uiname);
        login.loginMain(uiname);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AdjustFormFilterUI();
        }
        return this.filterUI;
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            ArrayList<Integer> precisionList = new ArrayList<Integer>();
            while (rowSet.next()) {
                Date beginDate = rowSet.getDate("cycleRangeBeginDate");
                Date endDate = rowSet.getDate("cycleRangeEndDate");
                String period = beginDate + " - " + endDate;
                if (beginDate.compareTo(endDate) == 0) {
                    period = ((java.util.Date)beginDate).toString();
                }
                rowSet.updateString("entriesCycle", period);
                String cId = rowSet.getString("currencyId");
                BigDecimal amount = rowSet.getBigDecimal("entriesAugmentAmount");
                int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)cId));
                precisionList.add(new Integer(scale));
                amount = amount.setScale(scale, 5);
                rowSet.updateBigDecimal("entriesAugmentAmount", amount);
            }
            int[] precArray = new int[precisionList.size()];
            int i = 0;
            for (Integer element : precisionList) {
                precArray[i] = element;
                ++i;
            }
            Arrays.sort(precArray);
            this.maxPrecision = precArray.length > 0 ? precArray[precArray.length - 1] : 4;
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
    }

    protected void execQuery() {
        super.execQuery();
        AdjustFormFilterParam p = null;
        try {
            p = (AdjustFormFilterParam)this.getFilterUI().getParam();
        }
        catch (Exception e) {
            return;
        }
        boolean isCollect = p.isCollectFlag();
        if (isCollect) {
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            this.initStatusStyle(this.tblMain);
            this.tblMain.getGroupManager().group();
        } else {
            this.tblMain.getDataRequestManager().setDataRequestMode(1);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getQueryDlg();
        EntityViewInfo en = new EntityViewInfo();
        en.getSorter().add(new SorterItemInfo("companyName"));
        en.getSorter().add(new SorterItemInfo("fpFormNumber"));
        dialog.setEntityViewInfo(en);
        if (!dialog.show()) {
            SysUtil.abort();
        }
        FilterParam param = (FilterParam)this.getFilterUI().getParam();
        this.executeQuery(param);
    }

    private void currencyFormat(ICell cell) {
        if (cell == null) {
            return;
        }
        KDTDefaultCellEditor editor = FMClientHelper.getCurrencyEditor((int)this.maxPrecision);
        String numberFmt = FMClientHelper.getNumberFtm((int)this.maxPrecision);
        cell.getStyleAttributes().setNumberFormat(numberFmt);
        cell.setEditor((ICellEditor)editor);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (!AdjustFormListUI.this.isInitStatueSyle) {
                AdjustFormListUI.this.tblMain.getGroupManager().group();
            }
            AdjustFormListUI.this.isInitStatueSyle = true;
            int rowCount = AdjustFormListUI.this.tblMain.getRowCount();
            IRow row = null;
            String currencyId = null;
            for (int i = 0; i < rowCount; ++i) {
                row = AdjustFormListUI.this.tblMain.getRow(i);
                currencyId = row.getCell("currencyId").getValue().toString();
                FMClientHelper.currencyFormat((BOSUuid)BOSUuid.read((String)currencyId), (ICell)row.getCell("entriesAugmentAmount"));
            }
        }
    }
}

