/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPException;
import com.kingdee.eas.fm.fp.FPTemplateFactory;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.IFPTemplate;
import com.kingdee.eas.fm.fp.client.AbstractFPFormAddNewCondUI;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormAddNewCondParam;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class FPFormAddNewCondUI
extends AbstractFPFormAddNewCondUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";
    private FPFormAddNewCondParam value;
    private FPTemplateInfo templateInfoPre;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public static FPFormAddNewCondParam showDialogWindow(Component ui) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FPFormAddNewCondUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        FPFormAddNewCondParam retValue2 = ((FPFormAddNewCondUI)uiWindow.getUIObject()).getValue();
        if (retValue2 == null) {
            return new FPFormAddNewCondParam();
        }
        return retValue2;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.value = null;
        this.destroyWindow();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.verifyInputData();
        FPFormAddNewCondParam retValue = new FPFormAddNewCondParam();
        retValue.setState(1);
        retValue.setJointSubFPForm(this.chkJointSubFPForm.getSelected() == 32);
        retValue.setCompany((CompanyOrgUnitInfo)this.bizPromptCompany.getData());
        retValue.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        retValue.setTemplate((FPTemplateInfo)this.bizPromptTemplate.getData());
        retValue.setBeginYear((Integer)this.spnBeginYear.getValue());
        retValue.setBeginMonth((Integer)this.spnBeginMonth.getValue() - 1);
        retValue.setEndYear((Integer)this.spnEndYear.getValue());
        retValue.setEndMonth((Integer)this.spnEndMonth.getValue() - 1);
        this.setValue(retValue);
        GregorianCalendar beginCalendar = new GregorianCalendar(retValue.getBeginYear(), retValue.getBeginMonth(), 1, 0, 0, 0);
        GregorianCalendar endCalendar = new GregorianCalendar(retValue.getEndYear(), retValue.getEndMonth() + 1, 0, 23, 59, 59);
        Date beginTime = beginCalendar.getTime();
        Date endTime = endCalendar.getTime();
        boolean isPass = FPFormClientHelper.checkInterlaced(retValue.getCompany().getId().toString(), retValue.getTemplate().getId().toString(), retValue.getCurrency().getId().toString(), beginTime, endTime);
        if (!isPass) {
            retValue.setState(0);
            throw new FPException(FPException.FPFORMINTERLACEDEXISTED);
        }
        this.destroyWindow();
    }

    private void verifyInputData() {
        this.checkDate();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.bizPromptCompany, (String)"NoCompany");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.bizPromptTemplate, (String)"NoTemplate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.comboCurrency, (String)"NoCurrency");
    }

    private void checkDate() {
        int beginYear = new Integer(this.spnBeginYear.getValue().toString());
        int beginMonth = new Integer(this.spnBeginMonth.getValue().toString());
        int endYear = new Integer(this.spnEndYear.getValue().toString());
        int endMonth = new Integer(this.spnEndMonth.getValue().toString());
        Calendar beginCal = Calendar.getInstance();
        beginCal.set(beginYear, beginMonth, 1);
        Date beginDate = beginCal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.set(endYear, endMonth, 1);
        Date endDate = endCal.getTime();
        if (beginDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginBigerThanEnd"));
            SysUtil.abort();
        }
    }

    public FPFormAddNewCondParam getValue() {
        return this.value;
    }

    public void setValue(FPFormAddNewCondParam retValue) {
        this.value = retValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.bizPromptCompany.setData((Object)company);
        this.bizPromptTemplate.setHasCUDefaultFilter(false);
        if (company != null) {
            EntityViewInfo ev = FPClientHelper.getTemplateFilterInfo(company.getId().toString());
            this.bizPromptTemplate.setEntityViewInfo(ev);
        }
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        this.comboCurrency.addItems(currencyCollection.toArray());
        this.bizPromptTemplate.setEnabled(true);
        this.bizPromptTemplate.setRequired(true);
        this.bizPromptTemplate.setCommitFormat("$number$");
        CurrencyInfo currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spnBeginYear, (KDSpinner)this.spnBeginMonth, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnEndMonth);
    }

    protected void bizPromptCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptCompany_dataChanged(e);
        if (this.bizPromptCompany.getValue() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.bizPromptCompany.getValue();
            boolean isGroup = ContextHelperFactory.getRemoteInstance().isOnlyUnion(company);
            if (isGroup) {
                this.chkJointSubFPForm.setEnabled(true);
            } else {
                this.chkJointSubFPForm.setSelected(false);
                this.chkJointSubFPForm.setEnabled(false);
            }
        }
    }

    protected void bizPromptTemplate_preChange(PreChangeEvent e) throws Exception {
        super.bizPromptTemplate_preChange(e);
        this.templateInfoPre = (FPTemplateInfo)this.bizPromptTemplate.getValue();
    }

    protected void bizPromptTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptTemplate_dataChanged(e);
        FPTemplateInfo fpTemplateInfo = (FPTemplateInfo)this.bizPromptTemplate.getValue();
        if (fpTemplateInfo.getCycleType() != null) {
            String cycleType = fpTemplateInfo.getCycleType().toString();
            if (this.templateInfoPre != null && this.templateInfoPre.getCycleType().toString().equals(cycleType)) {
                return;
            }
        }
        FMClientHelper.initSpinFromTO((KDSpinner)this.spnBeginYear, (KDSpinner)this.spnBeginMonth, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnEndMonth);
        if (this.bizPromptTemplate.getValue() != null) {
            FPTemplateInfo templateInfo = (FPTemplateInfo)this.bizPromptTemplate.getValue();
            if (!templateInfo.containsKey("cycleType")) {
                IFPTemplate template = FPTemplateFactory.getRemoteInstance();
                templateInfo = template.getFPTemplateInfo("select *  where id='" + templateInfo.getId() + "'");
            }
            if (templateInfo.getCycleType().equals((Object)CycleTypeEnum.QUARTER)) {
                Calendar instance = Calendar.getInstance();
                int thisMonth = instance.get(2);
                int quarter = DateUtil.getSeason((int)thisMonth);
                SpinnerNumberModel mBeginModel = new SpinnerNumberModel(3 * quarter - 2, 1, 10, 3);
                this.spnBeginMonth.setModel((SpinnerModel)mBeginModel);
                SpinnerNumberModel mEndModel = new SpinnerNumberModel(3 * quarter, 3, 12, 3);
                this.spnEndMonth.setModel((SpinnerModel)mEndModel);
            }
            if (templateInfo.getCycleType().equals((Object)CycleTypeEnum.YEAR)) {
                SpinnerNumberModel mBeginModel = new SpinnerNumberModel(1, 1, 1, 1);
                this.spnBeginMonth.setModel((SpinnerModel)mBeginModel);
                SpinnerNumberModel mEndModel = new SpinnerNumberModel(12, 12, 12, 1);
                this.spnEndMonth.setModel((SpinnerModel)mEndModel);
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }

    protected boolean checkBeforeWindowClosing() {
        return true;
    }
}

