/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fm.common.client.ExcelFileFilter;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IndentCellTextRender;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPApproveFacadeFactory;
import com.kingdee.eas.fm.fp.FPException;
import com.kingdee.eas.fm.fp.FPFormEntryCollection;
import com.kingdee.eas.fm.fp.FPFormEntryInfo;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPFormStateEnum;
import com.kingdee.eas.fm.fp.FPItemInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.IFPApproveFacade;
import com.kingdee.eas.fm.fp.IFPForm;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FPFormClientHelper {
    static String ITEM_NAME = "FPItemName";
    static String OVERDUEDEAL = "FPOverdueDeal";
    static String REMARK = "FPRemark";
    static String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";

    public static void setData(KDTable tblMain, FPFormInfo formInfo) {
        FPFormClientHelper.setData(tblMain, formInfo, false, true);
    }

    public static void setData(KDTable tblMain, FPFormInfo formInfo, boolean viewOverDueFlag) {
        FPFormClientHelper.setData(tblMain, formInfo, false, viewOverDueFlag);
    }

    public static void setData(KDTable tblMain, FPFormInfo formInfo, boolean lockFlag, boolean viewOverDueFlag) {
        CycleRangeCollection cycleRangeColl = formInfo.getCycleRanges();
        CycleTypeEnum cycleTypeEnum = formInfo.getCycleType();
        FPFormClientHelper.clearTable(tblMain);
        FPFormClientHelper.setHeader(tblMain, cycleRangeColl, cycleTypeEnum, formInfo.getCurrency().getId(), lockFlag, viewOverDueFlag);
        FPFormEntryCollection entryColl = formInfo.getEntries();
        IndentCellTextRender render = new IndentCellTextRender();
        for (int i = 0; i < formInfo.getTemplate().getEntries().size(); ++i) {
            IRow iRow = tblMain.addRow();
            int size = formInfo.getCycleRanges().size();
            for (int j = 0; j < size; ++j) {
                FPFormEntryInfo entryInfo = entryColl.get(i * size + j);
                if (j == 0) {
                    FPItemTypeEnum type = entryInfo.getFpItem().getType();
                    if (!FPItemTypeEnum.SYSTEMHOLD.equals((Object)type)) {
                        iRow.getCell(ITEM_NAME).setRenderer((IBasicRender)render);
                    }
                    iRow.getCell(ITEM_NAME).setValue((Object)entryInfo.getName());
                    iRow.setUserObject((Object)entryInfo);
                    iRow.getCell(OVERDUEDEAL).setValue((Object)entryInfo.getBackAmount());
                    iRow.getCell(OVERDUEDEAL).setUserObject((Object)entryInfo);
                    iRow.getCell(REMARK).setValue((Object)entryInfo.getComment());
                }
                CycleRangeInfo cycleRangeInfo = cycleRangeColl.get(j);
                String key = cycleRangeInfo.genTimeKey();
                iRow.getCell(key).setValue((Object)entryInfo.getPlanAmount());
                iRow.getCell(key).setUserObject((Object)entryInfo);
            }
        }
        FPFormClientHelper.formatTableStyle(tblMain, lockFlag);
        FPFormClientHelper.formatNumberStyle(tblMain, formInfo);
        FPFormClientHelper.setActualData(tblMain, formInfo);
        FPFormClientHelper.setExp(tblMain, formInfo);
    }

    private static void formatNumberStyle(KDTable tblMain, FPFormInfo formInfo) {
        String formatNumber = FMClientHelper.getNumberFtm((BOSUuid)formInfo.getCurrency().getId());
        CycleRangeCollection cycleRangeColl = formInfo.getCycleRanges();
        int rowCount = tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int size = formInfo.getCycleRanges().size();
            for (int j = 0; j < size; ++j) {
                CycleRangeInfo cycleRangeInfo = cycleRangeColl.get(j);
                String key = cycleRangeInfo.genTimeKey();
                tblMain.getRow(i).getCell(key).getStyleAttributes().setNumberFormat(formatNumber);
            }
        }
    }

    private static void setActualData(KDTable tblMain, FPFormInfo formInfo) {
        IRow actualRow = tblMain.getRow(0);
        IRow forecastRow = tblMain.getRow(1);
        IRow perBalanceRow = tblMain.getRow(2);
        CycleRangeCollection cycleRangeColl = formInfo.getCycleRanges();
        for (int i = 0; i < cycleRangeColl.size(); ++i) {
            ObjectUuidPK companyId = new ObjectUuidPK(formInfo.getCompany().getId());
            ObjectUuidPK currencyId = new ObjectUuidPK(formInfo.getCurrency().getId());
            BigDecimal actualValue = FPFormClientHelper.getActualBegining((IObjectPK)companyId, (IObjectPK)currencyId, cycleRangeColl.get(i).getBeginDate());
            actualRow.getCell(i + 2).setValue((Object)actualValue);
            if (actualValue != null) {
                actualRow.getCell(i + 2).setValue((Object)actualValue);
                perBalanceRow.getCell(i + 2).setValue((Object)actualValue);
                continue;
            }
            perBalanceRow.getCell(i + 2).setValue(forecastRow.getCell(i + 2).getValue());
        }
    }

    public static void setExp(KDTable tblMain, FPFormInfo formInfo) {
        IRow actualRow = tblMain.getRow(0);
        IRow forecastRow = tblMain.getRow(1);
        IRow perBalanceRow = tblMain.getRow(2);
        IRow currentBalanceRow = tblMain.getRow(tblMain.getRowCount() - 1);
        for (int i = 2; i < tblMain.getColumnCount() - 1; ++i) {
            ICell cell = perBalanceRow.getCell(i);
            FPFormEntryInfo entry = (FPFormEntryInfo)cell.getUserObject();
            String exp = "=cell(ROW_INDEX-1,COLUMN_INDEX).value";
            if (actualRow.getCell(i).getValue() == null) {
                cell.setExpressions(exp);
            }
            if (i > 2) {
                ICell cell1 = forecastRow.getCell(i);
                FPFormEntryInfo entry1 = (FPFormEntryInfo)cell.getUserObject();
                String exp1 = "=cell(" + tblMain.getRowCount() + ",COLUMN_INDEX-1).value";
                cell1.setExpressions(exp1);
            }
            ICell cell2 = currentBalanceRow.getCell(i);
            FPFormEntryInfo entry2 = (FPFormEntryInfo)cell.getUserObject();
            String exp2 = entry.getFpItem().getCellExp();
            cell2.setExpressions(exp2);
            for (int j = 3; j < tblMain.getRowCount(); ++j) {
                IRow row = tblMain.getRow(j);
                FPFormEntryInfo info = (FPFormEntryInfo)row.getUserObject();
                String expression = info.getFpItem().getCellExp();
                if (info.getType() != FPItemTypeEnum.SYSTEMHOLD && info.getType() != FPItemTypeEnum.SUBTOTAL) continue;
                System.out.println(expression);
                row.getCell(i).setExpressions(expression);
                row.getCell(i).getStyleAttributes().setLocked(true);
            }
        }
        for (int j = 3; j < tblMain.getRowCount() - 1; ++j) {
            IRow row = tblMain.getRow(j);
            FPFormEntryInfo info = (FPFormEntryInfo)row.getUserObject();
            String expression = info.getFpItem().getCellExp();
            if (info.getType() != FPItemTypeEnum.SYSTEMHOLD && info.getType() != FPItemTypeEnum.SUBTOTAL) continue;
            System.out.println(expression);
            row.getCell(1).setExpressions(expression);
            row.getCell(1).getStyleAttributes().setLocked(true);
        }
    }

    public static void putTotalData(KDTable tblMain) {
        BigDecimal[] sumAry = new BigDecimal[2];
        IRow totalRow = null;
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            int j;
            IRow row = tblMain.getRow(i);
            FPFormEntryInfo info = (FPFormEntryInfo)row.getUserObject();
            if (info.getType() == FPItemTypeEnum.SYSTEMHOLD) {
                if (sumAry[0] != null && totalRow != null) {
                    for (j = 0; j < sumAry.length; ++j) {
                        totalRow.getCell(j + 1).setValue((Object)sumAry[j]);
                        sumAry[j] = null;
                    }
                }
                totalRow = row;
                continue;
            }
            if (info.getType() == FPItemTypeEnum.ONLYREFERENCED) continue;
            for (j = 0; j < sumAry.length; ++j) {
                BigDecimal bigDecimal = (BigDecimal)row.getCell(j + 1).getValue();
                if (sumAry[j] == null) {
                    sumAry[j] = bigDecimal;
                    continue;
                }
                if (bigDecimal == null) continue;
                sumAry[j] = sumAry[j].add(bigDecimal);
            }
        }
    }

    public static void clearTable(KDTable kdTable) {
        kdTable.removeHeadRows();
        kdTable.removeRows();
        kdTable.removeColumns();
    }

    private static void setHeader(KDTable tblMain, CycleRangeCollection cycleRangeColl, CycleTypeEnum cycleTypeEnum, BOSUuid currencyId, boolean lockFlag, boolean viewOverDueFlag) {
        tblMain.checkParsed();
        KDTDefaultCellEditor cellEditor = FPFormClientHelper.getCurrencyEditor(currencyId);
        IColumn iColumn = null;
        IRow headRow = tblMain.addHeadRow();
        iColumn = tblMain.addColumn();
        iColumn.setKey(ITEM_NAME);
        iColumn.getStyleAttributes().setLocked(true);
        iColumn.setWidth(240);
        iColumn = tblMain.addColumn();
        iColumn.getStyleAttributes().setLocked(lockFlag);
        iColumn.getStyleAttributes().setHided(viewOverDueFlag);
        iColumn.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currencyId));
        iColumn.setKey(OVERDUEDEAL);
        iColumn.setEditor((ICellEditor)cellEditor);
        iColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        for (int i = 0; i < cycleRangeColl.size(); ++i) {
            CycleRangeInfo cycleRangeInfo = cycleRangeColl.get(i);
            iColumn = tblMain.addColumn();
            iColumn.getStyleAttributes().setLocked(lockFlag);
            String key = cycleRangeInfo.genTimeKey();
            iColumn.setKey(key);
            headRow.getCell(key).setValue((Object)cycleRangeInfo.toString());
            iColumn.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currencyId));
            iColumn.setEditor((ICellEditor)cellEditor);
            iColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        iColumn = tblMain.addColumn();
        iColumn.setKey(REMARK);
        iColumn.getStyleAttributes().setLocked(lockFlag);
        iColumn.setWidth(240);
        headRow.getCell(ITEM_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fp.FPFormResource", (String)ITEM_NAME));
        headRow.getCell(OVERDUEDEAL).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fp.FPFormResource", (String)OVERDUEDEAL));
        headRow.getCell(REMARK).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fp.FPFormResource", (String)REMARK));
    }

    public static KDTDefaultCellEditor getCurrencyEditor(BOSUuid currencyId) {
        KDFormattedTextField currencyTxtFiled = new KDFormattedTextField();
        currencyTxtFiled.setDataType(1);
        currencyTxtFiled.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId));
        currencyTxtFiled.setMaximumValue((Comparable)Constants.MAX_VALUE);
        currencyTxtFiled.setMinimumValue((Comparable)Constants.MIN_VALUE);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)currencyTxtFiled);
        return cellEditor;
    }

    public static String getPeriodStr(int beginYear, int beginMonth, int endYear, int endMonth) {
        String periodStr = beginYear + "." + beginMonth + "  -  " + endYear + "." + endMonth;
        return periodStr;
    }

    public static void afterEditPlanAmount(KDTable tblMain, int rowIndex, int colIndex) {
        FPFormEntryInfo formEntryInfo;
        ICell iCell = tblMain.getCell(rowIndex, colIndex);
        if (iCell.getValue() == null) {
            iCell.setValue((Object)Constants.ZERO);
        }
        if ((formEntryInfo = (FPFormEntryInfo)iCell.getUserObject()) == null) {
            return;
        }
        Object value = iCell.getValue();
        BigDecimal newValue = null;
        newValue = new BigDecimal(value.toString());
        formEntryInfo.setPlanAmount(newValue);
        iCell.setValue((Object)newValue);
    }

    public static void afterEditOverdueDeal(KDTable tblMain, int rowIndex, int colIndex) {
        ICell iCell = tblMain.getCell(rowIndex, colIndex);
        FPFormEntryInfo formEntryInfo = (FPFormEntryInfo)iCell.getUserObject();
        Object value = iCell.getValue();
        BigDecimal newValue = null;
        newValue = value == null ? Constants.ZERO : new BigDecimal(value.toString());
        formEntryInfo.setBackAmount(newValue);
        iCell.setValue((Object)newValue);
    }

    public static void afterEditComment(KDTable tblMain, int rowIndex, int colIndex) {
        ICell iCell = tblMain.getCell(rowIndex, OVERDUEDEAL);
        ICell iCellRemark = tblMain.getCell(rowIndex, REMARK);
        FPFormEntryInfo formEntryInfo = (FPFormEntryInfo)iCell.getUserObject();
        String remark = TypeConversionUtils.objToString((Object)iCellRemark.getValue());
        formEntryInfo.setComment(remark);
        iCellRemark.setValue((Object)remark);
    }

    public static boolean isEditOverdueDeal(KDTable tblMain, int colIndex) {
        IColumn iColumn = tblMain.getColumn(colIndex);
        String key = iColumn.getKey();
        return key.equals(OVERDUEDEAL);
    }

    public static boolean isEditComment(KDTable tblMain, int colIndex) {
        IColumn iColumn = tblMain.getColumn(colIndex);
        String key = iColumn.getKey();
        return key.equals(REMARK);
    }

    public static void auditForm(Component ui, String formId) throws EASBizException, BOSException {
        IFPApproveFacade iFPApproveFacade = FPApproveFacadeFactory.getRemoteInstance();
        FPFormStateEnum stateEnum = FPFormClientHelper.getFormState(formId);
        if (stateEnum.equals((Object)FPFormStateEnum.APPROVED)) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"AlreadyAudit"));
            SysUtil.abort();
        } else if (stateEnum.equals((Object)FPFormStateEnum.BEFOREAPPROVAL) || stateEnum.equals((Object)FPFormStateEnum.ADJUSTING)) {
            int returnValue = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IfAuditForm"));
            if (returnValue == 0) {
                iFPApproveFacade.approve(formId);
                MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"auditSuccess"));
            } else if (returnValue == 2) {
                SysUtil.abort();
            }
        } else {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"OverdueForm"));
            SysUtil.abort();
        }
    }

    public static void antiAuditForm(Component ui, String formId, FPFormStateEnum stateEnum) throws EASBizException, BOSException {
        IFPApproveFacade iFPApproveFacade = FPApproveFacadeFactory.getRemoteInstance();
        if (stateEnum.equals((Object)FPFormStateEnum.BEFOREAPPROVAL)) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NotAudit"));
            SysUtil.abort();
        } else if (stateEnum.equals((Object)FPFormStateEnum.OUTDATED)) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"OutDate"));
            SysUtil.abort();
        } else if (stateEnum.equals((Object)FPFormStateEnum.ADJUSTING)) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"Adjusting"));
            SysUtil.abort();
        } else if (stateEnum.equals((Object)FPFormStateEnum.APPROVED)) {
            int returnValue = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IfAntiAuditForm"));
            if (returnValue == 0) {
                iFPApproveFacade.antiApprove(formId);
                MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"AntiAuditSuccess"));
            } else if (returnValue == 2) {
                SysUtil.abort();
            }
        }
    }

    public static void formatTableStyle(KDTable table, boolean lockFlag) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            Object obj = row.getUserObject();
            FPItemTypeEnum type = null;
            if (obj instanceof FPFormEntryInfo) {
                type = ((FPFormEntryInfo)obj).getType();
            } else if (obj instanceof FPItemInfo) {
                type = ((FPItemInfo)obj).getType();
            }
            if (row.getRowIndex() > 2) {
                if (type == FPItemTypeEnum.SYSTEMHOLD) {
                    row.getStyleAttributes().setLocked(true);
                    row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                }
                if (type == FPItemTypeEnum.SUBTOTAL) {
                    row.getStyleAttributes().setLocked(true);
                    row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                    if (row.getCell(REMARK) != null) {
                        row.getCell(REMARK).getStyleAttributes().setLocked(lockFlag);
                    }
                }
            } else if (row.getRowIndex() != 1) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            } else {
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                row.getStyleAttributes().setLocked(true);
                ICell cell = table.getCell(1, 2);
                if (cell != null) {
                    cell.getStyleAttributes().setLocked(lockFlag);
                }
            }
            if (i != table.getRowCount() - 1) continue;
            row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
    }

    public static BigDecimal getActualBegining(IObjectPK companyPK, IObjectPK currencyPK, Date beginDate) {
        BigDecimal dayStartAmt = null;
        long nowTime = System.currentTimeMillis();
        if (beginDate.getTime() > nowTime) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        try {
            String companyNum = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(companyPK, selector).getNumber();
            String currencyNum = CurrencyFactory.getRemoteInstance().getCurrencyInfo(currencyPK, selector).getNumber();
            ICashManagement iCashMgt = CashManagementFactory.getRemoteInstance();
            dayStartAmt = iCashMgt.cash(companyNum, CashDataSourceEnum.CB, null, null, null, currencyNum, beginDate, beginDate, CashDataTypeEnum.C, true);
            if (dayStartAmt == null) {
                dayStartAmt = Constants.ZERO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dayStartAmt = null;
        }
        if (dayStartAmt != null && dayStartAmt.signum() != 0) {
            return dayStartAmt;
        }
        return null;
    }

    public static SelectorItemCollection getUserDefSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cycleRanges.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.fpItem.*"));
        sic.add(new SelectorItemInfo("entries.cycleRange.*"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditedTime"));
        return sic;
    }

    public static FPFormInfo getUserDefValue(IObjectPK pk) throws Exception {
        IFPForm ifpform = FPFormFactory.getRemoteInstance();
        FPFormInfo info = ifpform.getFPFormInfo(pk, FPFormClientHelper.getUserDefSelectors());
        for (int i = 0; i < info.getEntries().size(); ++i) {
            info.getTemplate().getEntries().add(info.getEntries().get(i).getFpItem());
        }
        FPFormClientHelper.sortFormEntries(info);
        return info;
    }

    public static void sortFormEntries(FPFormInfo info) {
        FPFormEntryCollection coll = info.getEntries();
        Object[] collAry = coll.toArray();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                FPFormEntryInfo new01 = (FPFormEntryInfo)o1;
                FPFormEntryInfo new02 = (FPFormEntryInfo)o2;
                if (new01.getFpItem().getLineNo() != new02.getFpItem().getLineNo()) {
                    return new01.getFpItem().getLineNo() - new02.getFpItem().getLineNo();
                }
                return new01.getCycleRange().getBeginDate().compareTo(new02.getCycleRange().getBeginDate());
            }
        };
        Arrays.sort(collAry, c);
        info.getEntries().clear();
        for (int i = 0; i < collAry.length; ++i) {
            info.getEntries().add((FPFormEntryInfo)collAry[i]);
        }
    }

    public static FPFormStateEnum getFormState(String formId) throws EASBizException, BOSException {
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        FPFormInfo info = iFPForm.getFPFormInfo((IObjectPK)new ObjectUuidPK(formId));
        return info.getState();
    }

    public static void viewOverdue(KDTable tblMain) {
        IColumn col = tblMain.getColumn(OVERDUEDEAL);
        if (!col.getStyleAttributes().isHided()) {
            col.getStyleAttributes().setHided(true);
        } else {
            col.getStyleAttributes().setHided(false);
        }
    }

    public static boolean checkSelectedRowCount(KDTable tblMain, int maxNum) {
        ArrayList blocks = tblMain.getSelectManager().getBlocks();
        boolean returnValue = true;
        if (blocks.size() > maxNum) {
            returnValue = false;
        } else {
            int rowCount = 0;
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < blocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)blocks.get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ++rowCount;
                }
            }
            if (rowCount > maxNum) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public static boolean checkInterlaced(String companyId, String templateId, String currencyId, Date beginTime, Date endTime) throws EASBizException {
        boolean isPass = false;
        try {
            IFPForm iFPForm = FPFormFactory.getRemoteInstance();
            isPass = iFPForm.checkAddNew(companyId, templateId, currencyId, beginTime, endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPass;
    }

    public static void hideStatRows(KDTable tblMain) {
        tblMain.getRow(0).getStyleAttributes().setHided(true);
        tblMain.getRow(1).getStyleAttributes().setHided(true);
        tblMain.getRow(2).getStyleAttributes().setHided(true);
        tblMain.getRow(tblMain.getRowCount() - 1).getStyleAttributes().setHided(true);
    }

    public static void importExcel(Component ui, KDTable tblMain) throws Exception {
        int i;
        KDSBook kdsBook;
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)resourcePath, (String)"ImportFP"));
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        if ((kdsBook = POIXlsReader.parse((String)filePath)) == null) {
            throw new FPException(FPException.READEXCEL);
        }
        int headRowCount = tblMain.getHeadRowCount();
        int maxColumn = tblMain.getColumnCount();
        int maxRow = tblMain.getRowCount();
        ICell cell = null;
        IRow row = null;
        Object str = null;
        FPFormEntryInfo formEntryInfo = null;
        String sheetName = kdsBook.getSheet((Object)new Integer(0)).getName();
        KDSSheet sheet = kdsBook.getSheet((Object)sheetName);
        int sheetRowCount = sheet.getRowCount();
        int sheetColumnCount = sheet.getColumnCount();
        if (maxRow != sheetRowCount - 1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"RowCountError"));
            return;
        }
        IColumn col = tblMain.getColumn(OVERDUEDEAL);
        String test = sheet.getCell(headRowCount, 4, false).getText();
        int colSize = sheet.getColumnCount() > tblMain.getColumnCount() ? tblMain.getColumnCount() : sheet.getColumnCount();
        int headerRowCount = tblMain.getHeadRowCount();
        for (i = 0; i < headerRowCount; ++i) {
            IRow row1 = tblMain.getHeadRow(i);
            for (int j = 0; j < colSize; ++j) {
                if (row1.getCell(j).getValue().toString().trim().equals(sheet.getCell(i, j, false).getText().trim())) continue;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"ColumnCountError"));
                SysUtil.abort();
            }
        }
        for (i = 0; i < maxRow; ++i) {
            row = tblMain.getRow(i);
            formEntryInfo = (FPFormEntryInfo)row.getUserObject();
            for (int j = 1; j < maxColumn; ++j) {
                BigDecimal theValue = null;
                Object strItem = null;
                cell = tblMain.getRow(i).getCell(j);
                String text = sheet.getCell(i + headRowCount, j, false).getText();
                if (text != null && text.trim().length() != 0) {
                    if (FMClientHelper.verifyIsNumber((String)text)) {
                        theValue = new BigDecimal(text);
                    }
                    theValue.setScale(1, 5);
                } else {
                    theValue = Constants.ZERO;
                }
                if (cell.getStyleAttributes().isLocked()) continue;
                cell.setValue((Object)theValue);
            }
        }
    }
}

