/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.FPFormFilterParam;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPTemplateFactory;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.IFPTemplate;
import com.kingdee.eas.fm.fp.client.AbstractFPFormFilterUI;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;

public class FPFormFilterUI
extends AbstractFPFormFilterUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";

    protected void init() throws Exception {
        super.init();
        this.initCompanyIds();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.f7Template.setHasCUDefaultFilter(false);
        if (company != null) {
            EntityViewInfo ev = FPClientHelper.getTemplateFilterInfo(company.getId().toString());
            this.f7Template.setEntityViewInfo(ev);
        }
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        this.cboCurrency.addItems(currencyCollection.toArray());
        CurrencyInfo currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
        this.setF7NumberFormFilter(new String[]{company.getId().toString()});
    }

    protected void initCompanyIds() throws BOSException {
        String[] companyIds = new String[]{this.currentCompany.getId().toString()};
        this.setCompanyIds(companyIds);
        try {
            FPClientHelper.setTemplateFilterByCompany(companyIds, this.currentCompany.getId().toString(), this.f7Template);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        String[] companyIds = this.getCompanyIds();
        FPClientHelper.setTemplateFilterByCompany(companyIds, this.currentCompany.getId().toString(), this.f7Template);
        this.setF7NumberFormFilter(companyIds);
    }

    private void setF7NumberFormFilter(String[] companyIds) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            companySet.add(companyIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
        ev.setFilter(filter);
        this.f7NumberForm.setEntityViewInfo(ev);
        this.f7NumberForm.setData(null);
        this.f7NumberTo.setEntityViewInfo(ev);
        this.f7NumberTo.setData(null);
    }

    public Object getParam() {
        FPFormFilterParam param = new FPFormFilterParam();
        if (this.getCompanyIds() != null) {
            String[] companyIds = this.getCompanyIds();
            param.setCompanyIdAry(companyIds);
        }
        if (this.f7Template.getValue() != null) {
            param.setTemplateId(((FPTemplateInfo)this.f7Template.getValue()).getId().toString());
        }
        if (this.cboCurrency.getSelectedItem() != null && !(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.f7NumberForm.getData() != null) {
            param.setBeginNumber(((FPFormInfo)this.f7NumberForm.getData()).getNumber());
        }
        if (this.f7NumberTo.getData() != null) {
            param.setEndNumber(((FPFormInfo)this.f7NumberTo.getData()).getNumber());
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof FPFormFilterParam)) {
            return;
        }
        FPFormFilterParam formFilterParam = (FPFormFilterParam)param;
        String[] companyIds = formFilterParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        String currencyId = formFilterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                this.cboCurrency.setSelectedItem((Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String templateId = formFilterParam.getTemplateId();
        FPTemplateInfo templateInfo = null;
        try {
            if (templateId != null) {
                IFPTemplate iTemplate = FPTemplateFactory.getRemoteInstance();
                templateInfo = iTemplate.getFPTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
            }
            this.f7Template.setData(templateInfo);
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String beginNumber = formFilterParam.getBeginNumber();
        String endNumber = formFilterParam.getEndNumber();
        FPFormInfo beginInfo = new FPFormInfo();
        beginInfo.setNumber(beginNumber);
        this.f7NumberForm.setValue((Object)beginInfo);
        FPFormInfo endInfo = new FPFormInfo();
        endInfo.setNumber(endNumber);
        this.f7NumberTo.setValue((Object)endInfo);
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.cboCurrency, (String)"NoCurrency");
        return true;
    }
}

